/*
 * QFeWl萔Œ`ꂽW_\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclHomogeneousPoint2D.java,v 1.19 2000/04/26 09:38:57 hideit Exp $
 *
 */

package jp.go.ipa.jgcl;

import java.io.PrintWriter;

/**
 * QFeWl萔Œ`ꂽW_\NXB
 *
 * @version $Revision: 1.19 $, $Date: 2000/04/26 09:38:57 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclCartesianPoint2D
 */

public class JgclHomogeneousPoint2D extends JgclPoint2D {
    /** 
     * WX WlB
     * @serial
     */
    private double wx;

    /** 
     * WY WlB
     * @serial
     */
    private double wy;

    /** 
     * W WlB
     * @serial
     */
    private double w;

    /**
     * WX, WY, W ݒ肷B
     * 
     * @param wx	WX Wl
     * @param wy	WY Wl
     * @param w	W Wl
     */
    private void setArgs(double wx, double wy, double w) {
	this.wx = wx;
	this.wy = wy;
	this.w = w;
    }

    /**
     * (wx/w, wy/w) Œ`IuWFNg\zB
     * 
     * @param wx	WX Wl
     * @param wy	WY Wl
     * @param w	W Wl
     */
    public JgclHomogeneousPoint2D(double wx, double wy, double w) {
        super();

	setArgs(wx, wy, w);
    }

    /**
     * (c[0]/c[2], c[1]/c[2]) 
     * `IuWFNg\zB
     * 
     * @param c Wl̔z
     */
    public JgclHomogeneousPoint2D(double[] c) {
        super();

	setArgs(c[0], c[1], c[2]);
    }

    /**
     * X Wl (WX/W) ԂB
     *
     * @return X Wl
     */
    public double x() {
        return wx / w;
    }

    /**
     * Y Wl (WY/W) ԂB
     *
     * @return Y Wl
     */
    public double y() {
        return wy / w;
    }

    /**
     * WX WlԂB
     *
     * @return	WX Wl
     */
    public double wx() {
        return wx;
    }

    /**
     * WY WlԂB
     *
     * @return	WY Wl
     */
    public double wy() {
        return wy;
    }

    /**
     * W WlԂB
     *
     * @return	W Wl
     */
    public double w() {
        return w;
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclPoint2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint2D crd;
	if (reverseTransform == false)
	    crd = transformationOperator.transform(this);
	else
	    crd = transformationOperator.reverseTransform(this);
	return new JgclHomogeneousPoint2D((this.w * crd.x()), (this.w * crd.y()), this.w);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab +
                       getClassName() + " "
                       + wx() + " "
                       + wy() + " "
                       + w()  + " End");
    }
}
