/*
 * PFeWl萔Œ`ꂽ3̓W_\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclHomogeneousPoint1D.java,v 1.17 2000/04/26 09:38:57 hideit Exp $
 *
 */

package jp.go.ipa.jgcl;

import java.io.PrintWriter;

/**
 * PFeWl萔Œ`ꂽ3̓W_\NXB
 *
 * @version $Revision: 1.17 $, $Date: 2000/04/26 09:38:57 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclCartesianPoint1D
 */

public class JgclHomogeneousPoint1D extends JgclPoint1D {
    /** 
     * WX WlB
     * @serial
     */
    private final double wx;

    /** 
     * W WlB
     * @serial
     */
    private final double w;

    /**
     * WX/W Œ`IuWFNg\zB
     * 
     * @param wx	WX Wl
     * @param w W Wl
     */
    public JgclHomogeneousPoint1D(double wx, double w) {
        super();

        this.wx = wx;
        this.w = w;
    }

    /**
     * X WlԂB
     *
     * @return X Wl
     */
    public double x() {
        return wx / w;
    }

    /**
     * WX WlԂB
     *
     * @return WX Wl
     */
    public double wx() {
        return wx;
    }

    /**
     * W WlԂB
     *
     * @return W Wl
     */
    public double w() {
        return w;
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab +
                       getClassName() + " "
                       + wx() + " "
                       + w()  + " End");
    }
}
