/*
 * 􉽗vf\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclGeometry.java,v 1.23 2000/04/26 09:38:56 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;

/**
 * JgclGeometry ́A􉽗vf̃NXKw̃[gƂȂ钊ۃNXłB
 * ׂĂ̊􉽗vfNX́ÃX[p[NXƂ JgclGeometry ܂B
 * <p>
 * JgclGeometry ́A
 * 􉽗vf̎ (ȐȂ̂ȖʂȂ̂AƂ) 
 *  (QȂ̂RȂ̂AƂ) 
 * ₢킹郁\bhĂ܂B
 * JgclGeometry ̃TuNX́A
 * ̖₢킹\bhg̎ɍv悤
 * I[o[ChȂ΂Ȃ܂B
 * </p>
 * @version $Revision: 1.23 $, $Date: 2000/04/26 09:38:56 $
 * @author Information-technology Promotion Agency, Japan
 */
public abstract class JgclGeometry extends java.lang.Object
    implements java.io.Serializable {
    /**
     * doCheck `FbNtRXgN^Ăяo
     * doCheck ̃}X^[tOB
     * <p>
     * ʏ false ɂč}B
     * debug ɂ true ɂB
     * </p>
     */
    static final boolean doCheckDebug = false;

    /**
     * IuWFNg\zB
     */
    protected JgclGeometry() {
	super();
    }

    /**
     * ̊􉽗vf̎Ԃۃ\bhB
     *
     * @return 􉽗vf̎
     */

    public abstract int dimension();


    /**
     * ̊􉽗vfPۂԂB
     *
     * @return PȂ <code>true</code>, Ȃ <code>false<code>
     */
    public boolean is1D() {
	return dimension() == 1;
    }


    /**
     * ̊􉽗vfQۂԂB
     *
     * @return QȂ <code>true</code>, Ȃ <code>false<code>
     */
    public boolean is2D() {
	return dimension() == 2;
    }


    /**
     * ̊􉽗vfRۂԂB
     *
     * @return RȂ <code>true</code>, Ȃ <code>false<code>
     */
    public boolean is3D() {
	return dimension() == 3;
    }


    /**
     * ̊􉽗vfxNgۂԂB
     *
     * @return xNgȂ <code>true</code>, Ȃ <code>false<code>
     * @see	JgclVector
     */
    public boolean isVector() {
	// return this instanceof JgclVector;
	return false;
    }


    /**
     * ̊􉽗vf_ۂԂB
     *
     * @return _Ȃ <code>true</code>, Ȃ <code>false<code>
     * @see	JgclPoint
     */
    public boolean isPoint() {
	// return this instanceof Point;
	return false;
    }


    /**
     * ̊􉽗vfzu (ǏWn) ۂԂB
     *
     * @return zu (ǏWn) Ȃ <code>true</code>, Ȃ <code>false<code>
     * @see	JgclPlacement
     */
    public boolean isPlacement() {
	// return this instanceof Placement;
	return false;
    }


    /**
     * ̊􉽗vf􉽓IȕϊsȂZqۂԂB
     *
     * @return 􉽓IȕϊsȂZqȂ <code>true</code>,
     *         Ȃ <code>false<code>
     * @see	JgclCartesianTransformationOperator
     */
    public boolean isTransformationOperator() {
	// return this instanceof CartesianTransformationOperator;
	return false;
    }


    /**
     * ̊􉽗vfȐۂԂB
     *
     * @return ȐȂ <code>true</code>, Ȃ <code>false<code>
     * @see	JgclParametricCurve
     */
    public boolean isCurve() {
	// return this instanceof ParametricCurve;
	return false;
    }


    /**
     * ̊􉽗vfȖʂۂԂB
     *
     * @return ȖʂȂ <code>true</code>, Ȃ <code>false<code>
     * @see	JgclParametricSurface
     * @see	JgclNonParametricSurface
     */
    public boolean isSurface() {
	// return this instanceof ParametricSurface
	//    || this instanceof NonParametricSurface;
	return false;
    }


    /**
     * ̊􉽗vfpgbNۂԂB
     *
     * @return pgbNȂ <code>true</code>,
     *         Ȃ <code>false<code>
     * @see	JgclParametricCurve
     * @see	JgclParametricSurface
     */
    public boolean isParametric() {
	// return this instanceof ParametricCurve
	//    || this instanceof ParametricSurface;
	return false;
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	R`Ȃ <code>true</code>,
     *		Ȃ <code>false<code>
     */
    public boolean isFreeform() {
	return false;
    }

    /**
     * ݂̃Xbhɐݒ肳Ă鋗̋e덷ԂB
     * 
     * @return	݂̃Xbhɐݒ肳Ă鋗̋e덷
     * @see	JgclConditionOfOperation
     */
    public double getToleranceForDistance() {
	JgclConditionOfOperation cond =
	    JgclConditionOfOperation.getCondition();
	return cond.getToleranceForDistance();
    }

    /**
     * ݂̃Xbhɐݒ肳Ă鋗̋e덷ԂB
     * 
     * @return	݂̃Xbhɐݒ肳Ă鋗̋e덷
     * @see	JgclConditionOfOperation
     */
    public JgclToleranceForDistance getToleranceForDistanceAsObject() {
	JgclConditionOfOperation cond =
	    JgclConditionOfOperation.getCondition();
	return cond.getToleranceForDistanceAsObject();
    }

    /**
     * ݂̃Xbhɐݒ肳Ă鋗̋e덷̎ԂB
     * 
     * @return	݂̃Xbhɐݒ肳Ă鋗̋e덷̎
     * @see	JgclConditionOfOperation
     */
    public double getToleranceForDistance2() {
	JgclConditionOfOperation cond =
	    JgclConditionOfOperation.getCondition();
	return cond.getToleranceForDistance2();
    }

    /**
     * ݂̃Xbhɐݒ肳Ăpx̋e덷ԂB
     * 
     * @return	݂̃Xbhɐݒ肳Ăpx̋e덷
     * @see	JgclConditionOfOperation
     */
    public double getToleranceForAngle() {
	JgclConditionOfOperation cond =
	    JgclConditionOfOperation.getCondition();
	return cond.getToleranceForAngle();
    }

    /**
     * ݂̃Xbhɐݒ肳Ăpx̋e덷ԂB
     * 
     * @return	݂̃Xbhɐݒ肳Ăpx̋e덷
     * @see	JgclConditionOfOperation
     */
    public JgclToleranceForAngle getToleranceForAngleAsObject() {
	JgclConditionOfOperation cond =
	    JgclConditionOfOperation.getCondition();
	return cond.getToleranceForAngleAsObject();
    }

    /**
     * ݂̃Xbhɐݒ肳Ăp[^l̋e덷ԂB
     * 
     * @return	݂̃Xbhɐݒ肳Ăp[^l̋e덷
     * @see	JgclConditionOfOperation
     */
    public double getToleranceForParameter() {
	JgclConditionOfOperation cond =
	    JgclConditionOfOperation.getCondition();
	return cond.getToleranceForParameter();
    }

    /**
     * ݂̃Xbhɐݒ肳Ăp[^l̋e덷ԂB
     * 
     * @return	݂̃Xbhɐݒ肳Ăp[^l̋e덷
     * @see	JgclConditionOfOperation
     */
    public JgclToleranceForParameter getToleranceForParameterAsObject() {
	JgclConditionOfOperation cond =
	    JgclConditionOfOperation.getCondition();
	return cond.getToleranceForParameterAsObject();
    }

    /**
     * ݂̃Xbhɐݒ肳Ăl̋e덷ԂB
     * 
     * @return	݂̃Xbhɐݒ肳Ăl̋e덷
     * @see	JgclConditionOfOperation
     */
    public double getToleranceForRealNumber() {
	JgclConditionOfOperation cond =
	    JgclConditionOfOperation.getCondition();
	return cond.getToleranceForRealNumber();
    }

    /**
     * ݂̃Xbhɐݒ肳Ăl̋e덷ԂB
     * 
     * @return	݂̃Xbhɐݒ肳Ăl̋e덷
     * @see	JgclConditionOfOperation
     */
    public JgclTolerance getToleranceForRealNumberAsObject() {
	JgclConditionOfOperation cond =
	    JgclConditionOfOperation.getCondition();
	return cond.getToleranceForRealNumberAsObject();
    }

    /**
     * o̓Xg[ɂ̊􉽗vf̌`o͂B
     *
     * @param out	o̓Xg[
     */
    public void output(OutputStream out) {
        PrintWriter writer = new PrintWriter(out, true);
        output(writer, 0);
    }

    /**
     * o̓Xg[ɂ̊􉽗vf̌`o͂B
     * <p>
     * ۃ\bhȂ̂ŁAeTuNXŃI[oCh
     * </p>
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     */
    protected abstract void output(PrintWriter writer, int indent);

    /**
     * Cfg̐[̐TabԂB
     *
     * @param indent    Cfg̐[
     * @return	Tab
     */
    protected String makeIndent(int indent) {
        StringBuffer buffer;
        String       indent_tab;

        buffer = new StringBuffer();
        // make string of tabs
        for (int i = 0; i < indent; i++) {
            buffer.append("\t");
        }
        return new String(buffer);
    }

    /**
     * ̊􉽗vf́upbP[WNXvԂB
     *
     * @return pbP[WNX
     */
    protected String getClassName()
    {
        StringTokenizer tokens = 
            new StringTokenizer(getClass().getName(), ".");
        // get last of tokens
        while (tokens.countTokens() != 1) {
            tokens.nextToken();
        }
        return tokens.nextToken();
    }
}
