/*
 * 2D ȐȌӏŕāA
 * ȌȂPȕȐ̏WɂNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclDivideCmcIntoSimpleLoops2D.java,v 1.4 2000/04/26 09:38:53 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 2D ȐȌӏŕāA
 * ȌȂPȕȐ̏WɂNX
 *
 * @version $Revision: 1.4 $, $Date: 2000/04/26 09:38:53 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclDivideCmcIntoSimpleLoops2D {
    /**
     * Ȑ
     */
    private JgclCompositeCurve2D closedCmc;

    /**
     * Ȑ̉lŁA
     * v (E) ɉĂ (ƌȂ) ̂ł JgclLoopWise.CWA
     * v () ɉĂ (ƌȂ) ̂ł JgclLoopWise.CCW
     * w肷
     */
    private int cmcWise;

    /**
     * Ȑ̋Ȑǂ瑤ɃItZbĝł邩lŁA
     * ̋ȐɃItZbĝł JgclWhichSide.INA
     * ̋ȐOɃItZbĝł JgclWhichSide.OUT
     * w肷
     */
    private int validSide;

    /**
     *  ParameterOnSegment ̌
     */
    private int parameterOnSegmentCounter;

    /**
     * px̋e덷
     */
    private double aTol;

    /**
     * ZIuWFNg\z
     *
     * @param closedCmc	Ȑ
     * @param cmcWise	Ȑ̉l
     * @param validSide	Ȑ̋Ȑǂ瑤ɃItZbĝł邩l
     * @exception JgclOpenCurve	JȐł
     */
    JgclDivideCmcIntoSimpleLoops2D(JgclCompositeCurve2D closedCmc,
				   int cmcWise,
				   int validSide)
	 throws JgclOpenCurve
    {

	// ĂKv
	if (closedCmc.isClosed() != true)
	    throw new JgclOpenCurve();

	if (closedCmc.isPeriodic() != true)
	    closedCmc = new JgclCompositeCurve2D(closedCmc.segments(), true);

	this.closedCmc = closedCmc;
	this.cmcWise = cmcWise;
	this.validSide = validSide;

	this.parameterOnSegmentCounter = 0;
	this.aTol = JgclConditionOfOperation.getCondition().getToleranceForAngle();
    }

    /**
     * ȐȌӏŕāAȌȂPȕȐ̏Wɂ
     *
     * @return	ȌȂPȕȐ̏W
     */
    JgclCompositeCurve2D[] doIt() {
	// ZOgԂ̎Ȍ_߂
	JgclCompositeCurveSegment2D[] segments = closedCmc.decomposeAsSegmentsRecursively();
	int nSegments = segments.length;
	JgclToleranceForDistance dTol = closedCmc.getToleranceForDistanceAsObject();

	Vector selfIntsList = new Vector();

	for (int i = 0; i < nSegments; i++) {
	    JgclIntersectionPoint2D[] ints;

	    if (segments[i].isFreeform() == true) {
		JgclPolyline2D polyline = segments[i].toPolyline(dTol);
		JgclPoint1D[] parameters = new JgclPoint1D[polyline.nPoints()];
		for (int j = 0; j < polyline.nPoints(); j++) {
		    JgclPointOnCurve2D poc = (JgclPointOnCurve2D)polyline.pointAt(j);
		    parameters[j] = JgclPoint1D.of(poc.parameter());
		}
		JgclPolyline1D polyline1D =
		    new JgclPolyline1D(parameters, polyline.isPeriodic());

		ints = polyline.selfIntersect();
		JgclPoint1D pnt1D;
		for (int j = 0; j < ints.length; j++) {
		    pnt1D = polyline1D.coordinates(ints[j].pointOnCurve1().parameter());
		    ParameterOnSegment posA =
			new ParameterOnSegment(segments[i], i, pnt1D.x());
		    pnt1D = polyline1D.coordinates(ints[j].pointOnCurve2().parameter());
		    ParameterOnSegment posB =
			new ParameterOnSegment(segments[i], i, pnt1D.x());
		    IntersectionInfo intsInfo =
			new IntersectionInfo (ints[j], posA, posB);
		    selfIntsList.addElement(intsInfo);
		}
	    }

	    for (int k = (i + 1); k < nSegments; k++) {
		ints = segments[i].intersect(segments[k]);
		for (int j = 0; j < ints.length; j++) {
		    ParameterOnSegment posA =
			new ParameterOnSegment(segments[i], i, 
					       ints[j].pointOnCurve1().parameter());
		    ParameterOnSegment posB =
			new ParameterOnSegment(segments[k], k,
					       ints[j].pointOnCurve2().parameter());
		    IntersectionInfo intsInfo =
			new IntersectionInfo (ints[j], posA, posB);
		    selfIntsList.addElement(intsInfo);
		}
	    }
	}

	// Ȍ_Ȃ΁AgԂ
	if (selfIntsList.size() == 0) {
	    JgclCompositeCurve2D[] result = new JgclCompositeCurve2D[1];
	    result[0] = closedCmc;
	    return result;
	}

	// Ȍ_\[g
	JgclListSorter.ObjectComparator comparator =
	    new JgclListSorter.ObjectComparator() {
	    public boolean latterIsGreaterThanFormer(java.lang.Object former,
						     java.lang.Object latter) {
		IntersectionInfo f = (IntersectionInfo)former;
		IntersectionInfo l = (IntersectionInfo)latter;
		if (f == l)
		    return false;

		if (f.posA.segmentIndex < l.posA.segmentIndex)
		    return true;

		if (f.posA.segmentIndex > l.posA.segmentIndex)
		    return false;

		return (f.posA.parameter < l.posA.parameter) ? true : false;
	    }
	};
	JgclListSorter.doSorting(selfIntsList, comparator);

	// Ȍ_ŁAP[vɕ
	return divideIntoSimpleLoops(segments, selfIntsList);
    }

    private class ParameterOnSegment {
	JgclCompositeCurveSegment2D segment;
	int segmentIndex;
	double parameter;
	int id;

	ParameterOnSegment(JgclCompositeCurveSegment2D s,
			   int i,
			   double p) {
	    segment = s;
	    segmentIndex = i;
	    parameter = p;
	    id = JgclDivideCmcIntoSimpleLoops2D.this.parameterOnSegmentCounter++;
	}

	boolean isMateBig(ParameterOnSegment mate) {
	    boolean result;

	    if (this.segmentIndex < mate.segmentIndex) {
		result = true;

	    } else if (this.segmentIndex > mate.segmentIndex) {
		result = false;

	    } else {
		result = false;

		if (this.parameter < mate.parameter)
		    result = true;

		if (result == false) {
		    if ((this.id != mate.id) &&
			(!(this.parameter < mate.parameter)) &&
			(!(this.parameter > mate.parameter))) {
			/* 2 parameters are exactly same */
			if (this.id < mate.id) {
			    result = true;
			}
		    }
		}
	    }

	    return result;
	}
    }

    private class IntersectionInfo {
	JgclPoint2D coordinates;
	ParameterOnSegment posA;
	ParameterOnSegment posB;

	IntersectionInfo (JgclPoint2D c,
			  ParameterOnSegment pA,
			  ParameterOnSegment pB) {
	    coordinates = c;
	    posA = pA;
	    posB = pB;
	}
    }

    private static final int VI_A = 0;
    private static final int VI_B = 0;

    private class VertexInfo {
	boolean[] used;			// TRUE if outward path was already used
	ParameterOnSegment[] me;	// pointer to my PntOnCmc
	ParameterOnSegment[] pair;	// pointer to the next-in of outward path

	VertexInfo(ParameterOnSegment posA,
		   ParameterOnSegment posB) {
	    used = new boolean[2];
	    me = new ParameterOnSegment[2];
	    pair = new ParameterOnSegment[2];

	    used[VI_A] = false;
	    used[VI_B] = false;

	    me[VI_A] = posA;
	    me[VI_B] = posB;

	    pair[VI_A] = null;
	    pair[VI_B] = null;
	}
    }

    private VertexInfo[] makeInOutInfo(Vector intersectionList)
    {
	int nVInfo = intersectionList.size();
	VertexInfo[] vInfo = new VertexInfo[nVInfo];

	/*
	 * fill 'me'
	 */
	for (int i = 0; i < nVInfo; i++) {
	    IntersectionInfo ints = (IntersectionInfo)intersectionList.elementAt(i);
	    vInfo[i] = new VertexInfo(ints.posA, ints.posB);
	}

	/*
	 * fill 'pair'
	 */
	for (int i = 0; i < nVInfo; i++) {
	    for (int k = 0; k < 2; k++) {
		for (int j = 0; j < nVInfo; j++) {
		    for (int l = 0; l < 2; l++) {
			if (vInfo[i].pair[k] == null) {
			    if (vInfo[i].me[k].isMateBig(vInfo[j].me[l]) == true)	/* < */
				vInfo[i].pair[k] = vInfo[j].me[l];
			} else {
			    if ((vInfo[i].me[k].isMateBig(vInfo[j].me[l]) == true)	/* < */ && 
				(vInfo[i].pair[k].isMateBig(vInfo[j].me[l]) != true))	/* > */
				vInfo[i].pair[k] = vInfo[j].me[l];
			}
		    }
		}

		if (vInfo[i].pair[k] == null) {	/* vInfo[i].me[k] is greatest */
		    vInfo[i].pair[k] = vInfo[i].me[k];
		    for (int j = 0; j < nVInfo; j++) {
			for (int l = 0; l < 2; l++) {
			    if (vInfo[i].pair[k].isMateBig(vInfo[j].me[l]) != true)	/* > */
				vInfo[i].pair[k] = vInfo[j].me[l];
			}
		    }
		}
	    }
	}

	return vInfo;
    }

    private ParameterOnSegment getUnusedOut(VertexInfo[] vInfo) {
	for (int i = 0; i < vInfo.length; i++) {
	    if (vInfo[i].used[VI_A] == false)
		return vInfo[i].me[VI_A];
	    if (vInfo[i].used[VI_B] == false)
		return vInfo[i].me[VI_B];
	}

	return null;
    }

    private ParameterOnSegment getMate(VertexInfo[] vInfo,
				       ParameterOnSegment popc) {
	for (int i = 0; i < vInfo.length; i++) {
	    if (vInfo[i].me[VI_A] == popc)
		return vInfo[i].me[VI_B];
	    if (vInfo[i].me[VI_B] == popc)
		return vInfo[i].me[VI_A];
	}

	return null;
    }

    private ParameterOnSegment getNextIn(VertexInfo[] vInfo,
					 ParameterOnSegment out) {
	for (int i = 0; i < vInfo.length; i++) {
	    if (vInfo[i].me[VI_A] == out) {
		vInfo[i].used[VI_A] = true;
		return vInfo[i].pair[VI_A];
	    }
	    if (vInfo[i].me[VI_B] == out) {
		vInfo[i].used[VI_B] = true;
		return vInfo[i].pair[VI_B];
	    }
	}

	return null;
    }

    private boolean forward2Right(double cp) {
	return (cp < (- this.aTol));
    }

    private boolean forward2Left(double cp) {
	return (cp > this.aTol);
    }

    private int isValidCmc(JgclVector2D in_tang,
			   JgclVector2D out_tang) {
	JgclVector2D iu_tang = in_tang.unitized();
	JgclVector2D ou_tang = out_tang.unitized();
	double crs_prod = in_tang.zOfCrossProduct(ou_tang);

	int is_valid;

	if (this.cmcWise == JgclLoopWise.CW) {
	    /**/ if (forward2Right(crs_prod))
		is_valid = JgclTrueFalseUndefined.TRUE;
	    else if (forward2Left(crs_prod))
		is_valid = JgclTrueFalseUndefined.FALSE;
	    else
		is_valid = JgclTrueFalseUndefined.UNDEFINED;
	} else { /* CCW */
	    /**/ if (forward2Right(crs_prod))
		is_valid = JgclTrueFalseUndefined.FALSE;
	    else if (forward2Left(crs_prod))
		is_valid = JgclTrueFalseUndefined.TRUE;
	    else
		is_valid = JgclTrueFalseUndefined.UNDEFINED;
	}

	if (this.validSide == JgclWhichSide.OUT) {
	    /**/ if (is_valid == JgclTrueFalseUndefined.TRUE)
		is_valid = JgclTrueFalseUndefined.FALSE;
	    else if (is_valid == JgclTrueFalseUndefined.FALSE)
		is_valid = JgclTrueFalseUndefined.TRUE;
	}

	return is_valid;
    }

    private JgclCompositeCurveSegment2D
    addTruncatedSegment(Vector segmentList,
			JgclCompositeCurveSegment2D segment,
			double sP,
			double eP,
			int transition) {
	JgclParameterSection trimmingSection =
	    new JgclParameterSection(sP, (eP - sP));
	JgclCompositeCurveSegment2D trimmedSegment =
	    segment.truncate(trimmingSection, transition);
	segmentList.addElement(trimmedSegment);
	return trimmedSegment;
    }

    private int getNextSegmentIndex(JgclCompositeCurveSegment2D[] segments,
				    int i) {
	return (++i < segments.length) ? i : 0;
    }

    private JgclCompositeCurve2D[] divideIntoSimpleLoops(JgclCompositeCurveSegment2D[] segments,
							 Vector intersectionList) {
	Vector resultVector = new Vector();

	VertexInfo[] vInfo = makeInOutInfo(intersectionList);

	Vector segmentList;
	JgclCompositeCurveSegment2D lastSegment;

	ParameterOnSegment first_out;
	ParameterOnSegment c_out;
	ParameterOnSegment c_in;
	int loop_is_valid;
	int is_v;

	JgclVector2D in_tang = null;
	JgclVector2D out_tang;
	JgclVector2D first_out_tang = null;

	int segmentIndex;

	while ((first_out = getUnusedOut(vInfo)) != null) {
	    segmentList = new Vector();

	    c_out = first_out;
	    lastSegment = null;
	    loop_is_valid = JgclTrueFalseUndefined.UNDEFINED;

	    do {
		c_in = getNextIn(vInfo, c_out);

		out_tang = c_out.segment.tangentVector(c_out.parameter);

		if (lastSegment == null) {
		    first_out_tang = out_tang;
		} else {
		    is_v = isValidCmc(in_tang, out_tang);
		    if (is_v != JgclTrueFalseUndefined.UNDEFINED) {
			if (loop_is_valid != JgclTrueFalseUndefined.FALSE)
			    loop_is_valid = is_v;
		    }
		}

		if ((c_out.segmentIndex == c_in.segmentIndex) &&
		    (c_out.isMateBig(c_in) == true)) {
		    /*
		     * one curve
		     */
		    lastSegment =
			addTruncatedSegment(segmentList, c_out.segment,
					    c_out.parameter, c_in.parameter,
					    JgclTransitionCode.CONTINUOUS);
		} else {
		    /*
		     * two or more curves
		     */
		    lastSegment =
			addTruncatedSegment(segmentList, c_out.segment,
					    c_out.parameter, c_out.segment.eParameter(),
					    c_out.segment.transition());

		    segmentIndex = c_out.segmentIndex;
		    while ((segmentIndex =
			    getNextSegmentIndex(segments, segmentIndex)) != c_in.segmentIndex) {
			segmentList.addElement(segments[segmentIndex]);
			lastSegment = segments[segmentIndex];
		    }

		    lastSegment =
			addTruncatedSegment(segmentList, c_in.segment,
					    c_in.segment.sParameter(), c_in.parameter,
					    JgclTransitionCode.CONTINUOUS);
		}

		if (lastSegment != null)
		    in_tang = lastSegment.tangentVector(lastSegment.eParameter());

	    } while ((c_out = getMate(vInfo, c_in)) != first_out);

	    is_v = isValidCmc(in_tang, first_out_tang);
	    if (is_v != JgclTrueFalseUndefined.UNDEFINED) {
		if (loop_is_valid != JgclTrueFalseUndefined.FALSE)
		    loop_is_valid = is_v;
	    }

	    JgclCompositeCurveSegment2D[] newSegments =
		new JgclCompositeCurveSegment2D[segmentList.size()];
	    segmentList.copyInto(newSegments);
	    JgclCompositeCurve2D newCurve = new JgclCompositeCurve2D(newSegments, true);
	    resultVector.addElement(newCurve);
	}

	JgclCompositeCurve2D[] result =
	    new JgclCompositeCurve2D[resultVector.size()];
	resultVector.copyInto(result);
	return result;
    }
}
