/*
 * Q : Ȑ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclCompositeCurve2D.java,v 1.73 2000/08/11 06:18:45 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.util.Enumeration;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Q : Ȑ\NXB
 * <p>
 * ȐƂ́A ([_ŘA) ̗LȐ܂Ƃ߂
 * {̋ȐɌĂ̂łB
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * <ul>
 * <li> Ȑ\ZOg̔z segments
 * <li> Ȑ`ۂ\tO periodic
 * </ul>
 * ێB
 * </p>
 * <p>
 * Ȑ̒`͗LŁA
 * Ȑ`łΎIA
 * łȂΔIȂ̂ɂȂB
 * p[^` [0, (ZOg̃p[^Ԃ̑l̑a)] ɂȂB
 * </p>
 *
 * @version $Revision: 1.73 $, $Date: 2000/08/11 06:18:45 $
 * @author Information-technology Promotion Agency, Japan
 * @see JgclCompositeCurveSegment2D
 */

public class JgclCompositeCurve2D extends JgclBoundedCurve2D {

    /**
     * Ȑ\ZOg̔zB
     * @serial
     */
    private JgclCompositeCurveSegment2D[] segments;

    /**
     * `ۂ\tOB
     * @serial
     */
    private boolean periodic;

    /**
     * eZOg (̃ZOg̒`ł) Jnp[^l̔zB
     * <p>
     * ̔z̗vf̓ZOgɓ̂ƂB
     * </p>
     * <p>
     * ̃tB[h́ÃNX̓ł̂ݗpB
     * </p>
     * @serial
     */
    private double[] localStartParams;

    /**
     * eZOg (Ȑ̒`ł) Jnp[^l̔zB
     * <p>
     * ̔z̗vf (ZOg + 1) ƂA
     * Ō̗vfɂ͕Ȑ̒`̏Ip[^l܂߂̂ƂB
     * </p>
     * <p>
     * ̃tB[h́ÃNX̓ł̂ݗpB
     * </p>
     * @serial
     */
    private double[] globalStartParams;

    /**
     * ZOg̔zƊJtO^ăIuWFNg\zB
     * 
     * @param segments	Ȑ\ZOg̔z
     * @param periodic	`ۂ\tO
     */
    public JgclCompositeCurve2D(JgclCompositeCurveSegment2D[] segments,
				boolean periodic) 
    {
	super();

	this.segments = new JgclCompositeCurveSegment2D[segments.length];
	this.periodic = periodic;

	this.localStartParams = new double[segments.length];
	this.globalStartParams = new double[segments.length + 1];

	this.globalStartParams[0] = 0;

	for (int i = 0; i < segments.length; i++) {
	    JgclCompositeCurveSegment2D seg = segments[i];
	    JgclParameterSection sec = seg.parameterDomain().section();

	    this.segments[i] = seg;
	    this.localStartParams[i] = sec.start();
	    this.globalStartParams[i+1] = this.globalStartParams[i] + sec.increase();
	}

    }

    /**
     * ZOg̕Ȑ̔z^ăIuWFNg\zB
     * <p>
     * segments ̗vf sense ̗vfvĂȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * ̃RXgN^ł segments[i]  sense[i] 
     * ȐZOg ({@link JgclCompositeCurveSegment2D JgclCompositeCurveSegment2D})
     * \z邪A
     * ̍ۂ̊eZOǵũZOgƂ̘AvɂẮA
     * ꂼ̋Ȑ̊􉽓IȓAIɔfB
     * </p>
     * <p>
     * Ō̃ZOg̏I_ƍŏ̃ZOg̎n_
     * vĂȂΊJ`A
     * vĂΕ`
     * ̕Ȑ\zB
     * </p>
     * <p>
     * ׂ荇ZOg􉽓IɘAłȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param segments	Ȑ\ZOg̕Ȑ̔z
     * @param sense	Ȑ\ZOǧtO̔z
     * @see	JgclCompositeCurveSegment2D
     * @see	JgclInvalidArgumentValue
     */
    public JgclCompositeCurve2D(JgclBoundedCurve2D[] segments,
				boolean[] sense)
    {
	super();

	if (segments.length != sense.length)
	    throw new JgclInvalidArgumentValue();

	double dTol = JgclConditionOfOperation.getCondition().getToleranceForDistance();

	this.segments = new JgclCompositeCurveSegment2D[segments.length];

	this.localStartParams = new double[segments.length];
	this.globalStartParams = new double[segments.length + 1];

	this.globalStartParams[0] = 0;

	int transition = JgclTransitionCode.UNKNOWN;

	for (int i = 0; i < segments.length; i++) {
	    int j = (i+1 == segments.length) ? 0 : i+1;
	    JgclBoundedCurve2D pseg = segments[i];
	    JgclBoundedCurve2D nseg = segments[j];
	    JgclParameterSection psec = pseg.parameterDomain().section();
	    JgclParameterSection nsec = nseg.parameterDomain().section();
	    double pp = sense[i] ? psec.end() : psec.start();
	    double np = sense[j] ? nsec.start() : nsec.end();
	    JgclCurveDerivative2D pder = pseg.evaluation(pp);
	    JgclCurveDerivative2D nder = nseg.evaluation(np);
	    double pcur = pseg.curvature(pp).curvature();
	    double ncur = nseg.curvature(np).curvature();

	    if (!pder.d0D().identical(nder.d0D())) {
		// sA
		transition = JgclTransitionCode.DISCONTINUOUS;
	    }
	    else if (!pder.d1D().identicalDirection(nder.d1D())) {
		// ڐsA
		transition = JgclTransitionCode.CONTINUOUS;
	    }
	    else if (Math.abs(pcur - ncur) >= dTol) {
		// ڐA & ȗsA
		// CONT_SAME_GRADIENT
		transition = JgclTransitionCode.CONTINUOUS;
	    }
	    else {
		// ڐA & ȗA
		// CONT_SAME_GRADIENT_SAME_CURVATURE
		transition = JgclTransitionCode.CONTINUOUS;
	    }

	    if ((j != 0) && (transition == JgclTransitionCode.DISCONTINUOUS))
		throw new JgclInvalidArgumentValue();

	    this.segments[i] = 
		new JgclCompositeCurveSegment2D(transition, sense[i], pseg);

	    this.localStartParams[i] = psec.start();
	    this.globalStartParams[i+1] = this.globalStartParams[i] + psec.increase();
	}

	this.periodic = (transition == JgclTransitionCode.DISCONTINUOUS) ? false : true;
    }

    /**
     * ̕Ȑ\ZOgԂB
     * 
     * @return	ZOg̔z
     */
    JgclCompositeCurveSegment2D[] segments() {
	return (JgclCompositeCurveSegment2D[]) this.segments.clone();
    }

    /**
     * ̕Ȑ (ċAI) ZOgɕB
     * 
     * @return	ZOg̔z
     */
    JgclCompositeCurveSegment2D[] decomposeAsSegmentsRecursively() {
	Vector resultList = new Vector();

	for (int i = 0; i < nSegments(); i++) {
	    JgclCompositeCurveSegment2D segment = this.segmentAt(i);
	    JgclBoundedCurve2D parent = segment.parentCurve();
	    if (parent.type() == COMPOSITE_CURVE_2D) {
		JgclCompositeCurve2D parentCmc = (JgclCompositeCurve2D)parent;
		JgclCompositeCurveSegment2D[] parentSegments =
		    parentCmc.decomposeAsSegmentsRecursively();
		JgclCompositeCurveSegment2D revised;
		if (segment.sameSense() == true) {
		    int j;
		    for (j = 0; j < (parentSegments.length - 1); j++)
			resultList.addElement(parentSegments[j]);
		    revised = parentSegments[j].
			makeCopyWithTransition(segment.transition());
		    resultList.addElement(revised);
		} else {
		    int j;
		    for (j = (parentSegments.length - 1); j > 0; j--) {
			revised = parentSegments[j].
			    makeReverseWithTransition(parentSegments[j-1].transition());
			resultList.addElement(revised);
		    }
		    revised = parentSegments[j].
			makeReverseWithTransition(segment.transition());
		    resultList.addElement(revised);
		}
	    } else {
		resultList.addElement(segment);
	    }
	}

	JgclCompositeCurveSegment2D[] result =
	    new JgclCompositeCurveSegment2D[resultList.size()];
	resultList.copyInto(result);
	return result;
    }

    /**
     * ̕Ȑ`ۂԂB
     * 
     * @return	`ł trueAȂ false
     */
    public boolean periodic() {
	return this.periodic;
    }

    /**
     * ̕Ȑ\ZOg̐ԂB
     * 
     * @return	ZOg̐
     */
    public int nSegments() {
	return this.segments.length;
    }

    /**
     * ̕Ȑ ith Ԗڂ̃ZOgԂB
     * 
     * @param ith	ZOg̃CfbNX
     * @return		ith Ԗڂ̃ZOg
     */
    public JgclCompositeCurveSegment2D segmentAt(int ith) {
	return this.segments[ith];
    }

    /**
     * ZOg̃CfbNXƂ̃ZOgł̋Ǐp[^l\NXB
     */
    class CompositeIndexParam {
	/**
	 * ZOg̃CfbNXB
	 */
	int index;

	/**
	 * Ǐp[^lB
	 * <p>
	 * ̒l [0, ZOg̃p[^Ԃ̑l] Ɏ܂B
	 * </p>
	 */
	double param;
    }

    /**
     * ̕Ȑɑ΂ė^ꂽp[^lA
     * ɑΉZOg̃CfbNX
     * ̃ZOgł̋ǏIȃp[^lɕϊB
     * <p>
     * ^ꂽp[^l̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param param	p[^l
     * @return		ZOg̃CfbNXƋǏp[^l
     */
    private CompositeIndexParam getIndexParam(double param)
    {
	JgclParameterDomain domain = parameterDomain();
	CompositeIndexParam ip = new CompositeIndexParam();

	checkValidity(param);
	param = domain.wrap(param);
	ip.index = JgclUtil.bsearchDoubleArray(globalStartParams, 1, (nSegments() - 1), param);
	ip.param = localStartParams[ip.index] + (param - globalStartParams[ip.index]);
	return ip;
    }

    /**
     * ̕Ȑ̂ZOg̃CfbNX
     * ̃ZOgł̋ǏIȃp[^l
     * ̕Ȑɑ΂p[^lɕϊB
     * 
     * @param index	ZOg̃CfbNX
     * @param param	ZOgł̋Ǐp[^l
     * @return		̕Ȑɑ΂p[^l
     */
    private double getCompositeParam(int index, double param) {
	return globalStartParams[index] + (param - localStartParams[index]);
    }

    /**
     * ̕Ȑ̊Jn_ԂB
     * <p>
     * ̕Ȑ`̏ꍇɂ null ԂB
     * </p>
     *
     * @return	Jn_
     */
    public JgclPoint2D startPoint() {
	if (isPeriodic())
	    return null;
	return segments[0].startPoint();
    }

    /**
     * ̕Ȑ̏I_ԂB
     * <p>
     * ̕Ȑ`̏ꍇɂ null ԂB
     * </p>
     *
     * @return	I_
     */
    public JgclPoint2D endPoint() {
	if (isPeriodic())
	    return null;

	int n = nSegments();
	return segments[n-1].endPoint();
    }

    /**
     * {@link #length(JgclParameterSection) length(JgclParameterSection)}
     * 邽߂ SegmentAccumulator ̎B
     */
    private class LengthAccumulator extends SegmentAccumulator {
	/**
	 * Ȑ̎w̋Ԃ̒B
	 */
	double length;

	/**
	 * leng  0 ɏB
	 *
	 * @param nsegs	ΏۂƂȂZOg̐
	 */
	void allocate(int nsegs) {
	    length = 0.0;
	}

	/**
	 * ^ꂽZOg̎w̋Ԃ̓̂ leng ɑB
	 *
	 * @param seg	ZOg
	 * @param sec	p[^
	 * @param compIndex	ZOg̔ԍ
	 */
	void doit(JgclCompositeCurveSegment2D seg,
		  JgclParameterSection sec,
		  int compIndex) {
	    length += seg.length(sec);
	}

	/**
	 * Ȑ̎w̋Ԃ̒ԂB
	 *
	 * @param leng ̒l
	 */
	double extract()
	{
	    return length;
	}
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ̑l͕ł܂ȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     * @see	JgclParameterOutOfRange
     */
    public double length(JgclParameterSection pint)
    {
        LengthAccumulator acc = new LengthAccumulator();
	acc.accumulate(pint);

        return acc.extract();
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		Wl
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint2D coordinates(double param)
    {
	CompositeIndexParam ip = getIndexParam(param);
	return segments[ip.index].coordinates(ip.param);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ڃxNg
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclVector2D tangentVector(double param)
    {
	CompositeIndexParam ip = getIndexParam(param);
	return segments[ip.index].tangentVector(ip.param);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return	ȗ
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveCurvature2D curvature(double param)
    {
	CompositeIndexParam ip = getIndexParam(param);
	return segments[ip.index].curvature(ip.param);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		֐
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveDerivative2D evaluation(double param)
    {
	CompositeIndexParam ip = getIndexParam(param);
	return segments[ip.index].evaluation(ip.param);
    }

    /**
     * {@link #singular() singular()}
     * 邽߂ SegmentAccumulator ̎B
     */
    private class SingularAccumulator extends SegmentAccumulator {
    JgclCompositeCurve2D curve;
	Vector singularVec;
	JgclIndefiniteSolution inf;

	SingularAccumulator(JgclCompositeCurve2D curve) {
	    this.curve = curve;
	    inf = null;
	}

	void allocate(int nsegs) {
	    singularVec = new Vector();
	}

	void doit(JgclCompositeCurveSegment2D seg,
		  JgclParameterSection sec,
		  int compIndex) {
	    JgclPointOnCurve2D[] singular;
	
	    try {
		singular = seg.singular();
	    }
	    catch (JgclIndefiniteSolution e) {
		inf = e;
		return;
	    }

	    double param;
	    for (int i = 0; i < singular.length; i++) {
		param = getCompositeParam(compIndex, singular[i].parameter());
		singularVec.addElement
		    (new JgclPointOnCurve2D(curve, param, doCheckDebug));
	    }

	    if (seg.transition() == JgclTransitionCode.CONTINUOUS) {
		param = getCompositeParam(compIndex, sec.end());
		singularVec.addElement
		    (new JgclPointOnCurve2D(curve, param, doCheckDebug));
	    }
	}

	JgclPointOnCurve2D[] extract() throws JgclIndefiniteSolution
	{
	    if (inf != null)
		throw inf;

	    JgclPointOnCurve2D[] thisSingular =
		new JgclPointOnCurve2D[singularVec.size()];
	    singularVec.copyInto(thisSingular);

	    return thisSingular;
	}
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ٓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return		ٓ_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve2D[] singular() throws JgclIndefiniteSolution {
	SingularAccumulator acc = new SingularAccumulator(this);

	try {
	    acc.accumulate(parameterDomain().section());
	}
	catch(JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
	return acc.extract();
    }

    /**
     * {@link #inflexion() inflexion()}
     * 邽߂ SegmentAccumulator ̎B
     */
    private class InflexionAccumulator extends SegmentAccumulator {
	JgclCompositeCurve2D curve;
	Vector inflexionVec;
	JgclIndefiniteSolution inf;

	InflexionAccumulator(JgclCompositeCurve2D curve) {
	    this.curve = curve;
	    inf = null;
	}

	void allocate(int nsegs) {
	    inflexionVec = new Vector();
	}

	void doit(JgclCompositeCurveSegment2D seg,
		  JgclParameterSection sec,
		  int compIndex) {
	    JgclPointOnCurve2D[] inflexion;

	    try {
		inflexion = seg.inflexion();
	    }
	    catch (JgclIndefiniteSolution e) {
		inf = e;
		return;
	    }

	    double param;
	    for (int i = 0; i < inflexion.length; i++) {
		param = getCompositeParam
		    (compIndex, inflexion[i].parameter());
		inflexionVec.addElement
		    (new JgclPointOnCurve2D(curve, param, doCheckDebug));
	    }
	    if (seg.transition() == JgclTransitionCode.CONT_SAME_GRADIENT) {
		param = getCompositeParam(compIndex, sec.end());
		inflexionVec.addElement
		    (new JgclPointOnCurve2D(curve, param, doCheckDebug));
	    }
	}

	JgclPointOnCurve2D[] extract() throws JgclIndefiniteSolution
	{
	    if (inf != null)
		throw inf;

	    JgclPointOnCurve2D[] thisInflexion =
		new JgclPointOnCurve2D[inflexionVec.size()];
	    inflexionVec.copyInto(thisInflexion);

	    return thisInflexion;
	}
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ϋȓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return	ϋȓ_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve2D[] inflexion() throws JgclIndefiniteSolution {
	InflexionAccumulator acc = new InflexionAccumulator(this);

	try {
	    acc.accumulate(parameterDomain().section());
	}
	catch(JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
	return acc.extract();
    }

    /**
     * ΏۂƂȂp[^ԂɊ܂܂ZOgɔCӂ̏{߂̒ۃNXB
     */
    private abstract class SegmentAccumulator {
	/**
	 * ^ꂽZOg̎w͈̔͂ɂāA炩̏sȂۃ\bhB
	 * <p>
	 * ̃\bh
	 * {@link #accumulate(JgclParameterSection) accumulate(JgclParameterSection)}
	 * ̒ŌĂяoB
	 * </p>
	 *
	 * @param seg	ZOg
	 * @param sec	p[^
	 * @param compIndex	ZOg̔ԍ
	 */
	abstract void doit(JgclCompositeCurveSegment2D seg,
			   JgclParameterSection sec,
			   int compIndex);

	/**
	 * ^ꂽZOg̎w͈̔͂ɂāA炩̏sȂۃ\bhB
	 * <p>
	 * ̃\bh
	 * {@link #accumulate(JgclParameterSection) accumulate(JgclParameterSection)}
	 * ̒ŌĂяoB
	 * </p>
	 *
	 * @param seg	ZOg
	 * @param sp	p[^Ԃ̊Jnl
	 * @param ep	p[^Ԃ̏Il
	 * @param compIndex	ZOg̔ԍ
	 */
	void doit(JgclCompositeCurveSegment2D seg, double sp, double ep,
		  int compIndex) {
	    doit(seg, new JgclParameterSection(sp, ep), compIndex);
	}

	/**
	 * 炩̏n߂邽߂̏sȂۃ\bhB
	 * <p>
	 * ̃\bh
	 * {@link #accumulate(JgclParameterSection) accumulate(JgclParameterSection)}
	 * ̒
	 * {@link #doit(JgclCompositeCurveSegment2D, double, double, int)
	 * doit(JgclCompositeCurveSegment2D, double, double, int)}
	 * ĂяoOɌĂяoB
	 * </p>
	 */
	abstract void allocate(int nsegs);

	/**
	 * ^ꂽp[^ԂɊ܂܂ZOg 
	 * {@link #doit(JgclCompositeCurveSegment2D, double, double, int)
	 * doit(JgclCompositeCurveSegment2D, double, double, int)}
	 * ĂяoB
	 */
	void accumulate(JgclParameterSection pint)
	{
	    CompositeIndexParam sx;
	    CompositeIndexParam ex;
	    JgclParameterDomain domain = parameterDomain();
	    boolean wraparound;

	    if (domain.isPeriodic()) {
		double sp = domain.wrap(pint.start());
		double ep = sp + pint.increase();
		sx = getIndexParam(sp);
		ex = getIndexParam(ep);
		wraparound = (domain.section().increase() < ep);
	    }
	    else {
		sx = getIndexParam(pint.lower());
		ex = getIndexParam(pint.upper());
		wraparound = false;
	    }

	    int nsegs;
	    if (wraparound) {
		// tail: segments.length - sx.index
		// head: ex.index + 1
		nsegs = segments.length + ex.index - sx.index + 1;
	    }
	    else {
		nsegs = ex.index - sx.index + 1;
	    }
	    allocate(nsegs);

	    JgclCompositeCurveSegment2D seg;

	    if (nsegs == 1)
		doit(segments[sx.index], sx.param, ex.param, sx.index);
	    else if (wraparound) {
		seg = segments[sx.index];
		doit(seg, sx.param, seg.eParameter(), sx.index);

		int i;
		for (i = sx.index+1; i < segments.length; i++) {
		    seg = segments[i];
		    doit(seg, seg.sParameter(), seg.eParameter(), i);
		}

		for (i = 0; i < ex.index; i++) {
		    seg = segments[i];
		    doit(seg, seg.sParameter(), seg.eParameter(), i);
		}
		seg = segments[ex.index];
		doit(seg, seg.sParameter(), ex.param, ex.index);
	    }
	    else {
		seg = segments[sx.index];
		doit(seg, sx.param, seg.eParameter(), sx.index);

		int i;
		for (i = sx.index+1; i < ex.index; i++) {
		    seg = segments[i];
		    doit(seg, seg.sParameter(), seg.eParameter(), i);
		}
		seg = segments[ex.index];
		doit(seg, seg.sParameter(), ex.param, ex.index);
	    }
	}
    }

    /**
     * {@link #projectFrom(JgclPoint2D) projectFrom(JgclPoint2D)}
     * 邽߂ SegmentAccumulator ̎B
     */
    private class ProjectionAccumulator extends SegmentAccumulator {
	JgclPoint2D point;
	JgclCompositeCurve2D curve;
	JgclPointOnGeometryList projList;
	JgclIndefiniteSolution inf;

	ProjectionAccumulator(JgclPoint2D point,
			      JgclCompositeCurve2D curve) {
	    this.curve = curve;
	    this.point = point;
	    inf = null;
	}

	void allocate(int nsegs) {
	    projList = new JgclPointOnGeometryList();
	}

	void doit(JgclCompositeCurveSegment2D seg,
		  JgclParameterSection sec,
		  int compIndex) {
	    JgclPointOnCurve2D[] proj;
	    try {
		proj = seg.projectFrom(point);
	    }
	    catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	    catch (JgclIndefiniteSolution e) {
		inf = e;
		return;
	    }

	    for (int i = 0; i < proj.length; i++) {
 		double param = getCompositeParam(compIndex, proj[i].parameter());
		projList.addPoint(curve, param);
	    }
	}

	JgclPointOnCurve2D[] extract()
	    throws JgclIndefiniteSolution
	{
	    if (inf != null)
		throw inf;

	    return projList.toJgclPointOnCurve2DArray();
	}
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param point	e̓_
     * @return	e_
     */
    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point)
	throws JgclIndefiniteSolution
    {
	ProjectionAccumulator acc = new ProjectionAccumulator(point, this);

	try {
	    acc.accumulate(parameterDomain().section());
	}
	catch(JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
	return acc.extract();
    }

    /**
     * {@link #toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * 邽߂ SegmentAccumulator ̎B
     */
    private class ToPolylineAccumulator extends SegmentAccumulator {
	JgclToleranceForDistance tol;
	JgclPolyline2D[] pls;
	JgclCompositeCurveSegment2D[] segs;
	int[] compIndex;
	JgclCompositeCurve2D curve;
	int segIndex;

	ToPolylineAccumulator(JgclToleranceForDistance tol,
			      JgclCompositeCurve2D curve) {
	    this.tol = tol;
	    this.curve = curve;
	    segIndex = 0;
	}

	void allocate(int nsegs) {
	    pls = new JgclPolyline2D[nsegs];
	    segs = new JgclCompositeCurveSegment2D[nsegs];
	    compIndex = new int[nsegs];
	}

	void doit(JgclCompositeCurveSegment2D seg,
		  JgclParameterSection sec,
		  int compIndex) {
	    segs[segIndex] = seg;
	    this.compIndex[segIndex] = compIndex;
	    try {
		pls[segIndex] = seg.toPolyline(sec, tol);
	    }
	    catch (JgclZeroLength e) {
		pls[segIndex] = null;
	    }
	    segIndex++;
	}

	JgclPolyline2D extract() {
	    int npnts = 1;
	    int i, j, k;

	    for (i = 0; i < pls.length; i++) {
		if (pls[i] == null)
		    continue;
		npnts += (pls[i].nPoints() - 1);
	    }

	    if (npnts < 2)
		throw new JgclZeroLength();

	    JgclPointOnCurve2D[] points = new JgclPointOnCurve2D[npnts];

	    k = 0;

	    double param;
	    for (i = 0; i < pls.length; i++) {
		if (pls[i] == null)
		    continue;
		for (j = 0; j < pls[i].nPoints(); j++) {
		    JgclPointOnCurve2D pnts =
			(JgclPointOnCurve2D)pls[i].pointAt(j);
		    param = getCompositeParam(compIndex[i], pnts.parameter());
		    if (i == 0 || j != 0) {
			try {
			    points[k++] = new JgclPointOnCurve2D(curve, param, doCheckDebug);
			}
			catch(JgclInvalidArgumentValue e) {
			    throw new JgclFatal();
			}
		    }
		}
	    }

	    return new JgclPolyline2D(points);
	}
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_́A
     * ̋Ȑx[XƂ JgclPointOnCurve2D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     */
    public JgclPolyline2D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol) 
    {
	if (pint.increase() < 0.0) {
	    return toPolyline(pint.reverse(), tol).reverse();
	}

	ToPolylineAccumulator accm = new ToPolylineAccumulator(tol, this);
	accm.accumulate(pint);

	return accm.extract();
    }

    /**
     * {@link #toBsplineCurve(JgclParameterSection)
     * toBsplineCurve(JgclParameterSection)}
     * 邽߂ SegmentAccumulator ̎B
     */
    private class ToBsplineCurveAccumulator extends SegmentAccumulator {
	JgclBsplineCurve2D result;

	ToBsplineCurveAccumulator() {
	}

	void allocate(int nsegs) {
	    result = null;
	}

	void doit(JgclCompositeCurveSegment2D seg,
		  JgclParameterSection sec,
		  int compIndex) {
	    try {
		JgclBsplineCurve2D bsc = seg.toBsplineCurve(sec);
		result = (result == null) ? bsc : result.mergeIfContinuous(bsc);
	    } catch (JgclTwoGeomertiesAreNotContinuous e) {
		// ł̂H
		throw new JgclFatal();
	    }
	}

	JgclBsplineCurve2D extract() {
	    return result;
	}
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     */
    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
	ToBsplineCurveAccumulator accm = new ToBsplineCurveAccumulator();
	accm.accumulate(pint.positiveIncrease());
	JgclBsplineCurve2D result = accm.extract();

	// KOKO : Ăꍇ̏

	if (pint.increase() < 0.0)
	    result = result.reverse();

	return result;
    }

    /**
     * {@link #doIntersect(JgclParametricCurve2D, boolean)
     * doIntersect(JgclParametricCurve2D, boolean)}
     * 邽߂ SegmentAccumulator 
     */
    private class IntersectionAccumulator extends SegmentAccumulator {
	JgclParametricCurve2D mate;
	JgclCompositeCurve2D curve;
	Vector intsvec;

	IntersectionAccumulator(JgclParametricCurve2D mate,
				JgclCompositeCurve2D curve) {
	    this.curve = curve;
	    this.mate = mate;
	}

	void allocate(int nsegs) {
	    intsvec = new Vector();
	}

	void doit(JgclCompositeCurveSegment2D seg,
		  JgclParameterSection sec,
		  int compIndex) {

	    JgclIntersectionPoint2D[] ints = seg.intersect(mate);

	    for (int i = 0; i < ints.length; i++) {
		double cparam = ints[i].pointOnCurve1().parameter();
 		double sparam = getCompositeParam(compIndex, cparam);

		JgclPointOnCurve2D thisPnts =
		    new JgclPointOnCurve2D(curve, sparam, doCheckDebug);
		JgclIntersectionPoint2D thisInts =
		    new JgclIntersectionPoint2D(thisPnts,
						ints[i].pointOnCurve2(), doCheckDebug);
		intsvec.addElement(thisInts);
	    }
	}

	JgclIntersectionPoint2D[] extract(boolean doExchange) {
	    JgclIntersectionPoint2D[] ints =
		new JgclIntersectionPoint2D[intsvec.size()];
	    intsvec.copyInto(ints);
	    if (doExchange)
		for (int i = 0; i < ints.length; i++)
		    ints[i] = ints[i].exchange();
	    return ints;
	}
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * ̋Ȑ̊eZOgƑ̋Ȑ̌_߂ɁA
     * ̃ZOgɑ΂p[^l
     * ̋Ȑɑ΂p[^lɕϊ
     * u_vƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    private JgclIntersectionPoint2D[] doIntersect(JgclParametricCurve2D mate,
						  boolean doExchange) {
	IntersectionAccumulator acc = new IntersectionAccumulator(mate, this);
	acc.accumulate(parameterDomain().section());

	return acc.extract(doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return	_̔z
     */
    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
	return doIntersect(mate, false);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		Ȑ̊̔z
     */
    public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate) {
	return this.getInterference(mate, false);
    }

    /**
     * ̗LȐƑ̗LȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * ̋Ȑ̊eZOgƑ̋Ȑ̊߂ɁA
     * ̃ZOgɑ΂p[^l
     * ̋Ȑɑ΂p[^lɕϊ
     * uvƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    private JgclCurveCurveInterference2D[] getInterference(JgclBoundedCurve2D mate,
							   boolean doExchange) {
	JgclCurveCurveInterferenceList interferenceList
	    = new JgclCurveCurveInterferenceList(this, mate);

	// this ̊eZOgɑ΂
	for (int i = 0; i < nSegments(); i++) {
	    // ZOgxł̊𓾂
	    JgclCurveCurveInterference2D[] localInterferences
		= this.segmentAt(i).interfere(mate, false);

	    // _Xgɒǉ
	    Vector intsList
		= JgclCurveCurveInterferenceList.extractIntersections
		(localInterferences);
	    for (Enumeration e = intsList.elements(); e.hasMoreElements();)
	    {
		JgclIntersectionPoint2D ints
		    = (JgclIntersectionPoint2D)e.nextElement();
		interferenceList.addAsIntersection
		    (ints.coordinates(),
		     ints.pointOnCurve1().parameter(),
		     this.getCompositeParam(i, ints.pointOnCurve2().parameter()));
	    }

	    // dXgɒǉ
	    Vector ovlpList
		= JgclCurveCurveInterferenceList.extractOverlaps
		(localInterferences);
	    for (Enumeration e = ovlpList.elements(); e.hasMoreElements();)
	    {
		JgclOverlapCurve2D ovlp
		    = (JgclOverlapCurve2D)e.nextElement();
		interferenceList.addAsOverlap
		    (ovlp.start1(),
		     this.getCompositeParam(i, ovlp.start2()),
		     ovlp.increase1(),
		     ovlp.increase2());
	    }
	}

	interferenceList.removeOverlapsContainedInOtherOverlap();
	interferenceList.removeIntersectionsContainedInOverlap();

	return interferenceList.toJgclCurveCurveInterference2DArray(doExchange);;
    }

    /**
     * ̗LȐƑ̗LȐ () ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ ()
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#getInterference(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate,
					     boolean doExchange) {
	return this.getInterference(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (|C) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (|C)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#getInterference(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate,
					     boolean doExchange) {
	return this.getInterference(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (xWGȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (xWGȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#getInterference(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate,
					     boolean doExchange) {
	return this.getInterference(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (aXvCȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (aXvCȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#getInterference(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate,
					     boolean doExchange) {
	return this.getInterference(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (gȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (gȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#getInterference(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate,
					     boolean doExchange) {
	return this.getInterference(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (ȐZOg) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (ȐZOg)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#getInterference(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate,
					     boolean doExchange) {
	return this.getInterference(mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (Ȑ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (Ȑ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#getInterference(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate,
					     boolean doExchange) {
	return this.getInterference(mate, doExchange);
    }

    /**
     * {@link #offsetByCompositeCurve(JgclParameterSection, double, int, JgclToleranceForDistance)
     * offsetByCompositeCurve(JgclParameterSection, double, int, JgclToleranceForDistance)}
     * 邽߂ SegmentAccumulator ̎B
     */
    private class OffsetByCompositeCurveAccumulator extends SegmentAccumulator {
	double magni;
	int side;
	JgclToleranceForDistance tol;
	int offsettedCurveIndex;
	JgclBoundedCurve2D[] offsettedCurves;
	JgclPoint2D[] vertices;

	OffsetByCompositeCurveAccumulator(double magni,
					int side,
					JgclToleranceForDistance tol) {
	    this.magni = magni;
	    this.side = side;
	    this.tol = tol;
	}

	void allocate(int nsegs) {
	    offsettedCurveIndex = 0;
	    offsettedCurves = new JgclBoundedCurve2D[nsegs];
	    vertices = new JgclPoint2D[nsegs];
	}

	void doit(JgclCompositeCurveSegment2D seg,
		  JgclParameterSection sec,
		  int compIndex) {
	    offsettedCurves[offsettedCurveIndex] =
		seg.offsetByBoundedCurve(sec, this.magni, this.side, this.tol);
	    vertices[offsettedCurveIndex] = seg.coordinates(sec.start());
	    offsettedCurveIndex++;
	}

	JgclBoundedCurve2D[] extract() {
	    return offsettedCurves;
	}

	JgclPoint2D[] extract2() {
	    return vertices;
	}
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ镡Ȑ߂B
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ镡Ȑ
     * @see	JgclWhichSide
     */
    public JgclCompositeCurve2D
    offsetByCompositeCurve(JgclParameterSection pint,
			   double magni,
			   int side,
			   JgclToleranceForDistance tol)
    {
	boolean offsettedIsPeriodic = false;
	if (this.isPeriodic() == true) {
	    if ((this.parameterDomain().section().absIncrease() - pint.absIncrease()) <
		this.getToleranceForParameter())
		offsettedIsPeriodic = true;
	}

	OffsetByCompositeCurveAccumulator accm
	    = new OffsetByCompositeCurveAccumulator(magni, side, tol);
	accm.accumulate(pint);
	JgclBoundedCurve2D[] offsettedCurves = accm.extract();
	int nOffsettedCurves = offsettedCurves.length;
	JgclPoint2D[] vertices = accm.extract2();

	JgclCompositeCurveSegment2D[] offsetted =
	    new JgclCompositeCurveSegment2D[2 * nOffsettedCurves];

	JgclBoundedCurve2D prevOffsettedCurve = null;
	JgclBoundedCurve2D crntOffsettedCurve = null;
	JgclBoundedCurve2D firstOffsettedCurve = offsettedCurves[0];

	int transition;

	for (int i = 0; i <= nOffsettedCurves; i++) {
	    /*
	     * offset the curve
	     */
	    if (i < nOffsettedCurves) {
		crntOffsettedCurve = offsettedCurves[i];

		transition = JgclTransitionCode.CONTINUOUS;
		if ((offsettedIsPeriodic == false) && (i == (nOffsettedCurves - 1)))
		    transition = JgclTransitionCode.DISCONTINUOUS;

		offsetted[2 * i] =
		    new JgclCompositeCurveSegment2D(transition, true,
						    crntOffsettedCurve);
	    } else {
		crntOffsettedCurve = offsettedCurves[0];
	    }

	    /*
	     * offset the corner
	     */
	    if (i == 0) {
		// start point at first offsetted segment
		; // do nothing
	    } else if ((i == nOffsettedCurves) && (offsettedIsPeriodic == false)) {
		// start point at first offsetted segment, but offsetted is open
		offsetted[2 * i - 1] = null;
	    } else if (prevOffsettedCurve.endPoint().identical(crntOffsettedCurve.startPoint()) == true) {
		// end point at prev. and start point at crnt. are identical
		offsetted[2 * i - 1] = null;
	    } else {
		JgclPoint2D center = (i < nOffsettedCurves) ? vertices[i] : vertices[0];
		JgclTrimmedCurve2D offsettedCorner =
		    JgclCircle2D.makeTrimmedCurve(center,
						  prevOffsettedCurve.endPoint(),
						  crntOffsettedCurve.startPoint());
		transition = JgclTransitionCode.CONTINUOUS;

		offsetted[2 * i - 1] =
		    new JgclCompositeCurveSegment2D(transition, true,
						    offsettedCorner);
	    }

	    prevOffsettedCurve = crntOffsettedCurve;
	}

	Vector listOfOffsetted = new Vector();
	for (int i = 0; i < (2 * nOffsettedCurves); i++)
	    if (offsetted[i] != null)
		listOfOffsetted.addElement(offsetted[i]);

	offsetted = new JgclCompositeCurveSegment2D[listOfOffsetted.size()];
	listOfOffsetted.copyInto(offsetted);

	return new JgclCompositeCurve2D(offsetted, offsettedIsPeriodic);
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂B
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     */
    public JgclBsplineCurve2D
    offsetByBsplineCurve(JgclParameterSection pint,
			 double magni,
			 int side,
			 JgclToleranceForDistance tol)
    {
	JgclCompositeCurve2D cmc =
	    this.offsetByCompositeCurve(pint, magni, side, tol);

	return cmc.toBsplineCurve();
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎLȐ߂B
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎLȐ
     * @see	JgclWhichSide
     */
    public JgclBoundedCurve2D
    offsetByBoundedCurve(JgclParameterSection pint,
			 double magni,
			 int side,
			 JgclToleranceForDistance tol)
    {
	return this.offsetByCompositeCurve(pint, magni, side, tol);
    }

    /**
     * ȐȌӏŕāAȌȂPȕȐ̏WɂB
     * <p>
     * ̃\bhĂ΂ۂ̕Ȑ́AȐ
     * {@link #offsetByCompositeCurve(JgclParameterSection, double, int, JgclToleranceForDistance)
     * offsetByCompositeCurve(JgclParameterSection, double, int, JgclToleranceForDistance)}
     * ŃItZbgʂł̂Ƒz肵ĂB
     * </p>
     * <p>
     * cmcWise ͕Ȑ̉lŁA
     * v (E) ɉĂ (ƌȂ) ̂ł JgclLoopWise.CWA
     * v () ɉĂ (ƌȂ) ̂ł JgclLoopWise.CCW
     * w肷B
     * </p>
     * <p>
     * valid_side  this ̋Ȑǂ瑤ɃItZbĝł邩lŁA
     * this ̋ȐɃItZbĝł JgclWhichSide.INA
     * łȂ this ̋ȐOɃItZbĝł JgclWhichSide.OUT
     * w肷
     * </p>
     *
     * @param cmcWise	Ȑ̉l
     * @param validSide	̋Ȑǂ瑤ɃItZbĝł邩l
     * @return	ȌȂPȕȐ̏W
     * @exception JgclOpenCurve	JȐł
     * @see	JgclLoopWise
     * @see	JgclWhichSide
     */
    public JgclCompositeCurve2D[] divideIntoSimpleLoopsIfClosed(int cmcWise,
								int validSide)
	 throws JgclOpenCurve
    {
	JgclDivideCmcIntoSimpleLoops2D proc =
	    new JgclDivideCmcIntoSimpleLoops2D(this, cmcWise, validSide);
	return proc.doIt();
    }

    /**
     * {@link #doFillet(JgclParameterSection, int, JgclParametricCurve2D, JgclParameterSection, int, double, boolean)
     * doFillet(JgclParameterSection, int, JgclParametricCurve2D, JgclParameterSection, int, double, boolean)}
     * 邽߂ SegmentAccumulator ̎B
     */
    private class FilletAccumulator extends SegmentAccumulator {
	JgclParametricCurve2D mate;
	JgclCompositeCurve2D curve;
	JgclParameterSection mateSec;
	int mateSide;
	int mySide;
	double radius;
	boolean doExchange;
	JgclFilletObjectList fltList;

	FilletAccumulator(JgclParametricCurve2D mate,
			  JgclParameterSection mateSec,
			  int mateSide,
			  JgclCompositeCurve2D curve,
			  int mySide,
			  double radius,
			  boolean doExchange) {
	    this.curve = curve;
	    this.mate = mate;
	    this.mateSec = mateSec;
	    this.mateSide = mateSide;
	    this.mySide = mySide;
	    this.radius = radius;
	    this.doExchange = doExchange;
	}

	void allocate(int nsegs) {
	    fltList = new JgclFilletObjectList();
	}

	void doit(JgclCompositeCurveSegment2D seg,
		  JgclParameterSection sec,
		  int compIndex) {

	    JgclFilletObject2D[] flts;
	    try {
		flts = seg.fillet(sec, mySide, mate, mateSec, mateSide, radius);
	    } catch (JgclIndefiniteSolution e) {
		flts = new JgclFilletObject2D[1];
		flts[0] = (JgclFilletObject2D)e.suitable();
	    }

	    JgclFilletObject2D thisFlt;

	    for (int i = 0; i < flts.length; i++) {
		double cparam = flts[i].pointOnCurve1().parameter();
 		double sparam = getCompositeParam(compIndex, cparam);

		JgclPointOnCurve2D thisPnt = new JgclPointOnCurve2D(curve, sparam, doCheckDebug);
		if (!doExchange)
		    thisFlt = new JgclFilletObject2D(radius, flts[i].center(), thisPnt, flts[i].pointOnCurve2());
		else
		    thisFlt = new JgclFilletObject2D(radius, flts[i].center(), flts[i].pointOnCurve2(), thisPnt);
		fltList.addFillet(thisFlt);
	    }
	}

	JgclFilletObject2D[] extract() {
	    return fltList.toJgclFilletObject2DArray(false);
	}
    }

    /**
     * ̋Ȑ̎w̋ԂƁA̋Ȑ̎w̋ԂɂtBbg߂B
     * <p>
     * tBbg݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param pint1	̋Ȑ̃p[^
     * @param side1	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param mate	̋Ȑ
     * @param pint2	̋Ȑ̃p[^
     * @param side2	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param radius	tBbga
     * @param doExchange	tBbg point1/2 邩ǂ
     * @return		tBbg̔z
     * @exception JgclIndefiniteSolution	s (ł͔Ȃ)
     */
    JgclFilletObject2D[]
	doFillet(JgclParameterSection pint1, int side1, JgclParametricCurve2D mate,
		 JgclParameterSection pint2, int side2, double radius,
		 boolean doExchange)
	throws JgclIndefiniteSolution
    {
	FilletAccumulator acc = new FilletAccumulator(mate, pint2, side2, this, side1, radius, doExchange);
	acc.accumulate(pint1);
	return acc.extract();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʐڐ߂B
     * <p>
     * ʐڐ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     *
     * @param mate	̋Ȑ
     * @return		ʐڐ̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʖ@߂B
     * <p>
     * ʖ@݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʖ@̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonNormal2D[]	commonNormal(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     *
     * @return	p[^`
     */
    JgclParameterDomain getParameterDomain() {
	try {
	    return new JgclParameterDomain(periodic, 0,
					   globalStartParams[nSegments()]);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve2D#COMPOSITE_CURVE_2D JgclParametricCurve2D.COMPOSITE_CURVE_2D}
     */
    int type() {
	return COMPOSITE_CURVE_2D;
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	 true
     */
    public boolean isFreeform() {
	return true;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclCompositeCurveSegment2D[] tSegments =
	    new JgclCompositeCurveSegment2D[this.nSegments()];
	for (int i = 0; i < this.nSegments(); i++)
	    tSegments[i] = (JgclCompositeCurveSegment2D)
		this.segmentAt(i).transformBy(reverseTransform,
					      transformationOperator,
					      transformedGeometries);
	return new JgclCompositeCurve2D(tSegments, this.periodic());
    }

    /**
     * ̋Ȑ|C̕܂ނۂԂB
     *
     * @return	̋Ȑ|Cł邩A
     *		܂͎g\镔iƂă|C܂ނȂ trueA
     *		łȂ false
     */
    protected boolean hasPolyline() {
	for (int i = 0; i < this.nSegments(); i++) {
	    if (this.segmentAt(i).hasPolyline() == true)
		return true;
	}
	return false;
    }

    /**
     * ̋Ȑ|C̕łłĂ邩ۂԂB
     *
     * @return	̋Ȑ|Cł邩A
     *		܂͎g\镔iƂă|C܂ނȂ trueA
     *		łȂ false
     */
    protected boolean isComposedOfOnlyPolylines() {
	for (int i = 0; i < this.nSegments(); i++) {
	    if (this.segmentAt(i).isComposedOfOnlyPolylines() == false)
		return false;
	}
	return true;
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tsegments");
	for (int i = 0; i < nSegments(); i++) {
	    segments[i].output(writer, indent + 2);
        }
        writer.println(indent_tab + "\tperiodic\t" + periodic);
        writer.println(indent_tab + "End");
    }
}
