/*
 * ϐъěWfł鑽\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclComplexPolynomial.java,v 1.21 2000/08/11 06:18:45 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * ϐъěWfł鑽\NXB
 * <p>
 * ̃NX́At ϐƂ n ̑ :
 * <pre>
 *	P(t) = A0 + A1 * t + A2 * t^2 + ... + An * t^n
 * </pre>
 * \B
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * ̊ěW Ai (i = 0, ..., n) ̒l܂ޕfz coef B
 * coef ɂ́A̒Ⴂ̌WlɊi[̂ƂB
 * ܂Acoef[i] ɂ i ̍̌W Ai ̒li[B
 * </p>
 *
 * @version $Revision: 1.21 $, $Date: 2000/08/11 06:18:45 $
 * @author Information-technology Promotion Agency, Japan
 */
public class JgclComplexPolynomial extends java.lang.Object implements JgclComplexFunctionWithOneVariable {
    /**
     * ěWl̔zB
     * <p>
     * ̒ႢWɊi[B
     * ܂Acoef[i] ɂ i ̍̌Wli[B
     * </p>
     */
    private JgclComplex[] coef;

    /**
     * ěWlKĂ邩ۂA\tOB
     * <p>
     * ̑͊Oɂ͌ȂB
     * </p>
     */
    private boolean normalized;

    /**
     * ^ȂŃIuWFNg\zB
     * <p>
     * ̃RXgN^g邱Ƃ͂ȂB
     * </p>
     */
    private JgclComplexPolynomial() {
	this.coef = null;
	this.normalized = false;
    }

    /**
     * ěWl܂ޔz^ăIuWFNg\zB
     * <p>
     * coef ɂ́A̒Ⴂ̌WlɊi[Ă̂ƂB
     * </p>
     *
     * @param	coef	̊ěWl̔z
     * @param	normalized	ěWlKĂ邩ۂA\tO
     */
    private JgclComplexPolynomial(JgclComplex[] coef, boolean normalized) {
	this.coef = (JgclComplex[])coef.clone();
	this.normalized = normalized;
    }

    /**
     * ěWl܂ޔz^ăIuWFNg\zB
     * <p>
     * coef ɂ́A̒Ⴂ̌WlɊi[Ă̂ƂB
     * ܂Acoef[i] ɂ i ̍̌Wli[ĂB
     * </p>
     * <p>
     * coef  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * ܂Acoef ̗vf 1 菬ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param	coef	̊ěWl̔z
     * @see	JgclInvalidArgumentValue
     */
    public JgclComplexPolynomial(JgclComplex[] coef)
    {
	if (coef == null)
	    throw new JgclInvalidArgumentValue("Array of coefficients is null.");

	if (coef.length < 1)
	    throw new JgclInvalidArgumentValue("Size of array of coefficients is zero.");

	this.coef = (JgclComplex[])coef.clone();
	this.normalized = false;
    }

    /**
     * e̎Wl܂ޔz^ăIuWFNg\zB
     * <p>
     * ěWׂ̋͂ 0 ł̂ƂB
     * </p>
     * <p>
     * coef ɂ́A̒Ⴂ̌WlɊi[Ă̂ƂB
     * ܂Acoef[i] ɂ i ̍̌Wli[ĂB
     * </p>
     * <p>
     * coef  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * ܂Acoef ̗vf 1 菬ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param	coef	̊ěWl̔z
     * @see	JgclInvalidArgumentValue
     */
    public JgclComplexPolynomial(double[] coef)
    {
	if (coef == null)
	    throw new JgclInvalidArgumentValue("Array of coefficients is null.");

	if (coef.length < 1)
	    throw new JgclInvalidArgumentValue("Size of array of coefficients is zero.");

	this.coef = new JgclComplex[coef.length];
	for (int i = 0; i < coef.length; i++)
	    this.coef[i] = new JgclComplex(coef[i]);
	this.normalized = false;
    }

    /**
     * 2 ̊ěWl^ăIuWFNg\zB
     * <p>
     * ̃RXgN^Ő鑽͕̎K 2 łB
     * </p>
     *
     * @param	coef0	0 ̌Wl
     * @param	coef1	1 ̌Wl
     * @param	coef2	2 ̌Wl
     */
    public JgclComplexPolynomial(JgclComplex coef0,
				 JgclComplex coef1,
				 JgclComplex coef2) {
	this.coef = new JgclComplex[3];
	this.coef[0] = coef0;
	this.coef[1] = coef1;
	this.coef[2] = coef2;
    }

    /**
     * ̑̎ԂB
     *
     * @return	̎
     */
    public int degree() {
	return this.coef.length - 1;
    }

    /**
     * ̑̎w̎̍̌W̒lԂB
     * <p>
     * coef[degree] ̒lԂB
     * </p>
     *
     * @param	degree	
     * @return	w̎̍̌Wl
     */
    public JgclComplex coefficientAt(int degree) {
	return this.coef[degree];
    }

    /**
     * ̑̎w͈̔͂̎̍̌W̒lԂB
     * <p>
     * lower  upper ܂ł̍̌WlԂB
     * </p>
     *
     * @param	lower	̉
     * @param	upper	̏
     * @return	w̎̍̌Wl̔z
     */
    public JgclComplex[] coefficientsBetween(int lower,
					     int upper) {
	int n = upper - lower + 1;
	JgclComplex[] result = new JgclComplex[n];
	for (int i = 0; i < n; i++)
	    result[i] = this.coef[lower + i];
	return result;
    }

    /**
     * ̑A^ꂽp[^lŕ]B
     * <p>
     * ^ꂽp[^l t ɂ邱̑̒l P(t) ԂB
     * </p>
     *
     * @param parameter	p[^l
     * @return	^ꂽp[^lő]l
     */
    public JgclComplex evaluate(JgclComplex parameter) {
	JgclComplex value = this.coef[this.degree()];
	for (int i = (this.degree() - 1); i >= 0; i--) {
	    value = value.mul(parameter).add(this.coef[i]);
	}
	return value;
    }

    /**
     * ̑ӂƂ񎟕 (A0 + A1 * t + A2 * t^2 = 0) B
     * <p>
     * ̑ 2 łȂ null ԂB
     * </p>
     * <p>
     * ʂƂēźA̍܂ށB
     * āA̔z̒͏ 2 łB
     * </p>
     * <p>
     * coef[2], coef[1] ̐ΒlƂ JgclMachineEpsilon.DOUBLE ȉłꍇɂ́A
     * ̍Ƃ (Double.NaN, 0.0) ԂB
     * </p>
     *
     * @return	̔z
     * @see	JgclMachineEpsilon#DOUBLE
     */
    public JgclComplex[] getRootsIfQuadric() {
	if (degree() != 2)
	    return null;

	JgclComplex[] roots = new JgclComplex[2];

	if (coef[2].abs() > JgclMachineEpsilon.DOUBLE) {
	    //          discriminant = sqrt(coef[1] * coef[1] - 4.0 * coef[2] * coef[0])
	    JgclComplex discriminant = coef[1].mul(coef[1]).sub(coef[2].mul(coef[0]).mul(4.0)).sqrt();
	    JgclComplex minusCoef1 = coef[1].minus();
	    boolean secondByAdding;

	    if (coef[1].real() > 0.0) {
		roots[0] = minusCoef1.sub(discriminant);
		secondByAdding = true;
	    } else {
		roots[0] = minusCoef1.add(discriminant);
		secondByAdding = false;
	    }
	    roots[0] = roots[0].div(coef[2].mul(2.0));

	    if (roots[0].abs() > JgclMachineEpsilon.DOUBLE) {
		roots[1] = coef[0].div(coef[2]).div(roots[0]);
	    } else {
		if (secondByAdding == true) {
		    roots[1] = minusCoef1.add(discriminant);
		} else {
		    roots[1] = minusCoef1.sub(discriminant);
		}
		roots[1] = roots[1].div(coef[2].mul(2.0));
	    }
	} else if (coef[1].abs() > JgclMachineEpsilon.DOUBLE) {
	    roots[0] = coef[0].minus().div(coef[1]);
	    roots[1] = roots[0].copy();
	} else {
	    roots[0] = new JgclComplex(Double.NaN, 0.0);
	    roots[1] = roots[0].copy();
	}

	return roots;
    }

    /**
     * ̑ɂāAΒl 0 Ƃ݂Ȃ鍂̌W菜ԂB
     * <p>
     * ̃\bhԂ̊ěWĺA
     * ̐Βl̍ől 1 ɂȂ悤ɐKꂽ̂ɂȂB
     * </p>
     * <p>
     * ̃\bhł́A
     * ̑
     * ěW̐Βl̍ől 1 ɂȂ悤ȐKsȂƂɁA
     * W̐Βl JgclMachineEpsilon.DOUBLE 菬Ȃ悤
     * 菜B
     * </p>
     * <p>
     * ̑
     * ěW̐Βl̍ől JgclMachineEpsilon.DOUBLE 菬ꍇɂ
     * 0 ̍̌Wl (0, 0)  0 ԂB
     * ܂A
     * ěW̐Βl̍ől̂ 0 ̍ŁA
     * ׂ̂Ă̍̌Wl Ai  ((|Ai| / |A0|) &lt; JgclMachineEpsilon.DOUBLE)
     * łꍇɂ
     * 0 ̍̌Wl (0, 0)  0 ԂB
     * </p>
     *
     * @return	Βl 0 Ƃ݂Ȃ鍂̌W菜
     * @see	JgclMachineEpsilon#DOUBLE
     */
    public JgclComplexPolynomial normalize() {
	/*
	 * if this has been normalized, return this
	 */
	if (this.normalized == true)
	    return this;

	/*
	 * get absolute min. & max. value
	 */
	int minIdx, maxIdx;
	double minVal, maxVal;

	minIdx = maxIdx = this.degree();
	minVal = maxVal = this.coef[this.degree()].abs();

	for (int i = (this.degree() - 1); i >= 0; i--) {
	    double absVal = this.coef[i].abs();
	    if (absVal < minVal) {
		minIdx = i;
		minVal = absVal;
	    }
	    if (maxVal < absVal) {
		maxIdx = i;
		maxVal = absVal;
	    }
	}

	/*
	 * if all values are same & zero, return zero polynomial
	 */
	if ((minIdx == maxIdx) &&
	    (maxVal < JgclMachineEpsilon.DOUBLE)) {
	    JgclComplex[] zeroCoef = new JgclComplex[1];
	    zeroCoef[0] = new JgclComplex(0.0, 0.0);
	    return new JgclComplexPolynomial(zeroCoef, true);
	}

	int actualDegree = this.degree() + 1;

	while (--actualDegree >= 0) {
	    if (this.coef[actualDegree].div(maxVal).abs() >
		JgclMachineEpsilon.DOUBLE)
		break;
	}

	if (actualDegree == 0) {
	    JgclComplex[] zeroCoef = new JgclComplex[1];
	    zeroCoef[0] = new JgclComplex(0.0, 0.0);
	    return new JgclComplexPolynomial(zeroCoef, true);
	}

	JgclComplex[] normalizedCoef = new JgclComplex[actualDegree + 1];
	for (int i = 0; i <= actualDegree; i++)
	    normalizedCoef[i] = this.coef[i].div(maxVal);
	return new JgclComplexPolynomial(normalizedCoef, true);
    }

    /**
     * ̑Ƒ̑́uav\ԂB
     * <p>
     * ̑ P(t) Ƒ̑ Q(t) ̘a P(t) + Q(t) ԂB
     * </p>
     *
     * @param mate	̑
     * @return	(this + mate)
     */
    public JgclComplexPolynomial add(JgclComplexPolynomial mate) {
	int ijk;

	if (mate.degree() > degree())
	    return mate.add(this);

        if ((degree() < 0) || (mate.degree() < 0))
            throw new JgclFatal();

        JgclComplex newCoef[] = new JgclComplex[degree() + 1];

	for (ijk = 0; ijk <= mate.degree(); ijk++)
            newCoef[ijk] = coef[ijk].add(mate.coef[ijk]);

	for ( ; ijk <= degree(); ijk++)
            newCoef[ijk] = coef[ijk];

        return new JgclComplexPolynomial(newCoef, false);
    }

    /**
     * ̑Ƒ̑́uv\ԂB
     * <p>
     * ̑ P(t) Ƒ̑ Q(t) ̍ P(t) - Q(t) ԂB
     * </p>
     *
     * @param mate	̑
     * @return	(this - mate)
     */
    public JgclComplexPolynomial subtract(JgclComplexPolynomial mate) {
	int ijk;

	return this.add(mate.multiply(new JgclComplex(-1)));
    }

    /**
     * ̑ɗ^ꂽlԂB
     * <p>
     * ̑ P(t)  val  val *  P(t) ԂB
     * </p>
     *
     * @param val	̊ěWɂl
     * @return	(this * val)
     */
    public JgclComplexPolynomial multiply(JgclComplex val) {
	int ijk;
        if (degree() < 0)
            throw new JgclFatal();

        JgclComplex newCoef[] = new JgclComplex[degree() + 1];

	for (ijk = 0; ijk <= degree(); ijk++)
            newCoef[ijk] = val.mul(coef[ijk]);

        return new JgclComplexPolynomial(newCoef, false);
    }

    /**
     * ̑Ƒ̑́uρv\ԂB
     * <p>
     * ̑ P(t) Ƒ̑ Q(t) ̐ P(t) * Q(t) ԂB
     * </p>
     *
     * @param mate	̑
     * @return	(this * mate)
     */
    public JgclComplexPolynomial multiply(JgclComplexPolynomial mate) {
	int ijk, klm;
	int idx;

        if ((degree() < 0) || (mate.degree() < 0)) {
            throw new JgclFatal();
        }

	int newDegree = degree() + mate.degree();
        JgclComplex newCoef[] = new JgclComplex[newDegree+1];

	for (ijk = 0; ijk <= newDegree; ijk++)
            newCoef[ijk] = new JgclComplex();

	for (ijk = 0; ijk <= degree(); ijk++)
	    for (klm = 0; klm <= mate.degree(); klm++) {
		idx = ijk + klm;
		JgclComplex c = coefficientAt(ijk).mul(mate.coefficientAt(klm));
		newCoef[idx] = newCoef[idx].add(c);
	    }
        return new JgclComplexPolynomial(newCoef, false);
    }

    /**
     * ̑̈ꎟ֐\ԂB
     * <p>
     * ̑̎ 0 ̏ꍇɂ́A
     * 0 ̍̌Wl 0 ł 0 ԂB
     * </p>
     *
     * @return	ꎟ֐\
     */
    public JgclComplexPolynomial derive() {
	int ijk;

        if (degree() < 0) {
            throw new JgclFatal();
        }

        JgclComplex newCoef[] = new JgclComplex[degree()];

	for (ijk = 1; ijk <= degree(); ijk++)
            newCoef[ijk - 1] = coef[ijk].mul(new JgclComplex(ijk));

        return new JgclComplexPolynomial(newCoef, false);
    }

    /**
     * ̍ Newton-Raphson @ɂċ߂悤ƂۂɁA
     * ̎ZɎsƂO () NXB
     */
    public class NRNotConverge extends JgclException {
	/**
	 * ł؂ۂ̍̐lB
	 * @serial
	 */
	private JgclComplex value;

	/**
	 * ł؂ۂ̍̐l^ăIuWFNg\zB
	 *
	 * @param value	ł؂ۂ̍̐l
	 */
	private NRNotConverge(JgclComplex value) {
	    super();
	    this.value = value;
	}

	/**
	 * ł؂ۂ̍̐lԂB
	 *
	 * @return	ł؂ۂ̍̐l
	 */
	public JgclComplex getValue() {
	    return this.value;
	}
    }

    /**
     * ̑ӂƂ̍ Newton-Raphson @ɂĈ߂B
     *
     * @param initialGuess	̍̏l
     * @return	̎l
     * @exception NRNotConverge	ZȂ
     */
    public JgclComplex getOneRootByNR(JgclComplex initialGuess)
        throws NRNotConverge
    {
	JgclComplex root = initialGuess;
	double epsilon = JgclMachineEpsilon.DOUBLE;
	int maxIteration = 50;
	JgclComplex value;	/* value of polynomial */
	double absVal;		/* absolute of value */
	JgclComplex deriv;	/* 1st derivative of polynomial */
	JgclComplex tempVal;	/* temporary area */
	double absTempVal;	/* absolute of temporary value */
	JgclComplex theCoef;	/* a coefficient */
	double delta;		/* delta at root */

	/*
	 * iteractive refinement by Newton-Raphson method
	 */
	for (int iteration = 0; iteration < maxIteration; iteration++) {
	    value = coefficientAt(degree());
	    deriv = value.copy();
	    delta = 0.0;

	    for (int j = degree() - 1; j >= 0; j--) {
		tempVal = value.mul(root);
		theCoef = coefficientAt(j);
		value = tempVal.add(theCoef);
		absTempVal = tempVal.abs();
		if (j > 0)
		    deriv = deriv.mul(root).add(value);
		delta = root.abs() * delta +
		    epsilon * (absTempVal + JgclMath.maxOf3(theCoef.abs(),
									     absTempVal,
									     value.abs()));
	    }

	    absVal = value.abs();
	    if (((absVal < epsilon) && (delta < epsilon)) || (absVal < delta)) {
		return root;
	    }

	    if (deriv.abs() > epsilon) {
		root = root.sub(value.div(deriv));
	    } else {
		root = root.sub(value.div(deriv.getEpsilon()));
	    }
	}

	throw this.new NRNotConverge(root);
    }

    /**
     * 鑽ӂƂ㐔sł邱ƂO () NXB
     * <p>
     * ̎ 0 ŁA0 ̌W (0, 0) ł邱ƂB
     * </p>
     */
    public class IndefiniteEquation extends JgclException {
	/**
	 * ^ɃIuWFNg\zB
	 */
	public IndefiniteEquation() {
	    super();
	}

	/**
	 * ^ăIuWFNg\zB
	 *
	 * @param s	
	 */
	public IndefiniteEquation(String s) {
	    super(s);
	}
    }

    /**
     * 鑽ӂƂ㐔s\ł邱ƂO () NXB
     * <p>
     * ̎ 0 ŁA0 ̌W (0, 0) ȊOł邱ƂB
     * </p>
     */
    public class ImpossibleEquation extends JgclException {
	/**
	 * ^ɃIuWFNg\zB
	 */
	public ImpossibleEquation() {
	    super();
	}

	/**
	 * ^ăIuWFNg\zB
	 *
	 * @param s	
	 */
	public ImpossibleEquation(String s) {
	    super(s);
	}
    }

    /**
     * ̍ Durand-Kerner @ɂċ߂悤ƂۂɁA
     * ̎ZɎsƂO () NXB
     */
    public class DKANotConverge extends JgclException {
	/**
	 * ł؂ۂ̍̐lB
	 * @serial
	 */
	private JgclComplex[] values;

	/**
	 * ł؂ۂ̍̐l^ăIuWFNg\zB
	 *
	 * @param value	ł؂ۂ̍̐l
	 */
	private DKANotConverge(JgclComplex[] values) {
	    super();
	    this.values = values;
	}

	/**
	 * ł؂ۂ̍̐lԂB
	 *
	 * @return	ł؂ۂ̍̐l
	 */
	public JgclComplex[] getValues() {
	    return this.values;
	}
    }

    /**
     * ̑ӂƂׂ̍̂Ă Durand-Kerner @ɂċ߂B
     *
     * @return	̔z
     * @exception DKANotConverge	ZȂ
     * @exception IndefiniteEquation	sł
     * @exception ImpossibleEquation	s\ł
     */
    public JgclComplex[] getRootsByDKA()
        throws DKANotConverge, IndefiniteEquation, ImpossibleEquation
    {
	JgclComplex[] result;

	if (this.normalized != true) {
	    return this.normalize().getRootsByDKA();
	}

	JgclComplexPolynomial func = this;
	int degree = func.degree();

	if (degree == 0) {
	    if (func.coefficientAt(degree).abs() < JgclMachineEpsilon.DOUBLE) {
		throw this.new IndefiniteEquation();
	    } else {
		throw this.new ImpossibleEquation();
	    }
	}

	//JgclComplex[] result = new JgclComplex[degree];
	result = new JgclComplex[degree];
	double radiusEps = 1.0e-8;

	int i;
	for (i = 0; i <= degree; i++) {
	    if (func.coefficientAt(i).abs() > JgclMachineEpsilon.DOUBLE)
		break;
	}
	int nonZeroCoef = i;

	if (nonZeroCoef > degree) {
	    throw this.new IndefiniteEquation();
	}

	if (nonZeroCoef > 0) {
	    int j, k;

	    for (j = nonZeroCoef; j > 0; j--)
		result[degree - j] = new JgclComplex(0.0, 0.0);

	    int revDegree = degree - nonZeroCoef;
	    if (revDegree == 0)
		return result;

	    JgclComplex[] coefs = new JgclComplex[revDegree + 1];
	    for (j = revDegree, k = degree; k >= nonZeroCoef; j--, k--)
		coefs[j] = func.coefficientAt(k);
	    func = new JgclComplexPolynomial(coefs, true);
	    degree = func.degree();
	}

	/*  */ if (degree == 1) {
	    result[0] = func.coefficientAt(degree - 1).minus().div(func.coefficientAt(degree));
	    return result;
	} else if (degree == 2) {
	    JgclComplex[] moreResult = func.getRootsIfQuadric();
	    result[0] = moreResult[0];
	    result[1] = moreResult[1];
	    return result;
	}

	if (func.getAbrth(result) < radiusEps)
	    return result;

	if (func.compDK3(result) != true)
	    throw this.new DKANotConverge(result);

	return result;
    }

    /**
     * Durand-Kerner @̏l𓾂B
     *
     * @param	result	li[z (o͗p)
     * @return	l̔a
     * @see	#getRootsByDKA()
     */
    private double getAbrth(JgclComplex[] result) {
	JgclComplexPolynomial func = this;
	int degree = func.degree();
	JgclComplex[] dcA = new JgclComplex[degree + 1];
	for (int i = 0; i <= degree; i++)
	    dcA[i] = func.coefficientAt(degree - i);

	JgclComplex[] ecC;	// coefficients after translation by beta
	double[] eCA;		// absolute of ecC

	JgclComplex ecbeta;	// center of roots
	int jm;			// number of coefficients that are not zero
	double erng;		// initial range of roots
	double erng1 = 0.0;	// refinemented of erng
	double eCM;		// jm / eCA0
	double erv;		// each of value that determines erng
	int iter;		// counter for iteration
	int maxIteration = 50;
	double ereps;		// epsilon value for iteration
	double eQ0;		// value of C polynomial at erng
	double eQ1;		// 1st differential at eQ0
	double ep2n;		// 2-pai / order
	double eh3n;		// 3 / 2 / order
	int ijk;
	int klm;
	int mno;
	JgclComplex ecci = new JgclComplex(0.0, 1.0);	// unit imaginary

	ecC = new JgclComplex[degree + 1];
	eCA = new double[degree + 1];

	/*
	 * guess range of root
	 */
	ecbeta = dcA[1].minus().div(dcA[0].mul(degree));
	// ecbeta = -dcA[1] / (degree * dcA[0]);

	for (ijk = 0; ijk <= degree; ijk++)
	    ecC[ijk] = dcA[ijk].copy();

	for (klm = 0; klm < degree; klm++) {
	    mno = degree - klm;
	    for (ijk = 1; ijk <= mno; ijk++) {
		ecC[ijk] = ecC[ijk].add(ecbeta.mul(ecC[ijk-1]));
		// ecC[ijk] += ecbeta * ecC[ijk-1];
	    }
	}

	for (ijk = 0; ijk <= degree; ijk++)
	    eCA[ijk] = ecC[ijk].abs();

	jm = degree;
	for (ijk = 1; ijk <= degree; ijk++)
	    if (eCA[ijk] == 0.0)
		jm--;

	erng = 0.0;
	eCM = jm / eCA[0];
	for (ijk = 1; ijk <= degree; ijk++)
	    if ((eCA[ijk] != 0.0) && ((erv = Math.exp(Math.log(eCA[ijk] * eCM) / ijk)) > erng))
		erng = erv;

	/*
	 * iteractive refinement of range of roots by Newton-Raphson's method
	 */
	ereps = erng * 0.01;

	for (iter = 0; iter < maxIteration; iter++) {
	    eQ1 = eQ0 = eCA[0];
	    for (klm = 1; klm < degree; klm++) {
		eQ0 = erng * eQ0 - eCA[klm];
		eQ1 = erng * eQ1 + eQ0;
	    }
	    eQ0 = erng * eQ0 - eCA[degree];

	    if (Math.abs(eQ1) > JgclMachineEpsilon.DOUBLE)
		erng1 = erng - eQ0 / eQ1;
	    else
		erng1 = erng - eQ0 /
		    JgclMath.copySign(JgclMachineEpsilon.DOUBLE, eQ1);

	    if ((erng - erng1) <= ereps)
		break;

	    erng = erng1;
	}

	/*
	 * set initial approximation of roots
	 */
	ep2n = (2.0 * Math.PI) / degree;
	eh3n = 3.0 / (2 * degree);
	for (ijk = 0; ijk < degree; ijk++) {
	    result[ijk] = ecbeta.add(ecci.mul(ep2n * ijk + eh3n).exp().mul(erng1));
	    // result[ijk] = ecbeta + erng1 * exp(ecci*(ep2n*ijk+eh3n))
	}

	return erng1;
    }

    /**
     * do 3rd-order Durand-Kerner method.
     *
     * @param	result	̔z (Ăяoŏlݒ肳Kv)
     * @return	Zۂ
     * @see	#getRootsByDKA()
     */
    private boolean compDK3(JgclComplex[] result) {
	JgclComplexPolynomial func = this;
	int degree = func.degree();
	JgclComplex[] dcA = new JgclComplex[degree + 1];
	for (int i = 0; i <= degree; i++)
	    dcA[i] = func.coefficientAt(degree - i);

	double[] eCA;		// absolute of coefficients
	JgclComplex[] edcA;	// normalized coefficients
	JgclComplex[] ecZN;	// work area

	int imax;		// index for coef. which absolute-value is max
	double emax;		// work area for imax
	int iter;		// counter for iteration
	int maxIteration = 50;
	int inconv;		// number of converged root
	double eZA;		// absolute of root
	JgclComplex ecP0;	// value of polynomial at root
	JgclComplex ecP1;	// 1st differential at ecP0
	double edelta;		// delta value for convergence
	JgclComplex ecPT;	// work area
	JgclComplex ecQA;	// work area
	JgclComplex ecQB;	// work area
	int ijk;
	int klm;
	JgclComplex ec1 = new JgclComplex(1.0, 0.0);
	double ewrk;
	double secondEps = 1.0e-8;

	eCA = new double[degree + 1];
	edcA = new JgclComplex[degree + 1];
	ecZN = new JgclComplex[degree];

	/*
	 * normalize the coefficients
	 */
	imax = 0;
	emax = dcA[0].abs();
	for (ijk = 1; ijk <= degree; ijk++) {
	    if ((ewrk = dcA[ijk].abs()) > emax) {
		imax = ijk;
		emax = ewrk;
	    }
	}

	for (ijk = 0; ijk <= degree; ijk++) {
	    if (ijk != imax) {
		edcA[ijk] = dcA[ijk].div(dcA[imax]);
	    } else {
		edcA[ijk] = new JgclComplex(1.0, 0.0);
	    }
	    eCA[ijk] = edcA[ijk].abs();
	}

	/*
	 * iteractive refinement by Durand-Kerner's method
	 */
	for (iter = 0; iter < maxIteration; iter++) {
	    inconv = 0;

	    for (klm = 0; klm < degree; klm++) {
		ecP0 = edcA[0].copy();
		ecP1 = ecP0.copy();
		edelta = 0.0;
		eZA = result[klm].abs();

		for (ijk = 1; ijk <= degree; ijk++) {
		    ecPT = result[klm].mul(ecP0);
		    ecP0 = ecPT.add(edcA[ijk]);
		    edelta = eZA * edelta +
			JgclMachineEpsilon.DOUBLE *
			(ecPT.abs() + JgclMath.maxOf3(eCA[ijk], ecPT.abs(), ecP0.abs()));
		    if (ijk != degree)
			ecP1 = result[klm].mul(ecP1).add(ecP0);
		}

		ecQA = new JgclComplex(0.0, 0.0);
		for (ijk = 0; ijk < degree; ijk++)
		    if (ijk != klm)
			ecQA = ecQA.add(ec1.div(result[klm].sub(result[ijk])));

		ecQB = ecP0.div(ecP1);
		ecZN[klm] = result[klm].sub(ecQB.div(ec1.sub(ecQB.mul(ecQA))));

		/*
		 * convergence test
		 */
		if (ecP0.abs() < edelta)
		    inconv++;
	    }

	    /*
	     * second convergence test (this is looser than above one)
	     */
	    if (iter > 5) {
		double ec2CT = 0.0;
		for (ijk = 0; ijk < degree; ijk++)
		    ec2CT += ecZN[ijk].sub(result[ijk]).abs();
		if (ec2CT < secondEps)
		    inconv = degree;
	    }

	    for (ijk = 0; ijk < degree; ijk++)
		result[ijk] = ecZN[ijk];

	    /*
	     * return if all is converged
	     */
	    if (inconv == degree)
		break;
	}

	return (iter == maxIteration) ? false : true;
    }

    /**************************************************************************
     *
     * Debug
     *
     **************************************************************************/
    /* Debug : getRootsIfQuadric */
    private static void debugGetRootsIfQuadric(String argv[]) {
	JgclComplex[] coef = new JgclComplex[argv.length - 2];
	for (int i = 0; i < argv.length - 2; i++)
	    coef[i] = new JgclComplex(Double.valueOf(argv[i]).doubleValue(), 0.0);

	try {
	    JgclComplexPolynomial poly = new JgclComplexPolynomial(coef);
	    JgclComplex[] result = poly.getRootsIfQuadric();
	    for (int i = 0; i < result.length; i++)
		System.out.println("result : " + result[i] +
				   ", evaluate : " + poly.evaluate(result[i]));
	}
	catch (JgclInvalidArgumentValue e) {
	    System.err.println(e);
	}
    }

    /* Debug : getOneRootByNR */
    private static void debugGetOneRootByNR(String argv[]) {
	JgclComplex[] coef = new JgclComplex[argv.length - 2];
	for (int i = 0; i < argv.length - 2; i++)
	    coef[i] = new JgclComplex(Double.valueOf(argv[i]).doubleValue(), 0.0);

	try {
	    JgclComplexPolynomial poly = new JgclComplexPolynomial(coef);
	    JgclComplex result =
		poly.getOneRootByNR(new JgclComplex(Double.valueOf(argv[argv.length - 2]).doubleValue(),
						    Double.valueOf(argv[argv.length - 1]).doubleValue()));
	    System.out.println("result : " + result + ", evaluate : " + poly.evaluate(result));
	}
	catch (JgclInvalidArgumentValue e) {
	    System.err.println(e);
	}
	catch (JgclComplexPolynomial.NRNotConverge e) {
	    System.err.println(e);
	}
    }

    /* Debug : getRootsByDKA */
    private static void debugGetRootsByDKA(String argv[]) {
	JgclComplex[] coef = new JgclComplex[argv.length - 2];
	for (int i = 0; i < argv.length - 2; i++)
	    coef[i] = new JgclComplex(Double.valueOf(argv[i]).doubleValue(), 0.0);

	try {
	    JgclComplexPolynomial poly = new JgclComplexPolynomial(coef);
	    JgclComplex[] result = poly.getRootsByDKA();
	    for (int i = 0; i < result.length; i++)
		System.out.println("result : " + result[i] +
				   ", evaluate : " + poly.evaluate(result[i]));
	}
	catch (JgclInvalidArgumentValue e) {
	    System.err.println(e);
	}
	catch (JgclComplexPolynomial.DKANotConverge e) {
	    System.err.println(e);
	}
	catch (JgclComplexPolynomial.IndefiniteEquation e) {
	    System.err.println(e);
	}
	catch (JgclComplexPolynomial.ImpossibleEquation e) {
	    System.err.println(e);
	}
    }

    /* Debug */
    /**
     * fobOpCvOB
     */
    public static void main(String argv[]) {
	// debugGetRootsIfQuadric(argv);
	System.err.println("---");
	debugGetOneRootByNR(argv);
	System.err.println("---");
	debugGetRootsByDKA(argv);
    }
}

/* end of file */
