/*
 * f\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclComplex.java,v 1.9 2000/04/26 09:38:48 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * f\NXB
 * <p>
 * ̃NX̃CX^X́A
 * f̎\ re Ƌ\ im
 * B
 * </p>
 *
 * @version $Revision: 1.9 $, $Date: 2000/04/26 09:38:48 $
 * @author Information-technology Promotion Agency, Japan
 */
public class JgclComplex extends java.lang.Object implements Cloneable {
    /**
     * B
     */
    private final double re;

    /**
     * B
     */
    private final double im;

    /**
     *  0.0A 0.0 ̃IuWFNg\zB
     */
    public JgclComplex() {
	re = 0.0;
	im = 0.0;
    }

    /**
     * ^ꂽƋŃIuWFNg\zB
     *
     * @param r	
     * @param i	
     */
    public JgclComplex(double r, double i) {
	re = r;
	im = i;
    }

    /**
     * ^ꂽA 0.0 ̃IuWFNg\zB
     *
     * @param r	
     */
    public JgclComplex(double r) {
	re = r;
	im = 0.0;
    }

    /**
     * ̕f̎̒lԂB
     *
     * @return	̒l
     */
    public double real() {
	return re;
    }

    /**
     * ̕f̋̒lԂB
     *
     * @return	̒l
     */
    public double imag() {
	return im;
    }

    /**
     * ̕f̕ԂB
     *
     * @return	Vɐꂽ
     */
    public JgclComplex copy() {
	return new JgclComplex(this.re, this.im);
    }

    /**
     * (- this) ԂB
     *
     * @return	(- this)
     */
    public JgclComplex minus() {
	return new JgclComplex((- this.re), (- this.im));
    }

    /**
     * (this + mate) ԂB
     *
     * @return	(this + mate)
     */
    public JgclComplex add(JgclComplex mate) {
	return new JgclComplex((this.re + mate.re), (this.im + mate.im));
    }

    /**
     * (this - mate) ԂB
     *
     * @return	(this - mate)
     */
    public JgclComplex sub(JgclComplex mate) {
	return new JgclComplex((this.re - mate.re), (this.im - mate.im));
    }

    /**
     * (this * mate) ԂB
     *
     * @return	(this * mate)
     */
    public JgclComplex mul(JgclComplex mate) {
	return new JgclComplex(((this.re * mate.re) - (this.im * mate.im)),
			       ((this.re * mate.im) + (this.im * mate.re)));

    }

    /**
     * (this * mate) ԂB
     *
     * @return	(this * mate)
     */
    public JgclComplex mul(double mate) {
	return new JgclComplex((this.re * mate), (this.im * mate));
    }

    /**
     * (this / mate) ԂB
     *
     * @return	(this / mate)
     */
    public JgclComplex div(JgclComplex mate) {
	double denom = (mate.re * mate.re) + (mate.im * mate.im);
	return new JgclComplex((((this.re * mate.re) + (this.im * mate.im)) / denom),
			       (((this.im * mate.re) - (this.re * mate.im)) / denom));

    }

    /**
     * (this / mate) ԂB
     *
     * @return	(this / mate)
     */
    public JgclComplex div(double mate) {
	return new JgclComplex((this.re / mate), (this.im / mate));
    }

    /**
     * this ̐ΒlԂB
     *
     * @return	this ̐Βl
     */
    public double abs() {
	return Math.sqrt((this.re * this.re) + (this.im * this.im));
    }

    /**
     * this ̕ΊpԂB
     *
     * @return	this ̕Ίp
     */
    public double arg() {
	return Math.atan2(this.im, this.re);
    }

    /**
     * this ̋lԂB
     *
     * @return	this ̋l
     */
    public JgclComplex conj() {
	return new JgclComplex(this.re, (- this.im));
    }

    /**
     * this  exponential ԂB
     *
     * @return	this  exponential
     */
    public JgclComplex exp() {
	return new JgclComplex((Math.exp(this.re) * Math.cos(this.im)),
			       (Math.exp(this.re) * Math.sin(this.im)));

    }

    /**
     * this ̕ԂB
     *
     * @return this ̕
     */
    public JgclComplex sqrt() {
	double e = Math.sqrt(this.abs());
	double f = this.arg() / 2.0;
	return new JgclComplex((e * Math.cos(f)), (e * Math.sin(f)));
    }

    /**
     * ̕f̑\ String ԂB
     *
     * @return	̕f̑\
     */
    public String toString() {
	return "(" + this.re + ", " + this.im + ")";
    }

    /**
     * ̕f̕ɑΉuf̊ۂߌ덷vԂB
     *
     * @return	̕f̕ɑΉuf̊ۂߌ덷v
     */
    public final JgclComplex getEpsilon() {
	double meps = JgclMachineEpsilon.DOUBLE / Math.sqrt(2.0);
	return new JgclComplex(JgclMath.copySign(meps, this.re),
			       JgclMath.copySign(meps, this.im));
    }
}

/* end of file */
