/*
 * R : ~\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclCircle3D.java,v 1.64 2000/08/11 06:18:45 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : ~\NX
 * <p>
 * ~́A̒S̈ʒuƋǏ X/Y ̕ǏWn
 * (zuA{@link JgclAxis2Placement3D JgclAxis2Placement3D}) position 
 * a radius Œ`B
 * </p>
 * <p>
 * t p[^Ƃ~ P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(t) = position.location() + radius * (cos(t) * position.x() + sin(t) * position.y())
 * </pre>
 * </p>
 *
 * @version $Revision: 1.64 $, $Date: 2000/08/11 06:18:45 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclCircle3D extends JgclConic3D {

    /**
     * aB
     * @serial
     */
    private double radius;


    /**
     * aݒ肷B
     * <p>
     * radius ̒lA
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     *
     * @param radius	a
     * @see	JgclInvalidArgumentValue
     */
    private void setRadius(double radius)
    {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = condition.getToleranceForDistance();

	if (radius < dTol) {
	    throw new JgclInvalidArgumentValue();
	}
	this.radius = radius;
    }

    /**
     * ǏWnƔa^ăIuWFNg\zB
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * radius ̒lA
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param position	SƋǏ X/Y/Z ̕ǏWn
     * @param radius	a
     * @see	JgclInvalidArgumentValue
     */
    public JgclCircle3D(JgclAxis2Placement3D position, double radius)
    {
	super(position);
	setRadius(radius);
    }

    /**
     * SA@xNgƔa^ăIuWFNg\zB
     * <p>
     * \z~̋Ǐ X/Y ́̕A
     * ̃RXgN^̓Ō肷B
     * </p>
     * <p>
     * center  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * radius ̒lA
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param center	S
     * @param normal	@xNg
     * @param radius	a
     * @see	JgclInvalidArgumentValue
     */
    public JgclCircle3D(JgclPoint3D center, JgclVector3D normal, double radius)
    {
	super(new JgclAxis2Placement3D(center, normal,
				       normal.verticalVector().unitized()));
	setRadius(radius);
    }

    /**
     * ^ꂽO_܂ޕʂ\ǏWn𐶐B
     * <p>
     * ^ꂽO_̒SǏWň_ƂB
     * </p>
     * <p>
     * (pnt2 - pnt1) ̕Ǐ X ̕ƂB
     * </p>
     * <p>
     * ^ꂽO_Ԃ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param pnt1	ʏ̈_
     * @param pnt2	ʏ̈_
     * @param pnt3	ʏ̈_
     * @return	O_܂ޕʂ\ǏWn
     * @see	JgclInvalidArgumentValue
     */
    static private JgclAxis2Placement3D placement
	(JgclPoint3D pnt1, JgclPoint3D pnt2, JgclPoint3D pnt3)
    {
	if (pnt1.identical(pnt2) || pnt1.identical(pnt3) || pnt2.identical(pnt3))
	    throw new JgclInvalidArgumentValue();

	JgclVector3D vec2 = pnt2.subtract(pnt1); // X-axis direction
	JgclVector3D vec3 = pnt3.subtract(pnt1);

	if (vec2.identicalDirection(vec3))
	    throw new JgclInvalidArgumentValue();

	JgclVector3D normal = vec2.crossProduct(vec3); // Z-axis direction

	JgclLine3D line2 = new JgclLine3D(pnt1.linearInterpolate(pnt2, 0.5),
					  vec2.crossProduct(normal));

	JgclLine3D line3 = new JgclLine3D(pnt1.linearInterpolate(pnt3, 0.5),
					  vec3.crossProduct(normal));
	JgclIntersectionPoint3D isec;

	try {
	    isec = line2.intersect1Line(line3);
	    if (isec == null)
		throw new JgclFatal();
	}
	catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}

	return new JgclAxis2Placement3D(isec.coordinates(), normal, vec2);
    }

    /**
     * ʉ߂O_^ăIuWFNg\zB
     * <p>
     * (pnt2 - pnt1) ̕Ǐ X ̕ƂB
     * </p>
     * <p>
     * ^ꂽO_Ԃ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param pnt1	~̈_
     * @param pnt2	~̈_
     * @param pnt3	~̈_
     * @see	JgclInvalidArgumentValue
     */
    public JgclCircle3D(JgclPoint3D pnt1, JgclPoint3D pnt2, JgclPoint3D pnt3)
    {
	super(placement(pnt1, pnt2, pnt3));
	setRadius(position().location().subtract(pnt1).length());
    }

    /**
     * ̉~̔apāA^ꂽʒuƌXłQ̉~쐬B
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param position	Q̉~̈ʒuƌXǏWn
     * @return	Q̉~
     * @see	JgclInvalidArgumentValue
     */
    JgclConic2D toLocal2D(JgclAxis2Placement2D position) {
	return new JgclCircle2D(position, radius);
    }

    /**
     * ̉~̔aԂB
     * 
     * @return	a
     */
    public double radius() {
	return this.radius;
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ŗ^Ԃ [0, 2 * PI] Ɏ܂ĂKv͂ȂB
     * ܂Apint ̑l͕ł܂ȂB
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     */
    public double length(JgclParameterSection pint) {
        return radius() * Math.abs(pint.increase());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * 
     * @param param	p[^l
     * @return		Wl
     */
    public JgclPoint3D coordinates(double param) {
	param = parameterDomain().wrap(param);
	JgclPoint3D center = position().location();
	double ecos = Math.cos(param) * radius;
	double esin = Math.sin(param) * radius;
	JgclVector3D x = position().x().multiply(ecos);
	JgclVector3D y = position().y().multiply(esin);

	return center.add(x.add(y));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * 
     * @param param	p[^l
     * @return		ڃxNg
     */
    public JgclVector3D tangentVector(double param) {
	param = parameterDomain().wrap(param);
	double ecos = Math.cos(param) * radius;
	double esin = Math.sin(param) * radius;
	JgclVector3D x = position().x().multiply(-esin);
	JgclVector3D y = position().y().multiply(ecos);

	return x.add(y);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * 
     * @param param	p[^l
     * @return		ȗ
     */
    public JgclCurveCurvature3D curvature(double param) {
	param = parameterDomain().wrap(param);
	double ucos = Math.cos(param);
	double usin = Math.sin(param);
	JgclVector3D x = position().x().multiply(-ucos);
	JgclVector3D y = position().y().multiply(-usin);

	return new JgclCurveCurvature3D(1.0 / radius, x.add(y));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * 
     * @param param	p[^l
     * @return		֐
     */
    public JgclCurveDerivative3D evaluation(double param) {
	param = parameterDomain().wrap(param);
	double ecos = Math.cos(param) * radius;
	double esin = Math.sin(param) * radius;
	JgclPoint3D center = position().location();
	JgclVector3D xcos = position().x().multiply(ecos);
	JgclVector3D ysin = position().y().multiply(esin);
	JgclVector3D xsin = position().x().multiply(esin);
	JgclVector3D ycos = position().y().multiply(ecos);

	JgclPoint3D d0 = center.add(xcos.add(ysin));
	JgclVector3D d1 = ycos.add(xsin.multiply(-1.0));
	JgclVector3D d2 = xcos.add(ysin).multiply(-1.0);
	JgclVector3D d3 = ycos.multiply(-1.0).add(xsin);

	return new JgclCurveDerivative3D(d0, d1, d2, d3);
    }

    /**
     * ̉~̃p[^l 0 ̓_
     * _ ({@link JgclPointOnCurve3D JgclPointOnCurve3D})  suitable Ƃ
     * JgclIndefiniteSolution ̗O𔭐B
     */
    private void indefiniteFoot()
	throws JgclIndefiniteSolution
    {
	JgclPointOnCurve3D p;

	try {
	    p = new JgclPointOnCurve3D(this, 0, doCheckDebug);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

 	throw new JgclIndefiniteSolution(p);
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * ^ꂽ_̉~̒SʂǏ Z ɂȂA
     * ɓ̓e_ԂB
     * </p>
     * <p>
     * ^ꂽ_Ƃ̉~̒SʂǏ Z Ƃ̋A
     * ݐݒ肳Ă鉉Z̋̋e덷
     * ꍇɂ́A
     * p[^l 0 ̓_ suitable Ƃ
     * JgclIndefiniteSolution ̗O𓊂B
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @exception	JgclIndefiniteSolution	s (e̓_~̒SʂǏ Z ɂ)
     */
    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point)
	throws JgclIndefiniteSolution
    {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = condition.getToleranceForDistance();
	double aTol = condition.getToleranceForAngle();
	
	// vector from center to point -> V
	JgclVector3D eV = point.subtract(position().location());

	if (eV.length() < dTol)
	    indefiniteFoot();

	eV = eV.unitized();

	double edot = eV.dotProduct(position().z());

	// angle of V & normal is less than aTol ?
	if (Math.abs(edot) > Math.cos(aTol))
	    indefiniteFoot();

	// cross of V & normal -> U
	JgclVector3D eU = eV.crossProduct(position().z());

	// cross of normal & U -> V
	eV = position().z().crossProduct(eU).unitized();

	double eangle = position().x().angleWith(eV, position().z());
	double eangle2 = eangle + Math.PI;
	if (eangle2 >= 2*Math.PI)
	    eangle2 -= 2*Math.PI;

	// get the projected

        JgclPointOnCurve3D[] prj = { new JgclPointOnCurve3D(this, eangle, doCheckDebug),
                                     new JgclPointOnCurve3D(this, eangle2, doCheckDebug) };
        return prj;
    }

    /**
     * ^ꂽp[^ԂɂāA
     * Ԃ̗[Ԍłꂽ_̃p[^l߂B
     * <p>
     * ̃\bh
     * {@link JgclConic3D#toPolyline(JgclParameterSection, JgclToleranceForDistance) 
     * JgclConic3D.toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ŌĂяo邽߂ɗpӂĂB
     * ̃NXł
     * toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * I[o[ChĂ̂ŁA
     * ̃\bh͌Ăяo邱Ƃ͂ȂB
     * </p>
     * <p>
     * ̃\bh͏ JgclFatal ̗O𓊂B
     * </p>
     * 
     * @param left	[ (ԉ) ̃p[^l
     * @param right	E[ (ԏ) ̃p[^l
     * @return		łꂽ_̃p[^l
     */
    double getPeak(double left, double right) {
	// This should never be called because Circle provides
	// its own toPolyline().
	throw new JgclFatal();
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_́A
     * ̋Ȑx[XƂ JgclPointOnCurve3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ȂAʂƂē|C_ɏkނ悤ȏꍇɂ
     * JgclZeroLength ̗O𔭐B
     * </p>
     * 
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see	JgclPointOnCurve3D
     * @see	JgclZeroLength
     */
    public JgclPolyline3D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol) {

	double sa = parameterDomain().wrap(pint.start());
	double inc = pint.increase();
	
	int no_intvls = JgclCircle2D.toPolylineNDivision(radius(), inc, tol);
	double atheta = inc / no_intvls;

	JgclPoint3D[] pnts = new JgclPoint3D[no_intvls + 1];

	for (int i = 0; i < no_intvls + 1; i++)
            pnts[i] = new JgclPointOnCurve3D(this, sa + (atheta * i), doCheckDebug);

	if (no_intvls == 1 && pnts[0].identical(pnts[1]))
	    throw new JgclZeroLength();

	return new JgclPolyline3D(pnts);
    }

    /**
     * ̋Ȑ̎w̋ԂČLxWGȐ̗ԂB
     * <p>
     * pint ̑l̐Βl (2 * ) ȏ̏ꍇɂ́A
     *  (2 * ) ƌȂďB
     * </p>
     *
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLxWGȐ̔z
     */
    public JgclPureBezierCurve3D[] toPolyBezierCurves(JgclParameterSection pint) {
	JgclCircle2D this2D =
	    (JgclCircle2D)this.toLocal2D(JgclAxis2Placement2D.origin);
	JgclPureBezierCurve2D[] bzcs2D = this2D.toPolyBezierCurves(pint);
	return this.transformPolyBezierCurvesInLocal2DToGrobal3D(bzcs2D);
    }

    /**
     * ̋Ȑ̎w̋ԂČLxWGȐ̗ԂB
     * <p>
     * nCurves ̒l 0 ȉ邢 4 ȏ̏ꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * <p>
     * ܂Apint ̑lɑ΂ nCurves ̒lꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @param nCurves	̋Ȑ̎w̋ԂČLxWGȐ̐ (1 Ȃ 3)
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLxWGȐ̔z
     * @see	#toPolyBezierCurves(JgclParameterSection)
     */
    JgclPureBezierCurve3D[] toPolyBezierCurvesOfN(int nCurves,
						  JgclParameterSection pint) {
	JgclCircle2D this2D =
	    (JgclCircle2D)this.toLocal2D(JgclAxis2Placement2D.origin);
	JgclPureBezierCurve2D[] bzcs2D = this2D.toPolyBezierCurvesOfN(nCurves, pint);
	return this.transformPolyBezierCurvesInLocal2DToGrobal3D(bzcs2D);
    }

    /**
     * ̋Ȑ̎w̋ԂČLaXvCȐԂB
     * <p>
     * pint ̑l̐Βl (2 * ) ȏ̏ꍇɂ́A
     *  (2 * ) ƌȂďA
     * `̋ȐԂB
     * </p>
     * 
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLaXvCȐ
     * @see	#toPolyBezierCurves(JgclParameterSection)
     */
    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
	JgclPureBezierCurve3D[] bzcs = this.toPolyBezierCurves(pint);
	boolean closed =
	    (Math.abs(pint.increase()) >= JgclMath.PI2) ? true : false;

	return JgclConic3D.convertPolyBezierCurvesToOneBsplineCurve(bzcs, closed);
    }

    /**
     * ̋Ȑ̎w̋ԂČLaXvCȐԂB
     * <p>
     * nSegments ̒l 0 ȉ邢 4 ȏ̏ꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * <p>
     * ܂Apint ̑lɑ΂ nSegments ̒lꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     * <p>
     * pint ̑l̐Βl (2 * ) ȏ̏ꍇɂ́A
     * `̋ȐԂB
     * </p>
     * 
     * @param nSegments	̋Ȑ̎w̋ԂČLaXvCȐ̃ZOg (1 Ȃ 3)
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLaXvCȐ
     * @see	#toPolyBezierCurvesOfN(int, JgclParameterSection)
     * @see	JgclConic3D#convertPolyBezierCurvesToOneBsplineCurve(JgclPureBezierCurve3D[], boolean)
     */
    JgclBsplineCurve3D toBsplineCurveOfNSegments(int nSegments,
						 JgclParameterSection pint) {
	JgclPureBezierCurve3D[] bzcs = this.toPolyBezierCurvesOfN(nSegments, pint);
	boolean closed =
	    (Math.abs(pint.increase()) >= JgclMath.PI2) ? true : false;

	return JgclConic3D.convertPolyBezierCurvesToOneBsplineCurve(bzcs, closed);
    }

    /**
     * ̋ȐƑ̋ȐƂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ~̂ƂɁA
     * ~ꕽʏɏĂA
     * ~̒SԂ̋Ɠ~̔a̍A
     * ƂɌݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ́A
     * ~̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution mate ~ŁA~̓I[o[bvĂAsł
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate)
	 throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̉~ (\ꂽ) RȐ̌_\㐔𐶐B
     * 
     * @param poly	xWGȐ邢͂aXvCȐ̂ZOg̑\̔z
     * @return		̉~ poly ̌_\㐔̍
     */
    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly){
	JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
	JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
	double rad2 = radius() * radius();
	boolean isPoly = poly.length < 4;
	int degree = xPoly.degree();
	double[] coef = new double[degree + 1];

	if (isPoly) {
	    for (int j = 0; j <= degree; j++)
		coef[j] = xPoly.coefficientAt(j) + yPoly.coefficientAt(j);
	    coef[0] -= rad2;
	}
	else {
	    JgclRealPolynomial wPoly = poly[3].multiply(poly[3]);
	    for (int j = 0; j <= degree; j++)
		coef[j] = xPoly.coefficientAt(j) + yPoly.coefficientAt(j) -
		    (rad2 * wPoly.coefficientAt(j));
	}

	return new JgclRealPolynomial(coef);
    }

    /**
     * ^ꂽ_̋Ȑɂ邩ۂ`FbNB
     * 
     * @param point	ΏۂƂȂ_
     * @return		^ꂽ_̋Ȑɂ trueAłȂ false
     */
    boolean checkSolution(JgclPoint3D point) {
	double dTol = getToleranceForDistance();
	return (Math.abs(point.toVector3D().length() - radius()) < dTol)
	    && (Math.abs(point.z()) < dTol);
    }

    /**
     * ^ꂽ_̋Ȑɂ̂ƂāA
     * ̓_̋Ȑł̃p[^l߂B
     * 
     * @param point	ΏۂƂȂ_
     * @return		p[^l
     */
    double getParameter(JgclPoint3D point) {
	double cos = point.x() / radius();
	if (cos > 1.0) cos = 1.0;
	if (cos < -1.0) cos = -1.0;
	double acos = Math.acos(cos);
	if (point.y() < 0.0) acos = Math.PI * 2 - acos;

	return acos;
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ~ꕽʏɏĂA
     * ~̒SԂ̋Ɠ~̔a̍A
     * ƂɌݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ́A
     * ~̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclConic3D#intersectCnc(JgclConic3D, boolean)
     * JgclConic3D.intersectCnc(JgclConic3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	~̓I[o[bvĂAsł
     */
    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) 
	throws JgclIndefiniteSolution
    {
	return intersectCnc(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclConic3D#intersectCnc(JgclConic3D, boolean)
     * JgclConic3D.intersectCnc(JgclConic3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclEllipse3D  mate, boolean doExchange) {
	try {
	    return intersectCnc(mate, doExchange);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();	// Never be occured
	}
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclConic3D#intersectCnc(JgclConic3D, boolean)
     * JgclConic3D.intersectCnc(JgclConic3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
	try {
	    return intersectCnc(mate, doExchange);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();	// Never be occured
	}
     }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉Z
     * {@link JgclConic3D#intersectCnc(JgclConic3D, boolean)
     * JgclConic3D.intersectCnc(JgclConic3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
	try {
	    return intersectCnc(mate, doExchange);
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();	// Never be occured
	}
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * |C̃NX́u|C vs. ~v̌_Z\bh
     * {@link JgclPolyline3D#intersect(JgclCircle3D, boolean)
     * JgclPolyline3D.intersect(JgclCircle3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. ~v̌_Z\bh
     * {@link JgclTrimmedCurve3D#intersect(JgclCircle3D, boolean)
     * JgclTrimmedCurve3D.intersect(JgclCircle3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. ~v̌_Z\bh
     * {@link JgclCompositeCurveSegment3D#intersect(JgclCircle3D, boolean)
     * JgclCompositeCurveSegment3D.intersect(JgclCircle3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐNX́uȐ vs. ~v̌_Z\bh
     * {@link JgclCompositeCurve3D#intersect(JgclCircle3D, boolean)
     * JgclCompositeCurve3D.intersect(JgclCircle3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐA^ꂽxNgɏ]ĕsړȐԂB
     *
     * @param moveVec	sړ̕Ɨʂ\xNg
     * @return		sړ̋Ȑ
     */
    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
	return new JgclCircle3D(position().parallelTranslate(moveVec), radius);
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * <p>
     * LŎIȃp[^`ԂB
     * ȂAvC}ȗLԂ [0, (2 * )] łB
     * </p>
     * 
     * @return	LŎIȃp[^`
     */
    JgclParameterDomain getParameterDomain() {
	try {
	    return new JgclParameterDomain(true, 0, 2*Math.PI);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȑ􉽓IɕĂ邩ۂԂB
     * <p>
     * ~Ȃ̂ŁA true ԂB
     * </p>
     *
     * @return	~Ȃ̂ŁA <code>false</code>
     */
    boolean getClosedFlag() {
	return true;
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve3D#CIRCLE_3D JgclParametricCurve3D.CIRCLE_3D}
     */
    int type() {
	return CIRCLE_3D;
    }

    /**
     * ̋ȐA^ꂽǏWn Z ̎ɁA
     * ^ꂽpx]ȐԂB
     *
     * @param trns	ǏWn瓾ꂽWϊZq
     * @param rCos	cos(]px)
     * @param rSin	sin(]px)
     * @return		]̋Ȑ
     */
    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns,
				  double rCos, double rSin) {
	JgclAxis2Placement3D rpos = position().rotateZ(trns, rCos, rSin);
	return new JgclCircle3D(rpos, radius());
    }

    /**
     * ̋Ȑ̓_ŁA^ꂽɂȂ_ԂB
     *
     * @param line	
     * @return		^ꂽɂȂ_
     */
    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol2 = condition.getToleranceForDistance2();

	double start = 0.0, increase = Math.PI / 2.0;
	int itry = 0, limit = 3;
	JgclPoint3D point;
	JgclVector3D vector;

	/* 
	 * Get a point which is not on the line and verify that
	 * the distance between a point and the line is greater
	 * than the tolelance.
	 */
	do {
	    if (itry > limit) {
		throw new JgclFatal();	// should never be occurred
	    }
	    point = this.coordinates(start + (increase * itry));
	    vector = point.subtract(line.project1From(point));
	    itry++;
	} while (point.isOn(line) || vector.norm() < dTol2);

	return point;
    }

    /**
     * ̋ȐƁAꂽxWGȖʂƂ̊𒲂ׂB
     * <p>
     * ̃\bh {@link JgclIntsCncBzs3D JgclIntsCncBzs3D} ̓ŎgB
     * </p>
     *
     * @param bi	ꂽxWGȖʂ̏
     * @return	Ă trueAłȂ false
     */
    boolean checkInterfere(JgclIntsCncBzs3D.BezierSurfaceInfo bi) {
	double dTol = getToleranceForDistance();
	if (!((bi.box.min().z() < -dTol) && (bi.box.max().z() > dTol))) 
	    return false;
	boolean all_in = true;
	boolean all_out = true;

	JgclPoint2D[] point = new JgclPoint2D[4];
	point[0] = new JgclCartesianPoint2D(bi.box.min().x(), bi.box.min().y());
	point[1] = new JgclCartesianPoint2D(bi.box.max().x(), bi.box.min().y());
	point[2] = new JgclCartesianPoint2D(bi.box.max().x(), bi.box.max().y());
	point[3] = new JgclCartesianPoint2D(bi.box.min().x(), bi.box.max().y());

	for (int i = 0; i < 4; i++) {
	    double dist = point[i].toVector2D().length();
	    if (dist < (this.radius() - dTol))
		all_out = false;
	    else if (dist > (this.radius() + dTol))
		all_in = false;
	    else {
		all_out = false;
		all_in = false;
	    }
	}

	if (all_in == true)
	    return false; /* no interfere */

	else if (all_out == true) {
	    if ((bi.box.min().x() > (this.radius() + dTol))
		|| (bi.box.min().y() > (this.radius() + dTol))
		|| (bi.box.max().x() < (-(this.radius() + dTol)))
		|| (bi.box.max().y() < (-(this.radius() + dTol))))
		return false;  /* no interfere */
	    if (((point[0].x() > 0.0) && (point[0].y() > 0.0))
		|| ((point[1].x() < 0.0) && (point[1].y() > 0.0))
		|| ((point[2].x() < 0.0) && (point[2].y() < 0.0))
		|| ((point[3].x() > 0.0) && (point[3].y() < 0.0)))
		return false;  /* no interfere */
	    
	    return true; /* interfere */
	}
	else
	    return true; /* interfere */
    }

    /**
     * ̉~ȐƗ^ꂽʂ̌_߂B
     * <p>
     * ̃\bh {@link JgclIntsCncBzs3D JgclIntsCncBzs3D} ̓ŎgB
     * </p>
     *
     * @param plane  
     * @return       _̔z
     */
    JgclIntersectionPoint3D[] intersectConicPlane(JgclPlane3D plane) {
	JgclAxis2Placement3D position =
	    new JgclAxis2Placement3D(JgclPoint3D.origin, null, null);
	JgclCircle3D circle = new JgclCircle3D(position, this.radius());

	try {
	    return circle.intersect(plane);
	}
	catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł (̉~Ȑ̋ǏWnł) Wl
     * ԂB
     * 
     * @param parameter	p[^l
     * @return	̉~Ȑ̋ǏWnł̍Wl
     */
    JgclPoint3D nlFunc(double parameter) {
	double x = this.radius() * Math.cos(parameter);
	double y = this.radius() * Math.sin(parameter);
	double z = 0.0;

	return new JgclCartesianPoint3D(x, y, z);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł (̉~Ȑ̋ǏWnł) ڃxNg
     * ԂB
     * 
     * @param parameter	p[^l
     * @return	̉~Ȑ̋ǏWnł̐ڃxNg
     */
    JgclVector3D dnlFunc(double parameter) {
	double x = - this.radius() * Math.sin(parameter);
	double y = this.radius() * Math.cos(parameter);
	double z = 0.0;

	return new JgclLiteralVector3D(x, y, z);
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclAxis2Placement3D tPosition =
	    this.position().transformBy(reverseTransform,
					transformationOperator,
					transformedGeometries);
	double tRadius;
	if (reverseTransform != true)
	    tRadius = transformationOperator.transform(this.radius());
	else
	    tRadius = transformationOperator.reverseTransform(this.radius());
	return new JgclCircle3D(tPosition, tRadius);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tposition");
        position().output(writer, indent + 2);
        writer.println(indent_tab + "\tradius " + radius);
        writer.println(indent_tab + "End");
    }
}
