/*
 * aXvC̃mbg\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclBsplineKnot.java,v 1.39 2000/08/11 06:18:43 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;

/**
 * aXvC̃mbg\NXB
 * <p>
 * ̃NX̃CX^X́Aȉ̑lɂĂaXvC̃mbg\B
 * <ul>
 * <li>	degree :		aXvC̎
 * <li> nControlPoints :	̃mbgɑΉ鐧_̐
 * <li> knotSpec :		mbg̎ʂ ({@link JgclKnotType JgclKnotType})
 * <li> periodic :		`ۂ_l
 * <li>	knotMultiplicities :	embg̑dx̔z
 * <li> knots :			embg̒l̔z
 * </ul>
 * </p>
 * <p>
 * ۂ̃mbg̒́A
 * periodic  false ł (degree + nControlPoints + 1)A
 * periodic  true ł (2 * degree + nControlPoints + 1)
 * ɂȂB
 * </p>
 * <p>
 * <a name="CONSTRAINTS">[Ԃ̍S]</a>
 * </p>
 * <p>
 * degree  1 ȏłȂ΂ȂȂB
 * </p>
 * <p>
 * knotSpec  JgclKnotType.UNIFORM_KNOTS ̏ꍇɂ
 * <ul>
 * <li>	knotMultiplicities 邢 knots  null łȂ΂ȂȂB
 * </ul>
 * </p>
 * <p>
 * knotSpec  JgclKnotType.UNSPECIFIED ̏ꍇɂ
 * <ul>
 * <li>	knotMultiplicities 邢 knots  null łĂ͂ȂȂB
 * <li>	knotMultiplicities ̒ 1 ȏłȂ΂ȂȂB
 * <li>	knotMultiplicities ̒ knots ̒vȂ΂ȂȂB
 * <li>	(knots[i-1] &gt; knots[i]) łĂ͂ȂȂB
 * <li>	knotMultiplicities[i]  (degree + 1) ȉłȂ΂ȂȂB
 * <li>	periodic  false ł
 *	knotMultiplicities[i] ̑a (degree + nControlPoints + 1) ƈvȂ΂ȂȂB
 * <li>	periodic  true ł
 * <ul>
 * <li>	knotMultiplicities[i] ̑a (2 * degree + nControlPoints + 1) ƈvȂ΂ȂȂB
 * <li>	ŏƍŌ (2 * degree) ̃mbgԊu݂ɈvȂ΂ȂȂB
 * </ul>
 * </ul>
 * </p>
 * <p>
 * knotSpec 
 * JgclKnotType.QUASI_UNIFORM_KNOTS 邢
 * JgclKnotType.PICEWISE_BEZIER_KNOTS łĂ͂ȂȂB
 * </p>
 *
 * @version $Revision: 1.39 $, $Date: 2000/08/11 06:18:43 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclBsplineKnot extends java.lang.Object implements Serializable {

    /**
     * B
     * @serial
     */
    private int degree;

    /**
     * _̐B
     * @serial
     */
    private int nControlPoints;

    /**
     * mbg̎ ({@link JgclKnotType JgclKnotType}) B
     * <p>
     * ܂̂Ƃ
     * {@link JgclKnotType#QUASI_UNIFORM_KNOTS JgclKnotType.QUASI_UNIFORM_KNOTS},
     * {@link JgclKnotType#PIECEWISE_BEZIER_KNOTS JgclKnotType.PIECEWISE_BEZIER_KNOTS}
     * ɂ͑ΉĂȂB
     * </p>
     * @serial
     */
    private int knotSpec;

    /**
     * `ۂ\tOB
     * @serial
     */
    private boolean periodic;

    /**
     * mbgdx̔zB
     * @serial
     */
    private int[] knotMultiplicities;

    /**
     * mbgl̔zB
     * @serial
     */
    private double[] knots;

    /**
     * etB[hɐݒ肷l^ăIuWFNg\zB
     * <p>
     * ̒l <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param degree	
     * @param knotSpec	mbg̎ (JgclKnotType)
     * @param periodic	`ۂ\tO
     * @param knotMultiplicities	mbgdx̔z
     * @param knots	mbgl̔z
     * @param nControlPoints	_̐
     * @see	JgclKnotType
     * @see	JgclInvalidArgumentValue
     */
    public JgclBsplineKnot(int degree, int knotSpec, boolean periodic,
			   int[] knotMultiplicities, double[] knots,
			   int nControlPoints)
    {
	this(degree, knotSpec, periodic, knotMultiplicities, knots, nControlPoints, true);
    }

    /**
     * etB[hɐݒ肷l^ăIuWFNg\zB
     * <p>
     * doCheck  true łƂɁA
     * ̒l <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param degree	
     * @param knotSpec	mbg̎ (JgclKnotType)
     * @param periodic	`ۂ\tO
     * @param knotMultiplicities	mbgdx̔z
     * @param knots	mbgl̔z
     * @param nControlPoints	_̐
     * @param doCheck	̃`FbN邩ǂ
     * @see	JgclKnotType
     * @see	JgclInvalidArgumentValue
     */
    JgclBsplineKnot(int degree, int knotSpec, boolean periodic,
		    int[] knotMultiplicities, double[] knots,
		    int nControlPoints, boolean doCheck)
    {
	super();
	setData(degree, knotSpec, periodic, knotMultiplicities, knots, nControlPoints, doCheck);
    }

    /**
     * etB[hɐݒ肷l^ăIuWFNg\zB
     * <p>
     * ̃RXgN^ł͑قȂmbg̐𖾎B
     * ɗ^mbglуmbgdx̔z񂪁A
     * \zIuWFNgŕKvƂȂ̂ꍇɗp邱Ƃz肵ĂB
     * </p>
     * <p>
     * ̒l <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param degree	
     * @param knotSpec	mbg̎ (JgclKnotType)
     * @param periodic	`ۂ\tO
     * @param nKnots	mbg/dx̔z̒
     * @param knotMultiplicities	mbgdx̔z
     * @param knots	mbgl̔z
     * @param nControlPoints	_̐
     * @see	JgclKnotType
     * @see	JgclInvalidArgumentValue
     */
    JgclBsplineKnot(int degree, int knotSpec, boolean periodic,
		    int nKnots, int[] knotMultiplicities, double[] knots,
		    int nControlPoints)
    {
	this(degree, knotSpec, periodic, nKnots, knotMultiplicities, knots, nControlPoints, true);
    }

    /**
     * etB[hɐݒ肷l^ăIuWFNg\zB
     * <p>
     * ̃RXgN^ł͑قȂmbg̐𖾎B
     * ɗ^mbglуmbgdx̔z񂪁A
     * \zIuWFNgŕKvƂȂ̂ꍇɗp邱Ƃz肵ĂB
     * </p>
     * <p>
     * doCheck  true łƂɁA
     * ̒l <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param degree	
     * @param knotSpec	mbg̎ (JgclKnotType)
     * @param periodic	`ۂ\tO
     * @param nKnots	mbg/dx̔z̒
     * @param knotMultiplicities	mbgdx̔z
     * @param knots	mbgl̔z
     * @param nControlPoints	_̐
     * @param doCheck	̃`FbN邩ǂ
     * @see	JgclKnotType
     * @see	JgclInvalidArgumentValue
     */
    JgclBsplineKnot(int degree, int knotSpec, boolean periodic,
		    int nKnots, int[] knotMultiplicities, double[] knots,
		    int nControlPoints, boolean doCheck)
    {
	super();
	int[] new_multi = new int[nKnots];
	double[] new_knots = new double[nKnots];

	if (knots.length < nKnots || knotMultiplicities.length < nKnots)
	    throw new JgclInvalidArgumentValue();
	for (int i = 0; i < nKnots; i++) {
	    new_multi[i] = knotMultiplicities[i];
	    new_knots[i] = knots[i];
	}
	setData(degree, knotSpec, periodic, new_multi, new_knots, nControlPoints, doCheck);
    }

    /**
     * ̃CX^X̃tB[hɒlݒ肷B
     * <p>
     * doCheck  true łƂɁA
     * ̒l <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param degree	
     * @param knotSpec	mbg̎ (JgclKnotType)
     * @param periodic	`ۂ\tO
     * @param knotMultiplicities	mbgdx̔z
     * @param knots	mbgl̔z
     * @param nControlPoints	_̐
     * @param doCheck	̃`FbN邩ǂ
     * @see	JgclKnotType
     * @see	JgclInvalidArgumentValue
     */
    private void setData(int degree, int knotSpec, boolean periodic,
			 int[] knotMultiplicities, double[] knots,
			 int nControlPoints, boolean doCheck)
    {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double p_tol = condition.getToleranceForParameter();
	this.degree = degree;
	this.nControlPoints = nControlPoints;
	this.knotSpec = knotSpec;
	this.periodic = periodic;

	if (!doCheck) {
	    if (knotSpec != JgclKnotType.UNSPECIFIED) {
		this.knotMultiplicities = null;
		this.knots = null;
	    } else {
		int uik = knotMultiplicities.length;
		this.knotMultiplicities = new int[uik];
		this.knots = new double[uik];
		for (int i = 0; i < uik; i++) {
		    this.knotMultiplicities[i] = knotMultiplicities[i];
		    this.knots[i] = knots[i];
		}
	    }
	    return;
	}

	if (degree < 1) {
	    throw new JgclInvalidArgumentValue();
	}
	switch (knotSpec) {
	case JgclKnotType.UNIFORM_KNOTS:
	    if (knotMultiplicities != null) {
		throw new JgclInvalidArgumentValue();
	    }
	    if (knots != null) {
		throw new JgclInvalidArgumentValue();
	    }
	    this.knotMultiplicities = null;
	    this.knots = null;
	    break;
	case JgclKnotType.UNSPECIFIED:
	    {
		int uik;
		int sum;

		if (knotMultiplicities == null) {
		    throw new JgclInvalidArgumentValue();
		}
		if ((uik = knotMultiplicities.length) < 1) {
		    throw new JgclInvalidArgumentValue();
		}

		if (knots == null) {
		    throw new JgclInvalidArgumentValue();
		}
		if (knots.length != uik) {
		    throw new JgclInvalidArgumentValue();
		}

		this.knotMultiplicities = new int[uik];
		this.knots = new double[uik];
		sum = 0;
		for (int i = 0; i < uik; i++) {
		    this.knotMultiplicities[i] = knotMultiplicities[i];
		    this.knots[i] = knots[i];
		    sum += knotMultiplicities[i];
		    if (i > 0 && knots[i-1] > knots[i]) {
			throw new JgclInvalidArgumentValue();
		    }
		    if (knotMultiplicities[i] > degree + 1) {
			throw new JgclInvalidArgumentValue();
		    }
		}
		if ((periodic && 2 * degree + nControlPoints + 1 != sum) ||
		    (!periodic && degree + nControlPoints + 1 != sum)) {
		    /*
		    System.out.println("degree:" + degree + " nControlPoints:" + nControlPoints
				       + " sum:" + sum);
		    */
		    throw new JgclInvalidArgumentValue();
		}
		if (periodic) {
		    /*
		     * In closed case, first (2 * n) intervals and last (2 * n) intervals
		     * should be coincide.
		     */
		    double h_intvl, h_start, h_end; /* head (interval, start, end) */
		    double t_intvl, t_start, t_end; /* tail (interval, start, end) */
		    int n2 = 2 * degree;
		    int i, j;

		    h_end = knotValueAt(i = 0);
		    t_end = knotValueAt(j = nControlPoints); /* In closed case,
					the number of segments is equal to nControlPoints */
		    while (i < n2) {
			h_start = h_end;
			t_start = t_end;
			h_intvl = (h_end = knotValueAt(i++)) - h_start;
			t_intvl = (t_end = knotValueAt(j++)) - t_start;
			if (Math.abs(h_intvl - t_intvl) > p_tol)
			    throw new JgclInvalidArgumentValue();
		    }
		}
	    }
	    break;
	default:	/* includes QUASI_UNIFORM_KNOTS and PICEWISE_BEZIER_KNOTS */
	    throw new JgclInvalidArgumentValue();
	}
    }

    /**
     * ̃mbg̎ԂB
     * 
     * @return	
     */
    public int degree() {
	return degree;
    }

    /**
     * ̃mbg̐_̐ԂB
     * 
     * @return	_̐
     */
    public int nControlPoints() {
	return nControlPoints;
    }

    /**
     * ̃mbg̃mbg̎ʂԂB
     * 
     * @return	mbg̎
     * @see	JgclKnotType
     */
    public int knotSpec() {
	return knotSpec;
    }

    /**
     * ̃mbg̃mbgl̔z̒ԂB
     * <p>
     * mbg̎ʂ JgclKnotType.UNSPECIFIED łȂꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @return	mbgl̔z̒
     * @see	JgclFatal
     */
    public int nKnots() {
	if (knotSpec() != JgclKnotType.UNSPECIFIED)
	    throw new JgclFatal();

	return knots.length;
    }

    /**
     * ̃mbg̃mbgdx̔zԂB
     * <p>
     * mbg̎ʂ JgclKnotType.UNSPECIFIED łȂꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @return	mbgdx̔z
     * @see	JgclFatal
     */
    public int[] knotMultiplicities() {
	if (knotSpec() != JgclKnotType.UNSPECIFIED)
	    throw new JgclFatal();

	return (int[])knotMultiplicities.clone();
    }

    /**
     * ̃mbg̃mbgl̔zԂB
     * <p>
     * mbg̎ʂ JgclKnotType.UNSPECIFIED łȂꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @return	mbgl̔z
     * @see	JgclFatal
     */
    public double[] knots() {
	if (knotSpec() != JgclKnotType.UNSPECIFIED)
	    throw new JgclFatal();

	return (double[])knots.clone();
    }

    /**
     * ̃mbg񂪎mbgdx̔z i Ԗڂ̒lԂB
     * <p>
     * mbg̎ʂ JgclKnotType.UNSPECIFIED łȂꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @return	i Ԗڂ̃mbgdx
     * @see	JgclFatal
     */
    public int knotMultiplicityAt(int i) {
	if (knotSpec() != JgclKnotType.UNSPECIFIED)
	    throw new JgclFatal();

	return knotMultiplicities[i];
    }

    /**
     * ̃mbǵAw̃mbglɑΉmbgdxԂB
     * <p>
     * ^ꂽlmbglłȂꍇɂ 0 ԂB
     * </p>
     * <p>
     * ȂÃ\bhɐlԂɂ
     * mbg񂪐`ĂKvB
     * </p>
     *
     * @param knot	dx𒲂ׂmbgl
     * @return	w̃mbgl̃mbgdx
     * @see	#beautify()
     */
    public int knotMultiplicityAt(double knot) {
	double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();

	if (this.knotSpec() != JgclKnotType.UNSPECIFIED) {
	    // jtH[
	    double lower = Math.floor(knot);
	    double upper = Math.ceil(knot);

	    double lowerLimit = 0 - this.degree();
	    double upperLimit = (this.nKnotValues() - 1) -  this.degree();

	    if ((knot - lower) < pTol) {
		if ((lowerLimit <= lower) && (lower <= upperLimit))
		    return 1;
	    } else if ((upper - knot) < pTol) {
		if ((lowerLimit <= upper) && (upper <= upperLimit))
		    return 1;
	    }
	} else {
	    // 񃆃jtH[
	    for (int i = 0; i < this.nKnots(); i++) {
		double ithKnot = this.knotAt(i);
		if (Math.abs(knot - ithKnot) < pTol)
		    return this.knotMultiplicityAt(i);
		if (knot < ithKnot)
		    return 0;
	    }
	}

	return 0;
    }

    /**
     * ̃mbg񂪎mbgl̔z i Ԗڂ̒lԂB
     * <p>
     * mbg̎ʂ JgclKnotType.UNSPECIFIED łȂꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @return	i Ԗڂ̃mbgl
     * @see	JgclFatal
     */
    public double knotAt(int i) {
	if (knotSpec() != JgclKnotType.UNSPECIFIED)
	    throw new JgclFatal();

	return knots[i];
    }

    /**
     * ̃mbg񂪕`ł邩ۂԂB
     * 
     * @return	`ł trueAłȂ false
     */
    public boolean isPeriodic() {
	return periodic;
    }

    /**
     * ̃mbg񂪊J`ł邩ۂԂB
     * 
     * @return	J`ł trueAłȂ false
     */
    public boolean isNonPeriodic() {
	return !periodic;
    }

    /**
     * ̃mbg񂪕\p[^`ԂB
     * 
     * @return	p[^`
     */
    JgclParameterDomain getParameterDomain() {
	double start, increase;

	start = knotValueAt(degree);
	increase = knotValueAt(degree + nSegments()) - start;

	try {
	    return new JgclParameterDomain(periodic, start, increase);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̃mbg񂪎aXvC̃ZOg̐ԂB
     *
     * @return	ZOg̐
     */
    public int nSegments() {
	if (periodic) {
	    return nControlPoints;
	} else {
	    return nControlPoints - degree;
	}
    }

    /**
     * ̃mbg̃mbg̐ԂB
     * <p>
     * Ōumbg̐vƂ
     * knots tB[hɐݒ肳ꂽmbgl̔z̒ł͂ȂA
     * aXvC̃mbg{̃mbg̐łB
     * </p>
     *
     * @return	mbg̐
     */
    public int nKnotValues() {
	return 2 * degree + nSegments() + 1;
    }

    /**
     * ^ꂽmbg n Ԗڂ̃mbglԂB
     * <p>
     * Ōun ԖځvƂ
     * ^ꂽmbgl̔z̃CfbNXł͂ȂA
     * aXvC̃mbg{̈Ӗł̃CfbNXłB
     * </p>
     *
     * @param knotMultiplicities mbgdx̔z
     * @param knots	mbgl̔z
     * @param n		CfbNX
     * @return		n Ԗڂ̃mbgl
     */
    static double knotValueAt(int[] knotMultiplicities,
			      double[] knots,
			      int n) {
	int sum = 0;
	int i = 0;

	while (n >= sum)
	    sum += knotMultiplicities[i++];

	return (knots[i-1]);
    }	

    /**
     * ̃mbg n Ԗڂ̃mbglԂB
     * <p>
     * Ōun ԖځvƂ
     * knots tB[hɐݒ肳ꂽmbgl̔z̃CfbNXł͂ȂA
     * aXvC̃mbg{̈Ӗł̃CfbNXłB
     * </p>
     *
     * @param n	CfbNX
     * @return	n Ԗڂ̃mbgl
     */
    public double knotValueAt(int n) {
	if (knotSpec == JgclKnotType.UNIFORM_KNOTS)
	    return (double)(n - degree);
	else 
	    return JgclBsplineKnot.knotValueAt(knotMultiplicities, knots, n);
    }	

    /**
     * ̃mbǵA^ꂽp[^lɑΉZOg̃CfbNXԂB
     * <p>
     * param 
     * {@link JgclParameterDomain#wrap(double) JgclParameterDomain.wrap(double)}
     * 邢
     * {@link JgclParameterDomain#force(double) JgclParameterDomain.force(double)}
     * pĐKĂKvB
     * </p>
     *
     * @param param	p[^l
     * @return		ΉZOg̃CfbNX
     */
    public int segmentIndex(double param) {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double p_tol = condition.getToleranceForParameter();
	int r;
	int sum;
	int i;

	r = nSegments();
	if (Math.abs(knotValueAt(degree + r) - param) < p_tol) {	/* upper limit */
	    while ((--r >= 0) && (Math.abs(knotValueAt(degree + r) - param) < p_tol))
		;
	    return r;
	}

	if (knotSpec == JgclKnotType.UNIFORM_KNOTS)
	    return ((int)param);

	sum = i = 0;
	while (!(param < knots[i])) {
	    /*
	     * while knots[i] is less-equal than param,
	     * sum is accumulated by knotMultiplicities[i], and
	     * i   is incremented by 1.
	     */
	    sum += knotMultiplicities[i++];

	    if (i >= knots.length) {
		/*
		 * i is equal with the size of 'knots' array
		 */
		if (param > (knots[--i] + p_tol)) {
		    /*
		     * param is greater than the max valid value, out of range
		     */
		    return (-1);
		}

		param = knots[i];
		while (!(param > knots[i]))
		    sum -= knotMultiplicities[i--];
		break;
	    }
	}

	r = sum - degree - 1;
	if (r >= 0)
	    return (r);
	else
	    return (-1);
    }

    /**
     * ̃mbg (kނĂȂ) LȃZOg̏ԂB
     *
     * @return	LȃZOg̏
     */
    ValidSegmentInfo validSegments() {
	int nseg_p1;	/* # of segments + 1 */
	int[] sn;	/* pointer to 'segment number' array */
	double[] kp;	/* pointer to 'knot point' array */

	int nvseg;		/* # of valid segments */
	double kval, pval;	/* value of knot */
	int i, k;		/* loop counter */

	double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();

	nseg_p1 = nSegments() + 1;

	sn = new int[nseg_p1];
	kp = new double[nseg_p1];

	nvseg = (- 1);
	i = degree;
	pval = (knotValueAt(i) - 1.0);	/* Initial value of 'pval' should be smaller
					   than lower limit of first segment.
					   So (- 1.0) is applied. */

	for (k = 0; k < nseg_p1; k++) {	/* from lower limit to upper limit */

	    if (((kval = knotValueAt(i)) - pval) > tol_p) {
		/* segment has a width. first pass of this 'for' block shall reach here. */
		sn[++nvseg] = i - degree;
		kp[nvseg]   = kval;
	    } else {
		/* reduced segment */
		sn[nvseg] = i - degree;
	    }

	    i++;
	    pval = kval;
	}
       
	return new ValidSegmentInfo(nvseg, sn, kp);
    }

    /**
     * mbg (kނĂȂ) LȃZOg̏\NXB
     */
    class ValidSegmentInfo {
	/**	
	 * LȃZOg̃CfbNX̔zB
	 */
	private int[] segmentNumber;

	/**
	 * LȃZOg̃mbg_̔zB
	 */
 	private double[] knotPoint;

	/**
	 * etB[hɐݒ肷l^ăIuWFNg\zB
	 *
	 * @param nSegments	LȃZOg̐B
	 * @param segmentNumber	LȃZOg̃CfbNX̔z
	 * @param knotPoint	LȃZOg̃mbg_̔z
	 */
	ValidSegmentInfo(int nSegments, int[] segmentNumber, double[] knotPoint) {
	    this.segmentNumber = new int[nSegments];
	    this.knotPoint = new double[nSegments + 1];
	    for (int i = 0; i < nSegments; i++) {
		this.segmentNumber[i] = segmentNumber[i];
		this.knotPoint[i] = knotPoint[i];
	    }
	    this.knotPoint[nSegments] = knotPoint[nSegments];
	}

	/**
	 * LȃZOg̐ԂB
	 *
	 * @return	LȃZOg̐
	 */
	int nSegments() {
	    return segmentNumber.length;
	}

	/**
	 * n Ԗڂ̗LȃZOg̃CfbNXԂB
	 *
	 * @return	n Ԗڂ̗LȃZOg̃CfbNX
	 */
	int segmentNumber(int n) {
	    return segmentNumber[n];
	}

	/**
	 * n Ԗڂ̗LȃZOg̃mbg_ԂB
	 * <p>
	 * ʂƂēz̗vf 2 ŁA
	 * ŏ̗vfɂ̓ZOg̎n_̃p[^lA
	 * Ԗڂ̗vfɂ̓ZOg̏I_̃p[^l
	 * B
	 * </p>
	 *
	 * @return	n Ԗڂ̗LȃZOg̃mbg_̔z
	 */
	double[] knotPoint(int n) {
	    double[] prms = new double[2];

	    prms[0] = knotPoint[n];
	    prms[1] = knotPoint[n + 1];
	    return prms;
	}

	/**
	 * n Ԗڂ̗LȃZOg̎n_̃p[^lԂB
	 *
	 * @return	n Ԗڂ̗LȃZOg̎n_̃p[^l
	 */
	double headKnotPoint(int n) {
	    return knotPoint[n];
	}

	/**
	 * n Ԗڂ̗LȃZOg̏I_̃p[^lԂB
	 *
	 * @return	n Ԗڂ̗LȃZOg̏I_̃p[^l
	 */
	double tailKnotPoint(int n) {
	    return knotPoint[n + 1];
	}

	/**
	 * ^ꂽp[^lg̓Ɋ܂ޗLȃZOg
	 * segmentNumber[] ł̃CfbNXԂB
	 *
	 * @param	p[^l
	 * @return	p[^lg̓Ɋ܂ޗLȃZOg segmentNumber[] ł̃CfbNX
	 */
	int segmentIndex(double param) {
	    double tol_p = JgclConditionOfOperation.getCondition().getToleranceForParameter();
	    int nseg;
	    int i;

	    if (param < knotPoint[0])
		return -1;

	    nseg = nSegments();
	    for (i = 0; i < nseg; i++)
		if (param < knotPoint[i + 1])
		    return i;

	    if (Math.abs(param - knotPoint[nseg]) < tol_p)
		return (nseg - 1);

	    return -1;
	}

	/**
	 * ^ꂽZOgLۂ𒲂ׂB
	 * <p>
	 * ^ꂽZOgLłȂ΁A-1 ԂB
	 * </p>
	 * 
	 * @param	ZOg̃CfbNX
	 * @return	^ꂽZOg segmentNumber[] ł̃CfbNX
	 */
	int isValidSegment(int seg) {
	    int klm;
	    int nvseg = nSegments();
	    for (klm = 0; klm < nvseg; klm++) {
		if (segmentNumber(klm) == seg)
		    return klm;
	    }
	    return -1;
	}

	/**
	 * Ǐp[^敝֕ϊB
	 *
	 * @param index	ΏۂƂLȃZOg̓Y
	 * @param local	Ǐp[^
	 * @return	敝
	 */
	double l2Gw(int index, double local) {
	    double[] knots = knotPoint(index);
	    return (knots[1] - knots[0]) * local;
	}

	/**
	 * Ǐp[^ll֕ϊB
	 *
	 * @param index	ΏۂƂLȃZOg̓Y
	 * @param local	Ǐp[^l
	 * @return	l
	 */
	double l2Gp(int index, double local) {
	    double[] knots = knotPoint(index);
	    return knots[0] + (knots[1] - knots[0]) * local;
	}

	/**
	 * ^ꂽp[^lɓmbg_n_ƂZOg̔ԍԂB
	 * <p>
	 * ŏIZOg̏I_ɓꍇɂ́A(ŏIZOg̔ԍ + 1) ԂB
	 * </p>
	 * <p>
	 * ^ꂽp[^lmbg_łȂꍇɂ -1 ԂB
	 * </p>
	 *
	 * @param param	p[^l
	 * @return	p[^lɓmbg_n_ƂZOg̔ԍ
	 */
	int getSegmentNumberThatStartIsEqualTo(double param) {
	    double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
	    for (int i = 0; i <= this.segmentNumber.length; i++)
		if (Math.abs(param - this.knotPoint[i]) < pTol)
		    return segmentNumber[i];
	    return (- 1);
	}
    }

    /**
     * ̃mbǵA
     * ^ꂽp[^lɓmbg_n_Ƃ (Ō) ZOg̔ԍԂB
     * <p>
     * ŏIZOg̏I_ɓꍇɂ́A(ŏIZOg̔ԍ + 1) ԂB
     * </p>
     * <p>
     * ^ꂽp[^lmbg_łȂꍇɂ -1 ԂB
     * </p>
     *
     * @param param	p[^l
     * @return	p[^lɓmbg_n_Ƃ (Ō) ZOg̔ԍ
     */
    int getSegmentNumberThatStartIsEqualTo(double param) {
	double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();

	for (int i = (this.degree + this.nSegments()); i >= this.degree; i--)
	    if (Math.abs(param - this.knotValueAt(i)) < pTol)
		return (i - this.degree);
	return (- 1);
    }

    /**
     * ̃mbg̗[̒l`ƂĐ̂ɂmbgԂB
     *
     * @return	[̒l`ƂĐmbg
     */
    JgclBsplineKnot makeKnotsClosed()
    {
	int n_kel = this.nKnotValues();
	int lower_idx = this.degree();
	int upper_idx = this.degree() + this.nSegments();
	double intvl;
	int i, j, k;
  
	double[] simple_knots = new double[n_kel];
	int[] simple_knot_multi = new int[n_kel];
  
	for (i = 0; i < n_kel; i++) {
	    simple_knots[i]      = this.knotValueAt(i);
	    simple_knot_multi[i] = 1;
	}
  
	j = lower_idx;
	k = upper_idx;
	for (i = 0; i < this.degree(); i++) {
	    intvl = simple_knots[j+1] - simple_knots[j];
	    simple_knots[k+1] = simple_knots[k] + intvl;
	    j++;
	    k++;
	}

	j = lower_idx;
	k = upper_idx;
	for (i = 0; i < this.degree(); i++) {
	    intvl = simple_knots[k] - simple_knots[k-1];
	    simple_knots[j-1] = simple_knots[j] - intvl;
	    j--;
	    k--;
	}

	int uik =
	    JgclBsplineKnot.beautify(n_kel, simple_knots, simple_knot_multi);

	return new JgclBsplineKnot(this.degree(), JgclKnotType.UNSPECIFIED,
				   this.isPeriodic(),
				   uik, simple_knot_multi, simple_knots,
				   this.nControlPoints());
    }

    /**
     * mbg𐮌`B
     * <p>
     * ^ꂽmbgɂđdx
     * knotMultiplicities ŖĂȂӏCB
     * </p>
     *
     * @param uik	ez̗Lȗvf
     * @param knots	mbgl̔z (vfFuik ȏ)
     * @param knotMultiplicities mbgdx̔z (vfFuik ȏ)
     * @return Cꂽmbg̗Lȗvf
     */
    static int beautify(int uik,
			double[] knots,
			int[]    knotMultiplicities) {
	double kval = knots[0] - 1.0;
	double p_tol = JgclConditionOfOperation.getCondition().getToleranceForParameter();

	int j = 0;
	for (int i = 0; i < uik; i++) {
	    if (Math.abs(kval - knots[i]) > p_tol) {
		kval = knots[j] = knots[i];
		knotMultiplicities[j] = knotMultiplicities[i];
		j++;
	    } else {
		knotMultiplicities[j - 1] += knotMultiplicities[i];
	    }
	}

	return j;
    }

    /**
     * mbg𐮌`B
     * <p>
     * ^ꂽmbgɂđdx
     * knotMultiplicities ŖĂȂӏCB
     * </p>
     *
     * @return Cꂽmbg
     */
    public JgclBsplineKnot beautify() {
	if (knotSpec != JgclKnotType.UNSPECIFIED)
	    return this;

	int uik = nKnots();
	double[] new_knots = knots();
	int[] new_knot_multi = knotMultiplicities();
	int n_new_knots = JgclBsplineKnot.beautify(uik, new_knots, new_knot_multi);

	try {
	    return new JgclBsplineKnot(degree, knotSpec, periodic,
				       n_new_knots, new_knot_multi, new_knots,
				       nControlPoints);
	} catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̃mbg𔽓]mbgԂB
     * <p>
     * ̃\bhԂmbg̃p[^` 0 Ŏn܂B
     * </p>
     *
     * @return	]mbg
     */
    public JgclBsplineKnot reverse() {
	if (knotSpec != JgclKnotType.UNSPECIFIED) {
	    return this;	// same as this
	}

	int n_kel = nKnotValues();
	int[] new_multi = new int[n_kel];
	double[] new_knots = new double[n_kel];
	int i, j;

	new_multi[degree] = 1;
	new_knots[degree] = 0.0;

	int lk_idx = degree + nSegments();	// index of last internal knot

	for (i = degree - 1, j = lk_idx; i >= 0; i--, j++) {
	    new_knots[i] = new_knots[i+1] - (knotValueAt(j+1) - knotValueAt(j));
	    new_multi[i] = 1;
	}
    
	for (i = degree + 1, j = lk_idx; i < n_kel; i++, j--) {
	    new_knots[i] = new_knots[i-1] + (knotValueAt(j) - knotValueAt(j-1));
	    new_multi[i] = 1;
	}
	return new JgclBsplineKnot(degree, knotSpec, periodic, new_multi, new_knots,
				   nControlPoints).beautify();
    }

    /**
     * ́uvmbgA^ꂽmbg_Jn_ɂȂ悤ɃVtgB
     *
     * @param firstSegment	Jn_ƂȂmbg_n_ƂZOg̔ԍ
     * @return	^ꂽԍ̃ZOg̎n_Jn_Ƃmbg
     */
    JgclBsplineKnot shift(int firstSegment) {
	if (this.periodic != true)
	    throw new JgclFatal("knots should be closed form.");

	if ((firstSegment < 0) || (this.nSegments() < firstSegment))
	    throw new JgclFatal("given index is wrong.");

	if (this.knotSpec == JgclKnotType.UNIFORM_KNOTS)
	    return this;

	int nKnots = this.nKnotValues();
	double[] newKnots = new double[nKnots];
	int[] newKnotMultiplicities = new int[nKnots];

	double upperParam = this.knotValueAt(this.degree + this.nSegments());
	double plusFactor = 0.0;
	double minusFactor = this.knotValueAt(this.degree + firstSegment) -
	                     this.knotValueAt(this.degree);

	for (int i = 0; i < nKnots; i++) {
	    int j = i + firstSegment;
	    if (j >= nKnots) {
		j += (2 * this.degree) + 1;
		plusFactor = upperParam;
	    }
	    newKnots[i] = this.knotValueAt(j % nKnots) + plusFactor - minusFactor;
	    newKnotMultiplicities[i] = 1;
	}

	JgclBsplineKnot knotData =
	    new JgclBsplineKnot(this.degree, this.knotSpec, true,
				newKnotMultiplicities, newKnots, this.nControlPoints);
	return knotData.beautify();
    }

    /**
     * ̃mbg knotSpec  JgclKnotType.UNSPECIFIED ɕςmbgԂB
     * <p>
     * ̃mbg knotSpec  JgclKnotType.UNSPECIFIED łꍇɂ́AgԂB
     * </p>
     *
     * @return	 knotSpec  JgclKnotType.UNSPECIFIED ɕςmbg
     */
    JgclBsplineKnot makeExplicit() {
	switch (knotSpec()) {
	case JgclKnotType.UNSPECIFIED:
	    return this;
	case JgclKnotType.UNIFORM_KNOTS:
	    int uik = nKnotValues();
	    double[] new_knots = new double[uik];
	    int[] new_knot_multi = new int[uik];
	    for (int uj = 0; uj < uik; uj++) {
		new_knots[uj] = uj - degree();
		new_knot_multi[uj] = 1;
	    }
	    return new JgclBsplineKnot(degree(), JgclKnotType.UNSPECIFIED, periodic,
				       new_knot_multi, new_knots, nControlPoints());
	}
	throw new JgclFatal();
    }

    /*
     *                       n
     * aXvC֐ N (t) ̕]
     *                       i
     */

    /**
     * ́ujtH[ȁvmbg񂪕\aXvC֐A
     * ^ꂽp[^lŕ]B
     * <p>
     * ]֐̒li[邽߂̔z r ̗vf́A
     * ȂƂ (aXvC̎ + 1) łȂ΂ȂȂB
     * </p>
     *
     * @param k0	mbg̐擪̃mbg̒l
     * @param n	֐̎
     * @param i	Z̑ΏۂƂmbg͈̔͂̐擪̃mbg̃CfbNX
     * @param t	p[^l
     * @param r	֐l̔z
     * @see	#evalBsplineU(double, double[])	\bh
     */
    private void evalUniform(int k0, int n, int i,
			     double t, double[] r) {
	int j, k;

	if (n == 0) {
	    r[0] = 1.0;
	} else {
	    double[] rTmp = new double[r.length - 1];

	    for (j = 0; j < r.length - 1; j++) rTmp[j] = r[j + 1]; // Kv?
	    evalUniform(k0, (n - 1), (i + 1), t, rTmp);
    	    for (j = 0; j < r.length - 1; j++) r[j + 1] = rTmp[j];

	    for (j = 0, k = i; j <= n; j++, k++) {
		if (j == 0)
		    r[j] =                        (k0 + (k + n + 1) - t) * r[j + 1]  / n;
		else if (j == n)
		    r[j] =  (t - k0 + k) * r[j]                                      / n;
		else
		    r[j] = ((t - k0 + k) * r[j] + (k0 + (k + n + 1) - t) * r[j + 1]) / n;
	    }
	}
    }

    /**
     * ́ujtH[ȁvmbg񂪕\aXvC֐A
     * ^ꂽp[^lŕ]B
     * <p>
     * ]֐̒li[邽߂̔z r ̗vf́A
     * ȂƂ (aXvC̎ + 1) łȂ΂ȂȂB
     * </p>
     *
     * @param t	p[^l
     * @param r	֐l̔z
     * @return	t ɑ΂ėLƂȂZOg̔ԍ
     * @see	#evaluateBsplineFunction(double, double[])	\bh
     * @see	#evalUniform(int, int, int, double, double[])	\bh
     */
    private int evalBsplineU(double t, double[] r)
    {
	int n_seg = nSegments();
	JgclParameterDomain dmn = getParameterDomain();
	if (!dmn.isValid(t))
	    throw new JgclFatal();
	t = dmn.wrap(dmn.force(t));

	int isckt;
	int i;

	for (isckt = 1; !(t < isckt); isckt++)
	    ;
	isckt--;
	if (isckt >= n_seg)
	    isckt = n_seg - 1; // special case

	for (i = 0; i <= degree(); i++) r[i] = 0.0;
	evalUniform((- degree()), degree(), isckt, t, r);

	return isckt;
    }

    /**
     * ̃mbg񂪕\aXvC֐A^ꂽp[^lŕ]B
     * <p>
     * ]֐̒li[邽߂̔z r ̗vf́A
     * ȂƂ (aXvC̎ + 1) łȂ΂ȂȂB
     * </p>
     *
     * @param n	֐̎
     * @param i	Z̑ΏۂƂmbg͈̔͂̐擪̃mbg̃CfbNX
     * @param t	p[^l
     * @param r	֐l̔z
     * @param pTol	p[^l̋e덷
     * @see	#evalBspline(double, double[])	\bh
     */
    private void evalNonUniform(int n, int i, double t, double[] r, double pTol)
    {
	double tk;
	double w1 = 0.0;
	double w2 = 0.0;
	int j, k;

	if (n == 0) {
	    r[0] = 1.0;
	} else {
	    double[] rTmp = new double[r.length - 1];

	    for (j = 0; j < r.length - 1; j++) rTmp[j] = r[j + 1]; // Kv?
	    evalNonUniform((n - 1), (i + 1), t, rTmp, pTol);
	    for (j = 0; j < r.length - 1; j++) r[j + 1] = rTmp[j];

	    for (j = 0, k = i; j <= n; j++, k++) {
		if (j != 0) {
		    if ((w1 = knotValueAt(k + n) - (tk = knotValueAt(k))) < pTol)
			w1 = 0.0;
		    else
			w1 = (t - tk) / w1;
		}

		if (j != n) {
		    if ((w2 = (tk = knotValueAt(k + n + 1)) - knotValueAt(k + 1)) < pTol)
			w2 = 0.0;
		    else
			w2 = (tk - t) / w2;
		}

		if (j == 0)
		    r[j] = w2 * r[j + 1];
		else if (j == n)
		    r[j] = w1 * r[j];
		else
		    r[j] = w1 * r[j] + w2 * r[j + 1];
	    }
	}
    }

    /**
     * ̃mbg񂪕\aXvC֐A^ꂽp[^lŕ]B
     * <p>
     * ]֐̒li[邽߂̔z r ̗vf́A
     * ȂƂ (aXvC̎ + 1) łȂ΂ȂȂB
     * </p>
     *
     * @param t	p[^l
     * @param r	֐l̔z
     * @return	t ɑ΂ėLƂȂZOg̔ԍ
     * @see	#evaluateBsplineFunction(double, double[])	\bh
     * @see	#evalNonUniform(int, int, double, double[], double)	\bh
     */
    private int evalBspline(double t, double[] r) {
	int isckt;
	int i;

	int n_seg = nSegments();		// number of segments
	int n_seg_pd = n_seg + degree();	// (number of segments) + degree
	JgclParameterDomain dmn = getParameterDomain();
	if (!dmn.isValid(t))
	    throw new JgclFatal();
	t = dmn.wrap(dmn.force(t));

	for (isckt = degree() + 1; isckt <= n_seg_pd; isckt++) {
	    // #ifdef PAR_IS_LESS_THAN_UPPER_LIMIT
	    //     if (t < knotValueAt(isckt))
	    // 	break;
	    // #else
	    if (isckt < n_seg_pd) {
	     	if (t < knotValueAt(isckt))
		    break;
	        } else {
		    if (!(t > knotValueAt(isckt)))
			break;
		}
	    // #endif
	}
	if (isckt > n_seg_pd) {
	    throw new JgclFatal();
	}

	isckt -= degree() + 1;

	double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
	for (i = 0; i <= degree(); i++) r[i] = 0.0;
	evalNonUniform(degree(), isckt, t, r, pTol);

	return isckt;
    }

    /**
     * ̃mbg񂪕\aXvC֐A^ꂽp[^lŕ]B
     * <p>
     * ]֐̒li[邽߂̔z r ̗vf́A
     * ȂƂ (aXvC̎ + 1) łȂ΂ȂȂB
     * </p>
     *
     * @param t	p[^l
     * @param r	֐l̔z
     * @return	t ɑ΂ėLƂȂZOg̔ԍ
     * @see	#evalBsplineU(double, double[])	jtH[ȏꍇ̉\bh
     * @see	#evalBspline(double, double[])	񃆃jtH[ȏꍇ̉\bh
     */
    int evaluateBsplineFunction(double t, double[] r) {
	if (knotSpec() == JgclKnotType.UNIFORM_KNOTS)
	    return evalBsplineU(t, r);
	else
	    return evalBspline(t, r);
    }

    /**
     * {@link #output(PrintWriter, int, int) output(PrintWriter, int, int)}
     * ŎQƂ String ̓񎟌zB
     * <p>
     * 3 x 6 ̓񎟌zB
     * <pre>
     *		keyWords[0] : Ȑp̕܂ޔz
     *		keyWords[1] : Ȗʂ U p̕܂ޔz
     *		keyWords[2] : Ȗʂ V p̕܂ޔz
     * </pre>
     * </p>
     */
    static final String[][] keyWords
	= {{"\tdegree\t", "\tnControlPoints\t", "\tknotSpec\t", "\tknotMultiplicities\t",
	    "\tknots\t", "\tperiodic\t"},
	   {"\tuDegree\t", "\tuNControlPoints\t", "\tuKnotSpec\t", "\tuKnotMultiplicities\t",
	    "\tuKnots\t", "\tuPeriodic\t"},
	   {"\tvDegree\t", "\tvNControlPoints\t", "\tvKnotSpec\t", "\tvKnotMultiplicities\t",
	    "\tvKnots\t", "\tvPeriodic\t"}};

    /**
     * o̓Xg[Ɍ`o͂B
     * <p>
     * index ̒l͈ȉ̈ӖB
     * <pre>
     *		0 : Ȑp̕ŏo͂
     *		1 : Ȗʂ U p̕ŏo͂
     *		2 : Ȗʂ V p̕ŏo͂
     * </pre>
     * </p>
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @param index	L[[hIl
     */
    protected void output(PrintWriter writer, int indent, int index) {
        // make string of indent tabs
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < indent; i++) {
            buf.append("\t");
        }
        String indent_tab = new String(buf);

        // output formatted infomation of parameters
        //writer.println(indent_tab + "JgclBsplineKnot");
        writer.println(indent_tab + keyWords[index][0] + degree);
        writer.println(indent_tab + keyWords[index][1] + nControlPoints);
        writer.println(indent_tab + keyWords[index][2] + JgclKnotType.toString(knotSpec));
	if (knotSpec == JgclKnotType.UNSPECIFIED) {
	    // formatting knotMultiplicities
	    writer.print(indent_tab + keyWords[index][3]);
	    int i = 0;
	    while (true) {
		writer.print(knotMultiplicities[i++]);
		for (int j = 0; j < 20 && i < knotMultiplicities.length; j++, i++) {
		    writer.print(" " + knotMultiplicities[i]);
		}
		writer.println();
		if (i < knotMultiplicities.length) {
		    writer.print(indent_tab + "\t\t");	// two tabs?
		} else {
		    break;
		}
	    }
	    // formatting knots
	    writer.print(indent_tab + keyWords[index][4]);
	    i = 0;
	    while (true) {
		writer.print(knots[i++]);
		for (int j = 0; j < 3 && i < knots.length; j++, i++) {
		    writer.print(" " + knots[i]);
		}
		writer.println();
		if (i < knots.length) {
		    writer.print(indent_tab + "\t\t");	// two tabs?
		} else {
		    break;
		}
	    }
	}
        writer.println(indent_tab + keyWords[index][5] + periodic);
        //writer.println(indent_tab + "End");
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param out	o̓Xg[
     */
    public void output(OutputStream out) {
        PrintWriter writer = new PrintWriter(out, true);
	output(writer, 0, 0);
    }

    /**
     * 1 Ő_ 2A[d̃jtH[ȃmbgB
     */
    static JgclBsplineKnot quasiUniformKnotsOfLinearOneSegment;

    /**
     * static ȃtB[hɒlݒ肷B
     */
    static {
	int[] knotMultiplicities = {2, 2};
	double[] knots = {0.0, 1.0};

	quasiUniformKnotsOfLinearOneSegment =
	    new JgclBsplineKnot(1, JgclKnotType.UNSPECIFIED, false,
				knotMultiplicities, knots, 2);
    }
}
