/*
 * R : \NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclBoundedLine3D.java,v 1.30 2000/08/11 06:18:42 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : \NXB
 * <p>
 * ́A
 * n_̍Wl spnt
 * 
 * I_̍Wl epnt
 * Œ`B
 * </p>
 * <p>
 * ͔IȗLȐŁÃp[^` [0, 1] ƂȂB
 * </p>
 * <p>
 * t p[^Ƃ P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(t) = (1 - t) * spnt + t * epnt
 * </pre>
 * </p>
 *
 * @version $Revision: 1.30 $, $Date: 2000/08/11 06:18:42 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclBoundedLine3D extends JgclBoundedCurve3D {
    /**
     * n_B
     * @serial
     */
    private JgclPoint3D spnt;

    /**
     * I_B
     * @serial
     */
    private JgclPoint3D epnt;

    /**
     * ̃CX^X̃tB[hɒlݒ肷B
     * <p>
     * doCheck  true ̏ꍇA
     * spnt  epnt ̋ݐݒ肳Ă鉉Z̋̋e덷
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param spnt	n_̍Wl
     * @param epnt	I_̍Wl
     * @param doCheck	̃`FbN邩ǂ̃tO
     * @see	JgclPoint3D#identical(JgclPoint3D)
     * @see	JgclInvalidArgumentValue
     */
    private void setPoints(JgclPoint3D spnt, JgclPoint3D epnt, boolean doCheck) {
	if (doCheck && spnt.identical(epnt))
	    throw new JgclInvalidArgumentValue();

	this.spnt = spnt;
	this.epnt = epnt;
    }

    /**
     * n_ƏI_^ăIuWFNg\zB
     * <p>
     * spnt  epnt ̋ݐݒ肳Ă鉉Z̋̋e덷
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param spnt	n_
     * @param epnt	I_
     * @see	JgclPoint3D#identical(JgclPoint3D)
     * @see	JgclInvalidArgumentValue
     */
    public JgclBoundedLine3D(JgclPoint3D spnt, JgclPoint3D epnt) {
	super();
	setPoints(spnt, epnt, true);
    }

    /**
     * n_ƏI_^ăIuWFNg\zB
     * <p>
     * doCheck  true ̏ꍇA
     * spnt  epnt ̋ݐݒ肳Ă鉉Z̋̋e덷
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param spnt	n_
     * @param epnt	I_
     * @see	JgclPoint3D#identical(JgclPoint3D)
     * @see	JgclInvalidArgumentValue
     * @param doCheck	̃`FbN邩ǂ̃tO
     */
    JgclBoundedLine3D(JgclPoint3D spnt, JgclPoint3D epnt, boolean doCheck) {
	super();
	setPoints(spnt, epnt, doCheck);
    }

    /**
     * n_Ɓun_I_܂ł̃xNgv^ăIuWFNg\zB
     * <p>
     * dir ̑傫ݐݒ肳Ă鉉Z̋̋e덷
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param spnt	n_
     * @param dir	n_I_܂ł̃xNg
     * @see	JgclInvalidArgumentValue
     */
    public JgclBoundedLine3D(JgclPoint3D spnt, JgclVector3D dir) {
	super();
	setPoints(spnt, spnt.add(dir), true);
    }

    /**
     * n_Ɓun_I_܂ł̃xNgv^ăIuWFNg\zB
     * <p>
     * doCheck  true ̏ꍇA
     * dir ̑傫ݐݒ肳Ă鉉Z̋̋e덷
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param spnt	n_
     * @param dir	n_I_܂ł̃xNg
     * @param doCheck	̃`FbN邩ǂ̃tO
     * @see	JgclInvalidArgumentValue
     */
    JgclBoundedLine3D(JgclPoint3D spnt, JgclVector3D dir, boolean doCheck) {
	super();
	setPoints(spnt, spnt.add(dir), doCheck);
    }

    /**
     * ̐̎n_ԂB
     * 
     * @return	n_
     */
    public JgclPoint3D spnt() {
	return this.spnt;
    }

    /**
     * ̐̏I_ԂB
     * 
     * @return	I_
     */
    public JgclPoint3D epnt() {
	return this.epnt;
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ̑l͕ł܂ȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     * @see	JgclParameterOutOfRange
     */
    public double length(JgclParameterSection pint) {
	checkParameter(pint.start());
	checkParameter(pint.end());
        return length() * Math.abs(pint.increase());
    }

    /**
     * ̗LȐŜ̎ԏł̒ (̂) ԂB
     * 
     * @return	ȐŜ̒
     */
    public double length() {
	return this.spnt().distance(this.epnt());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint3D coordinates(double param) {
	param = checkParameter(param);
	return this.epnt().linearInterpolate(this.spnt(), param);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * 
     * @param param	p[^l
     * @return		ڃxNg
     */
    public JgclVector3D tangentVector(double param) {
	param = checkParameter(param);
	return this.epnt().subtract(this.spnt());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * ̋ȗ́A 0 łB
     * </p>
     * 
     * @param param	p[^l
     * @return		ȗ
     */
    public JgclCurveCurvature3D curvature(double param) {
	param = checkParameter(param);
	return new JgclCurveCurvature3D(0.0, JgclVector3D.zeroVector);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̃CԂB
     * <p>
     * ̃ĆA 0 łB
     * </p>
     * 
     * @param param	p[^l
     * @return		C
     */
    public double torsion(double param) {
	param = checkParameter(param);
	return 0.0;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * 
     * @param param	p[^l
     * @return		֐
     */
    public JgclCurveDerivative3D evaluation(double param) {
	param = checkParameter(param);
	return new JgclCurveDerivative3D(coordinates(param),
					 tangentVector(param),
					 JgclVector3D.zeroVector,
					 JgclVector3D.zeroVector);
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ɂ͓ٓ_݂͑Ȃ̂ƂāA 0 ̔zԂB
     * </p>
     * 
     * @return	ٓ_̔z
     */
    public JgclPointOnCurve3D[] singular() {
        return new JgclPointOnCurve3D[0];
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ɂ͕ϋȓ_݂͑Ȃ̂ƂāA 0 ̔zԂB
     * </p>
     * 
     * @return	ϋȓ_̔z
     */
    public JgclPointOnCurve3D[] inflexion() {
        return new JgclPointOnCurve3D[0];
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ւ̓e_̐́Aꂪ݂ꍇɂ́AK 1 łB
     * </p>
     * 
     * @param point	e̓_
     * @return	e_
     * @see	#project1From(JgclPoint3D)
     */
    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point) {
	JgclPointOnCurve3D[] prjp;
	JgclPointOnCurve3D poc;
	double param;

	if ((poc = project1From(point)) == null)
	    return new JgclPointOnCurve3D[0];
	prjp = new JgclPointOnCurve3D[1];
	prjp[0] = poc;
	return prjp;
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ null ԂB
     * </p>
     * <p>
     * _ւ̓e_̐́Aꂪ݂ꍇɂ́AK 1 łB
     * </p>
     * 
     * @param point	e̓_
     * @return	e_
     * @see	#projectFrom(JgclPoint3D)
     */
    public JgclPointOnCurve3D project1From(JgclPoint3D point) {
	JgclPointOnCurve3D[] prjp;
	JgclPointOnCurve3D poc;
	double param;

	poc = toLine().project1From(point);
	param = poc.parameter();

	JgclPointOnCurve3D result = null;

	if (!isValid(param)) {		// Ń`FbNׂ
	    return null;
	}

	return new JgclPointOnCurve3D(this, param, doCheckDebug);
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_
     * ̋Ȑx[XƂ JgclPointOnCurve3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * |C͏Ɍɂ̐Č̂ŁA
     * ̃\bh̓ł tol ̒l͎QƂȂB
     * </p>
     * 
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     */
    public JgclPolyline3D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol) {
	JgclPoint3D[] points = new JgclPoint3D[2];

	points[0] = new JgclPointOnCurve3D(this, pint.start(), doCheckDebug);
	points[1] = new JgclPointOnCurve3D(this, pint.end(), doCheckDebug);
	return new JgclPolyline3D(points);
    }

    /**
     * ̐Č|CԂB
     *
     * @return	̐Č|C
     */
    JgclPolyline3D toPolyline() {
	JgclPoint3D[] points = new JgclPoint3D[2];

	points[0] = this.spnt;
	points[1] = this.epnt;
	return new JgclPolyline3D(points);
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     */
    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
	return toLine().toBsplineCurve(pint);
    }

    /*
     * ̐𒼐ɕϊB
     *
     * @return	̐ϊ
     */
    public JgclLine3D toLine() {
	return new JgclLine3D(spnt(), epnt());
    }

    /**
     * ̐̐isPʉxNgԂB
     * 
     * @return	Pʉꂽis
     */
    public JgclVector3D unitizedDirection() {
	return tangentVector(0.0).unitized();
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (@)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȗ (͋Ȗ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ (͋Ȗ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate,
					       boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȗ (xWGȖ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate,
					       boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȗ (aXvCȖ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate,
					       boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̐Ɨ^ꂽƂ̊ԂɌ_邩ۂԂB
     * <p>
     * e덷̔fׂ͂āuvōsȂB
     * </p>
     *
     * @param lin	
     * @param ludir	̐KxNg
     * @return		0: parallel, 1: intersects, -1: overlap
     */
    private int haveIntsWithLine(JgclLine3D lin, JgclVector3D ludir) {
	double magni;
	JgclVector3D dir;
	double[] dists = new double[2];
	double d_tol = getToleranceForDistance();

	dir = this.spnt.subtract(lin.pnt());
	dists[0] = dir.crossProduct(ludir).length();

	dir = this.epnt.subtract(lin.pnt());
	dists[1] = dir.crossProduct(ludir).length();

	if (Math.abs(dists[0]) < d_tol && Math.abs(dists[1]) < d_tol)
	    return -1;
	else if (Math.abs(dists[0] - dists[1]) < d_tol) {
	    dir = this.epnt.subtract(this.spnt);
	    if (dir.crossProduct(ludir).length() < d_tol)
		return 0;
	}
	return 1;

    }

    /*
     * ̐̒[_̐́uvɂ邩ǂ𒲂ׂB
     * <p>
     * is_in, param ̗vf́AȂƂ 2 łKvB
     * </p>
     * <p>
     * is_in[0]  0 ̏ꍇA̐̎n_͑̐̓ɂȂƂB
     * </p>
     * <p>
     * is_in[0]  1 ̏ꍇA̐̎n_͑̐̓ɂ邱ƂB
     * ̏ꍇɂ́Aparam[0] ̒ĺA̐̎n_̑̐ɂp[^lB
     * </p>
     * <p>
     * is_in[1], param[1] ́A̐̏I_Ɋւēl̈ӖB
     * </p>
     *
     * @param	bas	̐
     * @param	BUdir	̐̒PʕxNg
     * @param	BLeng	̐̒
     * @param	is_in	[_̐́uvɂ邩ǂ܂ޔz (o͗p)
     * @param	param	[_̑̐ɂp[^l܂ޔz (o͗p)
     */
    private void
    isThisInBase(JgclBoundedLine3D bas, JgclVector3D BUdir, double BLeng,
		 int[] is_in, double[] param) {
	JgclVector3D dir;
	double d_tol = getToleranceForDistance();

	for (int i = 0; i < 2; i++) {
	    if (i == 0)
		dir = this.spnt().subtract(bas.spnt());
	    else
		dir = this.epnt().subtract(bas.spnt());

	    param[i] = BUdir.dotProduct(dir);
	    if ((param[i] < (0.0   - d_tol)) ||
		(param[i] > (BLeng + d_tol))) {
		is_in[i] = 0;	/* out of range */
	    } else {
		is_in[i] = 1;	/* this is in bas */
		if (true) {
		    if (param[i] < (0.0   + d_tol)) param[i] = 0.0;
		    if (param[i] > (BLeng - d_tol)) param[i] = BLeng;
		}
		param[i] /= BLeng;
	    }
	}
    }

    /**	
     * ^ꂽ񂩂A̐Ƒ̗LȐ̌_𐶐B
     *
     * @param	mate	̗LȐ
     * @param	Aparam	_̂̐ɂp[^l
     * @param	Bparam	_̗̑LȐɂp[^l
     * @return	쐬ꂽ_
     */
    private JgclIntersectionPoint3D
    toIntersectionPoint(JgclBoundedCurve3D mate, double Aparam, double Bparam) {
	JgclPoint3D crd1, crd2;
	JgclPointOnCurve3D poc1, poc2;

	crd1 = this.coordinates(Aparam);
	crd2 = mate.coordinates(Bparam);
	poc1 = new JgclPointOnCurve3D(crd1, this, Aparam, doCheckDebug);
	poc2 = new JgclPointOnCurve3D(crd2, mate, Bparam, doCheckDebug);

	crd1 = crd1.linearInterpolate(crd2, 0.5);

	return new JgclIntersectionPoint3D(crd1, poc1, poc2, doCheckDebug);
    }

    /**
     * ̐Ƒ̐̃I[o[bv߂B
     * <p>
     * ̐Ƒ̐I[o[bvȂ null ԂB
     * </p>
     * <p>
     * ̐Ƒ̐I[o[bvꍇɁA
     * needOverlap  false Ȃ΁A
     * I[o[bvԂ̒_̈ʒuɍ쐬_ suitable ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>     
     *
     * @param needOverlap	I[o[bv~ trueA_~ false
     * @param mate	̐
     * @param AUdir	̐̒PʕxNg
     * @param BUdir	̐̒PʕxNg
     * @param Aleng	̐̒
     * @param Bleng	̐̒
     * @return	I[o[bv
     * @exception JgclIndefiniteSolution I[o[bv邪AneedOverlap  false ł
     */
    private JgclCurveCurveInterference3D
    haveCommonSection(boolean needOverlap, JgclBoundedLine3D mate,
		      JgclVector3D AUdir, JgclVector3D BUdir,
		      double Aleng, double Bleng)
	 throws JgclIndefiniteSolution
    {
	JgclCurveCurveInterference3D intf;
	int[] A_inB = new int[2];
	int[] B_inA = new int[2];

	double[] pA_inA = new double[2];
	double[] pA_inB = new double[2];
	double[] pB_inA = new double[2];
	double[] pB_inB = new double[2];
	double[] Ap = new double[2];
	double[] Bp = new double[2];

	int i;

	this.isThisInBase(mate, BUdir, Bleng, A_inB, pA_inB);
	mate.isThisInBase(this, AUdir, Aleng, B_inA, pB_inA);

	if ((A_inB[0] + A_inB[1] + B_inA[0] + B_inA[1]) < 2)
	    return null;

	pA_inA[0] = 0.0; pA_inA[1] = 1.0;
	pB_inB[0] = 0.0; pB_inB[1] = 1.0;

	switch (A_inB[0] + A_inB[1] + B_inA[0] + B_inA[1]) {
	case 2:
	    i = 0;
	    if (A_inB[0] != 0) { Ap[i] = pA_inA[0]; Bp[i] = pA_inB[0]; i++; }
	    if (A_inB[1] != 0) { Ap[i] = pA_inA[1]; Bp[i] = pA_inB[1]; i++; }
	    if (B_inA[0] != 0) { Ap[i] = pB_inA[0]; Bp[i] = pB_inB[0]; i++; }
	    if (B_inA[1] != 0) { Ap[i] = pB_inA[1]; Bp[i] = pB_inB[1]; i++; }
	    break;

	case 3:
	    if (A_inB[0] != 0 && A_inB[1] != 0) {
		Ap[0] = pA_inA[0]; Bp[0] = pA_inB[0];
		Ap[1] = pA_inA[1]; Bp[1] = pA_inB[1];
	    } else {
		Ap[0] = pB_inA[0]; Bp[0] = pB_inB[0];
		Ap[1] = pB_inA[1]; Bp[1] = pB_inB[1];
	    }
	    break;

	case 4:
	    if (Aleng > Bleng) {
		Ap[0] = pA_inA[0]; Bp[0] = pA_inB[0];
		Ap[1] = pA_inA[1]; Bp[1] = pA_inB[1];
	    } else {
		Ap[0] = pB_inA[0]; Bp[0] = pB_inB[0];
		Ap[1] = pB_inA[1]; Bp[1] = pB_inB[1];
	    }
	    break;
	}

	/*
	 * overlap
	 */
	double d_tol = getToleranceForDistance();
	boolean hasWidth = true;
	boolean throwIndefinite = false;
	if ((Math.abs(Ap[0] - Ap[1]) * Aleng < d_tol) ||
	    (Math.abs(Bp[0] - Bp[1]) * Bleng < d_tol)) {
	    hasWidth = false;

	} else if (!needOverlap) {
	    /*
	     * make middle point of overlap as an intersection
	     */
	    hasWidth = false;
	    throwIndefinite = true;
	}

	if (hasWidth) {
	    JgclParameterSection sec1, sec2;

	    sec1 = new JgclParameterSection(Ap[0], Ap[1] - Ap[0]);
	    sec2 = new JgclParameterSection(Bp[0], Bp[1] - Bp[0]);
	    intf = new JgclOverlapCurve3D(this, sec1, mate, sec2, false);
	} else {
	    Ap[0] = (Ap[0] + Ap[1]) / 2.0;
	    Bp[0] = (Bp[0] + Bp[1]) / 2.0;
	    intf = toIntersectionPoint(mate, Ap[0], Bp[0]);
	    if (throwIndefinite)
		throw new JgclIndefiniteSolution(intf.toIntersectionPoint());
	}

	return intf;
    }

    /**
     * ̐Ƒ̐_ƂĂ̂ƂāǍ_߂B
     * <p>
     * ߂_ǂ炩̐̒`OĂꍇɂ́Anull ԂB
     * ̍ۂ̋e덷f́Ał́up[^lvōsȂB
     * </p>
     *
     * @param mate	̐
     * @param Alin	̐ϊ
     * @param Blin	̐ϊ
     * @return	̐Ƒ̐̌_
     * @see	#checkParameter(double)
     */
    private JgclIntersectionPoint3D getIntsWithBln(JgclBoundedLine3D mate,
						   JgclLine3D Alin, JgclLine3D Blin) {
	JgclIntersectionPoint3D ints;
	try {
	    ints = Alin.intersect1Line(Blin);	// use intersect1()
	} catch (JgclIndefiniteSolution e) {
	    throw new JgclFatal();		// Never be parallel
	}
	if (ints == null)
	    return null;

	double Aparam, Bparam;

	try {
	    JgclPointOnCurve3D poc;
	    poc = (JgclPointOnCurve3D)ints.pointOnGeometry1();
	    Aparam = this.checkParameter(poc.parameter());	// Ń`FbNׂ
	    poc = (JgclPointOnCurve3D)ints.pointOnGeometry2();
	    Bparam = mate.checkParameter(poc.parameter());	// Ń`FbNׂ
	} catch (JgclParameterOutOfRange e) {
	    return null;
	}

	return toIntersectionPoint(mate, Aparam, Bparam);
    }

    /**
     * ̐Ƒ̐Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ null ԂB
     * </p>
     * 
     * @param mate	̐
     * @param thisUdir	̐̒PʕxNg
     * @param mateUdir	̐̒PʕxNg
     * @param thisLeng	̐̒
     * @param mateLeng	̐̒
     * @return		
     * @see	#haveIntsWithLine(JgclLine3D, JgclVector3D)
     * @see	#haveCommonSection(boolean, JgclBoundedLine3D, JgclVector3D, JgclVector3D, double, double)
     * @see	#getIntsWithBln(JgclBoundedLine3D, JgclLine3D, JgclLine3D)
     */
    JgclCurveCurveInterference3D
    interfere1(JgclBoundedLine3D mate, JgclVector3D thisUdir, JgclVector3D mateUdir,
	       double thisLeng, double mateLeng) {
	JgclCurveCurveInterference3D com_sec;
	JgclIntersectionPoint3D ints;
	JgclLine3D Alin;
	JgclLine3D Blin;

	Blin = mate.toLine();
	if ((haveIntsWithLine(Blin, mateUdir)) < 0) {	// overlap?
	    try {
		return haveCommonSection(true, mate, thisUdir, mateUdir, thisLeng, mateLeng);
	    } catch (JgclIndefiniteSolution e) {
		throw new JgclFatal();
	    }
	}

	Alin = this.toLine();
	switch (mate.haveIntsWithLine(Alin, thisUdir)) {
	case -1:					// overlap?
	    try {
		return haveCommonSection(true, mate, thisUdir, mateUdir, thisLeng, mateLeng);
	    } catch (JgclIndefiniteSolution e) {
		throw new JgclFatal();
	    }
	case 0:						// parallel
	    return null;
	}

	return getIntsWithBln(mate, Alin, Blin);
    }

    /**
     * ̐Ƒ̐Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ null ԂB
     * </p>
     * 
     * @param mate	̐
     * @return		
     */
    public JgclCurveCurveInterference3D interfere1(JgclBoundedLine3D mate) {
	JgclVector3D AUdir = this.unitizedDirection();
	JgclVector3D BUdir = mate.unitizedDirection();
	double Aleng = this.length();
	double Bleng = mate.length();

	return interfere1(mate, AUdir, BUdir, Aleng, Bleng);
    }

    /**
     * ̐Ƒ̐Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̐
     * @param thisUdir	̐̒PʕxNg
     * @param mateUdir	̐̒PʕxNg
     * @param thisLeng	̐̒
     * @param mateLeng	̐̒
     * @return		̔z
     */
    JgclCurveCurveInterference3D[]
    interfere(JgclBoundedLine3D mate, JgclVector3D thisUdir, JgclVector3D mateUdir,
	      double thisLeng, double mateLeng) {
	JgclCurveCurveInterference3D sol;
	if ((sol = interfere1(mate, thisUdir, mateUdir, thisLeng, mateLeng)) == null)
	    return new JgclCurveCurveInterference3D[0];

	JgclCurveCurveInterference3D[] intf = new JgclCurveCurveInterference3D[1];
	intf[0] = sol;
	return intf;
    }

    /**
     * ̐Ƒ̐Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̐
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclBoundedLine3D mate,
					     boolean doExchange)
    {
	JgclBoundedLine3D Abln;
	JgclBoundedLine3D Bbln;
	if (!doExchange) {
	    Abln = this;
	    Bbln = mate;
	} else {
	    Abln = mate;
	    Bbln = this;
	}

	JgclVector3D AUdir = Abln.unitizedDirection();
	JgclVector3D BUdir = Bbln.unitizedDirection();
	double Aleng = Abln.length();
	double Bleng = Bbln.length();

	return Abln.interfere(Bbln, AUdir, BUdir, Aleng, Bleng);
    }

    /**
     * ^ꂽ̑ΏۂƂȂȐ̐ɕύXB
     *
     * @param sourceInterferences	̔z
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    private JgclCurveCurveInterference3D[]
    convertInterferences(JgclCurveCurveInterference3D[] sourceInterferences,
			 boolean doExchange)
    {
	Vector resultVector = new Vector();

	for (int i = 0; i < sourceInterferences.length; i++) {
	    JgclCurveCurveInterference3D intf;
	    if (!doExchange)
		intf = sourceInterferences[i].changeCurve1(this);
	    else
		intf = sourceInterferences[i].changeCurve2(this);
	    if (intf != null)
		resultVector.addElement(intf);
	}

	JgclCurveCurveInterference3D[] result =
	    new JgclCurveCurveInterference3D[resultVector.size()];
	resultVector.copyInto(result);
	return result;
    }

    /**
     * ̗LȐƑ̗LȐ (|C) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̐|CɕϊA
     * |C̃NX́u|C vs. |Cv̊Z\bh
     * {@link JgclPolyline3D#interfere(JgclPolyline3D, boolean)
     * JgclPolyline3D.interfere(JgclPolyline3D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclPolyline3D mate,
					     boolean doExchange)
    {
	return this.convertInterferences(this.toPolyline().interfere(mate, doExchange),
					 doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (xWGȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̐LaXvCȐɕϊA
     * aXvCȐ̃NX́uaXvCȐ vs. xWGȐv̊Z\bh
     * {@link JgclBsplineCurve3D#interfere(JgclPureBezierCurve3D, boolean)
     * JgclBsplineCurve3D.interfere(JgclPureBezierCurve3D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclPureBezierCurve3D mate,
					     boolean doExchange) {
	return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange),
					 doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (aXvCȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̐LaXvCȐɕϊA
     * aXvCȐ̃NX́uaXvCȐ vs. aXvCȐv̊Z\bh
     * {@link JgclBsplineCurve3D#interfere(JgclBsplineCurve3D, boolean)
     * JgclBsplineCurve3D.interfere(JgclBsplineCurve3D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclBsplineCurve3D mate,
					     boolean doExchange) {
	return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange),
					 doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (gȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. v̊Z\bh
     * {@link JgclTrimmedCurve3D#interfere(JgclBoundedLine3D, boolean)
     * JgclTrimmedCurve3D.interfere(JgclBoundedLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (gȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclTrimmedCurve3D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (ȐZOg) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. v̊Z\bh
     * {@link JgclCompositeCurveSegment3D#interfere(JgclBoundedLine3D, boolean)
     * JgclCompositeCurveSegment3D.interfere(JgclBoundedLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (ȐZOg)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurveSegment3D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (Ȑ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * Ȑ̃NX́uȐ vs. v̊Z\bh
     * {@link JgclCompositeCurve3D#interfere(JgclBoundedLine3D, boolean)
     * JgclCompositeCurve3D.interfere(JgclBoundedLine3D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (Ȑ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurve3D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		Ȑ̊̔z
     */
    public JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate) {
	return mate.interfere(this, true);
    }

    /**
     * ̐Ƒ̐̌_߂B
     * <p>
     * _݂Ȃꍇɂ null ԂB
     * </p>
     * 
     * @param mate	̐
     * @param AUdir	̐̒PʕxNg
     * @param BUdir	̐̒PʕxNg
     * @param Aleng	̐̒
     * @param Bleng	̐̒
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	I[o[bvĂ
     */
    JgclIntersectionPoint3D intersect1(JgclBoundedLine3D mate, JgclVector3D AUdir,
				       JgclVector3D BUdir, double Aleng, double Bleng)
	 throws JgclIndefiniteSolution
    {
	JgclCurveCurveInterference3D com_sec;
	JgclLine3D Alin;
	JgclLine3D Blin;

	Blin = mate.toLine();
	if ((haveIntsWithLine(Blin, BUdir)) < 0) {	// overlap?
	    if ((com_sec = haveCommonSection(false, mate, AUdir, BUdir, Aleng, Bleng)) == null)
		return null;

	    return com_sec.toIntersectionPoint();
	}

	Alin = this.toLine();
	switch (mate.haveIntsWithLine(Alin, AUdir)) {
	case -1:					// overlap?
	    if ((com_sec = haveCommonSection(false, mate, AUdir, BUdir, Aleng, Bleng)) == null)
		return null;

	    return com_sec.toIntersectionPoint();
	case 0:						// parallel
	    return null;
	}

	return getIntsWithBln(mate, Alin, Blin);
    }

    /**
     * ̐Ƒ̐̌_߂B
     * <p>
     * _݂Ȃꍇɂ null ԂB
     * </p>
     * 
     * @param mate	̐
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	I[o[bvĂ
     */
    public JgclIntersectionPoint3D intersect1(JgclBoundedLine3D mate)
	 throws JgclIndefiniteSolution
    {
	JgclCurveCurveInterference3D com_sec;
	JgclLine3D Alin;
	JgclLine3D Blin;

	JgclVector3D AUdir = this.unitizedDirection();
	JgclVector3D BUdir = mate.unitizedDirection();
	double Aleng = this.length();
	double Bleng = mate.length();

	return intersect1(mate, AUdir, BUdir, Aleng, Bleng);
    }

    /**
     * ̐̑ݔ͈͂̂ԂB
     *
     * @return	ݔ͈͂
     */
    JgclEnclosingBox3D enclosingBox() {
	double min_x, max_x, min_y, max_y, min_z, max_z;

	if (spnt().x() < epnt().x()) {
	    min_x = spnt().x();
	    max_x = epnt().x();
	} else {
	    min_x = epnt().x();
	    max_x = spnt().x();
	}
	if (spnt().y() < epnt().y()) {
	    min_y = spnt().y();
	    max_y = epnt().y();
	} else {
	    min_y = epnt().y();
	    max_y = spnt().y();
	}
	if (spnt().z() < epnt().z()) {
	    min_z = spnt().z();
	    max_z = epnt().z();
	} else {
	    min_z = epnt().z();
	    max_z = spnt().z();
	}
	return new JgclEnclosingBox3D(min_x, min_y, min_z, max_x, max_y, max_z);
    }

    /**
     * ̋ȐA^ꂽxNgɏ]ĕsړȐԂB
     *
     * @param moveVec	sړ̕Ɨʂ\xNg
     * @return		sړ̋Ȑ
     */
    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
	return new JgclBoundedLine3D(spnt.add(moveVec), epnt.add(moveVec));
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * <p>
     * LŔIȒ`ԂB
     * p[^Ԃ [0, 1] B
     * </p>
     * 
     * @return	p[^`
     */
    JgclParameterDomain getParameterDomain() {
	return new JgclParameterDomain(false, 0.0, 1.0);
    }

    /*
     * ^ꂽp[^l̐ɑ΂ėLۂԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param param	p[^l
     * @return	`Ɋۂ߂ꂽp[^l
     * @see	JgclParametricCurve#checkValidity(double)
     */
    private double checkParameter(double param) {
	checkValidity(param);
	return parameterDomain().force(param);
    }

    /**
     * ̐𔽓]ԂB
     *
     * @return	]
     */
    public JgclBoundedLine3D reverse() {
	return new JgclBoundedLine3D(this.epnt(), this.spnt());
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve3D#BOUNDED_LINE_3D JgclParametricCurve3D.BOUNDED_LINE_3D}
     */
    int type() {
	return BOUNDED_LINE_3D;
    }

    /**
     * ̋ȐA^ꂽǏWn Z ̎ɁA
     * ^ꂽpx]ȐԂB
     *
     * @param trns	ǏWn瓾ꂽWϊZq
     * @param rCos	cos(]px)
     * @param rSin	sin(]px)
     * @return		]̋Ȑ
     */
    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns,
				  double rCos, double rSin) {
	JgclPoint3D rspnt = spnt().rotateZ(trns, rCos, rSin);
	JgclPoint3D repnt = epnt().rotateZ(trns, rCos, rSin);

	return new JgclBoundedLine3D(rspnt, repnt);
    }

    /**
     * ̋Ȑ̓_ŁA^ꂽɂȂ_ԂB
     *
     * @param line	
     * @return		^ꂽɂȂ_
     */
    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint3D tSpnt = this.spnt().transformBy(reverseTransform,
						    transformationOperator,
						    transformedGeometries);
	JgclPoint3D tEpnt = this.epnt().transformBy(reverseTransform,
						    transformationOperator,
						    transformedGeometries);
	return new JgclBoundedLine3D(tSpnt, tEpnt);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tspnt");
        spnt.output(writer, indent + 2);
        writer.println(indent_tab + "\tepnt");
        epnt.output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }
}
