/*
 * Q : \NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclBoundedLine2D.java,v 1.31 2000/08/11 06:18:42 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Q : \NXB
 * <p>
 * ́A
 * n_̍Wl spnt
 * 
 * I_̍Wl epnt
 * Œ`B
 * </p>
 * <p>
 * ͔IȗLȐŁÃp[^` [0, 1] ƂȂB
 * </p>
 * <p>
 * t p[^Ƃ P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(t) = (1 - t) * spnt + t * epnt
 * </pre>
 * </p>
 *
 * @version $Revision: 1.31 $, $Date: 2000/08/11 06:18:42 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclBoundedLine2D extends JgclBoundedCurve2D {
    /**
     * n_B
     * @serial
     */
    private JgclPoint2D spnt;

    /**
     * I_B
     * @serial
     */
    private JgclPoint2D epnt;

    /**
     * ̃CX^X̃tB[hɒlݒ肷B
     * <p>
     * doCheck  true ̏ꍇA
     * spnt  epnt ̋ݐݒ肳Ă鉉Z̋̋e덷
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param spnt	n_̍Wl
     * @param epnt	I_̍Wl
     * @param doCheck	̃`FbN邩ǂ̃tO
     * @see	JgclPoint2D#identical(JgclPoint2D)
     * @see	JgclInvalidArgumentValue
     */
    private void setPoints(JgclPoint2D spnt, JgclPoint2D epnt, boolean doCheck) {
	if (doCheck && spnt.identical(epnt))
	    throw new JgclInvalidArgumentValue();

	this.spnt = spnt;
	this.epnt = epnt;
    }

    /**
     * n_ƏI_^ăIuWFNg\zB
     * <p>
     * spnt  epnt ̋ݐݒ肳Ă鉉Z̋̋e덷
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param spnt	n_
     * @param epnt	I_
     * @see	JgclPoint2D#identical(JgclPoint2D)
     * @see	JgclInvalidArgumentValue
     */
    public JgclBoundedLine2D(JgclPoint2D spnt, JgclPoint2D epnt) {
	super();
	setPoints(spnt, epnt, true);
    }

    /**
     * n_ƏI_^ăIuWFNg\zB
     * <p>
     * doCheck  true ̏ꍇA
     * spnt  epnt ̋ݐݒ肳Ă鉉Z̋̋e덷
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param spnt	n_
     * @param epnt	I_
     * @see	JgclPoint2D#identical(JgclPoint2D)
     * @see	JgclInvalidArgumentValue
     * @param doCheck	̃`FbN邩ǂ̃tO
     */
    JgclBoundedLine2D(JgclPoint2D spnt, JgclPoint2D epnt, boolean doCheck) {
	super();
	setPoints(spnt, epnt, doCheck);
    }

    /**
     * n_Ɓun_I_܂ł̃xNgv^ăIuWFNg\zB
     * <p>
     * dir ̑傫ݐݒ肳Ă鉉Z̋̋e덷
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param spnt	n_
     * @param dir	n_I_܂ł̃xNg
     * @see	JgclInvalidArgumentValue
     */
    public JgclBoundedLine2D(JgclPoint2D spnt, JgclVector2D dir) {
	super();
	setPoints(spnt, spnt.add(dir), true);
    }

    /**
     * n_Ɓun_I_܂ł̃xNgv^ăIuWFNg\zB
     * <p>
     * doCheck  true ̏ꍇA
     * dir ̑傫ݐݒ肳Ă鉉Z̋̋e덷
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param spnt	n_
     * @param dir	n_I_܂ł̃xNg
     * @param doCheck	̃`FbN邩ǂ̃tO
     * @see	JgclInvalidArgumentValue
     */
    JgclBoundedLine2D(JgclPoint2D spnt, JgclVector2D dir, boolean doCheck) {
	super();
	setPoints(spnt, spnt.add(dir), doCheck);
    }

    /**
     * ̐̎n_ԂB
     * 
     * @return	n_
     */
    public JgclPoint2D spnt() {
	return this.spnt;
    }

    /**
     * ̐̏I_ԂB
     * 
     * @return	I_
     */
    public JgclPoint2D epnt() {
	return this.epnt;
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ̑l͕ł܂ȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     * @see	JgclParameterOutOfRange
     */
    public double length(JgclParameterSection pint) {
	checkParameter(pint.start());
	checkParameter(pint.end());
        return length() * Math.abs(pint.increase());
    }

    /**
     * ̗LȐŜ̎ԏł̒ (̂) ԂB
     * 
     * @return	ȐŜ̒
     */
    public double length() {
	return this.spnt().distance(this.epnt());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint2D coordinates(double param) {
	param = checkParameter(param);
	return this.epnt().linearInterpolate(this.spnt(), param);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * 
     * @param param	p[^l
     * @return		ڃxNg
     */
    public JgclVector2D tangentVector(double param) {
	param = checkParameter(param);
	return this.epnt().subtract(this.spnt());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * ̋ȗ́A 0 łB
     * </p>
     * 
     * @param param	p[^l
     * @return		ȗ
     */
    public JgclCurveCurvature2D curvature(double param) {
	param = checkParameter(param);
	return new JgclCurveCurvature2D(0.0, JgclVector2D.zeroVector);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * 
     * @param param	p[^l
     * @return		֐
     */
    public JgclCurveDerivative2D evaluation(double param) {
	param = checkParameter(param);
	return new JgclCurveDerivative2D(coordinates(param),
					 tangentVector(param),
					 JgclVector2D.zeroVector);
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ɂ͓ٓ_݂͑Ȃ̂ƂāA 0 ̔zԂB
     * </p>
     * 
     * @return	ٓ_̔z
     */
    public JgclPointOnCurve2D[] singular() {
        return new JgclPointOnCurve2D[0];
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ɂ͕ϋȓ_݂͑Ȃ̂ƂāA 0 ̔zԂB
     * </p>
     * 
     * @return	ϋȓ_̔z
     */
    public JgclPointOnCurve2D[] inflexion() {
        return new JgclPointOnCurve2D[0];
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ւ̓e_̐́Aꂪ݂ꍇɂ́AK 1 łB
     * </p>
     * 
     * @param point	e̓_
     * @return	e_
     * @see	#project1From(JgclPoint2D)
     */
    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) {
	JgclPointOnCurve2D[] prjp;
	JgclPointOnCurve2D poc;
	double param;

	if ((poc = project1From(point)) == null)
	    return new JgclPointOnCurve2D[0];
	prjp = new JgclPointOnCurve2D[1];
	prjp[0] = poc;
	return prjp;
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ null ԂB
     * </p>
     * <p>
     * _ւ̓e_̐́Aꂪ݂ꍇɂ́AK 1 łB
     * </p>
     * 
     * @param point	e̓_
     * @return	e_
     * @see	#projectFrom(JgclPoint2D)
     */
    public JgclPointOnCurve2D project1From(JgclPoint2D point) {
	JgclPointOnCurve2D[] prjp;
	JgclPointOnCurve2D poc;
	double param;

	poc = toLine().project1From(point);
	param = poc.parameter();

	JgclPointOnCurve2D result = null;

	if (!isValid(param)) {		// Ń`FbNׂ
	    return null;
	}

	return new JgclPointOnCurve2D(this, param, doCheckDebug);
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_
     * ̋Ȑx[XƂ JgclPointOnCurve2D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * |C͏Ɍɂ̐Č̂ŁA
     * ̃\bh̓ł tol ̒l͎QƂȂB
     * </p>
     * 
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     */
    public JgclPolyline2D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol) {
	JgclPoint2D[] points = new JgclPoint2D[2];

	points[0] = new JgclPointOnCurve2D(this, pint.start(), doCheckDebug);
	points[1] = new JgclPointOnCurve2D(this, pint.end(), doCheckDebug);
	return new JgclPolyline2D(points);
    }

    /**
     * ̐Č|CԂB
     *
     * @return	̐Č|C
     */
    JgclPolyline2D toPolyline() {
	JgclPoint2D[] points = new JgclPoint2D[2];

	points[0] = this.spnt;
	points[1] = this.epnt;
	return new JgclPolyline2D(points);
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     */
    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
	return toLine().toBsplineCurve(pint);
    }

    /*
     * ̐𒼐ɕϊB
     *
     * @return	̐ϊ
     */
    public JgclLine2D toLine() {
	return new JgclLine2D(spnt(), epnt());
    }

    /**
     * ̐̐isPʉxNgԂB
     * 
     * @return	Pʉꂽis
     */
    public JgclVector2D unitizedDirection() {
	return tangentVector(0.0).unitized();
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (@)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂB
     * āA˂ JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̐Ɨ^ꂽƂ̊ԂɌ_邩ۂԂB
     * <p>
     * e덷̔fׂ͂āuvōsȂB
     * </p>
     *
     * @param lin	
     * @param ludir	̐KxNg
     * @return		0: parallel, 1: intersects, -1: overlap
     */
    private int haveIntsWithLine(JgclLine2D lin, JgclVector2D ludir) {
	double magni;
	JgclVector2D dir;
	double[] dists = new double[2];
	double d_tol = getToleranceForDistance();

	dir = this.spnt.subtract(lin.pnt());
	dists[0] = dir.zOfCrossProduct(ludir);

	dir = this.epnt.subtract(lin.pnt());
	dists[1] = dir.zOfCrossProduct(ludir);

	if (Math.abs(dists[0]) < d_tol && Math.abs(dists[1]) < d_tol)
	    return -1;
	else if (Math.abs(dists[0] - dists[1]) < d_tol)
	    return 0;
	return 1;

    }

    /*
     * ̐̒[_̐́uvɂ邩ǂ𒲂ׂB
     * <p>
     * is_in, param ̗vf́AȂƂ 2 łKvB
     * </p>
     * <p>
     * is_in[0]  0 ̏ꍇA̐̎n_͑̐̓ɂȂƂB
     * </p>
     * <p>
     * is_in[0]  1 ̏ꍇA̐̎n_͑̐̓ɂ邱ƂB
     * ̏ꍇɂ́Aparam[0] ̒ĺA̐̎n_̑̐ɂp[^lB
     * </p>
     * <p>
     * is_in[1], param[1] ́A̐̏I_Ɋւēl̈ӖB
     * </p>
     *
     * @param	bas	̐
     * @param	BUdir	̐̒PʕxNg
     * @param	BLeng	̐̒
     * @param	is_in	[_̐́uvɂ邩ǂ܂ޔz (o͗p)
     * @param	param	[_̑̐ɂp[^l܂ޔz (o͗p)
     */
    private void
    isThisInBase(JgclBoundedLine2D bas, JgclVector2D BUdir, double BLeng,
		 int[] is_in, double[] param) {
	JgclVector2D dir;
	double d_tol = getToleranceForDistance();

	for (int i = 0; i < 2; i++) {
	    if (i == 0)
		dir = this.spnt().subtract(bas.spnt());
	    else
		dir = this.epnt().subtract(bas.spnt());

	    param[i] = BUdir.dotProduct(dir);
	    if ((param[i] < (0.0   - d_tol)) ||
		(param[i] > (BLeng + d_tol))) {
		is_in[i] = 0;	/* out of range */
	    } else {
		is_in[i] = 1;	/* this is in bas */
		if (true) {
		    if (param[i] < (0.0   + d_tol)) param[i] = 0.0;
		    if (param[i] > (BLeng - d_tol)) param[i] = BLeng;
		}
		param[i] /= BLeng;
	    }
	}
    }

    /**	
     * ^ꂽ񂩂A̐Ƒ̗LȐ̌_𐶐B
     *
     * @param	mate	̗LȐ
     * @param	Aparam	_̂̐ɂp[^l
     * @param	Bparam	_̗̑LȐɂp[^l
     * @return	쐬ꂽ_
     */
    private JgclIntersectionPoint2D
    toIntersectionPoint(JgclBoundedCurve2D mate, double Aparam, double Bparam) {
	JgclPoint2D crd1, crd2;
	JgclPointOnCurve2D poc1, poc2;

	crd1 = this.coordinates(Aparam);
	crd2 = mate.coordinates(Bparam);
	poc1 = new JgclPointOnCurve2D(crd1, this, Aparam, doCheckDebug);
	poc2 = new JgclPointOnCurve2D(crd2, mate, Bparam, doCheckDebug);

	crd1 = crd1.linearInterpolate(crd2, 0.5);

	return new JgclIntersectionPoint2D(crd1, poc1, poc2, doCheckDebug);
    }

    /**
     * ̐Ƒ̐̃I[o[bv߂B
     * <p>
     * ̐Ƒ̐I[o[bvȂ null ԂB
     * </p>
     * <p>
     * ̐Ƒ̐I[o[bvꍇɁA
     * needOverlap  false Ȃ΁A
     * I[o[bvԂ̒_̈ʒuɍ쐬_ suitable ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>     
     *
     * @param needOverlap	I[o[bv~ trueA_~ false
     * @param mate	̐
     * @param AUdir	̐̒PʕxNg
     * @param BUdir	̐̒PʕxNg
     * @param Aleng	̐̒
     * @param Bleng	̐̒
     * @return	I[o[bv
     * @exception JgclIndefiniteSolution I[o[bv邪AneedOverlap  false ł
     */
    private JgclCurveCurveInterference2D
    haveCommonSection(boolean needOverlap, JgclBoundedLine2D mate,
		      JgclVector2D AUdir, JgclVector2D BUdir,
		      double Aleng, double Bleng)
	 throws JgclIndefiniteSolution
    {
	JgclCurveCurveInterference2D intf;
	int[] A_inB = new int[2];
	int[] B_inA = new int[2];

	double[] pA_inA = new double[2];
	double[] pA_inB = new double[2];
	double[] pB_inA = new double[2];
	double[] pB_inB = new double[2];
	double[] Ap = new double[2];
	double[] Bp = new double[2];

	int i;

	this.isThisInBase(mate, BUdir, Bleng, A_inB, pA_inB);
	mate.isThisInBase(this, AUdir, Aleng, B_inA, pB_inA);

	if ((A_inB[0] + A_inB[1] + B_inA[0] + B_inA[1]) < 2)
	    return null;

	pA_inA[0] = 0.0; pA_inA[1] = 1.0;
	pB_inB[0] = 0.0; pB_inB[1] = 1.0;

	switch (A_inB[0] + A_inB[1] + B_inA[0] + B_inA[1]) {
	case 2:
	    i = 0;
	    if (A_inB[0] != 0) { Ap[i] = pA_inA[0]; Bp[i] = pA_inB[0]; i++; }
	    if (A_inB[1] != 0) { Ap[i] = pA_inA[1]; Bp[i] = pA_inB[1]; i++; }
	    if (B_inA[0] != 0) { Ap[i] = pB_inA[0]; Bp[i] = pB_inB[0]; i++; }
	    if (B_inA[1] != 0) { Ap[i] = pB_inA[1]; Bp[i] = pB_inB[1]; i++; }
	    break;

	case 3:
	    if (A_inB[0] != 0 && A_inB[1] != 0) {
		Ap[0] = pA_inA[0]; Bp[0] = pA_inB[0];
		Ap[1] = pA_inA[1]; Bp[1] = pA_inB[1];
	    } else {
		Ap[0] = pB_inA[0]; Bp[0] = pB_inB[0];
		Ap[1] = pB_inA[1]; Bp[1] = pB_inB[1];
	    }
	    break;

	case 4:
	    if (Aleng > Bleng) {
		Ap[0] = pA_inA[0]; Bp[0] = pA_inB[0];
		Ap[1] = pA_inA[1]; Bp[1] = pA_inB[1];
	    } else {
		Ap[0] = pB_inA[0]; Bp[0] = pB_inB[0];
		Ap[1] = pB_inA[1]; Bp[1] = pB_inB[1];
	    }
	    break;
	}

	/*
	 * overlap
	 */
	double d_tol = getToleranceForDistance();
	boolean hasWidth = true;
	boolean throwIndefinite = false;
	if ((Math.abs(Ap[0] - Ap[1]) * Aleng < d_tol) ||
	    (Math.abs(Bp[0] - Bp[1]) * Bleng < d_tol)) {
	    hasWidth = false;

	} else if (!needOverlap) {
	    /*
	     * make middle point of overlap as an intersection
	     */
	    hasWidth = false;
	    throwIndefinite = true;
	}

	if (hasWidth) {
	    JgclParameterSection sec1, sec2;

	    sec1 = new JgclParameterSection(Ap[0], Ap[1] - Ap[0]);
	    sec2 = new JgclParameterSection(Bp[0], Bp[1] - Bp[0]);
	    intf = new JgclOverlapCurve2D(this, sec1, mate, sec2, false);
	} else {
	    Ap[0] = (Ap[0] + Ap[1]) / 2.0;
	    Bp[0] = (Bp[0] + Bp[1]) / 2.0;
	    intf = toIntersectionPoint(mate, Ap[0], Bp[0]);
	    if (throwIndefinite)
		throw new JgclIndefiniteSolution(intf.toIntersectionPoint());
	}

	return intf;
    }

    /**
     * ̐Ƒ̐_ƂĂ̂ƂāǍ_߂B
     * <p>
     * ߂_ǂ炩̐̒`OĂꍇɂ́Anull ԂB
     * ̍ۂ̋e덷f́Ał́up[^lvōsȂB
     * </p>
     *
     * @param mate	̐
     * @param Alin	̐ϊ
     * @param Blin	̐ϊ
     * @return	̐Ƒ̐̌_
     * @see	#checkParameter(double)
     */
    private JgclIntersectionPoint2D getIntsWithBln(JgclBoundedLine2D mate,
						   JgclLine2D Alin, JgclLine2D Blin) {
	JgclVector2D a2b;	/* vector from Alin.pnt to Blin.pnt */
	double crosz;		/* 3rd element of cross product */
	double Aparam, Bparam;

	a2b = Blin.pnt().subtract(Alin.pnt());
	crosz = Alin.dir().zOfCrossProduct(Blin.dir());
	try {
	    Aparam = a2b.zOfCrossProduct(Blin.dir()) / crosz;
	    Aparam = this.checkParameter(Aparam);	// Ń`FbNׂ
	    Bparam = a2b.zOfCrossProduct(Alin.dir()) / crosz;
	    Bparam = mate.checkParameter(Bparam);	// Ń`FbNׂ
	} catch (JgclParameterOutOfRange e) {
	    return null;
	}

	return toIntersectionPoint(mate, Aparam, Bparam);
    }

    /**
     * ̐Ƒ̐Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ null ԂB
     * </p>
     * 
     * @param mate	̐
     * @param thisUdir	̐̒PʕxNg
     * @param mateUdir	̐̒PʕxNg
     * @param thisLeng	̐̒
     * @param mateLeng	̐̒
     * @return		
     * @see	#haveIntsWithLine(JgclLine2D, JgclVector2D)
     * @see	#haveCommonSection(boolean, JgclBoundedLine2D, JgclVector2D, JgclVector2D, double, double)
     * @see	#getIntsWithBln(JgclBoundedLine2D, JgclLine2D, JgclLine2D)
     */
    JgclCurveCurveInterference2D
    interfere1(JgclBoundedLine2D mate, JgclVector2D thisUdir, JgclVector2D mateUdir,
	       double thisLeng, double mateLeng) {
	JgclCurveCurveInterference2D com_sec;
	JgclIntersectionPoint2D ints;
	JgclLine2D Alin;
	JgclLine2D Blin;

	Blin = mate.toLine();
	if ((haveIntsWithLine(Blin, mateUdir)) < 0) {	// overlap?
	    try {
		return haveCommonSection(true, mate, thisUdir, mateUdir, thisLeng, mateLeng);
	    } catch (JgclIndefiniteSolution e) {
		throw new JgclFatal();
	    }
	}

	Alin = this.toLine();
	switch (mate.haveIntsWithLine(Alin, thisUdir)) {
	case -1:					// overlap?
	    try {
		return haveCommonSection(true, mate, thisUdir, mateUdir, thisLeng, mateLeng);
	    } catch (JgclIndefiniteSolution e) {
		throw new JgclFatal();
	    }
	case 0:						// parallel
	    return null;
	}

	return getIntsWithBln(mate, Alin, Blin);
    }

    /**
     * ̐Ƒ̐Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ null ԂB
     * </p>
     * 
     * @param mate	̐
     * @return		
     */
    public JgclCurveCurveInterference2D interfere1(JgclBoundedLine2D mate) {
	JgclVector2D AUdir = this.unitizedDirection();
	JgclVector2D BUdir = mate.unitizedDirection();
	double Aleng = this.length();
	double Bleng = mate.length();

	return interfere1(mate, AUdir, BUdir, Aleng, Bleng);
    }

    /**
     * ̐Ƒ̐Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̐
     * @param thisUdir	̐̒PʕxNg
     * @param mateUdir	̐̒PʕxNg
     * @param thisLeng	̐̒
     * @param mateLeng	̐̒
     * @return		̔z
     */
    JgclCurveCurveInterference2D[]
    interfere(JgclBoundedLine2D mate, JgclVector2D thisUdir, JgclVector2D mateUdir,
	      double thisLeng, double mateLeng) {
	JgclCurveCurveInterference2D sol;
	if ((sol = interfere1(mate, thisUdir, mateUdir, thisLeng, mateLeng)) == null)
	    return new JgclCurveCurveInterference2D[0];

	JgclCurveCurveInterference2D[] intf = new JgclCurveCurveInterference2D[1];
	intf[0] = sol;
	return intf;
    }

    /**
     * ̐Ƒ̐Ƃ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̐
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate,
					     boolean doExchange)
    {
	JgclBoundedLine2D Abln;
	JgclBoundedLine2D Bbln;
	if (!doExchange) {
	    Abln = this;
	    Bbln = mate;
	} else {
	    Abln = mate;
	    Bbln = this;
	}

	JgclVector2D AUdir = Abln.unitizedDirection();
	JgclVector2D BUdir = Bbln.unitizedDirection();
	double Aleng = Abln.length();
	double Bleng = Bbln.length();

	return Abln.interfere(Bbln, AUdir, BUdir, Aleng, Bleng);
    }

    /**
     * ^ꂽ̑ΏۂƂȂȐ̐ɕύXB
     *
     * @param sourceInterferences	̔z
     * @param doExchange	ڐG this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    private JgclCurveCurveInterference2D[]
    convertInterferences(JgclCurveCurveInterference2D[] sourceInterferences,
			 boolean doExchange)
    {
	Vector resultVector = new Vector();

	for (int i = 0; i < sourceInterferences.length; i++) {
	    JgclCurveCurveInterference2D intf;
	    if (!doExchange)
		intf = sourceInterferences[i].changeCurve1(this);
	    else
		intf = sourceInterferences[i].changeCurve2(this);
	    if (intf != null)
		resultVector.addElement(intf);
	}

	JgclCurveCurveInterference2D[] result =
	    new JgclCurveCurveInterference2D[resultVector.size()];
	resultVector.copyInto(result);
	return result;
    }

    /**
     * ̗LȐƑ̗LȐ (|C) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̐|CɕϊA
     * |C̃NX́u|C vs. |Cv̊Z\bh
     * {@link JgclPolyline2D#interfere(JgclPolyline2D, boolean)
     * JgclPolyline2D.interfere(JgclPolyline2D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	ڐG this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate,
					     boolean doExchange)
    {
	return this.convertInterferences(this.toPolyline().interfere(mate, doExchange),
					 doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (xWGȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̐LaXvCȐɕϊA
     * aXvCȐ̃NX́uaXvCȐ vs. xWGȐv̊Z\bh
     * {@link JgclBsplineCurve2D#interfere(JgclPureBezierCurve2D, boolean)
     * JgclBsplineCurve2D.interfere(JgclPureBezierCurve2D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	ڐG this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate,
					     boolean doExchange) {
	return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange),
					 doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (aXvCȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̐LaXvCȐɕϊA
     * aXvCȐ̃NX́uaXvCȐ vs. aXvCȐv̊Z\bh
     * {@link JgclBsplineCurve2D#interfere(JgclBsplineCurve2D, boolean)
     * JgclBsplineCurve2D.interfere(JgclBsplineCurve2D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	ڐG this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate,
					     boolean doExchange) {
	return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange),
					 doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (gȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. v̊Z\bh
     * {@link JgclTrimmedCurve2D#interfere(JgclBoundedLine2D, boolean)
     * JgclTrimmedCurve2D.interfere(JgclBoundedLine2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (gȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (ȐZOg) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. v̊Z\bh
     * {@link JgclCompositeCurveSegment2D#interfere(JgclBoundedLine2D, boolean)
     * JgclCompositeCurveSegment2D.interfere(JgclBoundedLine2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (ȐZOg)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (Ȑ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * Ȑ̃NX́uȐ vs. v̊Z\bh
     * {@link JgclCompositeCurve2D#interfere(JgclBoundedLine2D, boolean)
     * JgclCompositeCurve2D.interfere(JgclBoundedLine2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (Ȑ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		Ȑ̊̔z
     */
    public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate) {
	return mate.interfere(this, true);
    }

    /**
     * ̐Ƒ̐̌_߂B
     * <p>
     * _݂Ȃꍇɂ null ԂB
     * </p>
     * 
     * @param mate	̐
     * @param AUdir	̐̒PʕxNg
     * @param BUdir	̐̒PʕxNg
     * @param Aleng	̐̒
     * @param Bleng	̐̒
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	I[o[bvĂ
     */
    JgclIntersectionPoint2D intersect1(JgclBoundedLine2D mate, JgclVector2D AUdir,
				       JgclVector2D BUdir, double Aleng, double Bleng)
	 throws JgclIndefiniteSolution
    {
	JgclCurveCurveInterference2D com_sec;
	JgclLine2D Alin;
	JgclLine2D Blin;

	Blin = mate.toLine();
	if ((haveIntsWithLine(Blin, BUdir)) < 0) {	// overlap?
	    if ((com_sec = haveCommonSection(false, mate, AUdir, BUdir, Aleng, Bleng)) == null)
		return null;

	    return com_sec.toIntersectionPoint();
	}

	Alin = this.toLine();
	switch (mate.haveIntsWithLine(Alin, AUdir)) {
	case -1:					// overlap?
	    if ((com_sec = haveCommonSection(false, mate, AUdir, BUdir, Aleng, Bleng)) == null)
		return null;

	    return com_sec.toIntersectionPoint();
	case 0:						// parallel
	    return null;
	}

	return getIntsWithBln(mate, Alin, Blin);
    }

    /**
     * ̐Ƒ̐̌_߂B
     * <p>
     * _݂Ȃꍇɂ null ԂB
     * </p>
     * 
     * @param mate	̐
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	I[o[bvĂ
     */
    public JgclIntersectionPoint2D intersect1(JgclBoundedLine2D mate)
	 throws JgclIndefiniteSolution
    {
	JgclCurveCurveInterference2D com_sec;
	JgclLine2D Alin;
	JgclLine2D Blin;

	JgclVector2D AUdir = this.unitizedDirection();
	JgclVector2D BUdir = mate.unitizedDirection();
	double Aleng = this.length();
	double Bleng = mate.length();

	return intersect1(mate, AUdir, BUdir, Aleng, Bleng);
    }

    /**
     * ̐Ƒ̒̌_߂B
     * <p>
     * ̃\bhł́Athis  bounded ł͂Ȃ infinite  line ƌȂA
     * mate Ƃ̌_߂B
     * _ƂĕԂ JgclIntersectionPoint2D  pointOnCurve1  basisCurve ɂ
     * this ł͂ȂAthis ϊ JgclLine2D ݒ肳B
     * sȏꍇɂ null ԂA
     * dĂꍇɂ JgclIndefiniteSolution 𓊂B
     * </p>
     *
     * @param mate	̒
     * @return	_
     * @exception	JgclIndefiniteSolution	dĂ
     */
    public JgclIntersectionPoint2D intersect1AsInfiniteLine(JgclLine2D mate)
	 throws JgclIndefiniteSolution
    {
	boolean overlap;	

	switch (this.haveIntsWithLine(mate, mate.dir().unitized())) {
	case 0:		// parallel
	    return null;
	case (-1):	// overlap
	    overlap = true;
	    break;
	default:	// intersect
	    overlap = false;
	    break;
	}

	JgclLine2D lineA = this.toLine();
	JgclLine2D lineB = mate;
	double paramA;
	double paramB;

	if (overlap == false) {
	    JgclVector2D a2b = lineB.pnt().subtract(lineA.pnt());
	    double crosz = lineA.dir().zOfCrossProduct(lineB.dir());
	    paramA = a2b.zOfCrossProduct(lineB.dir()) / crosz;
	    paramB = a2b.zOfCrossProduct(lineA.dir()) / crosz;
	} else {
	    paramA = 0.0;
	    paramB = lineB.project1From(lineA.coordinates(paramA)).parameter();
	}

	JgclIntersectionPoint2D intersection =
	    new JgclIntersectionPoint2D(lineA, paramA,
					lineB, paramB, doCheckDebug);

	if (overlap == true)
	    throw new JgclIndefiniteSolution("Two curves overlap.", intersection);

	return intersection;
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂B
     * <p>
     * ʂƂē Bspline Ȑ͂̃|C̃ItZbgȐɌɍČB
     * āÃ\bh̓ł tol ̒l͎QƂȂB
     * </p>
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     */
    public JgclBsplineCurve2D
        offsetByBsplineCurve(JgclParameterSection pint,
			     double magni,
                             int side,
                             JgclToleranceForDistance tol)
    {
	return toLine().offsetByBsplineCurve(pint, magni, side, tol);
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎLȐ߂B
     * <p>
     * ʂƂēLȐ͂̃|C̃ItZbgȐɌɍČB
     * āÃ\bh̓ł tol ̒l͎QƂȂB
     * </p>
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎLȐ
     * @see	JgclWhichSide
     */
    public JgclBoundedCurve2D
        offsetByBoundedCurve(JgclParameterSection pint,
			     double magni,
                             int side,
                             JgclToleranceForDistance tol)
    {
	JgclVector2D lineDirection = this.tangentVector(0.0);
	JgclVector2D offsetVector;
	if (side == JgclWhichSide.RIGHT)
	    offsetVector = JgclVector2D.of(lineDirection.y(), - lineDirection.x());
	else
	    offsetVector = JgclVector2D.of(- lineDirection.y(), lineDirection.x());
	offsetVector = offsetVector.unitized().multiply(magni);
	if (pint.increase() < 0.0)
	    offsetVector = offsetVector.reverse();

	return new JgclBoundedLine2D(this.coordinates(pint.start()).add(offsetVector),
				     this.coordinates(pint.end()).add(offsetVector));
    }

    /**
     * ̐̎w̋ԂƁA̋Ȑ̎w̋ԂɂtBbg߂B
     * <p>
     * tBbg݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     *
     * @param pint1	̋Ȑ̃p[^
     * @param side1	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param mate	̋Ȑ
     * @param pint2	̋Ȑ̃p[^
     * @param side2	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param radius	tBbga
     * @param doExchange	tBbg point1/2 邩ǂ
     * @return		tBbg̔z
     * @exception JgclIndefiniteSolution	s
     * @see	JgclWhichSide
     */
    JgclFilletObject2D[]
	doFillet(JgclParameterSection pint1, int side1, JgclParametricCurve2D mate,
		 JgclParameterSection pint2, int side2, double radius,
		 boolean doExchange)
	throws JgclIndefiniteSolution
    {
	JgclLine2D lin = toLine();
	JgclFilletObject2D[] flts;
	boolean indefinite = false;
	try {
	    flts = lin.fillet(pint1, side1, mate, pint2, side2, radius);
	} catch (JgclIndefiniteSolution e) {
	    flts = new JgclFilletObject2D[1];
	    flts[0] = (JgclFilletObject2D)e.suitable();
	    indefinite = true;
	}
	JgclPointOnCurve2D poc1;
	for (int i = 0; i < flts.length; i++) {
	    poc1 = new JgclPointOnCurve2D(this, flts[i].pointOnCurve1().parameter(), doCheckDebug);
	    if (!doExchange)
		flts[i] = new JgclFilletObject2D(radius, flts[i].center(), poc1, flts[i].pointOnCurve2());
	    else
		flts[i] = new JgclFilletObject2D(radius, flts[i].center(), flts[i].pointOnCurve2(), poc1);
	}
	if (indefinite)
	    throw new JgclIndefiniteSolution(flts[0]);
	return flts;
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʐڐ߂B
     * <p>
     * ʐڐ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     *
     * @param mate	̋Ȑ
     * @return		ʐڐ̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʖ@߂B
     * <p>
     * ʖ@݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʖ@̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonNormal2D[]	commonNormal(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̐̑ݔ͈͂`ԂB
     *
     * @return	ݔ͈͂`
     */
    JgclEnclosingBox2D enclosingBox() {
	double min_x, max_x, min_y, max_y;

	if (spnt().x() < epnt().x()) {
	    min_x = spnt().x();
	    max_x = epnt().x();
	} else {
	    min_x = epnt().x();
	    max_x = spnt().x();
	}
	if (spnt().y() < epnt().y()) {
	    min_y = spnt().y();
	    max_y = epnt().y();
	} else {
	    min_y = epnt().y();
	    max_y = spnt().y();
	}
	return new JgclEnclosingBox2D(min_x, min_y, max_x, max_y);
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * <p>
     * LŔIȒ`ԂB
     * p[^Ԃ [0, 1] B
     * </p>
     * 
     * @return	p[^`
     */
    JgclParameterDomain getParameterDomain() {
	return new JgclParameterDomain(false, 0.0, 1.0);
    }

    /*
     * ^ꂽp[^l̐ɑ΂ėLۂԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param param	p[^l
     * @return	`Ɋۂ߂ꂽp[^l
     * @see	JgclParametricCurve#checkValidity(double)
     */
    private double checkParameter(double param) {
	checkValidity(param);
	return parameterDomain().force(param);
    }

    /**
     * ̐𔽓]ԂB
     *
     * @return	]
     */
    public JgclBoundedLine2D reverse() {
	return new JgclBoundedLine2D(this.epnt(), this.spnt());
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve2D#BOUNDED_LINE_2D JgclParametricCurve2D.BOUNDED_LINE_2D}
     */
    int type() {
	return BOUNDED_LINE_2D;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint2D tSpnt = this.spnt().transformBy(reverseTransform,
						    transformationOperator,
						    transformedGeometries);
	JgclPoint2D tEpnt = this.epnt().transformBy(reverseTransform,
						    transformationOperator,
						    transformedGeometries);
	return new JgclBoundedLine2D(tSpnt, tEpnt);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tspnt");
        spnt.output(writer, indent + 2);
        writer.println(indent_tab + "\tepnt");
        epnt.output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }
}
