/*
 * ߎ(Approximation)ꂽBsplineȐ𐶐邽߂̒ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclApproximation.java,v 1.5 2000/05/25 13:11:57 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * ߎ(Approximation)ꂽBsplineȐ𐶐邽߂̒ۃNX
 *
 * @version $Revision: 1.5 $, $Date: 2000/05/25 13:11:57 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclApproximation {
    protected static boolean debug = false;

    /*
     * `ۂ\tO
     */
    protected boolean isClosed;

    /**
     * ߎ_̐
     */
    protected int nPoints;

    /**
     * ߎ_̃p[^
     * J`̏ꍇAnPoints̔zB
     * `̏ꍇA(nPoints+1)̔zB
     */
    protected double[] params;

    /**
     * 
     */
    protected static final int degree = 3;

    /**
     * IuWFNg\z
     *
     * @param nPoints	_̌
     * @param params	p[^
     * @param isClosed	`ǂ
     */
    protected JgclApproximation(int nPoints, double[] params, boolean isClosed) {
	// _̐Ȃ
	if (nPoints < 2 || (isClosed && nPoints < 3)) {
	    throw new JgclInvalidArgumentValue();
	}

	// z̐ĂȂ
	if ((!isClosed && nPoints != params.length) ||
	    (isClosed && (nPoints + 1) != params.length))
	    throw new JgclInvalidArgumentValue();

	this.nPoints = nPoints;
	this.params = params;
	this.isClosed = isClosed;
    }

    // 
    // ȉ͋e덷^ċߎꍇɕKvȏ
    // gh2aprcBsc3_Rev2, gh2aprcCBsc3_Rev2 (in gh2aprcBscR2.c) ڐA
    //

    /**
     * ZOg̐̎蓾ŏlԂ
     *
     * @param isClosed	`ۂ\tO
     * @param degree	
     * @return	ZOg̐̎蓾ŏl
     */
    static int minSegmentNumber(boolean isClosed, int degree) {
	if (isClosed) {
	    /*
	     * if closed curve is desired, nseg should be greater
	     * than the degree of curve
	     */
	    return degree + 1;
	} else {
	    return 1;
	}
    }

    /**
     * ZOg̐̎蓾ŏlԂ
     *
     * @return	ZOg̐̎蓾ŏl
     */
    protected int minSegmentNumber() {
	return minSegmentNumber(isClosed, degree);
    }

    /**
     * ZOg̐̎蓾őlԂ
     *
     * @param isClosed	`ۂ\tO
     * @param degree	
     * @return	ZOg̐̎蓾ől
     */
    static int maxSegmentNumber(int nPoints, boolean isClosed, int degree) {
	if (isClosed) {
	    return nPoints;
	} else {
	    return nPoints - degree;
	}
    }

    /**
     * ZOg̐̎蓾őlԂ
     *
     * @return	ZOg̐̎蓾ől
     */
    protected int maxSegmentNumber() {
	return maxSegmentNumber(nPoints, isClosed, degree);
    }

    private int nseg_numer = 1;
    private int nseg_denom = 2;

    /**
     * ZOg̐̏lZo
     *
     * @return	ZOg̐̏l
     */
    protected int initSegmentNumber() {
	nseg_numer = 1;
	nseg_denom = 2;

	int nseg = (nPoints * nseg_numer) / nseg_denom;

	int min_nseg = minSegmentNumber();
	if (nseg < min_nseg)
	    nseg = min_nseg;

	if (nseg > maxSegmentNumber())
	    return -1;		// nPoints is too few

	return nseg;
    }

    /*
     * 󋵂ɉāAɎZOg߂
     *
     * @param nsegs	܂łɎZOg̔z
     *			юɎZOg(nsegIԖڂɃZbg)
     * @param nsegI	܂łɎZOg̐
     * @param is_tolerated	Őߎe덷𖞂ǂ?
     *				<code>true</code>ȂΎ̃ZOg炷B
     *				<code>false</code>ȂΑ₷B
     * @return		<code>true</code>ȂΎ̃ZOg͂܂ĂȂB
     *			<code>false</code>ȂΎ̃ZOg͊ɎĂB
     */
    protected boolean reNewSegmentNumber(int[] nsegs, int nsegI, boolean is_tolerated) {
	if (debug)
	    System.err.println("// nseg = " + nsegs[nsegI] + ", tolerated = " + is_tolerated);

	/*
	 * if current curve is tolerated, decrease segments.
	 * otherwise, increase segments.
	 */
	nseg_denom *=  2;
	nseg_numer *=  2;
	if (is_tolerated)
	    nseg_numer--;
	else
	    nseg_numer++;

	nsegs[++nsegI] = (nPoints * nseg_numer) / nseg_denom;

	/*
	 * compare nseg with the maximum value
	 */
	int min_nseg = minSegmentNumber();
	int max_nseg = maxSegmentNumber();

	if (max_nseg < min_nseg) max_nseg = min_nseg;

	if (nsegs[nsegI] < min_nseg) nsegs[nsegI] = min_nseg;
	if (nsegs[nsegI] > max_nseg) nsegs[nsegI] = max_nseg;

  	/*
  	 * if nseg is same as previous, stop the approaching
  	 */
  	for (int i = 0; i < nsegI; i++) {
  	    if (nsegs[i] == nsegs[nsegI])
		return false;
  	}
	return true;
    }

    /**
     * ZOgmbg
     */
    protected boolean compKnots(double sp, double ep, int nseg,
				int lower, int upper,
				double curvatures[],
				double sorted_curvatures[],
				double[] knots)
    {
	double threshold;
	int i, k;

	if (nseg == 1) {
	    knots[0] = sp;
	    knots[1] = ep;
	} else {
	    if ((k = upper - (nseg - 2)) < lower) {
		if (debug)
		    System.err.println("nseg is too large\n");
		return false;
	    }

	    threshold = sorted_curvatures[k];

	    if (debug)
		System.err.println("threshold : " + threshold);

	    k = 0;
	    knots[k++] = sp;
	    for (i = lower; i <= upper; i++) {
		if (!(curvatures[i] < threshold) && k < nseg)
		    knots[k++] = params[i];
	    }
	    knots[k] = ep;

	    if (nseg != k) {
		if (debug)
		    System.err.println("something wrong\n");
		return false;
	    }
	}

	return true;
    }

    /**
     * e덷𖞂ǂ𔻒肷
     *
     * @param tol	e덷
     * @param res	c̔z
     * @return		e덷𖞂ǂ
     */
    protected boolean tolerated(double tol, double res[]) {
	int i;

	if (debug) {
	    double max_r;
	    int max_i;

	    max_r = res[0];
	    max_i = 0;
	    for (i = 0; i < nPoints; i++) {
		if (res[i] > max_r) {
		    max_r = res[i];
		    max_i = i;
		}
	    }

	    System.err.println("max res : " + max_r + " [" + max_i + "]");
	}

	for (i = 0; i < nPoints; i++) {
	    if (res[i] > tol)
		return false;
	}

	return true;
    }

    protected static final int MARGIN = 4;

    // 
    // ȉ̓ZOg(mbg)^ċߎꍇɕKvȏ
    // gh2aprxBsc3, gh2aprxCBsc3 (in gh2aprxBsc.c) ڐA
    // 

    /*
     * mbg𓾂
     *
     * @return	mbg
     */
    private double[] getKnotArray(int uik, double[] orig, int nSegments) {
	double[] knots = new double[uik];
	if (isClosed) {
	    int i,j;

	    for (i = (this.degree - 1), j = (nSegments - 1); i >= 0; i--, j--) {
		knots[i] = knots[i+1] - (orig[j+1] - orig[j]);
	    }

	    for (i = (this.degree + 1), j = 1; j < (nSegments + 1); i++, j++) {
		knots[i] = orig[j];
	    }

	    for (j = 0; j < this.degree; i++, j++) {
		knots[i] = knots[i-1] + (orig[j+1] - orig[j]);
	    }
	} else {
	    for (int i = 0; i < knots.length; i++) {
		knots[i] = orig[i];
	    }
	}

	return knots;
    }

    /*
     * mbg̑dx𓾂
     *
     * @return	mbg̑dx
     */
    private int[] getKnotMultiplicities(int length) {
	int[] knotMultiplicities = new int[length];
	for (int i = 0; i < knotMultiplicities.length; i++) {
	    knotMultiplicities[i] = 1;
	}

	if (!this.isClosed) {
	    knotMultiplicities[0] = knotMultiplicities[length - 1] = this.degree + 1;
	}
	return knotMultiplicities;
    }

    /**
     * Bsplinẽmbg𓾂
     *
     * @param nsegs	ZOg
     * @param knots	mbg̒l
     * @return		Bsplinẽmbg
     * @see JgclBsplineKnot
     */
    protected JgclBsplineKnot getKnotData(int nsegs, double[] knots) {
	int uicp, uik;
	if (isClosed) {
	    uicp = nsegs;
	    uik  = (2 * degree) + nsegs + 1;
	} else {
	    uicp = nsegs + degree;
	    uik  = nsegs + 1;
	}

	knots = getKnotArray(uik, knots, nsegs);

	if (debug) {
	    for (int i = 0; i < knots.length; i++) {
		System.err.println("knots[" + i + "] = " +
			       knots[i]);
	    }
	}

	// mbg̑dx
	int[] knotMultiplicities = getKnotMultiplicities(knots.length);

	if (debug) {
	    for (int i = 0; i < knotMultiplicities.length; i++) {
		System.err.println("knotMultiplicities[" + i + "] = " +
				   knotMultiplicities[i]);
	    }
	}

	// get BsplineKnot
	return new JgclBsplineKnot(degree, JgclKnotType.UNSPECIFIED,
				   isClosed, uik, knotMultiplicities,
				   knots, uicp, JgclGeometry.doCheckDebug);
    }

    /**
     * ߎvẐ߂̃RrAs߂
     *
     * @param knotData	Bsplinẽmbg
     * @return    ߎvẐ߂̃RrAs
     * @see JgclBsplineKnot
     * @see JgclMatrix
     */
    protected JgclMatrix getDesignMatrix(JgclBsplineKnot knotData) {
	int uicp = knotData.nControlPoints();
	int nseg = knotData.nSegments();
	int npnts = nPoints;
	JgclMatrix designMatrix = new JgclMatrix(npnts, uicp);
	double[] bcoef = new double[degree + 1];

	if (debug)
	    System.err.println("<start getDesignMatrix()>");

  	for (int i = 0; i < npnts; i++) {
	    int cseg = knotData.evaluateBsplineFunction(params[i], bcoef);

	    if (this.isClosed) {
		// Ăꍇ
		int j, m;
		for (j = 0; j < cseg; j++) {
		    designMatrix.setElementAt(i, j, 0.0);
		}

		//for (int l = 0; l < degree; l++, j++) {
		for (int l = 0; l <= degree; l++, j++) {
		    m = j % uicp;
		    designMatrix.setElementAt(i, m, bcoef[l]);
		}
	    
		for (; j < uicp; j++) {
		    designMatrix.setElementAt(i, j, 0.0);
		}
	    } else {
		// JĂꍇ
		int j, k;
		for (j = 0, k = 0; j < cseg; j++, k++) {
		    designMatrix.setElementAt(i, k, 0.0);
		}

		for (int l = 0; l <= degree; l++, j++, k++) {
		    designMatrix.setElementAt(i, k, bcoef[l]);
		}
	    
		for (; j < uicp; j++, k++) {
		    designMatrix.setElementAt(i, k, 0.0);
		}
	    }
	}

	if (debug) {
	    for (int i = 0; i < designMatrix.getRowSize(); i++) {
		System.err.print("<" + designMatrix.getElementAt(i, 0)); 
		for (int j = 1; j < designMatrix.getColumnSize(); j++) {
		    System.err.print(", " + designMatrix.getElementAt(i, j));
		}
		System.err.println(">");
	    }
	}

  	return designMatrix;
    }
}

// end of file
