/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclUtil;
import jp.go.ipa.jgcl.JgclVector;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclZeroLength;

public abstract class JgclVector3D
extends JgclVector {
    public static final JgclVector3D zeroVector = new JgclLiteralVector3D(0.0, 0.0, 0.0);
    public static final JgclVector3D xUnitVector = new JgclLiteralVector3D(1.0, 0.0, 0.0, true);
    public static final JgclVector3D yUnitVector = new JgclLiteralVector3D(0.0, 1.0, 0.0, true);
    public static final JgclVector3D zUnitVector = new JgclLiteralVector3D(0.0, 0.0, 1.0, true);
    private JgclVector3D unitized;

    protected JgclVector3D() {
        this.unitized = null;
    }

    protected JgclVector3D(boolean confirmedAsUnitized) {
        this.unitized = confirmedAsUnitized ? this : null;
    }

    public static JgclVector3D zeroVector() {
        return zeroVector;
    }

    public static JgclVector3D xUnitVector() {
        return xUnitVector;
    }

    public static JgclVector3D yUnitVector() {
        return yUnitVector;
    }

    public static JgclVector3D zUnitVector() {
        return zUnitVector;
    }

    public int dimension() {
        return 3;
    }

    public boolean is3D() {
        return true;
    }

    public abstract double x();

    public abstract double y();

    public abstract double z();

    public JgclVector3D unitized() {
        if (this.unitized != null) {
            return this.unitized;
        }
        double leng = this.length();
        if (!JgclUtil.isDividable(JgclMath.maxOf3(this.x(), this.y(), this.z()), leng)) {
            this.unitized = zeroVector;
            return this.unitized;
        }
        this.unitized = new JgclLiteralVector3D(this.x() / leng, this.y() / leng, this.z() / leng, true);
        return this.unitized;
    }

    public JgclVector3D reverse() {
        return new JgclLiteralVector3D(-this.x(), -this.y(), -this.z());
    }

    public JgclVector3D verticalVector() {
        return this.crossProduct(this.parallelDirection(yUnitVector) ? zUnitVector : yUnitVector);
    }

    public double dotProduct(JgclVector3D mate) {
        return this.x() * mate.x() + this.y() * mate.y() + this.z() * mate.z();
    }

    public JgclVector3D crossProduct(JgclVector3D mate) {
        return new JgclLiteralVector3D(this.y() * mate.z() - this.z() * mate.y(), this.z() * mate.x() - this.x() * mate.z(), this.x() * mate.y() - this.y() * mate.x());
    }

    public JgclVector3D add(JgclVector3D mate) {
        return new JgclLiteralVector3D(this.x() + mate.x(), this.y() + mate.y(), this.z() + mate.z());
    }

    public JgclVector3D subtract(JgclVector3D mate) {
        return new JgclLiteralVector3D(this.x() - mate.x(), this.y() - mate.y(), this.z() - mate.z());
    }

    public JgclVector3D multiply(double scale) {
        return new JgclLiteralVector3D(this.x() * scale, this.y() * scale, this.z() * scale);
    }

    public JgclVector3D divide(double scale) {
        return new JgclLiteralVector3D(this.x() / scale, this.y() / scale, this.z() / scale);
    }

    public boolean identical(JgclVector3D mate) {
        double zv;
        double yv;
        double dTol2 = this.getToleranceForDistance2();
        double xv = this.x() - mate.x();
        return xv * xv + (yv = this.y() - mate.y()) * yv + (zv = this.z() - mate.z()) * zv < dTol2;
    }

    private boolean identicalDirection(JgclVector3D mate, boolean allowReversed) {
        boolean result;
        double aTol = this.getToleranceForAngle();
        double dTol2 = this.getToleranceForDistance2();
        if (this.norm() < dTol2 || mate.norm() < dTol2) {
            result = true;
        } else {
            double crossProd;
            double dotProd = this.dotProduct(mate);
            if (allowReversed) {
                dotProd = Math.abs(dotProd);
            }
            result = Math.abs(Math.atan2(crossProd = this.crossProduct(mate).length(), dotProd)) < aTol;
        }
        return result;
    }

    public boolean identicalDirection(JgclVector3D mate) {
        return this.identicalDirection(mate, false);
    }

    public boolean parallelDirection(JgclVector3D mate) {
        return this.identicalDirection(mate, true);
    }

    public double norm() {
        double xv = this.x();
        double yv = this.y();
        double zv = this.z();
        return xv * xv + yv * yv + zv * zv;
    }

    JgclVector3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        JgclVector3D lvec = trns.toLocal(this);
        double x = rCos * lvec.x() - rSin * lvec.y();
        double y = rSin * lvec.x() + rCos * lvec.y();
        double z = lvec.z();
        JgclLiteralVector3D rvec = new JgclLiteralVector3D(x, y, z);
        return trns.toEnclosed(rvec);
    }

    public JgclVector3D project(JgclVector3D dNorm) {
        JgclVector3D uNorm = dNorm.unitized();
        double d = uNorm.dotProduct(this);
        return this.subtract(uNorm.multiply(d));
    }

    JgclVector2D to2D() {
        return new JgclLiteralVector2D(this.x(), this.y());
    }

    JgclVector2D to2D(JgclCartesianTransformationOperator3D transform) {
        return transform.toLocal(this).to2D();
    }

    public JgclPoint3D toPoint3D() {
        return new JgclCartesianPoint3D(this.x(), this.y(), this.z());
    }

    public static JgclPoint3D[] toPoint3D(JgclVector3D[] vecs) {
        JgclPoint3D[] pnts = new JgclPoint3D[vecs.length];
        int i = 0;
        while (i < vecs.length) {
            pnts[i] = vecs[i].toPoint3D();
            ++i;
        }
        return pnts;
    }

    public double[] toDoubleArray() {
        double[] array = new double[]{this.x(), this.y(), this.z()};
        return array;
    }

    public double angleWith(JgclVector3D mate, JgclVector3D norm) {
        JgclVector3D crsUnitVec;
        JgclVector3D mateUnitVec;
        JgclVector3D thisUnitVec;
        try {
            thisUnitVec = this.unitized();
            mateUnitVec = mate.unitized();
        }
        catch (JgclZeroLength jgclZeroLength) {
            return 0.0;
        }
        double dot = thisUnitVec.dotProduct(mateUnitVec);
        if (dot > 1.0) {
            dot = 1.0;
        }
        if (dot < -1.0) {
            dot = -1.0;
        }
        double theta = Math.acos(dot);
        JgclVector3D crsVec = thisUnitVec.crossProduct(mateUnitVec);
        try {
            crsUnitVec = crsVec.unitized();
        }
        catch (JgclZeroLength jgclZeroLength) {
            return dot < 0.0 ? Math.PI : 0.0;
        }
        if (crsUnitVec.dotProduct(norm) < 0.0) {
            theta = Math.PI * 2 - theta;
        }
        return theta;
    }

    protected abstract JgclVector3D doTransformBy(boolean var1, JgclCartesianTransformationOperator3D var2, Hashtable var3);

    public synchronized JgclVector3D transformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        if (transformedGeometries == null) {
            return this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclVector3D transformed = (JgclVector3D)transformedGeometries.get(this);
        if (transformed == null) {
            transformed = this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
            transformedGeometries.put(this, transformed);
        }
        return transformed;
    }

    public synchronized JgclVector3D transformBy(JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(false, transformationOperator, transformedGeometries);
    }

    public synchronized JgclVector3D reverseTransformBy(JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(true, transformationOperator, transformedGeometries);
    }

    public static JgclLiteralVector3D of(double x, double y, double z) {
        return new JgclLiteralVector3D(x, y, z);
    }

    public static JgclLiteralVector3D of(double[] components) {
        return new JgclLiteralVector3D(components);
    }
}

