/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclFreeformCurveWithControlPoints3D;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;

class JgclToParameterSpaceOfSurface3D {
    private static final int MYDEF_UIP = 21;
    private static final double MYDEF_PAR_BIAS = 0.1;
    private static final double MYDEF_HYP_BIAS = 0.1;
    private JgclElementarySurface3D surface;
    private JgclCartesianTransformationOperator3D trns;

    private JgclToParameterSpaceOfSurface3D(JgclElementarySurface3D surface) {
        this.surface = surface;
        this.trns = new JgclCartesianTransformationOperator3D(surface.position(), 1.0);
    }

    private JgclPoint2D[] to2DControlPointsOfPlane(JgclFreeformCurveWithControlPoints3D ffc) {
        int npnts = ffc.nControlPoints();
        JgclPoint2D[] pnts2D = new JgclPoint2D[npnts];
        int i = 0;
        while (i < npnts) {
            pnts2D[i] = ffc.controlPointAt(i).to2D(this.trns);
            ++i;
        }
        return pnts2D;
    }

    private JgclParametricCurve2D convertCurvePlane(JgclParametricCurve3D curve) {
        switch (curve.type()) {
            case 1: {
                JgclLine3D lin = (JgclLine3D)curve;
                return lin.toLocal2D(this.trns);
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                JgclConic3D cnc = (JgclConic3D)curve;
                return cnc.toLocal2D(this.trns);
            }
            case 20: {
                JgclPolyline3D pol = (JgclPolyline3D)curve;
                int npnts = pol.nPoints();
                JgclPoint2D[] pnts2D = new JgclPoint2D[npnts];
                int i = 0;
                while (i < npnts) {
                    pnts2D[i] = pol.pointAt(i).to2D(this.trns);
                    ++i;
                }
                return new JgclPolyline2D(pnts2D, pol.closed());
            }
            case 22: {
                JgclPureBezierCurve3D bzc = (JgclPureBezierCurve3D)curve;
                return new JgclPureBezierCurve2D(this.to2DControlPointsOfPlane(bzc), bzc.weights());
            }
            case 21: {
                JgclBsplineCurve3D bsc = (JgclBsplineCurve3D)curve;
                return new JgclBsplineCurve2D(bsc.knotData(), this.to2DControlPointsOfPlane(bsc), bsc.weights());
            }
        }
        throw new JgclNotSupported();
    }

    private JgclPoint3D[] transformCirEllPol(JgclConic3D cirell) {
        JgclPoint3D[] pnts = new JgclPoint3D[21];
        double step = 0.3141592653589793;
        int i = 1;
        while (i < 21) {
            double t = (double)i * step;
            pnts[i] = cirell.coordinates(t);
            ++i;
        }
        pnts[0] = pnts[20];
        return pnts;
    }

    private JgclPoint3D[] transformParPol(JgclParabola3D par) {
        JgclPoint3D[] pnts = new JgclPoint3D[21];
        int half_uip = 10;
        int i = 1;
        while (i <= half_uip) {
            double t = 0.1 * (double)i * (double)i;
            pnts[half_uip + i] = par.coordinates(t);
            pnts[half_uip - i] = par.coordinates(-t);
            ++i;
        }
        pnts[half_uip] = par.position().location();
        return pnts;
    }

    private JgclPoint3D[] transformHypPol(JgclHyperbola3D hyp) {
        JgclPoint3D[] pnts = new JgclPoint3D[21];
        int half_uip = 10;
        int i = 1;
        while (i <= half_uip) {
            double t = 0.1 * (double)i * (double)i;
            pnts[half_uip + i] = hyp.coordinates(t);
            pnts[half_uip - i] = hyp.coordinates(-t);
            ++i;
        }
        pnts[half_uip] = hyp.position().location().add(hyp.position().x().multiply(hyp.xRadius()));
        return pnts;
    }

    /*
     * Unable to fully structure code
     */
    private int getNeighborNonPoleIdx(boolean[] is_pole, int ith, boolean inc) {
        block4: {
            uip = is_pole.length;
            src = ith;
            if (!inc) ** GOTO lbl14
            while (is_pole[ith]) {
                if (++ith >= uip) {
                    ith = 0;
                }
                if (ith != src) continue;
                return -1;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (--ith <= 0) {
                    ith = uip - 1;
                }
                if (ith != src) continue;
                return -1;
lbl14:
                // 2 sources

                ** while (is_pole[ith])
            }
        }
        return ith;
    }

    private void adjustPole(JgclPoint2D[] pnts, boolean[] is_pole) {
        int uip = pnts.length;
        int i = 0;
        while (i < uip) {
            if (is_pole[i]) {
                double x_in;
                int in;
                int ip = this.getNeighborNonPoleIdx(is_pole, i, false);
                if (ip < 0 || (in = this.getNeighborNonPoleIdx(is_pole, i, true)) < 0) {
                    return;
                }
                double x_ip = pnts[ip].x();
                if (x_ip > (x_in = pnts[in].x())) {
                    x_in += Math.PI * 2;
                }
                pnts[i] = new JgclCartesianPoint2D((x_ip + x_in) / 2.0, pnts[i].y());
            }
            ++i;
        }
    }

    private PointOnPolarSurface pntOnSph(JgclPoint3D pnt3d, double radius) {
        JgclPoint3D epnt = this.trns.toLocal(pnt3d);
        epnt = epnt.divide(radius);
        double ework = JgclMath.midOf3(-1.0, epnt.z(), 1.0);
        double y = Math.asin(ework);
        ework = Math.sqrt(1.0 - ework * ework);
        JgclPoint2D epnt2d = epnt.to2D().divide(ework);
        ework = JgclMath.midOf3(-1.0, epnt2d.x(), 1.0);
        double x = Math.acos(ework);
        if (epnt2d.y() < 0.0) {
            x = Math.PI * 2 - x;
        }
        boolean isPole = epnt2d.toVector2D().length() < pnt3d.getToleranceForDistance();
        return new PointOnPolarSurface(x, y, isPole);
    }

    private JgclPoint2D pntOnCyl(JgclPoint3D pnt3d, double radius) {
        JgclPoint3D epnt = this.trns.toLocal(pnt3d);
        epnt = epnt.divide(radius);
        double ework = JgclMath.midOf3(-1.0, epnt.x(), 1.0);
        double x = Math.acos(ework);
        if (epnt.y() < 0.0) {
            x = Math.PI * 2 - x;
        }
        double y = epnt.z();
        return new JgclCartesianPoint2D(x, y);
    }

    private PointOnPolarSurface pntOnCon(JgclPoint3D pnt3d, double radius, double semiAngle) {
        JgclPoint3D epnt = this.trns.toLocal(pnt3d);
        double y = epnt.z();
        double ework = radius + Math.tan(semiAngle) * epnt.z();
        if (Math.abs(ework) < pnt3d.getToleranceForDistance()) {
            return new PointOnPolarSurface(0.0, y, true);
        }
        epnt = epnt.divide(ework);
        ework = JgclMath.midOf3(-1.0, epnt.x(), 1.0);
        double x = Math.acos(ework);
        if (epnt.y() < 0.0) {
            x = Math.PI * 2 - x;
        }
        return new PointOnPolarSurface(x, y, false);
    }

    private JgclParametricCurve2D convertCurveSphere(JgclParametricCurve3D curve) {
        JgclSphericalSurface3D sph = (JgclSphericalSurface3D)this.surface;
        switch (curve.type()) {
            case 20: {
                JgclPolyline3D pol = (JgclPolyline3D)curve;
                int uip = pol.nPoints();
                JgclPoint2D[] pnts2d = new JgclPoint2D[uip];
                boolean[] isPole = new boolean[uip];
                int i = 0;
                while (i < uip) {
                    PointOnPolarSurface pos = this.pntOnSph(pol.pointAt(i), sph.radius());
                    pnts2d[i] = pos.pnt;
                    isPole[i] = pos.isPole;
                    ++i;
                }
                this.adjustPole(pnts2d, isPole);
                sph.confirmConnectionOfPointsOnSurface(pnts2d);
                return new JgclPolyline2D(pnts2d, pol.closed());
            }
            case 10: {
                JgclCircle3D cir = (JgclCircle3D)curve;
                JgclPoint3D[] pnts = this.transformCirEllPol(cir);
                int uip = pnts.length;
                JgclPoint2D[] pnts2d = new JgclPoint2D[uip];
                boolean[] isPole = new boolean[uip];
                int i = 0;
                while (i < uip) {
                    PointOnPolarSurface pos = this.pntOnSph(pnts[i], sph.radius());
                    pnts2d[i] = pos.pnt;
                    isPole[i] = pos.isPole;
                    ++i;
                }
                this.adjustPole(pnts2d, isPole);
                sph.confirmConnectionOfPointsOnSurface(pnts2d);
                return new JgclPolyline2D(pnts2d, false);
            }
        }
        throw new JgclNotSupported();
    }

    private JgclParametricCurve2D convertCurveCylinder(JgclParametricCurve3D curve) {
        JgclCylindricalSurface3D cyl = (JgclCylindricalSurface3D)this.surface;
        switch (curve.type()) {
            case 1: {
                JgclLine3D lin = (JgclLine3D)curve;
                JgclPoint2D spnt = this.pntOnCyl(lin.pnt(), cyl.radius());
                JgclPoint2D epnt = this.pntOnCyl(lin.pnt().add(lin.dir()), cyl.radius());
                return new JgclLine2D(spnt, epnt);
            }
            case 20: {
                JgclPolyline3D pol = (JgclPolyline3D)curve;
                int uip = pol.nPoints();
                JgclPoint2D[] pnts2d = new JgclPoint2D[uip];
                int i = 0;
                while (i < uip) {
                    pnts2d[i] = this.pntOnCyl(pol.pointAt(i), cyl.radius());
                    ++i;
                }
                cyl.confirmConnectionOfPointsOnSurface(pnts2d);
                return new JgclPolyline2D(pnts2d, pol.closed());
            }
            case 10: 
            case 11: {
                JgclConic3D cnc = (JgclConic3D)curve;
                JgclPoint3D[] pnts = this.transformCirEllPol(cnc);
                int uip = pnts.length;
                JgclPoint2D[] pnts2d = new JgclPoint2D[uip];
                int i = 0;
                while (i < uip) {
                    pnts2d[i] = this.pntOnCyl(pnts[i], cyl.radius());
                    ++i;
                }
                cyl.confirmConnectionOfPointsOnSurface(pnts2d);
                return new JgclPolyline2D(pnts2d, false);
            }
        }
        throw new JgclNotSupported();
    }

    private JgclParametricCurve2D convertCurveCone(JgclParametricCurve3D curve) {
        JgclConicalSurface3D con = (JgclConicalSurface3D)this.surface;
        switch (curve.type()) {
            case 1: {
                JgclLine3D lin = (JgclLine3D)curve;
                boolean[] isPole = new boolean[2];
                PointOnPolarSurface pos = this.pntOnCon(lin.pnt(), con.radius(), con.semiAngle());
                JgclPoint2D spnt = pos.pnt;
                isPole[0] = pos.isPole;
                pos = this.pntOnCon(lin.pnt().add(lin.dir()), con.radius(), con.semiAngle());
                JgclPoint2D epnt = pos.pnt;
                isPole[1] = pos.isPole;
                if (isPole[0] && !isPole[1]) {
                    spnt = new JgclCartesianPoint2D(epnt.x(), spnt.y());
                } else if (!isPole[0] && isPole[1]) {
                    epnt = new JgclCartesianPoint2D(spnt.x(), epnt.y());
                }
                return new JgclLine2D(spnt, epnt);
            }
            case 20: {
                JgclPolyline3D pol = (JgclPolyline3D)curve;
                int uip = pol.nPoints();
                JgclPoint2D[] pnts2d = new JgclPoint2D[uip];
                boolean[] isPole = new boolean[uip];
                int i = 0;
                while (i < uip) {
                    PointOnPolarSurface pos = this.pntOnCon(pol.pointAt(i), con.radius(), con.semiAngle());
                    pnts2d[i] = pos.pnt;
                    isPole[i] = pos.isPole;
                    ++i;
                }
                this.adjustPole(pnts2d, isPole);
                con.confirmConnectionOfPointsOnSurface(pnts2d);
                return new JgclPolyline2D(pnts2d, pol.closed());
            }
            case 10: 
            case 11: {
                JgclConic3D cnc = (JgclConic3D)curve;
                JgclPoint3D[] pnts = this.transformCirEllPol(cnc);
                int uip = pnts.length;
                JgclPoint2D[] pnts2d = new JgclPoint2D[uip];
                boolean[] isPole = new boolean[uip];
                int i = 0;
                while (i < uip) {
                    PointOnPolarSurface pos = this.pntOnCon(pnts[i], con.radius(), con.semiAngle());
                    pnts2d[i] = pos.pnt;
                    isPole[i] = pos.isPole;
                    ++i;
                }
                this.adjustPole(pnts2d, isPole);
                con.confirmConnectionOfPointsOnSurface(pnts2d);
                return new JgclPolyline2D(pnts2d, false);
            }
            case 13: {
                JgclParabola3D par = (JgclParabola3D)curve;
                JgclPoint3D[] pnts = this.transformParPol(par);
                int uip = pnts.length;
                JgclPoint2D[] pnts2d = new JgclPoint2D[uip];
                boolean[] isPole = new boolean[uip];
                int i = 0;
                while (i < uip) {
                    PointOnPolarSurface pos = this.pntOnCon(pnts[i], con.radius(), con.semiAngle());
                    pnts2d[i] = pos.pnt;
                    isPole[i] = pos.isPole;
                    ++i;
                }
                this.adjustPole(pnts2d, isPole);
                con.confirmConnectionOfPointsOnSurface(pnts2d);
                return new JgclPolyline2D(pnts2d, false);
            }
            case 12: {
                JgclHyperbola3D hyp = (JgclHyperbola3D)curve;
                JgclPoint3D[] pnts = this.transformHypPol(hyp);
                int uip = pnts.length;
                JgclPoint2D[] pnts2d = new JgclPoint2D[uip];
                boolean[] isPole = new boolean[uip];
                int i = 0;
                while (i < uip) {
                    PointOnPolarSurface pos = this.pntOnCon(pnts[i], con.radius(), con.semiAngle());
                    pnts2d[i] = pos.pnt;
                    isPole[i] = pos.isPole;
                    ++i;
                }
                this.adjustPole(pnts2d, isPole);
                con.confirmConnectionOfPointsOnSurface(pnts2d);
                return new JgclPolyline2D(pnts2d, false);
            }
        }
        throw new JgclNotSupported();
    }

    static JgclParametricCurve2D convertCurve(JgclParametricCurve3D curve, JgclElementarySurface3D surface) {
        JgclToParameterSpaceOfSurface3D doObj = new JgclToParameterSpaceOfSurface3D(surface);
        switch (surface.type()) {
            case 1: {
                return doObj.convertCurvePlane(curve);
            }
            case 12: {
                return doObj.convertCurveSphere(curve);
            }
            case 10: {
                return doObj.convertCurveCylinder(curve);
            }
            case 11: {
                return doObj.convertCurveCone(curve);
            }
        }
        throw new JgclNotSupported();
    }

    private class PointOnPolarSurface {
        JgclPoint2D pnt;
        boolean isPole;

        PointOnPolarSurface(JgclPoint2D pnt, boolean isPole) {
            JgclToParameterSpaceOfSurface3D.this = JgclToParameterSpaceOfSurface3D.this;
            this.pnt = pnt;
            this.isPole = isPole;
        }

        PointOnPolarSurface(double x, double y, boolean isPole) {
            JgclToParameterSpaceOfSurface3D.this = JgclToParameterSpaceOfSurface3D.this;
            this.pnt = new JgclCartesianPoint2D(x, y);
            this.isPole = isPole;
        }
    }
}

