/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBoundedLine3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclEnclosingBox3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclOverlapCurve3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclSelfIntsPol3D {
    private JgclPolyline3D polyline;
    private JgclVector3D[] polylineUvecs;
    private double[] polylineLengs;
    private JgclEnclosingBox3D polylineEncls;

    private JgclSelfIntsPol3D(JgclPolyline3D polyline) {
        this(polyline, null, null, null);
    }

    private JgclSelfIntsPol3D(JgclPolyline3D polyline, JgclVector3D[] polylineUvecs, double[] polylineLengs, JgclEnclosingBox3D polylineEncls) {
        this.polyline = polyline;
        this.polylineUvecs = polylineUvecs;
        this.polylineLengs = polylineLengs;
        this.polylineEncls = polylineEncls;
    }

    private JgclCurveCurveInterferenceList getInterference() {
        JgclCurveCurveInterferenceList interferenceList = new JgclCurveCurveInterferenceList(this.polyline, this.polyline);
        int nSegments = this.polyline.nSegments();
        if (nSegments < 3) {
            return interferenceList;
        }
        SegmentInfo[] segmentInfo2 = new SegmentInfo[nSegments];
        int i = 0;
        while (i < nSegments) {
            segmentInfo2[i] = this.polylineUvecs == null ? new SegmentInfo(this.polyline.pointAt(i), this.polyline.pointAt(i + 1)) : new SegmentInfo(this.polyline.pointAt(i), this.polyline.pointAt(i + 1), this.polylineUvecs[i], this.polylineLengs[i]);
            ++i;
        }
        i = 0;
        while (i < nSegments) {
            if (!(segmentInfo2[i].tol < 0.0)) {
                int j = i + 1;
                while (j < nSegments) {
                    JgclCurveCurveInterference3D intf;
                    if (!(segmentInfo2[j].tol < 0.0) && segmentInfo2[i].box.hasIntersection(segmentInfo2[j].box) && (intf = segmentInfo2[i].bln.interfere1(segmentInfo2[j].bln, segmentInfo2[i].udir, segmentInfo2[j].udir, segmentInfo2[i].leng, segmentInfo2[j].leng)) != null) {
                        if (intf.isIntersectionPoint()) {
                            if (!(i + 1 == j || this.polyline.isPeriodic() && i == 0 && j == nSegments - 1)) {
                                JgclIntersectionPoint3D ints = intf.toIntersectionPoint();
                                interferenceList.addAsIntersection(ints.coordinates(), ints.pointOnCurve1().parameter() + (double)i, ints.pointOnCurve2().parameter() + (double)j, segmentInfo2[i].tol, segmentInfo2[j].tol);
                            }
                        } else {
                            JgclOverlapCurve3D ovlp = intf.toOverlapCurve();
                            interferenceList.addAsOverlap(ovlp.start1() + (double)i, ovlp.start2() + (double)j, ovlp.increase1(), ovlp.increase2(), segmentInfo2[i].tol, segmentInfo2[j].tol, segmentInfo2[i].tol, segmentInfo2[j].tol);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        interferenceList.removeOverlapsContainedInOtherOverlap();
        interferenceList.removeIntersectionsContainedInOverlap();
        return interferenceList;
    }

    static JgclIntersectionPoint3D[] intersection(JgclPolyline3D polyline) {
        JgclSelfIntsPol3D doObj = new JgclSelfIntsPol3D(polyline);
        return doObj.getInterference().toJgclIntersectionPoint3DArray(false);
    }

    static JgclCurveCurveInterference3D[] interference(JgclPolyline3D polyline) {
        JgclSelfIntsPol3D doObj = new JgclSelfIntsPol3D(polyline);
        return doObj.getInterference().toJgclCurveCurveInterference3DArray(false);
    }

    static JgclCurveCurveInterference3D[] interference(JgclPolyline3D polyline, JgclVector3D[] polylineUvecs, double[] polylineLengs, JgclEnclosingBox3D polylineEncls) {
        JgclSelfIntsPol3D doObj = new JgclSelfIntsPol3D(polyline, polylineUvecs, polylineLengs, polylineEncls);
        return doObj.getInterference().toJgclCurveCurveInterference3DArray(false);
    }

    private class SegmentInfo {
        private JgclBoundedLine3D bln;
        private JgclVector3D udir;
        private double leng;
        private double tol;
        private JgclEnclosingBox3D box;

        private SegmentInfo(JgclPoint3D spnt, JgclPoint3D epnt, JgclVector3D udir, double leng) {
            JgclSelfIntsPol3D.this = JgclSelfIntsPol3D.this;
            double d_tol = spnt.getToleranceForDistance();
            this.bln = new JgclBoundedLine3D(spnt, epnt);
            if (udir == null) {
                this.udir = this.bln.unitizedDirection();
                this.leng = this.bln.length();
            } else {
                this.udir = udir;
                this.leng = leng;
            }
            this.tol = this.leng < d_tol ? -1.0 : d_tol / this.leng;
            this.box = this.bln.enclosingBox();
        }

        private SegmentInfo(JgclPoint3D spnt, JgclPoint3D epnt) {
            this(spnt, epnt, null, 0.0);
        }
    }
}

