/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclComplexPolynomial;
import jp.go.ipa.jgcl.JgclException;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclMachineEpsilon;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclRealFunctionWithOneVariable;

public class JgclRealPolynomial
implements JgclRealFunctionWithOneVariable {
    private double[] coef;
    private boolean normalized;

    private JgclRealPolynomial() {
        this.coef = null;
        this.normalized = false;
    }

    private JgclRealPolynomial(double[] coef, boolean normalized) {
        this.coef = (double[])coef.clone();
        this.normalized = normalized;
    }

    public JgclRealPolynomial(double[] coef) {
        if (coef == null) {
            throw new JgclInvalidArgumentValue("Array of coefficients is null.");
        }
        if (coef.length < 1) {
            throw new JgclInvalidArgumentValue("Size of array of coefficients is zero.");
        }
        this.coef = (double[])coef.clone();
        this.normalized = false;
    }

    public JgclRealPolynomial(double[][] coef, int dimension) throws JgclInvalidArgumentValue {
        if (coef == null) {
            throw new JgclInvalidArgumentValue("Array of coefficients is null.");
        }
        if (coef.length < 1) {
            throw new JgclInvalidArgumentValue("Size of array of coefficients is zero.");
        }
        if (dimension < 0 || coef[0].length <= dimension) {
            throw new JgclInvalidArgumentValue("Wrong dimension.");
        }
        this.coef = new double[coef.length];
        int i = 0;
        while (i < coef.length) {
            this.coef[i] = coef[i][dimension];
            ++i;
        }
        this.normalized = false;
    }

    public JgclRealPolynomial(double coef0, double coef1, double coef2) {
        this.coef = new double[3];
        this.coef[0] = coef0;
        this.coef[1] = coef1;
        this.coef[2] = coef2;
    }

    public int degree() {
        return this.coef.length - 1;
    }

    public double coefficientAt(int degree) {
        return this.coef[degree];
    }

    public double[] coefficientsBetween(int lower, int upper) {
        int n = upper - lower + 1;
        double[] result = new double[n];
        int i = 0;
        while (i < n) {
            result[i] = this.coef[lower + i];
            ++i;
        }
        return result;
    }

    public double evaluate(double parameter) {
        double value = this.coef[this.degree()];
        int i = this.degree() - 1;
        while (i >= 0) {
            value = value * parameter + this.coef[i];
            --i;
        }
        return value;
    }

    private double[] getRootsIfQuadric(boolean mustHaveRoots) {
        double[] roots;
        if (this.degree() != 2) {
            return null;
        }
        double[] normalCoef = new double[3];
        double maxValue = Math.abs(this.coef[2]) > Math.abs(this.coef[1]) ? Math.abs(this.coef[2]) : Math.abs(this.coef[1]);
        maxValue = maxValue > Math.abs(this.coef[0]) ? maxValue : Math.abs(this.coef[0]);
        normalCoef[2] = this.coef[2] / maxValue;
        normalCoef[1] = this.coef[1] / maxValue;
        normalCoef[0] = this.coef[0] / maxValue;
        if (Math.abs(normalCoef[2]) < JgclMachineEpsilon.DOUBLE) {
            roots = !mustHaveRoots && Math.abs(normalCoef[1]) < JgclMachineEpsilon.DOUBLE ? new double[]{} : new double[]{-normalCoef[0] / normalCoef[1]};
        } else {
            double discriminant = normalCoef[1] * normalCoef[1] - 4.0 * normalCoef[2] * normalCoef[0];
            if (!mustHaveRoots && discriminant < -JgclMachineEpsilon.DOUBLE) {
                roots = new double[]{};
            } else {
                boolean secondByAdding;
                int nRoots;
                double[] twoRoots = new double[2];
                if (discriminant > JgclMachineEpsilon.DOUBLE * JgclMachineEpsilon.DOUBLE) {
                    nRoots = 2;
                } else {
                    discriminant = 0.0;
                    nRoots = 1;
                }
                discriminant = Math.sqrt(discriminant);
                if (normalCoef[1] > 0.0) {
                    twoRoots[0] = -normalCoef[1] - discriminant;
                    secondByAdding = true;
                } else {
                    twoRoots[0] = -normalCoef[1] + discriminant;
                    secondByAdding = false;
                }
                twoRoots[0] = twoRoots[0] / (2.0 * normalCoef[2]);
                if (Math.abs(twoRoots[0]) > JgclMachineEpsilon.DOUBLE) {
                    twoRoots[1] = normalCoef[0] / normalCoef[2] / twoRoots[0];
                } else {
                    twoRoots[1] = secondByAdding ? -normalCoef[1] + discriminant : -normalCoef[1] - discriminant;
                    twoRoots[1] = twoRoots[1] / (2.0 * normalCoef[2]);
                }
                roots = new double[nRoots];
                if (nRoots == 1) {
                    roots[0] = (twoRoots[0] + twoRoots[1]) / 2.0;
                } else {
                    roots[0] = twoRoots[0];
                    roots[1] = twoRoots[1];
                }
            }
        }
        return roots;
    }

    public double[] getRootsIfQuadric() {
        return this.getRootsIfQuadric(false);
    }

    public double[] getAlwaysRootsIfQuadric() {
        return this.getRootsIfQuadric(true);
    }

    public JgclRealPolynomial normalize() {
        double maxVal;
        int maxIdx;
        if (this.normalized) {
            return this;
        }
        int minIdx = maxIdx = this.degree();
        double minVal = maxVal = Math.abs(this.coef[this.degree()]);
        int i = this.degree() - 1;
        while (i >= 0) {
            double absVal = Math.abs(this.coef[i]);
            if (absVal < minVal) {
                minIdx = i;
                minVal = absVal;
            }
            if (maxVal < absVal) {
                maxIdx = i;
                maxVal = absVal;
            }
            --i;
        }
        if (minIdx == maxIdx && maxVal < JgclMachineEpsilon.DOUBLE) {
            double[] zeroCoef = new double[]{0.0};
            return new JgclRealPolynomial(zeroCoef, true);
        }
        int actualDegree = this.degree() + 1;
        while (--actualDegree >= 0) {
            if (Math.abs(this.coef[actualDegree] / maxVal) > JgclMachineEpsilon.DOUBLE) break;
        }
        if (actualDegree == 0) {
            double[] zeroCoef = new double[]{0.0};
            return new JgclRealPolynomial(zeroCoef, true);
        }
        double[] normalizedCoef = new double[actualDegree + 1];
        int i2 = 0;
        while (i2 <= actualDegree) {
            normalizedCoef[i2] = this.coef[i2] / maxVal;
            ++i2;
        }
        return new JgclRealPolynomial(normalizedCoef, true);
    }

    public JgclRealPolynomial add(JgclRealPolynomial mate) {
        if (mate.degree() > this.degree()) {
            return mate.add(this);
        }
        if (this.degree() < 0 || mate.degree() < 0) {
            throw new JgclFatal();
        }
        double[] newCoef = new double[this.degree() + 1];
        int ijk = 0;
        while (ijk <= mate.degree()) {
            newCoef[ijk] = this.coef[ijk] + mate.coef[ijk];
            ++ijk;
        }
        while (ijk <= this.degree()) {
            newCoef[ijk] = this.coef[ijk];
            ++ijk;
        }
        return new JgclRealPolynomial(newCoef, false);
    }

    public JgclRealPolynomial subtract(JgclRealPolynomial mate) {
        return this.add(mate.multiply(-1.0));
    }

    public JgclRealPolynomial multiply(double val) {
        if (this.degree() < 0) {
            throw new JgclFatal();
        }
        double[] newCoef = new double[this.degree() + 1];
        int ijk = 0;
        while (ijk <= this.degree()) {
            newCoef[ijk] = val * this.coef[ijk];
            ++ijk;
        }
        return new JgclRealPolynomial(newCoef, false);
    }

    public JgclRealPolynomial multiply(JgclRealPolynomial mate) {
        if (this.degree() < 0 || mate.degree() < 0) {
            throw new JgclFatal();
        }
        int newDegree = this.degree() + mate.degree();
        double[] newCoef = new double[newDegree + 1];
        int ijk = 0;
        while (ijk <= newDegree) {
            newCoef[ijk] = 0.0;
            ++ijk;
        }
        ijk = 0;
        while (ijk <= this.degree()) {
            int klm = 0;
            while (klm <= mate.degree()) {
                int idx;
                int n = idx = ijk + klm;
                newCoef[n] = newCoef[n] + this.coefficientAt(ijk) * mate.coefficientAt(klm);
                ++klm;
            }
            ++ijk;
        }
        return new JgclRealPolynomial(newCoef, false);
    }

    public JgclRealPolynomial derive() {
        double[] newCoef;
        if (this.degree() < 0) {
            throw new JgclFatal();
        }
        if (this.degree() == 0) {
            newCoef = new double[]{0.0};
        } else {
            newCoef = new double[this.degree()];
            int ijk = 1;
            while (ijk <= this.degree()) {
                newCoef[ijk - 1] = (double)ijk * this.coef[ijk];
                ++ijk;
            }
        }
        return new JgclRealPolynomial(newCoef, false);
    }

    public double getOneRootByNR(double initialGuess) throws NRNotConverge {
        double root = initialGuess;
        double epsilon = JgclMachineEpsilon.DOUBLE;
        int maxIteration = 50;
        int iteration = 0;
        while (iteration < maxIteration) {
            double value;
            double deriv = value = this.coefficientAt(this.degree());
            double delta = 0.0;
            int j = this.degree() - 1;
            while (j >= 0) {
                double tempVal = value * root;
                double coef = this.coefficientAt(j);
                value = tempVal + coef;
                double absTempVal = Math.abs(tempVal);
                if (j > 0) {
                    deriv = deriv * root + value;
                }
                delta = Math.abs(root) * delta + epsilon * (absTempVal + JgclMath.maxOf3(Math.abs(coef), absTempVal, Math.abs(value)));
                --j;
            }
            double absVal = Math.abs(value);
            if (absVal < epsilon && delta < epsilon || absVal < delta) {
                return root;
            }
            root = Math.abs(deriv) > epsilon ? (root -= value / deriv) : (root -= value / JgclMath.copySign(epsilon, deriv));
            ++iteration;
        }
        throw new NRNotConverge(root);
    }

    public JgclComplexPolynomial toComplexPolynomial() {
        JgclComplex[] complexCoef = new JgclComplex[this.coef.length];
        int i = 0;
        while (i < this.coef.length) {
            complexCoef[i] = new JgclComplex(this.coef[i]);
            ++i;
        }
        try {
            return new JgclComplexPolynomial(complexCoef);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal("Can not create a complex polynomial.");
        }
    }

    private static void debugGetRootsIfQuadric(String[] argv) {
        double[] coef = new double[argv.length];
        int i = 0;
        while (i < argv.length) {
            coef[i] = Double.valueOf(argv[i]);
            ++i;
        }
        try {
            JgclRealPolynomial poly = new JgclRealPolynomial(coef);
            double[] result = poly.getRootsIfQuadric();
            if (result != null) {
                int i2 = 0;
                while (i2 < result.length) {
                    System.out.println("result : " + result[i2] + ", evaluate : " + poly.evaluate(result[i2]));
                    ++i2;
                }
            }
        }
        catch (JgclInvalidArgumentValue e) {
            System.err.println(e);
        }
    }

    private static void debugGetOneRootByNR(String[] argv) {
        double[] coef = new double[argv.length];
        int i = 0;
        while (i < argv.length) {
            coef[i] = Double.valueOf(argv[i]);
            ++i;
        }
        try {
            JgclRealPolynomial poly = new JgclRealPolynomial(coef);
            double result = poly.getOneRootByNR(0.0);
            System.out.println("result : " + result + ", evaluate : " + poly.evaluate(result));
        }
        catch (JgclInvalidArgumentValue e) {
            System.err.println(e);
        }
        catch (NRNotConverge e) {
            System.err.println(e);
        }
    }

    public static void main(String[] argv) {
        JgclRealPolynomial.debugGetRootsIfQuadric(argv);
        JgclRealPolynomial.debugGetOneRootByNR(argv);
    }

    public class NRNotConverge
    extends JgclException {
        private double value;

        private NRNotConverge(double value) {
            JgclRealPolynomial.this = JgclRealPolynomial.this;
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }
    }
}

