/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Enumeration;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclEnclosingBox2D;
import jp.go.ipa.jgcl.JgclFreeformSurfaceWithGivenControlPointsArray2D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclPureBezierSurfaceWithGivenControlPointsArray2D;
import jp.go.ipa.jgcl.JgclToleranceForAngle;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector3D;

final class JgclProjPntBzs3D {
    private static JgclProjPntBzs3D myOwnInstance = new JgclProjPntBzs3D();

    private JgclProjPntBzs3D() {
    }

    private static JgclPureBezierSurface3D getPartialDerivForU(JgclPureBezierSurface3D bzs) {
        JgclPureBezierSurface3D partialDeriv;
        int degree = bzs.uDegree();
        int uncp = bzs.uNControlPoints() - 1;
        int vncp = bzs.vNControlPoints();
        JgclPoint3D[][] partialDerivControlPoints = new JgclPoint3D[uncp][vncp];
        if (bzs.isPolynomial()) {
            int j = 0;
            while (j < vncp) {
                int i = 0;
                while (i < uncp) {
                    partialDerivControlPoints[i][j] = bzs.controlPointAt(i + 1, j).subtract(bzs.controlPointAt(i, j)).multiply(degree).toPoint3D();
                    ++i;
                }
                ++j;
            }
            partialDeriv = new JgclPureBezierSurface3D(partialDerivControlPoints);
        } else {
            double[][] partialDerivWeights = new double[uncp][vncp];
            int j = 0;
            while (j < vncp) {
                int i = 0;
                while (i < uncp) {
                    partialDerivControlPoints[i][j] = bzs.controlPointAt(i + 1, j).subtract(bzs.controlPointAt(i, j)).multiply(degree).toPoint3D();
                    partialDerivWeights[i][j] = (bzs.weightAt(i + 1, j) - bzs.weightAt(i, j)) * (double)degree;
                    ++i;
                }
                ++j;
            }
            partialDeriv = new JgclPureBezierSurface3D(partialDerivControlPoints, partialDerivWeights, false);
        }
        return partialDeriv;
    }

    private static JgclPureBezierSurface3D getPartialDerivForV(JgclPureBezierSurface3D bzs) {
        JgclPureBezierSurface3D partialDeriv;
        int degree = bzs.vDegree();
        int uncp = bzs.uNControlPoints();
        int vncp = bzs.vNControlPoints() - 1;
        JgclPoint3D[][] partialDerivControlPoints = new JgclPoint3D[uncp][vncp];
        if (bzs.isPolynomial()) {
            int j = 0;
            while (j < vncp) {
                int i = 0;
                while (i < uncp) {
                    partialDerivControlPoints[i][j] = bzs.controlPointAt(i, j + 1).subtract(bzs.controlPointAt(i, j)).multiply(degree).toPoint3D();
                    ++i;
                }
                ++j;
            }
            partialDeriv = new JgclPureBezierSurface3D(partialDerivControlPoints);
        } else {
            double[][] partialDerivWeights = new double[uncp][vncp];
            int j = 0;
            while (j < vncp) {
                int i = 0;
                while (i < uncp) {
                    partialDerivControlPoints[i][j] = bzs.controlPointAt(i, j + 1).subtract(bzs.controlPointAt(i, j)).multiply(degree).toPoint3D();
                    partialDerivWeights[i][j] = (bzs.weightAt(i, j + 1) - bzs.weightAt(i, j)) * (double)degree;
                    ++i;
                }
                ++j;
            }
            partialDeriv = new JgclPureBezierSurface3D(partialDerivControlPoints, partialDerivWeights, false);
        }
        return partialDeriv;
    }

    private static BezierSurface1D getProductFunctionOf3D(JgclPureBezierSurface3D bzs1, JgclPureBezierSurface3D bzs2) {
        int uDeg1 = bzs1.uDegree();
        int vDeg1 = bzs1.vDegree();
        int uDeg2 = bzs2.uDegree();
        int vDeg2 = bzs2.vDegree();
        int uDeg = uDeg1 + uDeg2;
        int vDeg = vDeg1 + vDeg2;
        int uNcp = uDeg + 1;
        int vNcp = vDeg + 1;
        double[] uBinCoef1 = JgclMath.pascalTriangle(bzs1.uNControlPoints());
        double[] vBinCoef1 = JgclMath.pascalTriangle(bzs1.vNControlPoints());
        double[] uBinCoef2 = JgclMath.pascalTriangle(bzs2.uNControlPoints());
        double[] vBinCoef2 = JgclMath.pascalTriangle(bzs2.vNControlPoints());
        double[] uBinCoef = JgclMath.pascalTriangle(uNcp);
        double[] vBinCoef = JgclMath.pascalTriangle(vNcp);
        BezierSurface1D prodFunc = myOwnInstance.new BezierSurface1D();
        prodFunc.controlPoints = new double[uNcp][vNcp];
        prodFunc.weights = null;
        int j_vDeg1 = -vDeg1;
        int j = 0;
        while (j <= vDeg) {
            int max0j = Math.max(0, j_vDeg1);
            int mindj = Math.min(vDeg2, j);
            int i_uDeg1 = -uDeg1;
            int i = 0;
            while (i <= uDeg) {
                int max0i = Math.max(0, i_uDeg1);
                int mindi = Math.min(uDeg2, i);
                double rl = 0.0;
                int l = max0i;
                int i_l = i - max0i;
                while (l <= mindi) {
                    double rm = 0.0;
                    int m = max0j;
                    int j_m = j - max0j;
                    while (m <= mindj) {
                        JgclPoint3D b3p1 = bzs1.controlPointAt(i_l, j_m);
                        JgclPoint3D b3p2 = bzs2.controlPointAt(l, m);
                        rm += vBinCoef2[m] * vBinCoef1[j_m] * (b3p1.x() * b3p2.x() + b3p1.y() * b3p2.y() + b3p1.z() * b3p2.z());
                        ++m;
                        --j_m;
                    }
                    rl += uBinCoef2[l] * uBinCoef1[i_l] * rm;
                    ++l;
                    --i_l;
                }
                prodFunc.controlPoints[i][j] = rl / (uBinCoef[i] * vBinCoef[j]);
                ++i_uDeg1;
                ++i;
            }
            ++j_vDeg1;
            ++j;
        }
        return prodFunc;
    }

    private static BezierSurface1D getProductFunctionOf1D(BezierSurface1D bzs1, BezierSurface1D bzs2) {
        int uDeg1 = bzs1.uDegree();
        int vDeg1 = bzs1.vDegree();
        int uDeg2 = bzs2.uDegree();
        int vDeg2 = bzs2.vDegree();
        int uDeg = uDeg1 + uDeg2;
        int vDeg = vDeg1 + vDeg2;
        int uNcp = uDeg + 1;
        int vNcp = vDeg + 1;
        double[] uBinCoef1 = JgclMath.pascalTriangle(bzs1.uNControlPoints());
        double[] vBinCoef1 = JgclMath.pascalTriangle(bzs1.vNControlPoints());
        double[] uBinCoef2 = JgclMath.pascalTriangle(bzs2.uNControlPoints());
        double[] vBinCoef2 = JgclMath.pascalTriangle(bzs2.vNControlPoints());
        double[] uBinCoef = JgclMath.pascalTriangle(uNcp);
        double[] vBinCoef = JgclMath.pascalTriangle(vNcp);
        BezierSurface1D prodFunc = myOwnInstance.new BezierSurface1D();
        prodFunc.controlPoints = new double[uNcp][vNcp];
        prodFunc.weights = null;
        int j_vDeg1 = -vDeg1;
        int j = 0;
        while (j <= vDeg) {
            int max0j = Math.max(0, j_vDeg1);
            int mindj = Math.min(vDeg2, j);
            int i_uDeg1 = -uDeg1;
            int i = 0;
            while (i <= uDeg) {
                int max0i = Math.max(0, i_uDeg1);
                int mindi = Math.min(uDeg2, i);
                double rl = 0.0;
                int l = max0i;
                int i_l = i - max0i;
                while (l <= mindi) {
                    double rm = 0.0;
                    int m = max0j;
                    int j_m = j - max0j;
                    while (m <= mindj) {
                        double b1p1 = bzs1.controlPointAt(i_l, j_m);
                        double b1p2 = bzs2.controlPointAt(l, m);
                        rm += vBinCoef2[m] * vBinCoef1[j_m] * (b1p1 * b1p2);
                        ++m;
                        --j_m;
                    }
                    rl += uBinCoef2[l] * uBinCoef1[i_l] * rm;
                    ++l;
                    --i_l;
                }
                prodFunc.controlPoints[i][j] = rl / (uBinCoef[i] * vBinCoef[j]);
                ++i_uDeg1;
                ++i;
            }
            ++j_vDeg1;
            ++j;
        }
        return prodFunc;
    }

    private static BezierSurface1D makeSubtractOfTwoProdFunctions(BezierSurface1D bzf1, BezierSurface1D bzf2) {
        BezierSurface1D diff = myOwnInstance.new BezierSurface1D();
        diff.controlPoints = new double[bzf1.uNControlPoints()][bzf1.vNControlPoints()];
        diff.weights = null;
        int i = 0;
        while (i < bzf1.uNControlPoints()) {
            int j = 0;
            while (j < bzf1.vNControlPoints()) {
                diff.controlPoints[i][j] = bzf1.controlPoints[i][j] - bzf2.controlPoints[i][j];
                ++j;
            }
            ++i;
        }
        return diff;
    }

    private static JgclPureBezierSurfaceWithGivenControlPointsArray2D makeBezierSurface2D(JgclPoint3D pnt, JgclPureBezierSurface3D bzs) {
        BezierSurface1D eBdpv;
        BezierSurface1D eBdpt3;
        BezierSurface1D eBdpt2;
        BezierSurface1D eBdpt1;
        BezierSurface1D eBdpu;
        JgclPureBezierSurface3D eB;
        int v;
        int u;
        int uncp = bzs.uNControlPoints();
        int vncp = bzs.vNControlPoints();
        JgclPoint3D[][] transformedControlPoints = new JgclPoint3D[uncp][vncp];
        BezierSurface1D bzf_w = myOwnInstance.new BezierSurface1D();
        if (bzs.isPolynomial()) {
            u = 0;
            while (u < uncp) {
                v = 0;
                while (v < vncp) {
                    transformedControlPoints[u][v] = bzs.controlPointAt(u, v).subtract(pnt).toPoint3D();
                    ++v;
                }
                ++u;
            }
            eB = new JgclPureBezierSurface3D(transformedControlPoints);
        } else {
            u = 0;
            while (u < uncp) {
                v = 0;
                while (v < vncp) {
                    transformedControlPoints[u][v] = bzs.controlPointAt(u, v).subtract(pnt).multiply(bzs.weightAt(u, v)).toPoint3D();
                    ++v;
                }
                ++u;
            }
            eB = new JgclPureBezierSurface3D(transformedControlPoints, bzs.weights());
        }
        BezierSurface1D eBdpB = bzs.isRational() ? JgclProjPntBzs3D.getProductFunctionOf3D(eB, eB) : null;
        JgclPureBezierSurface3D eBdu = JgclProjPntBzs3D.getPartialDerivForU(eB);
        BezierSurface1D eBde = eBdpu = JgclProjPntBzs3D.getProductFunctionOf3D(eB, eBdu);
        if (bzs.isRational()) {
            bzf_w.controlPoints = eB.weights;
            eBdpt1 = JgclProjPntBzs3D.getProductFunctionOf1D(bzf_w, eBdpu);
            bzf_w.controlPoints = eBdu.weights;
            eBdpt2 = JgclProjPntBzs3D.getProductFunctionOf1D(bzf_w, eBdpB);
            eBde = eBdpt3 = JgclProjPntBzs3D.makeSubtractOfTwoProdFunctions(eBdpt1, eBdpt2);
        }
        double[][] bzf_de_cntrl_pnts_21 = new double[2][1];
        bzf_de_cntrl_pnts_21[0][0] = 1.0;
        bzf_de_cntrl_pnts_21[1][0] = 1.0;
        bzf_w.controlPoints = bzf_de_cntrl_pnts_21;
        BezierSurface1D eBmdpu = JgclProjPntBzs3D.getProductFunctionOf1D(bzf_w, eBde);
        JgclPureBezierSurface3D eBdv = JgclProjPntBzs3D.getPartialDerivForV(eB);
        eBde = eBdpv = JgclProjPntBzs3D.getProductFunctionOf3D(eB, eBdv);
        if (bzs.isRational()) {
            bzf_w.controlPoints = eB.weights;
            eBdpt1 = JgclProjPntBzs3D.getProductFunctionOf1D(bzf_w, eBdpv);
            bzf_w.controlPoints = eBdv.weights;
            eBdpt2 = JgclProjPntBzs3D.getProductFunctionOf1D(bzf_w, eBdpB);
            eBde = eBdpt3 = JgclProjPntBzs3D.makeSubtractOfTwoProdFunctions(eBdpt1, eBdpt2);
        }
        double[][] bzf_de_cntrl_pnts_12 = new double[1][2];
        bzf_de_cntrl_pnts_12[0][0] = 1.0;
        bzf_de_cntrl_pnts_12[0][1] = 1.0;
        bzf_w.controlPoints = bzf_de_cntrl_pnts_12;
        BezierSurface1D eBmdpv = JgclProjPntBzs3D.getProductFunctionOf1D(bzf_w, eBde);
        double[][][] controlPoints = JgclFreeformSurfaceWithGivenControlPointsArray2D.allocateDoubleArray(true, eBmdpu.uNControlPoints(), eBmdpu.vNControlPoints());
        int i = 0;
        while (i < eBmdpu.uNControlPoints()) {
            int j = 0;
            while (j < eBmdpu.vNControlPoints()) {
                controlPoints[i][j][0] = eBmdpu.controlPoints[i][j];
                controlPoints[i][j][1] = eBmdpv.controlPoints[i][j];
                ++j;
            }
            ++i;
        }
        return new JgclPureBezierSurfaceWithGivenControlPointsArray2D(controlPoints);
    }

    private static boolean twoPointsCoincide(JgclPointOnSurface3D pos, double[] paramPair, JgclToleranceForDistance dTol) {
        JgclPoint3D crd1;
        JgclPoint3D crd0 = pos.basisSurface().coordinates(pos.uParameter(), pos.vParameter());
        if (crd0.distance2(crd1 = pos.basisSurface().coordinates(paramPair[0], paramPair[1])) > dTol.squared()) {
            return false;
        }
        double uDiff = pos.uParameter() - paramPair[0];
        double vDiff = pos.vParameter() - paramPair[1];
        return Math.abs(uDiff) < dTol.toToleranceForParameterU(pos.basisSurface(), pos.uParameter(), pos.vParameter()).value() && Math.abs(vDiff) < dTol.toToleranceForParameterV(pos.basisSurface(), pos.uParameter(), pos.vParameter()).value();
    }

    private static void addAsSolution(JgclPureBezierSurface3D bzs, double[] paramPair, JgclToleranceForDistance dTol, Vector zpl) {
        Enumeration e = zpl.elements();
        while (e.hasMoreElements()) {
            if (!JgclProjPntBzs3D.twoPointsCoincide((JgclPointOnSurface3D)e.nextElement(), paramPair, dTol)) continue;
            return;
        }
        zpl.addElement(new JgclPointOnSurface3D((JgclParametricSurface3D)bzs, paramPair[0], paramPair[1]));
    }

    private static void getZeroPoints(JgclPureBezierSurface3D bzs3D, JgclPureBezierSurfaceWithGivenControlPointsArray2D bzs, double uLbp, double uUbp, double vLbp, double vUbp, JgclToleranceForDistance dTol, Vector zpl) {
        double[] paramCenter = new double[]{(uLbp + uUbp) / 2.0, (vLbp + vUbp) / 2.0};
        JgclEnclosingBox2D box = bzs.approximateEnclosingBox();
        if (box.min().x() > 0.0 || box.min().y() > 0.0 || box.max().x() < 0.0 || box.max().y() < 0.0) {
            return;
        }
        if (box.min().x() > -dTol.value() && box.min().y() > -dTol.value() && box.max().x() < dTol.value() && box.max().y() < dTol.value()) {
            JgclProjPntBzs3D.addAsSolution(bzs3D, paramCenter, dTol, zpl);
            return;
        }
        JgclPureBezierSurfaceWithGivenControlPointsArray2D[] uBzs = bzs.uDivide(0.5);
        JgclPureBezierSurfaceWithGivenControlPointsArray2D[] u0vBzs = uBzs[0].vDivide(0.5);
        JgclPureBezierSurfaceWithGivenControlPointsArray2D[] u1vBzs = uBzs[1].vDivide(0.5);
        JgclProjPntBzs3D.getZeroPoints(bzs3D, u0vBzs[0], uLbp, paramCenter[0], vLbp, paramCenter[1], dTol, zpl);
        JgclProjPntBzs3D.getZeroPoints(bzs3D, u0vBzs[1], uLbp, paramCenter[0], paramCenter[1], vUbp, dTol, zpl);
        JgclProjPntBzs3D.getZeroPoints(bzs3D, u1vBzs[0], paramCenter[0], uUbp, vLbp, paramCenter[1], dTol, zpl);
        JgclProjPntBzs3D.getZeroPoints(bzs3D, u1vBzs[1], paramCenter[0], uUbp, paramCenter[1], vUbp, dTol, zpl);
    }

    private static JgclPureBezierCurve3D getBoundary(JgclPureBezierSurface3D bzs, int i) {
        JgclPoint3D[] controlPoints;
        int anotherIndex;
        double[] weights = null;
        switch (i) {
            case 0: {
                anotherIndex = 0;
                break;
            }
            case 1: {
                anotherIndex = bzs.uDegree();
                break;
            }
            case 2: {
                anotherIndex = 0;
                break;
            }
            case 3: {
                anotherIndex = bzs.vDegree();
                break;
            }
            default: {
                return null;
            }
        }
        if (i <= 1) {
            controlPoints = new JgclPoint3D[bzs.vNControlPoints()];
            i = 0;
            while (i < bzs.vNControlPoints()) {
                controlPoints[i] = bzs.controlPointAt(anotherIndex, i);
                ++i;
            }
            if (bzs.isRational()) {
                weights = new double[bzs.vNControlPoints()];
                i = 0;
                while (i < bzs.vNControlPoints()) {
                    weights[i] = bzs.weightAt(anotherIndex, i);
                    ++i;
                }
            }
        } else {
            controlPoints = new JgclPoint3D[bzs.uNControlPoints()];
            i = 0;
            while (i < bzs.uNControlPoints()) {
                controlPoints[i] = bzs.controlPointAt(i, anotherIndex);
                ++i;
            }
            if (bzs.isRational()) {
                weights = new double[bzs.uNControlPoints()];
                i = 0;
                while (i < bzs.uNControlPoints()) {
                    weights[i] = bzs.weightAt(i, anotherIndex);
                    ++i;
                }
            }
        }
        if (bzs.isPolynomial()) {
            return new JgclPureBezierCurve3D(controlPoints);
        }
        return new JgclPureBezierCurve3D(controlPoints, weights);
    }

    private static void computeWithBoundary(JgclPoint3D pnt, JgclPureBezierSurface3D bzs, JgclToleranceForDistance dTol, JgclToleranceForAngle aTol, Vector zpl) {
        double[] paramPair = new double[2];
        int i = 0;
        while (i < 4) {
            double param = i % 2 == 0 ? 0.0 : 1.0;
            JgclPureBezierCurve3D bzc = JgclProjPntBzs3D.getBoundary(bzs, i);
            JgclPointOnCurve3D[] feet = bzc.projectFrom(pnt);
            if (feet.length <= 0) {
                if (!(pnt.distance2(bzc.controlPointAt(0)) > dTol.squared())) {
                    if (i < 2) {
                        paramPair[0] = param;
                        paramPair[1] = 0.0;
                    } else {
                        paramPair[0] = 0.0;
                        paramPair[1] = param;
                    }
                    JgclProjPntBzs3D.addAsSolution(bzs, paramPair, dTol, zpl);
                }
                if (!(pnt.distance2(bzc.controlPointAt(bzc.degree())) > dTol.squared())) {
                    if (i < 2) {
                        paramPair[0] = param;
                        paramPair[1] = 1.0;
                    } else {
                        paramPair[0] = 1.0;
                        paramPair[1] = param;
                    }
                    JgclProjPntBzs3D.addAsSolution(bzs, paramPair, dTol, zpl);
                }
            } else {
                int j = 0;
                while (j < feet.length) {
                    JgclVector3D[] tangents;
                    JgclVector3D footVector;
                    if (i < 2) {
                        paramPair[0] = param;
                        paramPair[1] = feet[j].parameter();
                    } else {
                        paramPair[0] = feet[j].parameter();
                        paramPair[1] = param;
                    }
                    if (!(pnt.distance2(feet[j].coordinates()) > dTol.squared()) || !((footVector = feet[j].coordinates().subtract(pnt).unitized()).dotProduct((tangents = bzs.tangentVector(paramPair[0], paramPair[1]))[0].unitized()) > aTol.value()) && !(footVector.dotProduct(tangents[1].unitized()) > aTol.value())) {
                        JgclProjPntBzs3D.addAsSolution(bzs, paramPair, dTol, zpl);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    static JgclPointOnSurface3D[] projection(JgclPoint3D pnt, JgclPureBezierSurface3D bzs) {
        JgclToleranceForDistance dTol = JgclConditionOfOperation.getCondition().getToleranceForDistanceAsObject();
        JgclToleranceForAngle aTol = JgclConditionOfOperation.getCondition().getToleranceForAngleAsObject();
        Vector zeroPointList = new Vector();
        JgclPureBezierSurfaceWithGivenControlPointsArray2D eBmdp = JgclProjPntBzs3D.makeBezierSurface2D(pnt, bzs);
        JgclProjPntBzs3D.getZeroPoints(bzs, eBmdp, 0.0, 1.0, 0.0, 1.0, dTol, zeroPointList);
        JgclProjPntBzs3D.computeWithBoundary(pnt, bzs, dTol, aTol, zeroPointList);
        Object[] result = new JgclPointOnSurface3D[zeroPointList.size()];
        zeroPointList.copyInto(result);
        return result;
    }

    public static void main(String[] argv) {
        JgclPoint3D[][] controlPoints = new JgclPoint3D[4][4];
        controlPoints[0][0] = new JgclCartesianPoint3D(-906.190856934, 1146.898925781, 2000.0);
        controlPoints[1][0] = new JgclCartesianPoint3D(46.812759399, 1270.228881836, 1000.0);
        controlPoints[2][0] = new JgclCartesianPoint3D(943.757324219, 1281.440673828, 1000.0);
        controlPoints[3][0] = new JgclCartesianPoint3D(1594.042114258, 1102.051757813, 2000.0);
        controlPoints[0][1] = new JgclCartesianPoint3D(-794.072753906, -277.000549316, 0.0);
        controlPoints[1][1] = new JgclCartesianPoint3D(259.837097168, -108.823440552, 0.0);
        controlPoints[2][1] = new JgclCartesianPoint3D(1022.239990234, -176.094284058, 0.0);
        controlPoints[3][1] = new JgclCartesianPoint3D(1560.406738281, -512.448486328, 0.0);
        controlPoints[0][2] = new JgclCartesianPoint3D(-558.624816895, -1644.841064453, 0.0);
        controlPoints[1][2] = new JgclCartesianPoint3D(428.014221191, -1330.910400391, 0.0);
        controlPoints[2][2] = new JgclCartesianPoint3D(1246.476074219, -1476.66394043, 0.0);
        controlPoints[3][2] = new JgclCartesianPoint3D(1829.490112305, -2037.254272461, 0.0);
        controlPoints[0][3] = new JgclCartesianPoint3D(-502.565795898, -2833.292480469, 1000.0);
        controlPoints[1][3] = new JgclCartesianPoint3D(349.531555176, -2519.362060547, 0.0);
        controlPoints[2][3] = new JgclCartesianPoint3D(1033.451782227, -2597.844726563, 500.0);
        controlPoints[3][3] = new JgclCartesianPoint3D(1268.899780273, -3068.740478516, 1000.0);
        JgclCartesianPoint3D pnt = new JgclCartesianPoint3D(574.673950195, -1225.472839355, 3300.0);
        JgclPureBezierSurface3D bzs = new JgclPureBezierSurface3D(controlPoints);
        JgclPointOnSurface3D[] feet = bzs.projectFrom(pnt);
        int i = 0;
        while (i < feet.length) {
            JgclPoint3D coord = feet[i].coordinates();
            System.out.println(coord.x() + ", " + coord.y() + ", " + coord.z() + " (" + feet[i].uParameter() + ", " + feet[i].vParameter() + ")");
            ++i;
        }
    }

    private class BezierSurface1D {
        double[][] controlPoints;
        double[][] weights;

        BezierSurface1D() {
            JgclProjPntBzs3D.this = JgclProjPntBzs3D.this;
        }

        int uNControlPoints() {
            return this.controlPoints.length;
        }

        int vNControlPoints() {
            return this.controlPoints[0].length;
        }

        int uDegree() {
            return this.uNControlPoints() - 1;
        }

        int vDegree() {
            return this.vNControlPoints() - 1;
        }

        double controlPointAt(int i, int j) {
            return this.controlPoints[i][j];
        }
    }
}

