/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHomogeneousPoint3D;
import jp.go.ipa.jgcl.JgclHomogeneousVector3D;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclRealFunctionWithOneVariable;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclPolynomialCurve3D
extends JgclParametricCurve3D {
    private final JgclRealPolynomial polyX;
    private final JgclRealPolynomial polyY;
    private final JgclRealPolynomial polyZ;
    private final JgclRealPolynomial polyW;
    private JgclPolynomialCurve3D derivativeCurve;

    private JgclPolynomialCurve3D() {
        this.polyX = null;
        this.polyY = null;
        this.polyZ = null;
        this.polyW = null;
    }

    public JgclPolynomialCurve3D(JgclRealPolynomial xPoly, JgclRealPolynomial yPoly, JgclRealPolynomial zPoly) {
        if (xPoly == null || yPoly == null || zPoly == null) {
            throw new JgclFatal("one of arguments is null");
        }
        if (xPoly.degree() != yPoly.degree() || xPoly.degree() != zPoly.degree()) {
            throw new JgclFatal("given polynomials have different degrees");
        }
        this.polyX = xPoly;
        this.polyY = yPoly;
        this.polyZ = zPoly;
        this.polyW = null;
        this.derivativeCurve = null;
    }

    public JgclPolynomialCurve3D(JgclRealPolynomial wxPoly, JgclRealPolynomial wyPoly, JgclRealPolynomial wzPoly, JgclRealPolynomial wPoly) {
        if (wxPoly == null || wyPoly == null || wzPoly == null || wPoly == null) {
            throw new JgclFatal("one of arguments is null");
        }
        if (wxPoly.degree() != wPoly.degree() || wxPoly.degree() != wPoly.degree() || wzPoly.degree() != wPoly.degree()) {
            throw new JgclFatal("given polynomials have different degrees");
        }
        this.polyX = wxPoly;
        this.polyY = wyPoly;
        this.polyZ = wzPoly;
        this.polyW = wPoly;
        this.derivativeCurve = null;
    }

    public int degree() {
        return this.polyX.degree();
    }

    public boolean isIntegral() {
        return this.polyW == null;
    }

    public boolean isRational() {
        return this.polyW != null;
    }

    private JgclPolynomialCurve3D derivative() {
        if (this.derivativeCurve == null) {
            this.derivativeCurve = this.isIntegral() ? new JgclPolynomialCurve3D(this.polyX.derive(), this.polyY.derive(), this.polyZ.derive()) : new JgclPolynomialCurve3D(this.polyX.derive(), this.polyY.derive(), this.polyZ.derive(), this.polyW.derive());
        }
        return this.derivativeCurve;
    }

    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
        throw new JgclNotSupported();
    }

    JgclParameterDomain getParameterDomain() {
        return new JgclParameterDomain();
    }

    boolean getClosedFlag() {
        return false;
    }

    public boolean isFreeform() {
        return true;
    }

    private JgclLiteralVector3D evaluateAsIntegral(double param) {
        return new JgclLiteralVector3D(this.polyX.evaluate(param), this.polyY.evaluate(param), this.polyZ.evaluate(param));
    }

    private JgclHomogeneousVector3D evaluateAsRational(double param) {
        return new JgclHomogeneousVector3D(this.polyX.evaluate(param), this.polyY.evaluate(param), this.polyZ.evaluate(param), this.polyW.evaluate(param));
    }

    private JgclPoint3D evaluateD0(double param) {
        JgclPoint3D result;
        if (this.isIntegral()) {
            JgclLiteralVector3D D0 = this.evaluateAsIntegral(param);
            result = new JgclCartesianPoint3D(D0.x(), D0.y(), D0.z());
        } else {
            JgclHomogeneousVector3D D0H = this.evaluateAsRational(param);
            result = new JgclHomogeneousPoint3D(D0H.wx(), D0H.wy(), D0H.wz(), D0H.w());
        }
        return result;
    }

    private JgclVector3D evaluateD1(double param) {
        JgclVector3D result;
        if (this.isIntegral()) {
            result = this.derivative().evaluateAsIntegral(param);
        } else {
            JgclHomogeneousVector3D D0H = this.evaluateAsRational(param);
            JgclHomogeneousVector3D D1H = this.derivative().evaluateAsRational(param);
            JgclHomogeneousVector3D D0 = D0H;
            JgclHomogeneousVector3D D1 = new JgclHomogeneousVector3D(D1H.wx() - D1H.w() * ((JgclVector3D)D0).x(), D1H.wy() - D1H.w() * ((JgclVector3D)D0).y(), D1H.wz() - D1H.w() * ((JgclVector3D)D0).z(), D0H.w());
            result = D1;
        }
        return result;
    }

    private JgclVector3D[] evaluateD1D2(double param) {
        JgclVector3D[] result = new JgclVector3D[2];
        if (this.isIntegral()) {
            result[0] = this.derivative().evaluateAsIntegral(param);
            result[1] = this.derivative().derivative().evaluateAsIntegral(param);
        } else {
            JgclHomogeneousVector3D D0H = this.evaluateAsRational(param);
            JgclHomogeneousVector3D D1H = this.derivative().evaluateAsRational(param);
            JgclHomogeneousVector3D D2H = this.derivative().derivative().evaluateAsRational(param);
            JgclHomogeneousVector3D D0 = D0H;
            JgclHomogeneousVector3D D1 = new JgclHomogeneousVector3D(D1H.wx() - D1H.w() * ((JgclVector3D)D0).x(), D1H.wy() - D1H.w() * ((JgclVector3D)D0).y(), D1H.wz() - D1H.w() * ((JgclVector3D)D0).z(), D0H.w());
            JgclHomogeneousVector3D D2 = new JgclHomogeneousVector3D(D2H.wx() - (2.0 * D1H.w() * ((JgclVector3D)D1).x() + D2H.w() * ((JgclVector3D)D0).x()), D2H.wy() - (2.0 * D1H.w() * ((JgclVector3D)D1).y() + D2H.w() * ((JgclVector3D)D0).y()), D2H.wz() - (2.0 * D1H.w() * ((JgclVector3D)D1).z() + D2H.w() * ((JgclVector3D)D0).z()), D0H.w());
            result[0] = D1;
            result[1] = D2;
        }
        return result;
    }

    private JgclVector3D[] evaluateD1D2D3(double param) {
        JgclVector3D[] result = new JgclVector3D[3];
        if (this.isIntegral()) {
            result[0] = this.derivative().evaluateAsIntegral(param);
            result[1] = this.derivative().derivative().evaluateAsIntegral(param);
            result[2] = this.derivative().derivative().derivative().evaluateAsIntegral(param);
        } else {
            JgclHomogeneousVector3D D0H = this.evaluateAsRational(param);
            JgclHomogeneousVector3D D1H = this.derivative().evaluateAsRational(param);
            JgclHomogeneousVector3D D2H = this.derivative().derivative().evaluateAsRational(param);
            JgclHomogeneousVector3D D3H = this.derivative().derivative().derivative().evaluateAsRational(param);
            JgclHomogeneousVector3D D0 = D0H;
            JgclHomogeneousVector3D D1 = new JgclHomogeneousVector3D(D1H.wx() - D1H.w() * ((JgclVector3D)D0).x(), D1H.wy() - D1H.w() * ((JgclVector3D)D0).y(), D1H.wz() - D1H.w() * ((JgclVector3D)D0).z(), D0H.w());
            JgclHomogeneousVector3D D2 = new JgclHomogeneousVector3D(D2H.wx() - (2.0 * D1H.w() * ((JgclVector3D)D1).x() + D2H.w() * ((JgclVector3D)D0).x()), D2H.wy() - (2.0 * D1H.w() * ((JgclVector3D)D1).y() + D2H.w() * ((JgclVector3D)D0).y()), D2H.wz() - (2.0 * D1H.w() * ((JgclVector3D)D1).z() + D2H.w() * ((JgclVector3D)D0).z()), D0H.w());
            JgclHomogeneousVector3D D3 = new JgclHomogeneousVector3D(D3H.wx() - (3.0 * (D1H.w() * ((JgclVector3D)D2).x() + D2H.w() * ((JgclVector3D)D1).x()) + D3H.w() * ((JgclVector3D)D0).x()), D3H.wy() - (3.0 * (D1H.w() * ((JgclVector3D)D2).y() + D2H.w() * ((JgclVector3D)D1).y()) + D3H.w() * ((JgclVector3D)D0).y()), D3H.wz() - (3.0 * (D1H.w() * ((JgclVector3D)D2).z() + D2H.w() * ((JgclVector3D)D1).z()) + D3H.w() * ((JgclVector3D)D0).z()), D0H.w());
            result[0] = D1;
            result[1] = D2;
            result[2] = D3;
        }
        return result;
    }

    public JgclPoint3D coordinates(double param) {
        return this.evaluateD0(param);
    }

    public JgclVector3D tangentVector(double param) {
        return this.evaluateD1(param);
    }

    public JgclCurveCurvature3D curvature(double param) {
        JgclVector3D[] D1D2 = this.evaluateD1D2(param);
        JgclVector3D D1 = D1D2[0];
        JgclVector3D D2 = D1D2[1];
        double D1Leng = D1.length();
        JgclVector3D crsProd = D1.crossProduct(D2);
        double curvature = crsProd.magnitude() / (D1Leng * D1Leng * D1Leng);
        JgclVector3D normal = crsProd.crossProduct(D1).unitized();
        return new JgclCurveCurvature3D(curvature, normal);
    }

    public double torsion(double param) {
        JgclVector3D[] D1D2D3 = this.evaluateD1D2D3(param);
        JgclVector3D D1 = D1D2D3[0];
        JgclVector3D D2 = D1D2D3[1];
        JgclVector3D D3 = D1D2D3[2];
        double D1Leng = D1.length();
        JgclVector3D crsProd = D1.crossProduct(D2);
        double leng3 = D1Leng * D1Leng * D1Leng;
        double curvature = crsProd.magnitude() / leng3;
        return crsProd.dotProduct(D3) / (leng3 * leng3 * curvature * curvature);
    }

    public JgclCurveDerivative3D evaluation(double param) {
        JgclPoint3D D0 = this.evaluateD0(param);
        JgclVector3D[] D1D2D3 = this.evaluateD1D2D3(param);
        return new JgclCurveDerivative3D(D0, D1D2D3[0], D1D2D3[1], D1D2D3[2]);
    }

    public JgclPointOnCurve3D[] singular() {
        throw new JgclNotSupported();
    }

    public JgclPointOnCurve3D[] inflexion() {
        throw new JgclNotSupported();
    }

    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D mate) {
        throw new JgclNotSupported();
    }

    public JgclPolyline3D toPolyline(JgclParameterSection section, JgclToleranceForDistance tolerance) {
        throw new JgclNotSupported();
    }

    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection section) {
        throw new JgclNotSupported();
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
        throw new JgclNotSupported();
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) throws JgclIndefiniteSolution {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        throw new JgclNotSupported();
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        throw new JgclNotSupported();
    }

    public double length(JgclParameterSection pint) {
        double dTol = this.getToleranceForDistance() / 2.0;
        return JgclMath.getDefiniteIntegral(new 1(), pint, dTol);
    }

    int type() {
        return 30;
    }

    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        throw new JgclNotSupported();
    }

    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
        throw new JgclNotSupported();
    }

    private JgclRealPolynomial[] toPolynomialArray() {
        if (this.isIntegral()) {
            JgclRealPolynomial[] polyArray = new JgclRealPolynomial[]{this.polyX, this.polyY, this.polyZ};
            return polyArray;
        }
        JgclRealPolynomial[] polyArray = new JgclRealPolynomial[]{this.polyX, this.polyY, this.polyZ, this.polyW};
        return polyArray;
    }

    public JgclRealPolynomial[] crossProductD1D2() {
        JgclRealPolynomial[] d2Poly;
        JgclRealPolynomial[] d1Poly;
        JgclPolynomialCurve3D d1 = this.derivative();
        JgclPolynomialCurve3D d2 = d1.derivative();
        if (this.isIntegral()) {
            d1Poly = d1.toPolynomialArray();
            d2Poly = d2.toPolynomialArray();
        } else {
            JgclRealPolynomial[] d0WPoly = this.toPolynomialArray();
            JgclRealPolynomial[] d1WPoly = d1.toPolynomialArray();
            JgclRealPolynomial[] d2WPoly = d2.toPolynomialArray();
            d1Poly = new JgclRealPolynomial[3];
            d2Poly = new JgclRealPolynomial[3];
            int klm = 0;
            while (klm < 3) {
                JgclRealPolynomial workPoly1 = this.polyW.multiply(d1WPoly[klm]);
                JgclRealPolynomial workPoly2 = d1.polyW.multiply(d0WPoly[klm]);
                d1Poly[klm] = workPoly1.subtract(workPoly2);
                JgclRealPolynomial workPoly = this.polyW.multiply(this.polyW);
                workPoly1 = workPoly.multiply(d2WPoly[klm]);
                workPoly = d1.polyW.multiply(d0WPoly[klm]);
                workPoly2 = workPoly.multiply(d1WPoly[klm]);
                workPoly = d1.polyW.multiply(d1.polyW);
                JgclRealPolynomial workPoly3 = workPoly.multiply(d0WPoly[klm]);
                workPoly = d2.polyW.multiply(this.polyW);
                JgclRealPolynomial workPoly4 = workPoly.multiply(d0WPoly[klm]);
                workPoly = workPoly2.subtract(workPoly3).multiply(2.0);
                d2Poly[klm] = workPoly1.subtract(workPoly).subtract(workPoly4);
                ++klm;
            }
        }
        JgclRealPolynomial[] crossPoly = new JgclRealPolynomial[3];
        int ijk = 0;
        while (ijk < 3) {
            JgclRealPolynomial crossPoly1 = d1Poly[(ijk + 1) % 3].multiply(d2Poly[(ijk + 2) % 3]);
            JgclRealPolynomial crossPoly2 = d1Poly[(ijk + 2) % 3].multiply(d2Poly[(ijk + 1) % 3]);
            crossPoly[ijk] = crossPoly1.subtract(crossPoly2);
            ++ijk;
        }
        return crossPoly;
    }

    protected synchronized JgclParametricCurve3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        throw new JgclNotSupported();
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        StringBuffer buf = new StringBuffer();
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        if (this.polyW == null) {
            writer.print(String.valueOf(indent_tab) + "\tpolyX");
            writer.print(" [" + this.polyX.coefficientAt(0));
            int i = 1;
            while (i <= this.polyX.degree()) {
                writer.print(", " + this.polyX.coefficientAt(i));
                ++i;
            }
            writer.println("]");
            writer.print(String.valueOf(indent_tab) + "\tpolyY");
            writer.print(" [" + this.polyY.coefficientAt(0));
            int i2 = 1;
            while (i2 <= this.polyY.degree()) {
                writer.print(", " + this.polyY.coefficientAt(i2));
                ++i2;
            }
            writer.println("]");
            writer.print(String.valueOf(indent_tab) + "\tpolyZ");
            writer.print(" [" + this.polyZ.coefficientAt(0));
            int i3 = 1;
            while (i3 <= this.polyZ.degree()) {
                writer.print(", " + this.polyZ.coefficientAt(i3));
                ++i3;
            }
            writer.println("]");
        } else {
            writer.print(String.valueOf(indent_tab) + "\tpolyWX");
            writer.print(" [" + this.polyX.coefficientAt(0));
            int i = 1;
            while (i <= this.polyX.degree()) {
                writer.print(", " + this.polyX.coefficientAt(i));
                ++i;
            }
            writer.println("]");
            writer.print(String.valueOf(indent_tab) + "\tpolyWY");
            writer.print(" [" + this.polyY.coefficientAt(0));
            int i4 = 1;
            while (i4 <= this.polyY.degree()) {
                writer.print(", " + this.polyY.coefficientAt(i4));
                ++i4;
            }
            writer.println("]");
            writer.print(String.valueOf(indent_tab) + "\tpolyWZ");
            writer.print(" [" + this.polyZ.coefficientAt(0));
            int i5 = 1;
            while (i5 <= this.polyZ.degree()) {
                writer.print(", " + this.polyZ.coefficientAt(i5));
                ++i5;
            }
            writer.println("]");
            writer.print(String.valueOf(indent_tab) + "\tpolyW");
            writer.print(" [" + this.polyW.coefficientAt(0));
            int i6 = 1;
            while (i6 <= this.polyW.degree()) {
                writer.print(", " + this.polyW.coefficientAt(i6));
                ++i6;
            }
            writer.println("]");
        }
    }

    private static void test1(String[] argv) throws JgclInvalidArgumentValue {
        JgclPoint3D[] cntrlPoints = new JgclPoint3D[]{new JgclCartesianPoint3D(0.0, 0.0, 0.0), new JgclCartesianPoint3D(10.0, 10.0, 1.0), new JgclCartesianPoint3D(20.0, 10.0, -1.0), new JgclCartesianPoint3D(30.0, 0.0, 0.0)};
        JgclRealPolynomial[] polynomial = new JgclPureBezierCurve3D(cntrlPoints).polynomial(true);
        JgclPolynomialCurve3D polynomialCurve = new JgclPolynomialCurve3D(polynomial[0], polynomial[1], polynomial[2]);
        int i = 0;
        while (i <= 100) {
            double param = 0.01 * (double)i;
            JgclPoint3D crd = polynomialCurve.coordinates(param);
            JgclVector3D tng = polynomialCurve.tangentVector(param);
            JgclCurveCurvature3D crv = polynomialCurve.curvature(param);
            System.out.println(String.valueOf(crd.x()) + "\t" + crd.y() + "\t" + crd.z() + "\t" + tng.x() + "\t" + tng.y() + "\t" + tng.z() + "\t" + crv.curvature());
            ++i;
        }
    }

    private static void test2(String[] argv) throws JgclInvalidArgumentValue {
        JgclPoint3D[] cntrlPoints = new JgclPoint3D[]{new JgclCartesianPoint3D(0.0, 0.0, 0.0), new JgclCartesianPoint3D(10.0, 10.0, 1.0), new JgclCartesianPoint3D(20.0, 10.0, -1.0), new JgclCartesianPoint3D(30.0, 0.0, 0.0)};
        double[] weights = new double[]{1.0, 1.0, 1.0, 1.0};
        JgclRealPolynomial[] polynomial = new JgclPureBezierCurve3D(cntrlPoints, weights).polynomial(false);
        JgclPolynomialCurve3D polynomialCurve = new JgclPolynomialCurve3D(polynomial[0], polynomial[1], polynomial[2], polynomial[3]);
        int i = 0;
        while (i <= 100) {
            double param = 0.01 * (double)i;
            JgclPoint3D crd = polynomialCurve.coordinates(param);
            JgclVector3D tng = polynomialCurve.tangentVector(param);
            JgclCurveCurvature3D crv = polynomialCurve.curvature(param);
            System.out.println(String.valueOf(crd.x()) + "\t" + crd.y() + "\t" + crd.z() + "\t" + tng.x() + "\t" + tng.y() + "\t" + tng.z() + "\t" + crv.curvature());
            ++i;
        }
    }

    public static void main(String[] argv) {
        try {
            JgclPolynomialCurve3D.test2(argv);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {}
    }

    private final class 1
    implements JgclRealFunctionWithOneVariable {
        public double evaluate(double parameter) {
            return JgclPolynomialCurve3D.this.tangentVector(parameter).length();
        }

        /* synthetic */ 1() {
        }
    }
}

