/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnGeometry3D;

public class JgclPointOnPoint3D
extends JgclPointOnGeometry3D {
    private JgclPoint3D basisPoint;

    JgclPointOnPoint3D(JgclPoint3D basisPoint, boolean doCheck) {
        this(null, basisPoint, doCheck);
    }

    JgclPointOnPoint3D(JgclPoint3D point, JgclPoint3D basisPoint, boolean doCheck) {
        super(point);
        if (doCheck) {
            if (basisPoint == null) {
                throw new JgclInvalidArgumentValue();
            }
            if (point != null && !point.identical(basisPoint)) {
                throw new JgclInvalidArgumentValue();
            }
        }
        this.basisPoint = basisPoint;
    }

    public JgclPointOnPoint3D(JgclPoint3D basisPoint) {
        this(null, basisPoint);
    }

    public JgclPointOnPoint3D(JgclPoint3D point, JgclPoint3D basisPoint) {
        this(point, basisPoint, true);
    }

    public JgclGeometry geometry() {
        return this.basisPoint();
    }

    public JgclPoint3D basisPoint() {
        return this.basisPoint;
    }

    JgclPoint3D coordinates() {
        return this.basisPoint();
    }

    protected synchronized JgclPoint3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D tPoint = this.point();
        if (tPoint != null) {
            tPoint = tPoint.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclPoint3D tBasisPoint = this.basisPoint.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclPointOnPoint3D(tPoint, tBasisPoint, false);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        this.basisPoint.output(writer, indent + 2);
        writer.println("End");
    }
}

