/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnGeometry2D;

public class JgclPointOnPoint2D
extends JgclPointOnGeometry2D {
    private JgclPoint2D basisPoint;

    JgclPointOnPoint2D(JgclPoint2D basisPoint, boolean doCheck) {
        this(null, basisPoint, doCheck);
    }

    JgclPointOnPoint2D(JgclPoint2D point, JgclPoint2D basisPoint, boolean doCheck) {
        super(point);
        if (doCheck) {
            if (basisPoint == null) {
                throw new JgclInvalidArgumentValue();
            }
            if (point != null && !point.identical(basisPoint)) {
                throw new JgclInvalidArgumentValue();
            }
        }
        this.basisPoint = basisPoint;
    }

    public JgclPointOnPoint2D(JgclPoint2D basisPoint) {
        this(null, basisPoint);
    }

    public JgclPointOnPoint2D(JgclPoint2D point, JgclPoint2D basisPoint) {
        this(point, basisPoint, true);
    }

    public JgclGeometry geometry() {
        return this.basisPoint();
    }

    public JgclPoint2D basisPoint() {
        return this.basisPoint;
    }

    JgclPoint2D coordinates() {
        return this.basisPoint();
    }

    protected synchronized JgclPoint2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint2D tPoint = this.point();
        if (tPoint != null) {
            tPoint = tPoint.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclPoint2D tBasisPoint = this.basisPoint.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclPointOnPoint2D(tPoint, tBasisPoint, false);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        this.basisPoint.output(writer, indent + 2);
        writer.println("End");
    }
}

