/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterRangeOnCurve2D;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnGeometry2D;

public class JgclPointOnCurve2D
extends JgclPointOnGeometry2D
implements JgclParameterRangeOnCurve2D {
    private JgclParametricCurve2D basisCurve;
    private double parameter;

    JgclPointOnCurve2D(JgclParametricCurve2D basisCurve, double parameter, boolean doCheck) {
        this(null, basisCurve, parameter, doCheck);
    }

    JgclPointOnCurve2D(JgclPoint2D point, JgclParametricCurve2D basisCurve, double parameter, boolean doCheck) {
        super(point);
        if (doCheck) {
            JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
            double pTol = condition.getToleranceForParameter();
            if (basisCurve == null) {
                throw new JgclInvalidArgumentValue("basisCurve is null.");
            }
            basisCurve.checkValidity(parameter);
            if (point != null && !point.identical(basisCurve.coordinates(parameter))) {
                throw new JgclInvalidArgumentValue("point is not consistent with parameter.");
            }
        }
        this.basisCurve = basisCurve;
        this.parameter = parameter;
    }

    public JgclPointOnCurve2D(JgclParametricCurve2D basisCurve, double parameter) {
        this(null, basisCurve, parameter);
    }

    public JgclPointOnCurve2D(JgclPoint2D point, JgclParametricCurve2D basisCurve, double parameter) {
        this(point, basisCurve, parameter, true);
    }

    public JgclGeometry geometry() {
        return this.basisCurve();
    }

    public JgclParametricCurve2D basisCurve() {
        return this.basisCurve;
    }

    public double parameter() {
        return this.parameter;
    }

    JgclPoint2D coordinates() {
        JgclPoint2D coord;
        try {
            coord = this.basisCurve.coordinates(this.parameter);
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        return coord;
    }

    public boolean isPoint() {
        return true;
    }

    public boolean isSection() {
        return false;
    }

    boolean parametricallyIdentical(JgclPointOnCurve2D mate) {
        if (this.basisCurve() != mate.basisCurve()) {
            return false;
        }
        if (!this.identical(mate)) {
            return false;
        }
        return this.basisCurve().identicalParameter(this.parameter(), mate.parameter());
    }

    protected synchronized JgclPoint2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint2D tPoint = this.point();
        if (tPoint != null) {
            tPoint = tPoint.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclParametricCurve2D tBasisCurve = this.basisCurve.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclPointOnCurve2D(tPoint, tBasisCurve, this.parameter, false);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tpoint");
        this.coordinates().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tbasisCurve");
        this.basisCurve.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tparameter\t" + this.parameter);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

