/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclOpenCurve;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;

public abstract class JgclPoint2D
extends JgclPoint {
    public static final JgclPoint2D origin = new JgclCartesianPoint2D(0.0, 0.0);

    protected JgclPoint2D() {
    }

    public int dimension() {
        return 2;
    }

    public boolean is2D() {
        return true;
    }

    public abstract double x();

    public abstract double y();

    public JgclPoint2D add(JgclVector2D vector) {
        return new JgclCartesianPoint2D(this.x() + vector.x(), this.y() + vector.y());
    }

    public JgclPoint2D subtract(JgclVector2D vector) {
        return new JgclCartesianPoint2D(this.x() - vector.x(), this.y() - vector.y());
    }

    public JgclVector2D subtract(JgclPoint2D mate) {
        return new JgclLiteralVector2D(this.x() - mate.x(), this.y() - mate.y());
    }

    public JgclPoint2D multiply(double scale) {
        return new JgclCartesianPoint2D(this.x() * scale, this.y() * scale);
    }

    public JgclPoint2D divide(double scale) {
        return new JgclCartesianPoint2D(this.x() / scale, this.y() / scale);
    }

    public JgclPoint2D linearInterpolate(JgclPoint2D mate, double weightForThis) {
        double weightForMate = 1.0 - weightForThis;
        return new JgclCartesianPoint2D(this.x() * weightForThis + mate.x() * weightForMate, this.y() * weightForThis + mate.y() * weightForMate);
    }

    public JgclPoint2D midPoint(JgclPoint2D mate) {
        return this.linearInterpolate(mate, 0.5);
    }

    public boolean identical(JgclPoint2D mate) {
        return this.distance2(mate) < this.getToleranceForDistance2();
    }

    public JgclVector2D toVector2D() {
        return new JgclLiteralVector2D(this.x(), this.y());
    }

    public JgclPointOnCurve2D[] project(JgclParametricCurve2D mate) throws JgclIndefiniteSolution {
        return mate.projectFrom(this);
    }

    public boolean isOn(JgclParametricCurve2D mate) {
        JgclPointOnCurve2D prjp = mate.nearestProjectFrom(this);
        return prjp != null && this.identical(prjp);
    }

    public boolean isIn(JgclParametricCurve2D mate) throws JgclOpenCurve {
        if (!mate.isClosed()) {
            throw new JgclOpenCurve("mate is open");
        }
        if (this.isOn(mate)) {
            return true;
        }
        return this.pointIsInsideOf(mate);
    }

    public boolean isInsideOf(JgclParametricCurve2D mate) throws JgclOpenCurve {
        if (!mate.isClosed()) {
            throw new JgclOpenCurve("mate is open");
        }
        if (this.isOn(mate)) {
            return false;
        }
        return this.pointIsInsideOf(mate);
    }

    private boolean pointIsInsideOf(JgclParametricCurve2D mate) throws JgclOpenCurve {
        int inside = 0;
        int outside = 0;
        int i = 0;
        while (i < 3) {
            JgclLine2D lin = new JgclLine2D(this, new JgclLiteralVector2D(1.0, (double)i * 0.1));
            try {
                JgclIntersectionPoint2D[] ints = lin.intersect(mate);
                int nPositiveInts = 0;
                int j = 0;
                while (j < ints.length) {
                    if (ints[j].pointOnCurve1().parameter() > 0.0) {
                        ++nPositiveInts;
                    }
                    ++j;
                }
                if (nPositiveInts % 2 == 1) {
                    ++inside;
                } else {
                    ++outside;
                }
            }
            catch (JgclIndefiniteSolution jgclIndefiniteSolution) {}
            ++i;
        }
        return inside > outside;
    }

    public double distance(JgclPoint2D mate) {
        return Math.sqrt(this.distance2(mate));
    }

    public double distance2(JgclPoint2D mate) {
        double dx = this.x() - mate.x();
        double dy = this.y() - mate.y();
        return dx * dx + dy * dy;
    }

    public JgclPoint2D longestPoint(JgclPoint2D[] pnts) {
        return this.longestPoint(pnts, 0, pnts.length - 1);
    }

    public JgclPoint2D longestPoint(JgclPoint2D[] pnts, int start, int end) {
        if (start < 0 || end >= pnts.length) {
            throw new JgclInvalidArgumentValue();
        }
        double max_dist = this.distance2(pnts[start]);
        int index = start;
        int i = start + 1;
        while (i <= end) {
            double d;
            double dist = this.distance2(pnts[i]);
            if (d > max_dist) {
                max_dist = dist;
                index = i;
            }
            ++i;
        }
        return pnts[index];
    }

    static JgclVector2D collinear(JgclPoint2D[] points, int start, int end) {
        if (start < 0 || points.length <= end) {
            throw new JgclInvalidArgumentValue();
        }
        if (end - start <= 1) {
            return JgclVector2D.zeroVector;
        }
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        double dTol2 = dTol * dTol;
        JgclPoint2D basisPoint = points[start];
        JgclPoint2D longestPoint = basisPoint.longestPoint(points, start + 1, end);
        JgclVector2D uax = longestPoint.subtract(basisPoint);
        if (uax.norm() < dTol2) {
            return JgclVector2D.zeroVector;
        }
        uax = uax.unitized();
        int i = start + 1;
        while (i <= end) {
            JgclVector2D evec = points[i].subtract(points[start]);
            double ecrs = evec.zOfCrossProduct(uax);
            if (ecrs * ecrs > dTol2) {
                return null;
            }
            ++i;
        }
        return uax;
    }

    public JgclPoint2D center(JgclPoint2D pnt2, JgclPoint2D pnt3) {
        JgclVector2D vec3;
        if (pnt2 == null || pnt3 == null) {
            throw new JgclInvalidArgumentValue("There is a null argument.");
        }
        if (this.identical(pnt2) || this.identical(pnt3) || pnt2.identical(pnt3)) {
            throw new JgclInvalidArgumentValue("Points are collinear.");
        }
        JgclVector2D vec2 = this.subtract(pnt2);
        if (vec2.identicalDirection(vec3 = this.subtract(pnt3))) {
            throw new JgclInvalidArgumentValue("Points are collinear.");
        }
        JgclLine2D line2 = new JgclLine2D(this.linearInterpolate(pnt2, 0.5), vec2.verticalVector());
        JgclLine2D line3 = new JgclLine2D(this.linearInterpolate(pnt3, 0.5), vec3.verticalVector());
        try {
            JgclIntersectionPoint2D isec = line2.intersect1Line(line3);
            return isec.coordinates();
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    public static JgclPoint2D center(JgclPoint2D pnt1, JgclPoint2D pnt2, JgclPoint2D pnt3) {
        if (pnt1 == null) {
            throw new JgclInvalidArgumentValue("There is a null argument.");
        }
        return pnt1.center(pnt2, pnt3);
    }

    JgclPoint3D to3D() {
        return new JgclCartesianPoint3D(this.x(), this.y(), 0.0);
    }

    JgclPoint3D to3D(double z) {
        return new JgclCartesianPoint3D(this.x(), this.y(), z);
    }

    JgclCartesianPoint2D literal() {
        return new JgclCartesianPoint2D(this.x(), this.y());
    }

    protected abstract JgclPoint2D doTransformBy(boolean var1, JgclCartesianTransformationOperator2D var2, Hashtable var3);

    public synchronized JgclPoint2D transformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        if (transformedGeometries == null) {
            return this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclPoint2D transformed = (JgclPoint2D)transformedGeometries.get(this);
        if (transformed == null) {
            transformed = this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
            transformedGeometries.put(this, transformed);
        }
        return transformed;
    }

    public synchronized JgclPoint2D transformBy(JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(false, transformationOperator, transformedGeometries);
    }

    public synchronized JgclPoint2D reverseTransformBy(JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(true, transformationOperator, transformedGeometries);
    }

    public static JgclPoint2D[] transform(JgclPoint2D[] points, boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint2D[] tPoints = new JgclPoint2D[points.length];
        int i = 0;
        while (i < points.length) {
            tPoints[i] = points[i].transformBy(reverseTransform, transformationOperator, transformedGeometries);
            ++i;
        }
        return tPoints;
    }

    public static JgclPoint2D[] transform(JgclPoint2D[] points, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        return JgclPoint2D.transform(points, false, transformationOperator, transformedGeometries);
    }

    public static JgclPoint2D[] reverseTransform(JgclPoint2D[] points, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        return JgclPoint2D.transform(points, true, transformationOperator, transformedGeometries);
    }

    public static JgclCartesianPoint2D of(double x, double y) {
        return new JgclCartesianPoint2D(x, y);
    }

    public static JgclCartesianPoint2D of(double[] components) {
        return new JgclCartesianPoint2D(components);
    }
}

