/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclCartesianPoint1D;
import jp.go.ipa.jgcl.JgclLiteralVector1D;
import jp.go.ipa.jgcl.JgclPoint;
import jp.go.ipa.jgcl.JgclVector1D;

public abstract class JgclPoint1D
extends JgclPoint {
    public static final JgclPoint1D origin = new JgclCartesianPoint1D(0.0);

    protected JgclPoint1D() {
    }

    public int dimension() {
        return 1;
    }

    public boolean is1D() {
        return true;
    }

    public abstract double x();

    public JgclPoint1D add(JgclVector1D vector) {
        return new JgclCartesianPoint1D(this.x() + vector.x());
    }

    public JgclPoint1D subtract(JgclVector1D vector) {
        return new JgclCartesianPoint1D(this.x() - vector.x());
    }

    public JgclPoint1D multiply(double scale) {
        return new JgclCartesianPoint1D(this.x() * scale);
    }

    public JgclPoint1D divide(double scale) {
        return new JgclCartesianPoint1D(this.x() / scale);
    }

    public JgclPoint1D linearInterpolate(JgclPoint1D mate, double weightForThis) {
        return new JgclCartesianPoint1D(this.x() * weightForThis + mate.x() * (1.0 - weightForThis));
    }

    public JgclPoint1D midPoint(JgclPoint1D mate) {
        return this.linearInterpolate(mate, 0.5);
    }

    public boolean identical(JgclPoint1D mate) {
        return Math.abs(this.x() - mate.x()) < this.getToleranceForDistance();
    }

    public JgclVector1D toVector1D() {
        return new JgclLiteralVector1D(this.x());
    }

    public static JgclCartesianPoint1D of(double x) {
        return new JgclCartesianPoint1D(x);
    }
}

