/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclBoundedCurve2D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCommonNormal2D;
import jp.go.ipa.jgcl.JgclCommonTangent2D;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveCurvature2D;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclFilletObject2D;
import jp.go.ipa.jgcl.JgclFiltCrvCrv2D;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclMachineEpsilon;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;

public abstract class JgclParametricCurve2D
extends JgclParametricCurve {
    static final int LINE_2D = 1;
    static final int BOUNDED_LINE_2D = 2;
    static final int CIRCLE_2D = 10;
    static final int ELLIPSE_2D = 11;
    static final int HYPERBOLA_2D = 12;
    static final int PARABOLA_2D = 13;
    static final int POLYLINE_2D = 20;
    static final int BSPLINE_CURVE_2D = 21;
    static final int PURE_BEZIER_CURVE_2D = 22;
    static final int TRIMMED_CURVE_2D = 23;
    static final int COMPOSITE_CURVE_2D = 24;
    static final int COMPOSITE_CURVE_SEGMENT_2D = 25;
    static final int POLYNOMIAL_CURVE_2D = 30;

    protected JgclParametricCurve2D() {
    }

    public abstract JgclPoint2D coordinates(double var1);

    public abstract JgclVector2D tangentVector(double var1);

    public abstract JgclCurveCurvature2D curvature(double var1);

    public abstract JgclCurveDerivative2D evaluation(double var1);

    public abstract JgclPointOnCurve2D[] singular() throws JgclIndefiniteSolution;

    public abstract JgclPointOnCurve2D[] inflexion() throws JgclIndefiniteSolution;

    protected JgclPointOnCurve2D checkProjection(double Bparam, JgclPoint2D p, double dTol2) {
        JgclCurveCurvature2D Bcurv;
        double dist_from_Bnrml;
        Object result = null;
        if (!this.isValid(Bparam)) {
            return null;
        }
        JgclPoint2D Bpnt = this.coordinates(Bparam);
        JgclVector2D Bpnt2A = p.subtract(Bpnt);
        double norm = Bpnt2A.norm();
        if (norm > dTol2 && (dist_from_Bnrml = Bpnt2A.zOfCrossProduct((Bcurv = this.curvature(Bparam)).normal())) * dist_from_Bnrml > dTol2) {
            return null;
        }
        try {
            return new JgclPointOnCurve2D(Bpnt, this, Bparam, false);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean identicalParameter(double own_prm1, double own_prm2) {
        boolean bl;
        block9: {
            boolean bl2;
            block8: {
                boolean bl3;
                block7: {
                    boolean bl4;
                    block6: {
                        this.checkValidity(own_prm1);
                        this.checkValidity(own_prm2);
                        JgclPoint2D o1_crd = this.coordinates(own_prm1);
                        JgclPoint2D o2_crd = this.coordinates(own_prm2);
                        if (!o1_crd.identical(o2_crd)) {
                            return false;
                        }
                        JgclParameterDomain pdmn = this.parameterDomain();
                        double increase = 0.0;
                        double pTol = pdmn.isInfinite() ? JgclMachineEpsilon.DOUBLE : ((increase = Math.abs(pdmn.section().increase())) < 1.0 ? JgclMachineEpsilon.DOUBLE * increase : JgclMachineEpsilon.DOUBLE);
                        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
                        double savedPTol = condition.getToleranceForParameter();
                        condition.makeCopyWithToleranceForParameter(pTol).push();
                        try {
                            JgclParameterSection pint = own_prm1 > own_prm2 ? new JgclParameterSection(own_prm2, own_prm1 - own_prm2) : new JgclParameterSection(own_prm1, own_prm2 - own_prm1);
                            double leng = this.length(pint);
                            double dTol = condition.getToleranceForDistance();
                            if (leng < dTol) {
                                bl4 = true;
                                Object var20_17 = null;
                                break block6;
                            }
                            if (!pdmn.isPeriodic()) {
                                bl3 = false;
                                break block7;
                            }
                            double start = own_prm1 > own_prm2 ? own_prm1 : own_prm2;
                            pint = new JgclParameterSection(start, increase -= pint.increase());
                            leng = this.length(pint);
                            if (leng < dTol) {
                                bl2 = true;
                                break block8;
                            }
                            bl = false;
                            break block9;
                        }
                        catch (Throwable throwable) {
                            Object var20_21 = null;
                            JgclConditionOfOperation.pop();
                            throw throwable;
                        }
                    }
                    JgclConditionOfOperation.pop();
                    return bl4;
                }
                Object var20_18 = null;
                JgclConditionOfOperation.pop();
                return bl3;
            }
            Object var20_19 = null;
            JgclConditionOfOperation.pop();
            return bl2;
        }
        Object var20_20 = null;
        JgclConditionOfOperation.pop();
        return bl;
    }

    public abstract JgclPointOnCurve2D[] projectFrom(JgclPoint2D var1) throws JgclIndefiniteSolution;

    public abstract JgclPolyline2D toPolyline(JgclParameterSection var1, JgclToleranceForDistance var2);

    public abstract JgclBsplineCurve2D toBsplineCurve(JgclParameterSection var1);

    public abstract JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D var1) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint2D[] intersect(JgclLine2D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint2D[] intersect(JgclCircle2D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint2D[] intersect(JgclEllipse2D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint2D[] intersect(JgclHyperbola2D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint2D[] intersect(JgclParabola2D var1, boolean var2) throws JgclIndefiniteSolution;

    abstract JgclIntersectionPoint2D[] intersect(JgclPolyline2D var1, boolean var2);

    abstract JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D var1, boolean var2);

    abstract JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D var1, boolean var2);

    abstract JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D var1, boolean var2);

    abstract JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D var1, boolean var2);

    abstract JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D var1, boolean var2);

    public abstract JgclBsplineCurve2D offsetByBsplineCurve(JgclParameterSection var1, double var2, int var4, JgclToleranceForDistance var5);

    public JgclBoundedCurve2D offsetByBoundedCurve(JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tol) {
        return this.offsetByBsplineCurve(pint, magni, side, tol);
    }

    public JgclFilletObject2D[] fillet(JgclParameterSection pint1, int side1, JgclParametricCurve2D mate, JgclParameterSection pint2, int side2, double radius) throws JgclIndefiniteSolution {
        return JgclFiltCrvCrv2D.fillet(this, pint1, side1, mate, pint2, side2, radius);
    }

    public abstract JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D var1);

    public abstract JgclCommonNormal2D[] commonNormal(JgclParametricCurve2D var1);

    public int dimension() {
        return 2;
    }

    public boolean is2D() {
        return true;
    }

    abstract int type();

    public JgclPointOnCurve2D nearestProjectFrom(JgclPoint2D pnt) {
        JgclPointOnCurve2D[] proj;
        try {
            proj = this.projectFrom(pnt);
        }
        catch (JgclIndefiniteSolution e) {
            proj = new JgclPointOnCurve2D[]{(JgclPointOnCurve2D)e.suitable()};
        }
        if (proj.length == 0) {
            return null;
        }
        double dist = proj[0].distance2(pnt);
        int idx = 0;
        int i = 1;
        while (i < proj.length) {
            double dist2 = proj[i].distance2(pnt);
            if (dist2 < dist) {
                dist = dist2;
                idx = i;
            }
            ++i;
        }
        return proj[idx];
    }

    public JgclPointOnCurve2D nearestProjectWithDistanceFrom(JgclPoint2D pnt, double distance) {
        JgclPointOnCurve2D[] proj;
        try {
            proj = this.projectFrom(pnt);
        }
        catch (JgclIndefiniteSolution e) {
            proj = new JgclPointOnCurve2D[]{(JgclPointOnCurve2D)e.suitable()};
        }
        if (proj.length == 0) {
            return null;
        }
        double diff = Math.abs(distance - proj[0].distance(pnt));
        int idx = 0;
        int i = 1;
        while (i < proj.length) {
            double diff2 = Math.abs(distance - proj[i].distance(pnt));
            if (diff2 < diff) {
                diff = diff2;
                idx = i;
            }
            ++i;
        }
        return proj[idx];
    }

    public double pointToParameter(JgclPoint2D pnt) {
        JgclPointOnCurve2D proj = this.nearestProjectFrom(pnt);
        if (proj != null && pnt.identical(proj)) {
            return proj.parameter();
        }
        if (this.isFinite() && this.isOpen()) {
            double param = this.parameterDomain().section().lower();
            if (pnt.identical(new JgclPointOnCurve2D(this, param))) {
                return param;
            }
            param = this.parameterDomain().section().upper();
            if (pnt.identical(new JgclPointOnCurve2D(this, param))) {
                return param;
            }
        }
        if (this.hasPolyline()) {
            JgclBoundedCurve2D bounded = (JgclBoundedCurve2D)this;
            JgclPolyline2D polyline = bounded.toPolyline(this.getToleranceForDistanceAsObject());
            int i = 0;
            while (i < polyline.nPoints()) {
                JgclPointOnCurve2D pos = (JgclPointOnCurve2D)polyline.pointAt(i);
                if (pnt.identical(pos)) {
                    return pos.parameter();
                }
                ++i;
            }
        }
        throw new JgclInvalidArgumentValue();
    }

    int parameterValidity(double param) {
        JgclParameterDomain pDomain = this.parameterDomain();
        if (pDomain.isInfinite() || pDomain.isPeriodic()) {
            return 0;
        }
        double lower = pDomain.section().lower();
        double upper = pDomain.section().upper();
        double deltaDenom = 100.0;
        double delta = (upper - lower) / deltaDenom;
        double tol4Norm = this.getToleranceForDistance2();
        double tangentNorm = 0.0;
        if (param < lower) {
            double endParam = lower;
            while (endParam < upper) {
                JgclVector2D tangentVector = this.tangentVector(endParam);
                tangentNorm = tangentVector.norm();
                if (tangentNorm > tol4Norm) break;
                endParam += delta;
            }
            if (!(tangentNorm > tol4Norm)) {
                return 3;
            }
            double tol4Param = this.getToleranceForDistance() / Math.sqrt(tangentNorm);
            if (lower - param < tol4Param) {
                return 1;
            }
            return 3;
        }
        if (upper < param) {
            double endParam = upper;
            while (endParam > lower) {
                JgclVector2D tangentVector = this.tangentVector(endParam);
                tangentNorm = tangentVector.norm();
                if (tangentNorm > tol4Norm) break;
                endParam -= delta;
            }
            if (!(tangentNorm > tol4Norm)) {
                return 3;
            }
            double tol4Param = this.getToleranceForDistance() / Math.sqrt(tangentNorm);
            if (param - upper < tol4Param) {
                return 2;
            }
            return 3;
        }
        return 0;
    }

    protected abstract JgclParametricCurve2D doTransformBy(boolean var1, JgclCartesianTransformationOperator2D var2, Hashtable var3);

    public synchronized JgclParametricCurve2D transformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        if (transformedGeometries == null) {
            return this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclParametricCurve2D transformed = (JgclParametricCurve2D)transformedGeometries.get(this);
        if (transformed == null) {
            transformed = this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
            transformedGeometries.put(this, transformed);
        }
        return transformed;
    }

    public synchronized JgclParametricCurve2D transformBy(JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(false, transformationOperator, transformedGeometries);
    }

    public synchronized JgclParametricCurve2D reverseTransformBy(JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(true, transformationOperator, transformedGeometries);
    }

    protected boolean hasPolyline() {
        return false;
    }

    protected boolean isComposedOfOnlyPolylines() {
        return false;
    }
}

