/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Enumeration;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclDimensionsMismatch;
import jp.go.ipa.jgcl.JgclNullArgument;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterRangeOnCurve2D;
import jp.go.ipa.jgcl.JgclParameterRangeOnCurve3D;
import jp.go.ipa.jgcl.JgclParameterSectionOnCurve2D;
import jp.go.ipa.jgcl.JgclParameterSectionOnCurve3D;
import jp.go.ipa.jgcl.JgclParametricCurve;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclPoint;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;

class JgclParameterRangeOnCurveList {
    int dimension;
    JgclParametricCurve curve;
    JgclParameterDomain parameterDomain;
    JgclToleranceForDistance dTol;
    Vector listOfPoints;
    Vector listOfSections;
    private static final int PARAMETERS_NOT_IDENTICAL = 0;
    private static final int PARAMETERS_IDENTICAL = 1;
    private static final int PARAMETERS_CROSSBOUNDARY = 2;

    JgclParameterRangeOnCurveList(JgclParametricCurve curve) {
        if (curve == null) {
            throw new JgclNullArgument();
        }
        this.dimension = curve.dimension();
        this.curve = curve;
        this.parameterDomain = curve.parameterDomain();
        JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
        this.dTol = cond.getToleranceForDistanceAsObject();
        this.listOfPoints = new Vector();
        this.listOfSections = new Vector();
    }

    private double getToleranceForParameter(JgclParametricCurve curve, double param) {
        if (this.dimension == 2) {
            return this.dTol.toToleranceForParameter((JgclParametricCurve2D)curve, param).value();
        }
        return this.dTol.toToleranceForParameter((JgclParametricCurve3D)curve, param).value();
    }

    void addPoint(PointInfo thePoint) {
        Enumeration e = this.listOfPoints.elements();
        while (e.hasMoreElements()) {
            if (!thePoint.isIdenticalWith((PointInfo)e.nextElement())) continue;
            return;
        }
        this.listOfPoints.addElement(thePoint);
    }

    void addAsPoint(JgclPoint coord, double param) {
        this.addPoint(new PointInfo(coord, param));
    }

    void addAsPoint(JgclPoint coord, double param, double pTol) {
        this.addPoint(new PointInfo(coord, param, pTol));
    }

    void removePointsContainedInSection() {
        Vector clonedList = (Vector)this.listOfPoints.clone();
        this.listOfPoints.removeAllElements();
        Enumeration e1 = clonedList.elements();
        while (e1.hasMoreElements()) {
            PointInfo point = (PointInfo)e1.nextElement();
            boolean contained = false;
            Enumeration e2 = this.listOfSections.elements();
            while (e2.hasMoreElements()) {
                if (!point.isContainedIn((SectionInfo)e2.nextElement())) continue;
                contained = true;
                break;
            }
            if (contained) continue;
            this.listOfPoints.addElement(point);
        }
    }

    void addSection(SectionInfo theSection) {
        while (true) {
            SectionInfo mergedMate = null;
            Enumeration e = this.listOfSections.elements();
            while (e.hasMoreElements()) {
                SectionInfo mate = (SectionInfo)e.nextElement();
                if (!theSection.mergeIfConnectWith(mate)) continue;
                mergedMate = mate;
                break;
            }
            if (mergedMate == null) break;
            this.listOfSections.removeElement(mergedMate);
        }
        this.listOfSections.addElement(theSection);
    }

    void addAsSection(double headParam, double increaseParam) {
        this.addSection(new SectionInfo(headParam, increaseParam));
    }

    void addAsSection(double headParam, double increaseParam, double headPTol, double tailPTol) {
        this.addSection(new SectionInfo(headParam, increaseParam, headPTol, tailPTol));
    }

    void removeSectionsContainedInOtherSection() {
        Vector clonedList = (Vector)this.listOfSections.clone();
        this.listOfSections.removeAllElements();
        Enumeration e1 = clonedList.elements();
        while (e1.hasMoreElements()) {
            SectionInfo section = (SectionInfo)e1.nextElement();
            boolean contained = false;
            Enumeration e2 = clonedList.elements();
            while (e2.hasMoreElements()) {
                if (!section.isContainedIn((SectionInfo)e2.nextElement())) continue;
                contained = true;
                break;
            }
            if (contained) continue;
            this.listOfSections.addElement(section);
        }
    }

    JgclParameterRangeOnCurve2D[] toJgclParameterRangeOnCurve2DArray() {
        if (this.dimension != 2) {
            throw new JgclDimensionsMismatch();
        }
        int totalSize = this.listOfPoints.size() + this.listOfSections.size();
        JgclParameterRangeOnCurve2D[] result = new JgclParameterRangeOnCurve2D[totalSize];
        int i = 0;
        Enumeration e = this.listOfPoints.elements();
        while (e.hasMoreElements()) {
            PointInfo point = (PointInfo)e.nextElement();
            JgclParameterRangeOnCurve2D jgclParameterRangeOnCurve2D = result[i++] = point.coord == null ? new JgclPointOnCurve2D((JgclParametricCurve2D)this.curve, point.param, false) : new JgclPointOnCurve2D((JgclPoint2D)point.coord, (JgclParametricCurve2D)this.curve, point.param, false);
        }
        Enumeration e2 = this.listOfSections.elements();
        while (e2.hasMoreElements()) {
            SectionInfo ovlp = (SectionInfo)e2.nextElement();
            result[i++] = new JgclParameterSectionOnCurve2D((JgclParametricCurve2D)this.curve, ovlp.headPoint.param, ovlp.computeIncrease(), false);
        }
        return result;
    }

    JgclPointOnCurve2D[] toJgclPointOnCurve2DArray() {
        if (this.dimension != 2) {
            throw new JgclDimensionsMismatch();
        }
        int totalSize = this.listOfPoints.size() + this.listOfSections.size() * 2;
        JgclPointOnCurve2D[] result = new JgclPointOnCurve2D[totalSize];
        int i = 0;
        Enumeration e = this.listOfPoints.elements();
        while (e.hasMoreElements()) {
            PointInfo point = (PointInfo)e.nextElement();
            JgclPointOnCurve2D jgclPointOnCurve2D = result[i++] = point.coord == null ? new JgclPointOnCurve2D((JgclParametricCurve2D)this.curve, point.param, false) : new JgclPointOnCurve2D((JgclPoint2D)point.coord, (JgclParametricCurve2D)this.curve, point.param, false);
        }
        Enumeration e2 = this.listOfSections.elements();
        while (e2.hasMoreElements()) {
            SectionInfo ovlp = (SectionInfo)e2.nextElement();
            result[i++] = new JgclPointOnCurve2D((JgclParametricCurve2D)this.curve, ovlp.headPoint.param, false);
            result[i++] = new JgclPointOnCurve2D((JgclParametricCurve2D)this.curve, ovlp.tailPoint.param, false);
        }
        return result;
    }

    JgclParameterRangeOnCurve3D[] toJgclParameterRangeOnCurve3DArray() {
        if (this.dimension != 3) {
            throw new JgclDimensionsMismatch();
        }
        int totalSize = this.listOfPoints.size() + this.listOfSections.size();
        JgclParameterRangeOnCurve3D[] result = new JgclParameterRangeOnCurve3D[totalSize];
        int i = 0;
        Enumeration e = this.listOfPoints.elements();
        while (e.hasMoreElements()) {
            PointInfo point = (PointInfo)e.nextElement();
            JgclParameterRangeOnCurve3D jgclParameterRangeOnCurve3D = result[i++] = point.coord == null ? new JgclPointOnCurve3D((JgclParametricCurve3D)this.curve, point.param, false) : new JgclPointOnCurve3D((JgclPoint3D)point.coord, (JgclParametricCurve3D)this.curve, point.param, false);
        }
        Enumeration e2 = this.listOfSections.elements();
        while (e2.hasMoreElements()) {
            SectionInfo ovlp = (SectionInfo)e2.nextElement();
            result[i++] = new JgclParameterSectionOnCurve3D((JgclParametricCurve3D)this.curve, ovlp.headPoint.param, ovlp.computeIncrease(), false);
        }
        return result;
    }

    JgclPointOnCurve3D[] toJgclPointOnCurve3DArray() {
        if (this.dimension != 3) {
            throw new JgclDimensionsMismatch();
        }
        int totalSize = this.listOfPoints.size() + this.listOfSections.size() * 2;
        JgclPointOnCurve3D[] result = new JgclPointOnCurve3D[totalSize];
        int i = 0;
        Enumeration e = this.listOfPoints.elements();
        while (e.hasMoreElements()) {
            PointInfo point = (PointInfo)e.nextElement();
            JgclPointOnCurve3D jgclPointOnCurve3D = result[i++] = point.coord == null ? new JgclPointOnCurve3D((JgclParametricCurve3D)this.curve, point.param, false) : new JgclPointOnCurve3D((JgclPoint3D)point.coord, (JgclParametricCurve3D)this.curve, point.param, false);
        }
        Enumeration e2 = this.listOfSections.elements();
        while (e2.hasMoreElements()) {
            SectionInfo ovlp = (SectionInfo)e2.nextElement();
            result[i++] = new JgclPointOnCurve3D((JgclParametricCurve3D)this.curve, ovlp.headPoint.param, false);
            result[i++] = new JgclPointOnCurve3D((JgclParametricCurve3D)this.curve, ovlp.tailPoint.param, false);
        }
        return result;
    }

    static Vector extractPoints(JgclParameterRangeOnCurve2D[] array) {
        Vector<JgclParameterRangeOnCurve2D> result = new Vector<JgclParameterRangeOnCurve2D>();
        int i = 0;
        while (i < array.length) {
            if (array[i].isPoint()) {
                result.addElement(array[i]);
            }
            ++i;
        }
        return result;
    }

    static Vector extractSections(JgclParameterRangeOnCurve2D[] array) {
        Vector<JgclParameterRangeOnCurve2D> result = new Vector<JgclParameterRangeOnCurve2D>();
        int i = 0;
        while (i < array.length) {
            if (array[i].isSection()) {
                result.addElement(array[i]);
            }
            ++i;
        }
        return result;
    }

    static Vector extractPoints(JgclParameterRangeOnCurve3D[] array) {
        Vector<JgclParameterRangeOnCurve3D> result = new Vector<JgclParameterRangeOnCurve3D>();
        int i = 0;
        while (i < array.length) {
            if (array[i].isPoint()) {
                result.addElement(array[i]);
            }
            ++i;
        }
        return result;
    }

    static Vector extractSections(JgclParameterRangeOnCurve3D[] array) {
        Vector<JgclParameterRangeOnCurve3D> result = new Vector<JgclParameterRangeOnCurve3D>();
        int i = 0;
        while (i < array.length) {
            if (array[i].isSection()) {
                result.addElement(array[i]);
            }
            ++i;
        }
        return result;
    }

    static /* synthetic */ int access$1() {
        return 0;
    }

    static /* synthetic */ int access$2() {
        return 1;
    }

    static /* synthetic */ int access$3() {
        return 2;
    }

    class ParametricalIdentityOfTwoPoints {
        private int value;

        ParametricalIdentityOfTwoPoints() {
            JgclParameterRangeOnCurveList.this = JgclParameterRangeOnCurveList.this;
            this.setNonIdentical();
        }

        private void setNonIdentical() {
            this.value = JgclParameterRangeOnCurveList.access$1();
        }

        private void setIdentical() {
            this.value |= JgclParameterRangeOnCurveList.access$2();
        }

        private void setCrossBoundary() {
            this.value |= JgclParameterRangeOnCurveList.access$3();
        }

        private boolean isIdentical() {
            return (this.value & JgclParameterRangeOnCurveList.access$2()) != 0;
        }

        private boolean isCrossBoundary() {
            return (this.value & JgclParameterRangeOnCurveList.access$3()) != 0;
        }
    }

    class PointInfo {
        JgclPoint coord;
        double param;
        double pTol;

        PointInfo(JgclPoint coord, double param) {
            JgclParameterRangeOnCurveList.this = JgclParameterRangeOnCurveList.this;
            this.coord = coord;
            this.param = param;
            this.pTol = JgclParameterRangeOnCurveList.this.getToleranceForParameter(JgclParameterRangeOnCurveList.this.curve, param);
        }

        PointInfo(JgclPoint coord, double param, double pTol) {
            JgclParameterRangeOnCurveList.this = JgclParameterRangeOnCurveList.this;
            this.coord = coord;
            this.param = param;
            this.pTol = pTol;
        }

        private ParametricalIdentityOfTwoPoints getParametricalIdentityWith(PointInfo mate) {
            ParametricalIdentityOfTwoPoints result = new ParametricalIdentityOfTwoPoints();
            if (this == mate) {
                result.setIdentical();
                return result;
            }
            double diff = Math.abs(this.param - mate.param);
            double pTol = Math.max(this.pTol, mate.pTol);
            if (JgclParameterRangeOnCurveList.this.parameterDomain.isPeriodic() && Math.abs(diff - JgclParameterRangeOnCurveList.this.parameterDomain.section().absIncrease()) < pTol) {
                result.setCrossBoundary();
            }
            if (result.isCrossBoundary() || diff < pTol) {
                result.setIdentical();
            }
            return result;
        }

        private boolean isIdenticalWith(PointInfo mate) {
            if (this.coord != null && mate.coord != null && (JgclParameterRangeOnCurveList.this.dimension == 2 ? !((JgclPoint2D)this.coord).identical((JgclPoint2D)mate.coord) : !((JgclPoint3D)this.coord).identical((JgclPoint3D)mate.coord))) {
                return false;
            }
            return this.getParametricalIdentityWith(mate).isIdentical();
        }

        boolean isContainedIn(SectionInfo ovlp) {
            double ovlpUpper;
            double ovlpLower;
            if (this.isIdenticalWith(ovlp.headPoint)) {
                return true;
            }
            if (this.isIdenticalWith(ovlp.tailPoint)) {
                return true;
            }
            if (ovlp.headPoint.param < ovlp.tailPoint.param) {
                ovlpLower = ovlp.headPoint.param - ovlp.headPoint.pTol;
                ovlpUpper = ovlp.tailPoint.param + ovlp.tailPoint.pTol;
            } else {
                ovlpLower = ovlp.tailPoint.param - ovlp.tailPoint.pTol;
                ovlpUpper = ovlp.headPoint.param + ovlp.headPoint.pTol;
            }
            if (ovlp.crossBoundary) {
                double swap = ovlpLower;
                ovlpLower = ovlpUpper;
                ovlpUpper = swap;
            }
            return !(this.param < ovlpLower) || !(ovlpUpper < this.param);
        }
    }

    class SectionInfo {
        PointInfo headPoint;
        PointInfo tailPoint;
        private boolean crossBoundary;

        SectionInfo(double headParam, double increaseParam) {
            JgclParameterRangeOnCurveList.this = JgclParameterRangeOnCurveList.this;
            headParam = JgclParameterRangeOnCurveList.this.parameterDomain.wrap(headParam);
            double tailParam = JgclParameterRangeOnCurveList.this.parameterDomain.wrap(headParam + increaseParam);
            JgclParameterRangeOnCurveList jgclParameterRangeOnCurveList = JgclParameterRangeOnCurveList.this;
            jgclParameterRangeOnCurveList.getClass();
            this.headPoint = jgclParameterRangeOnCurveList.new PointInfo(null, headParam);
            JgclParameterRangeOnCurveList jgclParameterRangeOnCurveList2 = JgclParameterRangeOnCurveList.this;
            jgclParameterRangeOnCurveList2.getClass();
            this.tailPoint = jgclParameterRangeOnCurveList2.new PointInfo(null, tailParam);
            this.crossBoundary = headParam > tailParam && increaseParam > 0.0 || headParam < tailParam && increaseParam < 0.0;
        }

        SectionInfo(double headParam, double increaseParam, double headPTol, double tailPTol) {
            JgclParameterRangeOnCurveList.this = JgclParameterRangeOnCurveList.this;
            headParam = JgclParameterRangeOnCurveList.this.parameterDomain.wrap(headParam);
            double tailParam = JgclParameterRangeOnCurveList.this.parameterDomain.wrap(headParam + increaseParam);
            JgclParameterRangeOnCurveList jgclParameterRangeOnCurveList = JgclParameterRangeOnCurveList.this;
            jgclParameterRangeOnCurveList.getClass();
            this.headPoint = jgclParameterRangeOnCurveList.new PointInfo(null, headParam, headPTol);
            JgclParameterRangeOnCurveList jgclParameterRangeOnCurveList2 = JgclParameterRangeOnCurveList.this;
            jgclParameterRangeOnCurveList2.getClass();
            this.tailPoint = jgclParameterRangeOnCurveList2.new PointInfo(null, tailParam, tailPTol);
            this.crossBoundary = headParam > tailParam && increaseParam > 0.0 || headParam < tailParam && increaseParam < 0.0;
        }

        private void setCrossBoundaryFlags(SectionInfo mate, ParametricalIdentityOfTwoPoints identity) {
            if (mate.crossBoundary || identity.isCrossBoundary()) {
                this.crossBoundary = true;
            }
        }

        private double computeIncrease() {
            double increase = this.tailPoint.param - this.headPoint.param;
            if (JgclParameterRangeOnCurveList.this.parameterDomain.isPeriodic() && this.crossBoundary) {
                increase = increase > 0.0 ? (increase -= JgclParameterRangeOnCurveList.this.parameterDomain.section().absIncrease()) : (increase += JgclParameterRangeOnCurveList.this.parameterDomain.section().absIncrease());
            }
            return increase;
        }

        boolean mergeIfConnectWith(SectionInfo mate) {
            if (this == mate) {
                return false;
            }
            ParametricalIdentityOfTwoPoints identity = this.headPoint.getParametricalIdentityWith(mate.headPoint);
            if (identity.isIdentical()) {
                this.headPoint = mate.tailPoint;
                this.setCrossBoundaryFlags(mate, identity);
                return true;
            }
            identity = this.headPoint.getParametricalIdentityWith(mate.tailPoint);
            if (identity.isIdentical()) {
                this.headPoint = mate.headPoint;
                this.setCrossBoundaryFlags(mate, identity);
                return true;
            }
            identity = this.tailPoint.getParametricalIdentityWith(mate.headPoint);
            if (identity.isIdentical()) {
                this.tailPoint = mate.tailPoint;
                this.setCrossBoundaryFlags(mate, identity);
                return true;
            }
            identity = this.tailPoint.getParametricalIdentityWith(mate.tailPoint);
            if (identity.isIdentical()) {
                this.tailPoint = mate.headPoint;
                this.setCrossBoundaryFlags(mate, identity);
                return true;
            }
            return false;
        }

        boolean isContainedIn(SectionInfo mate) {
            if (mate == this) {
                return false;
            }
            if (!mate.crossBoundary) {
                double mateUpper;
                double mateLower;
                if (this.crossBoundary) {
                    return false;
                }
                if (mate.headPoint.param < mate.tailPoint.param) {
                    mateLower = mate.headPoint.param - mate.headPoint.pTol;
                    mateUpper = mate.tailPoint.param + mate.tailPoint.pTol;
                } else {
                    mateLower = mate.tailPoint.param - mate.tailPoint.pTol;
                    mateUpper = mate.headPoint.param + mate.headPoint.pTol;
                }
                if (this.headPoint.param < mateLower || mateUpper < this.headPoint.param || this.tailPoint.param < mateLower || mateUpper < this.tailPoint.param) {
                    return false;
                }
            } else {
                double mateUpper;
                double mateLower;
                if (mate.headPoint.param < mate.tailPoint.param) {
                    mateLower = mate.tailPoint.param - mate.tailPoint.pTol;
                    mateUpper = mate.headPoint.param + mate.headPoint.pTol;
                } else {
                    mateLower = mate.headPoint.param - mate.headPoint.pTol;
                    mateUpper = mate.tailPoint.param + mate.tailPoint.pTol;
                }
                if (mateUpper < this.headPoint.param && this.headPoint.param < mateLower || mateUpper < this.tailPoint.param && this.tailPoint.param < mateLower) {
                    return false;
                }
                if (!this.crossBoundary && (mateUpper < this.headPoint.param || mateUpper < this.tailPoint.param) && (this.headPoint.param < mateLower || this.tailPoint.param < mateLower)) {
                    return false;
                }
            }
            return true;
        }
    }
}

