/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.Serializable;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;

public class JgclParameterDomain
implements Serializable {
    private final boolean finite;
    private final boolean periodic;
    private final JgclParameterSection section;

    public JgclParameterDomain() {
        this.finite = false;
        this.periodic = false;
        this.section = null;
    }

    public JgclParameterDomain(boolean periodic, double start, double increase) {
        double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
        if (increase <= pTol) {
            throw new JgclInvalidArgumentValue("increase is less than the tolerance for parameter");
        }
        this.finite = true;
        this.periodic = periodic;
        this.section = new JgclParameterSection(start, increase);
    }

    public JgclParameterDomain(boolean periodic, JgclParameterSection section) {
        double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
        if (section.increase() <= pTol) {
            throw new JgclInvalidArgumentValue("increase is less than the tolerance for parameter");
        }
        this.finite = true;
        this.periodic = periodic;
        this.section = section;
    }

    public boolean isFinite() {
        return this.finite;
    }

    public boolean isInfinite() {
        return !this.finite;
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    public boolean isNonPeriodic() {
        return !this.periodic;
    }

    public JgclParameterSection section() {
        return this.section;
    }

    public boolean isValid(double value) {
        if (this.isInfinite()) {
            return true;
        }
        if (this.isPeriodic()) {
            return true;
        }
        return this.section.isValid(value);
    }

    public void checkValidity(double value) {
        if (!this.isValid(value)) {
            throw new JgclParameterOutOfRange();
        }
    }

    public void checkValidity(JgclParameterSection section) {
        this.checkValidity(section.start());
        this.checkValidity(section.end());
        if (this.isPeriodic()) {
            double pTol = JgclConditionOfOperation.getCondition().getToleranceForParameter();
            if (Math.abs(section.increase()) > Math.abs(this.section().increase()) + pTol) {
                throw new JgclInvalidArgumentValue();
            }
        }
    }

    public double wrap(double value) {
        if (this.isInfinite() || this.isNonPeriodic()) {
            return value;
        }
        double low = this.section.lower();
        double inc = Math.abs(this.section.increase());
        if (value < low) {
            double n = Math.floor((low - value) / inc) + 1.0;
            return value + n * inc;
        }
        if (!(value > this.section.upper())) {
            return value;
        }
        double n = Math.floor((value - low) / inc);
        return value - n * inc;
    }

    public double force(double value) {
        if (this.isInfinite() || this.isPeriodic()) {
            return value;
        }
        double low = this.section.lower();
        double high = this.section.upper();
        if (value < low) {
            return low;
        }
        if (high < value) {
            return high;
        }
        return value;
    }
}

