/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector2D;

class JgclOfst2D {
    private JgclParametricCurve2D curve;
    private JgclParameterSection pint;
    private int side;
    private double magni;
    private JgclToleranceForDistance tolerance;
    private JgclPolyline2D poly;
    private double[] sampling_parameters;

    JgclOfst2D(JgclParametricCurve2D curve, JgclParameterSection pint, double magni, int side, JgclToleranceForDistance tolerance) {
        curve.checkValidity(pint);
        this.curve = curve;
        this.pint = pint;
        this.side = side;
        this.magni = magni;
        this.tolerance = tolerance;
    }

    private JgclBsplineCurve2D offset_bsc() {
        this.set_sample_variables();
        JgclPoint2D[] offset_points = this.set_offset_points();
        double[] offset_parameters = this.set_offset_parameters(offset_points);
        JgclBsplineCurve2D obsc = this.approx_bsc(offset_points, offset_parameters);
        return obsc;
    }

    private void set_sample_variables() {
        this.poly = this.curve.toPolyline(this.pint, this.tolerance);
        this.sampling_parameters = new double[this.poly.nPoints()];
        int i = 0;
        while (i < this.poly.nPoints()) {
            this.sampling_parameters[i] = ((JgclPointOnCurve2D)this.poly.pointAt(i)).parameter();
            ++i;
        }
    }

    private JgclPoint2D[] set_offset_points() {
        JgclPoint2D[] offset_points = new JgclPoint2D[this.sampling_parameters.length];
        int i = 0;
        while (i < this.sampling_parameters.length) {
            offset_points[i] = this.make_offset_point(this.sampling_parameters[i]);
            ++i;
        }
        return offset_points;
    }

    private double[] set_offset_parameters(JgclPoint2D[] offset_points) {
        double[] parameters = new double[offset_points.length];
        parameters[0] = 0.0;
        JgclPoint2D source_point = offset_points[0];
        int i = 1;
        while (i < offset_points.length) {
            int n = i;
            parameters[n] = parameters[n] + (offset_points[i].distance(source_point) + parameters[i - 1]);
            source_point = offset_points[i];
            ++i;
        }
        double[] offset_parameters = new double[parameters.length];
        double lower = this.pint.lower();
        double interval = this.pint.increase();
        double maxlength = parameters[parameters.length - 1];
        int i2 = 0;
        while (i2 < parameters.length) {
            offset_parameters[i2] = lower + parameters[i2] / maxlength * interval;
            ++i2;
        }
        return offset_parameters;
    }

    private JgclBsplineCurve2D approx_bsc(JgclPoint2D[] offset_points, double[] offset_parameters) {
        JgclToleranceForDistance mid_tol = this.comp_mid_tol();
        JgclVector2D[] EndVector = new JgclVector2D[]{this.curve.tangentVector(this.pint.start()), this.curve.tangentVector(this.pint.end())};
        if (this.poly.isClosed()) {
            JgclPoint2D[] closed_offset_points = new JgclPoint2D[offset_points.length - 1];
            int i = 0;
            while (i < offset_points.length - 1) {
                closed_offset_points[i] = offset_points[i];
                ++i;
            }
            offset_points = closed_offset_points;
        }
        JgclBsplineCurve2D bsc = new JgclBsplineCurve2D(offset_points, offset_parameters, EndVector, this.poly.isClosed(), this.tolerance, mid_tol);
        return bsc;
    }

    private double get_circular_arc_height(JgclPoint2D[] points, int index) {
        JgclCircle2D circle;
        try {
            circle = new JgclCircle2D(points[index], points[index + 1], points[index + 2]);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            return 0.0;
        }
        double leng01 = points[index].distance(points[index + 1]) / 2.0;
        double leng02 = points[index + 1].distance(points[index + 2]) / 2.0;
        double height = leng01 > leng02 ? circle.radius() - Math.sqrt(circle.radius() * circle.radius() - leng01 * leng01) : circle.radius() - Math.sqrt(circle.radius() * circle.radius() - leng02 * leng02);
        return height;
    }

    private JgclToleranceForDistance comp_mid_tol() {
        JgclPoint2D[] cross_boundary_points;
        double height;
        if (this.poly.nPoints() < 3) {
            return this.tolerance;
        }
        double mid_tol = 0.0;
        int i = 2;
        int j = 0;
        while (i < this.poly.nPoints()) {
            height = this.get_circular_arc_height(this.poly.points(), j);
            if (i == 2 || mid_tol < height) {
                mid_tol = height;
            }
            ++i;
            ++j;
        }
        if (this.curve.isClosed() && mid_tol < (height = this.get_circular_arc_height(cross_boundary_points = new JgclPoint2D[]{this.poly.pointAt(this.poly.nPoints() - 2), this.poly.pointAt(0), this.poly.pointAt(1)}, 0))) {
            mid_tol = height;
        }
        return new JgclToleranceForDistance(mid_tol += this.tolerance.value());
    }

    private JgclPoint2D make_offset_point(double param) {
        JgclLiteralVector2D offset_dir;
        JgclVector2D tng = this.curve.tangentVector(param);
        tng = tng.unitized();
        if (this.side == 2) {
            offset_dir = new JgclLiteralVector2D(-1.0 * tng.y(), tng.x());
        } else if (this.side == 1) {
            offset_dir = new JgclLiteralVector2D(tng.y(), -1.0 * tng.x());
        } else {
            throw new JgclInvalidArgumentValue();
        }
        offset_dir = (JgclLiteralVector2D)offset_dir.unitized();
        offset_dir = (JgclLiteralVector2D)offset_dir.multiply(this.magni);
        JgclPoint2D cnt_pnt = this.curve.coordinates(param);
        JgclPoint2D offset_point = cnt_pnt.add(offset_dir);
        return offset_point;
    }

    JgclBsplineCurve2D offset() {
        if (this.magni == 0.0) {
            return this.curve.toBsplineCurve(this.pint);
        }
        return this.offset_bsc();
    }
}

