/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclIntsSphCon3D {
    private static final boolean debug = false;
    private static final int nst = 41;
    private final JgclSphericalSurface3D Sph;
    private final JgclConicalSurface3D Con;
    private double d_tol;
    private double a_tol;
    private double C_cos;
    private double C_sin;
    private double C_tan;
    private JgclPoint3D C_org;
    private JgclVector3D[] C_xyz;
    private JgclVector3D C2S;
    private JgclVector3D S2C;
    private double distC2S;

    JgclIntsSphCon3D(JgclSphericalSurface3D Sph, JgclConicalSurface3D Con) {
        this.Sph = Sph;
        this.Con = Con;
        this.d_tol = Sph.getToleranceForDistance();
        this.a_tol = Sph.getToleranceForAngle();
        this.C_cos = Math.cos(Con.semiAngle());
        this.C_sin = Math.sin(Con.semiAngle());
        this.C_tan = Math.tan(Con.semiAngle());
        this.C_org = Con.position().location();
        this.C_xyz = Con.position().axes();
        this.C_org = this.C_org.subtract(this.C_xyz[2].multiply(Con.radius() / this.C_tan));
        this.C2S = Sph.position().location().subtract(this.C_org);
        this.S2C = this.C2S.reverse();
        this.distC2S = this.C2S.length();
    }

    private static JgclVector3D UVWpntfromT(JgclVector3D u, JgclVector3D v, JgclVector3D w, double Ctan, double t) {
        double cost = Math.cos(t);
        double sint = Math.sin(t);
        return u.multiply(cost).add(v.multiply(sint)).multiply(Ctan).add(w);
    }

    private JgclIntersectionCurve3D makeCircle(JgclPoint3D loc, JgclVector3D axis, JgclVector3D refDir, double radius, boolean doExchange) {
        JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(loc, axis, refDir);
        JgclCircle3D resC = new JgclCircle3D(a2p, radius);
        return this.Sph.curveToIntersectionCurve(resC, this.Con, doExchange);
    }

    private JgclIntersectionCurve3D makePolyline(double t0, int nst, JgclVector3D Cu, JgclVector3D Cv, JgclVector3D Cw, boolean doExchange) {
        JgclPoint3D[] pnts = new JgclPoint3D[nst];
        double step = 2.0 * t0 / (double)(nst - 1);
        double a = this.C_tan * this.C_tan + 1.0;
        int i = 0;
        while (i < nst) {
            double t = -t0 + (double)i * step;
            JgclVector3D evec = JgclIntsSphCon3D.UVWpntfromT(Cu, Cv, Cw, this.C_tan, t);
            double b = 2.0 * evec.dotProduct(this.S2C);
            double s = -b / a;
            pnts[i] = this.C_org.add(evec.multiply(s));
            ++i;
        }
        JgclPolyline3D res = new JgclPolyline3D(pnts);
        return this.Sph.curveToIntersectionCurve(res, this.Con, doExchange);
    }

    private JgclSurfaceSurfaceInterference3D[] makeTwoPolyline(int nst, JgclVector3D Cu, JgclVector3D Cv, JgclVector3D Cw, boolean doExchange) {
        double[] dA = new double[3];
        JgclPoint3D[] pnts1 = new JgclPoint3D[nst];
        JgclPoint3D[] pnts2 = new JgclPoint3D[nst];
        double step = Math.PI * 2 / (double)(nst - 1);
        dA[2] = this.C_tan * this.C_tan + 1.0;
        dA[0] = this.distC2S * this.distC2S - this.Sph.radius() * this.Sph.radius();
        int i = 0;
        while (i < nst) {
            double dX0;
            double dX1;
            double t = -Math.PI + (double)i * step;
            JgclVector3D evec = JgclIntsSphCon3D.UVWpntfromT(Cu, Cv, Cw, this.C_tan, t);
            dA[1] = 2.0 * evec.dotProduct(this.S2C);
            JgclRealPolynomial pol = new JgclRealPolynomial(dA);
            double[] dX = pol.getAlwaysRootsIfQuadric();
            if (dX == null) {
                throw new JgclFatal();
            }
            if (dX.length == 1) {
                dX0 = dX1 = dX[0];
            } else if (dX[0] > dX[1]) {
                dX0 = dX[0];
                dX1 = dX[1];
            } else {
                dX0 = dX[1];
                dX1 = dX[0];
            }
            pnts1[i] = this.C_org.add(evec.multiply(dX0));
            pnts2[i] = this.C_org.add(evec.multiply(dX1));
            ++i;
        }
        JgclPolyline3D res = new JgclPolyline3D(pnts1);
        JgclIntersectionCurve3D ints1 = this.Sph.curveToIntersectionCurve(res, this.Con, doExchange);
        res = new JgclPolyline3D(pnts2);
        JgclIntersectionCurve3D ints2 = this.Sph.curveToIntersectionCurve(res, this.Con, doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints1, ints2};
        return sol;
    }

    private JgclIntersectionCurve3D makePolylineAtOneSide(int nst, JgclVector3D Cu, JgclVector3D Cv, JgclVector3D Cw, boolean doExchange) {
        double[] dX;
        JgclRealPolynomial pol;
        JgclIntersectionPoint3D[] CSint;
        double[] dA = new double[3];
        int my_nst = 2 * nst - 1;
        JgclPoint3D[] pnts = new JgclPoint3D[my_nst];
        double ework = Math.sqrt(this.distC2S * this.distC2S - this.Sph.radius() * this.Sph.radius());
        JgclPoint3D loc = this.C_org.add(Cw.multiply(ework * this.C_cos));
        JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(loc, this.Con.position().z(), this.Con.position().x());
        JgclCircle3D Cir = new JgclCircle3D(a2p, ework * this.C_sin);
        try {
            CSint = Cir.intersect(this.Sph);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        if (CSint.length < 1) {
            throw new JgclFatal();
        }
        JgclVector3D evec = CSint[0].subtract(Cir.position().location()).unitized();
        double t0 = Math.acos(Cu.dotProduct(evec));
        double step = 2.0 * t0 / (double)(nst - 1);
        dA[2] = this.C_tan * this.C_tan + 1.0;
        dA[0] = this.distC2S * this.distC2S - this.Sph.radius() * this.Sph.radius();
        int i = 0;
        while (i < nst - 1) {
            double dX0;
            double dX1;
            double t = -t0 + (double)i * step;
            evec = JgclIntsSphCon3D.UVWpntfromT(Cu, Cv, Cw, this.C_tan, t);
            dA[1] = 2.0 * evec.dotProduct(this.S2C);
            pol = new JgclRealPolynomial(dA);
            dX = pol.getAlwaysRootsIfQuadric();
            if (dX == null) {
                throw new JgclFatal();
            }
            if (dX.length == 1) {
                dX0 = dX1 = dX[0];
            } else if (dX[0] < dX[1]) {
                dX0 = dX[1];
                dX1 = dX[0];
            } else {
                dX0 = dX[0];
                dX1 = dX[1];
            }
            pnts[i] = this.C_org.add(evec.multiply(dX0));
            pnts[my_nst - 1 - i] = this.C_org.add(evec.multiply(dX1));
            ++i;
        }
        evec = JgclIntsSphCon3D.UVWpntfromT(Cu, Cv, Cw, this.C_tan, t0);
        dA[1] = 2.0 * evec.dotProduct(this.S2C);
        pol = new JgclRealPolynomial(dA);
        dX = pol.getAlwaysRootsIfQuadric();
        if (dX == null) {
            throw new JgclFatal();
        }
        if (dX.length == 2 && dX[0] < dX[1]) {
            dX[0] = dX[1];
        }
        pnts[nst - 1] = this.C_org.add(evec.multiply(dX[0]));
        JgclPolyline3D res = new JgclPolyline3D(pnts);
        return this.Sph.curveToIntersectionCurve(res, this.Con, doExchange);
    }

    private JgclSurfaceSurfaceInterference3D[] oneCircleOnePoint(boolean doExchange) {
        JgclIntersectionPoint3D intsP = this.Sph.pointToIntersectionPoint(this.C_org, this.Con, doExchange);
        double ework = 2.0 * this.Sph.radius() * this.C_cos * this.C_cos;
        if (this.C2S.dotProduct(this.C_xyz[2]) < 0.0) {
            ework *= -1.0;
        }
        JgclIntersectionCurve3D intsC = this.makeCircle(this.C_org.add(this.C_xyz[2].multiply(ework)), this.C_xyz[2], this.C_xyz[0], 2.0 * this.Sph.radius() * this.C_cos * this.C_sin, doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{intsP, intsC};
        return sol;
    }

    private JgclSurfaceSurfaceInterference3D[] twoCircleAtEachSide(boolean doExchange) {
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[2];
        double side = this.C2S.dotProduct(this.C_xyz[2]);
        int i = 0;
        while (i < 2) {
            double ework;
            if (i == 0) {
                ework = -this.distC2S * this.C_cos + Math.sqrt(this.Sph.radius() * this.Sph.radius() - this.distC2S * this.distC2S * (this.C_sin * this.C_sin));
                if (side > 0.0) {
                    ework *= -1.0;
                }
            } else {
                ework = this.distC2S * this.C_cos + Math.sqrt(this.Sph.radius() * this.Sph.radius() - this.distC2S * this.distC2S * (this.C_sin * this.C_sin));
                if (side < 0.0) {
                    ework *= -1.0;
                }
            }
            sol[i] = this.makeCircle(this.C_org.add(this.C_xyz[2].multiply(ework * this.C_cos)), this.C_xyz[2], this.C_xyz[0], Math.abs(ework * this.C_sin), doExchange);
            ++i;
        }
        return sol;
    }

    private JgclSurfaceSurfaceInterference3D[] oneTangentCircle(boolean doExchange) {
        double ework = this.Sph.radius() * this.C_sin;
        if (this.C2S.dotProduct(this.C_xyz[2]) < 0.0) {
            ework *= -1.0;
        }
        JgclIntersectionCurve3D intsC = this.makeCircle(this.Sph.position().location().subtract(this.C_xyz[2].multiply(ework)), this.C_xyz[2], this.C_xyz[0], this.Sph.radius() * this.C_cos, doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{intsC};
        return sol;
    }

    private JgclSurfaceSurfaceInterference3D[] twoCircleAtOneSide(boolean doExchange) {
        double ework = Math.sqrt(this.Sph.radius() * this.Sph.radius() - this.distC2S * this.distC2S * (this.C_sin * this.C_sin));
        double x1 = this.distC2S * this.C_cos + ework;
        double x2 = this.distC2S * this.C_cos - ework;
        if (this.C2S.dotProduct(this.C_xyz[2]) < 0.0) {
            x1 *= -1.0;
            x2 *= -1.0;
        }
        JgclIntersectionCurve3D intsC1 = this.makeCircle(this.C_org.add(this.C_xyz[2].multiply(x1 * this.C_cos)), this.C_xyz[2], this.C_xyz[0], Math.abs(x1 * this.C_sin), doExchange);
        JgclIntersectionCurve3D intsC2 = this.makeCircle(this.C_org.add(this.C_xyz[2].multiply(x2 * this.C_cos)), this.C_xyz[2], this.C_xyz[0], Math.abs(x2 * this.C_sin), doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{intsC1, intsC2};
        return sol;
    }

    private JgclSurfaceSurfaceInterference3D[] vertexOfConeIsOnSphere(boolean doExchange) {
        double acosd;
        boolean revSide;
        JgclVector3D Cw = this.C_xyz[2];
        JgclVector3D Cv = Cw.crossProduct(this.C2S);
        JgclVector3D Cu = Cv.crossProduct(Cw);
        Cu = Cu.unitized();
        Cv = Cv.unitized();
        JgclVector3D CuR = Cu;
        JgclVector3D CvR = Cv.reverse();
        JgclVector3D CwR = Cw.reverse();
        double cosd = this.C2S.dotProduct(Cw) / this.distC2S;
        if (cosd < 0.0) {
            revSide = true;
            cosd *= -1.0;
        } else {
            revSide = false;
        }
        if (cosd > 1.0) {
            cosd = 1.0;
        }
        if (Math.abs((acosd = Math.acos(cosd)) - (1.5707963267948966 - this.Con.semiAngle())) < this.a_tol) {
            JgclIntersectionCurve3D ints = !revSide ? this.makePolyline(Math.PI, 41, Cu, Cv, Cw, doExchange) : this.makePolyline(Math.PI, 41, CuR, CvR, CwR, doExchange);
            JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
            return sol;
        }
        if (acosd < 1.5707963267948966 - this.Con.semiAngle()) {
            JgclIntersectionCurve3D intsC = !revSide ? this.makePolyline(Math.PI, 41, Cu, Cv, Cw, doExchange) : this.makePolyline(Math.PI, 41, CuR, CvR, CwR, doExchange);
            JgclIntersectionPoint3D intsP = this.Sph.pointToIntersectionPoint(this.C_org, this.Con, doExchange);
            JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{intsC, intsP};
            return sol;
        }
        double t0 = Math.abs(acosd - 1.5707963267948966) < this.a_tol ? 1.5707963267948966 : Math.acos(-(1.0 / Math.tan(acosd)) / this.C_tan);
        JgclIntersectionCurve3D ints1 = this.makePolyline(t0, 41, Cu, Cv, Cw, doExchange);
        JgclIntersectionCurve3D ints2 = this.makePolyline(t0, 41, CuR, CvR, CwR, doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints1, ints2};
        return sol;
    }

    private JgclSurfaceSurfaceInterference3D[] vertexOfConeIsInSphere(boolean doExchange) {
        JgclVector3D Cw = this.C_xyz[2];
        JgclVector3D Cv = Cw.crossProduct(this.C2S);
        JgclVector3D Cu = Cv.crossProduct(Cw);
        Cu = Cu.unitized();
        Cv = Cv.unitized();
        if (this.C2S.dotProduct(Cw) < 0.0) {
            Cv = Cv.reverse();
            Cw = Cw.reverse();
        }
        return this.makeTwoPolyline(41, Cu, Cv, Cw, doExchange);
    }

    private JgclSurfaceSurfaceInterference3D[] vertexOfConeIsNotInSphere(boolean doExchange) {
        boolean revSide;
        JgclVector3D Cw = this.C_xyz[2];
        JgclVector3D Cv = Cw.crossProduct(this.C2S);
        JgclVector3D Cu = Cv.crossProduct(Cw);
        Cu = Cu.unitized();
        Cv = Cv.unitized();
        JgclVector3D CuR = Cu;
        JgclVector3D CvR = Cv.reverse();
        JgclVector3D CwR = Cw.reverse();
        double cosd = this.C2S.dotProduct(Cw) / this.distC2S;
        if (cosd < 0.0) {
            revSide = true;
            cosd *= -1.0;
        } else {
            revSide = false;
        }
        if (cosd > 1.0) {
            cosd = 1.0;
        }
        double alpha = this.Con.semiAngle();
        double theta = Math.asin(this.Sph.radius() / this.distC2S);
        double phi = Math.acos(cosd);
        if (Math.abs(phi - (alpha + theta)) < this.a_tol || Math.abs(phi - (alpha - theta)) < this.a_tol) {
            if (revSide) {
                Cu = CuR;
                Cv = CvR;
                Cw = CwR;
            }
            double ework = Math.sqrt(this.distC2S * this.distC2S - this.Sph.radius() * this.Sph.radius());
            JgclPoint3D resP = this.C_org.add(Cw.multiply(ework * this.C_cos));
            resP = resP.add(Cu.multiply(ework * this.C_sin));
            JgclIntersectionPoint3D intsP = this.Sph.pointToIntersectionPoint(resP, this.Con, doExchange);
            if (Math.abs(phi - (alpha + theta)) < this.a_tol && Math.abs(phi - 1.5707963267948966) < this.a_tol) {
                resP = this.C_org.subtract(Cw.multiply(ework * this.C_cos));
                resP = resP.add(Cu.multiply(ework * this.C_sin));
                JgclIntersectionPoint3D intsP2 = this.Sph.pointToIntersectionPoint(resP, this.Con, doExchange);
                JgclSurfaceSurfaceInterference3D[] intf = new JgclSurfaceSurfaceInterference3D[]{intsP, intsP2};
                return intf;
            }
            JgclSurfaceSurfaceInterference3D[] intf = new JgclSurfaceSurfaceInterference3D[]{intsP};
            return intf;
        }
        if (phi > alpha + theta || phi < alpha - theta) {
            return new JgclSurfaceSurfaceInterference3D[0];
        }
        if (Math.abs(theta - (alpha + phi)) < this.a_tol || theta > alpha + phi) {
            if (revSide) {
                Cu = CuR;
                Cv = CvR;
                Cw = CwR;
            }
            return this.makeTwoPolyline(41, Cu, Cv, Cw, doExchange);
        }
        JgclIntersectionCurve3D ints = !revSide ? this.makePolylineAtOneSide(41, Cu, Cv, Cw, doExchange) : this.makePolylineAtOneSide(41, CuR, CvR, CwR, doExchange);
        if (Math.abs(Math.PI - (theta + phi + alpha)) < this.a_tol) {
            if (!revSide) {
                Cu = CuR;
                Cv = CvR;
                Cw = CwR;
            }
            double ework = Math.sqrt(this.distC2S * this.distC2S - this.Sph.radius() * this.Sph.radius());
            JgclPoint3D resP = this.C_org.add(Cw.multiply(ework * this.C_cos));
            resP = resP.add(Cu.multiply(ework * this.C_sin));
            JgclIntersectionPoint3D intsP = this.Sph.pointToIntersectionPoint(resP, this.Con, doExchange);
            JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints, intsP};
            return sol;
        }
        if (theta + phi + alpha > Math.PI) {
            if (!revSide) {
                Cu = CuR;
                Cv = CvR;
                Cw = CwR;
            }
            JgclIntersectionCurve3D ints2 = this.makePolylineAtOneSide(41, Cu, Cv, Cw, doExchange);
            JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints, ints2};
            return sol;
        }
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
        return sol;
    }

    JgclSurfaceSurfaceInterference3D[] getInterference(boolean doExchange) {
        JgclLine3D C_axis = new JgclLine3D(this.C_org, this.C_xyz[2]);
        JgclPointOnCurve3D projp = C_axis.project1From(this.Sph.position().location());
        if (projp.distance(this.Sph.position().location()) < this.d_tol) {
            if (Math.abs(this.distC2S - this.Sph.radius()) < this.d_tol) {
                return this.oneCircleOnePoint(doExchange);
            }
            if (this.distC2S < this.Sph.radius()) {
                return this.twoCircleAtEachSide(doExchange);
            }
            if (Math.abs(this.distC2S - this.Sph.radius() / this.C_sin) < this.d_tol) {
                return this.oneTangentCircle(doExchange);
            }
            if (this.distC2S < this.Sph.radius() / this.C_sin) {
                return this.twoCircleAtOneSide(doExchange);
            }
            return new JgclSurfaceSurfaceInterference3D[0];
        }
        if (Math.abs(this.distC2S - this.Sph.radius()) < this.d_tol) {
            return this.vertexOfConeIsOnSphere(doExchange);
        }
        if (this.distC2S < this.Sph.radius()) {
            return this.vertexOfConeIsInSphere(doExchange);
        }
        return this.vertexOfConeIsNotInSphere(doExchange);
    }
}

