/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBoundedLine2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclEnclosingBox2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclOverlapCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclVector2D;

class JgclIntsPolPol2D {
    private JgclPolyline2D dA;
    private JgclVector2D[] dA_uvecs;
    private double[] dA_lengs;
    private JgclEnclosingBox2D dA_enrc;
    private JgclPolyline2D dB;
    private JgclVector2D[] dB_uvecs;
    private double[] dB_lengs;
    private JgclEnclosingBox2D dB_enrc;

    private JgclIntsPolPol2D(JgclPolyline2D dA, JgclPolyline2D dB) {
        this(dA, null, null, null, dB, null, null, null);
    }

    private JgclIntsPolPol2D(JgclPolyline2D dA, JgclVector2D[] dA_uvecs, double[] dA_lengs, JgclEnclosingBox2D dA_enrc, JgclPolyline2D dB, JgclVector2D[] dB_uvecs, double[] dB_lengs, JgclEnclosingBox2D dB_enrc) {
        this.dA = dA;
        this.dA_uvecs = dA_uvecs;
        this.dA_lengs = dA_lengs;
        this.dA_enrc = dA_enrc;
        this.dB = dB;
        this.dB_uvecs = dB_uvecs;
        this.dB_lengs = dB_lengs;
        this.dB_enrc = dB_enrc;
    }

    private JgclCurveCurveInterferenceList getInterference(boolean doRoughCheck) {
        JgclCurveCurveInterferenceList interferenceList = new JgclCurveCurveInterferenceList(this.dA, this.dB);
        if (doRoughCheck) {
            if (this.dA_enrc == null) {
                this.dA_enrc = this.dA.enclosingBox();
            }
            if (this.dB_enrc == null) {
                this.dB_enrc = this.dB.enclosingBox();
            }
            if (!this.dA_enrc.hasIntersection(this.dB_enrc)) {
                return interferenceList;
            }
        }
        int Anseg = this.dA.nSegments();
        int Bnseg = this.dB.nSegments();
        SegmentInfo[] Bsi = new SegmentInfo[Bnseg];
        int i = 0;
        while (i < Bnseg) {
            Bsi[i] = this.dB_uvecs == null ? new SegmentInfo(this.dB.pointAt(i), this.dB.pointAt(i + 1)) : new SegmentInfo(this.dB.pointAt(i), this.dB.pointAt(i + 1), this.dB_uvecs[i], this.dB_lengs[i]);
            ++i;
        }
        i = 0;
        while (i < Anseg) {
            SegmentInfo Asi = this.dA_uvecs == null ? new SegmentInfo(this.dA.pointAt(i), this.dA.pointAt(i + 1)) : new SegmentInfo(this.dA.pointAt(i), this.dA.pointAt(i + 1), this.dA_uvecs[i], this.dA_lengs[i]);
            if (!(Asi.tol < 0.0) && (this.dB_enrc == null && !doRoughCheck || Asi.box.hasIntersection(this.dB_enrc))) {
                int j = 0;
                while (j < Bnseg) {
                    JgclCurveCurveInterference2D intf;
                    if (!(Bsi[j].tol < 0.0) && Asi.box.hasIntersection(Bsi[j].box) && (intf = Asi.bln.interfere1(Bsi[j].bln, Asi.udir, Bsi[j].udir, Asi.leng, Bsi[j].leng)) != null) {
                        if (intf.isIntersectionPoint()) {
                            JgclIntersectionPoint2D ints = intf.toIntersectionPoint();
                            interferenceList.addAsIntersection(ints.coordinates(), ints.pointOnCurve1().parameter() + (double)i, ints.pointOnCurve2().parameter() + (double)j, Asi.tol, Bsi[j].tol);
                        } else {
                            JgclOverlapCurve2D ovlp = intf.toOverlapCurve();
                            interferenceList.addAsOverlap(ovlp.start1() + (double)i, ovlp.start2() + (double)j, ovlp.increase1(), ovlp.increase2(), Asi.tol, Bsi[j].tol, Asi.tol, Bsi[j].tol);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        interferenceList.removeOverlapsContainedInOtherOverlap();
        interferenceList.removeIntersectionsContainedInOverlap();
        return interferenceList;
    }

    static JgclIntersectionPoint2D[] intersection(JgclPolyline2D poly1, JgclPolyline2D poly2, boolean doExchange) {
        JgclIntsPolPol2D doObj = new JgclIntsPolPol2D(poly1, poly2);
        return doObj.getInterference(true).toJgclIntersectionPoint2DArray(doExchange);
    }

    static JgclCurveCurveInterference2D[] interference(JgclPolyline2D poly1, JgclPolyline2D poly2) {
        JgclIntsPolPol2D doObj = new JgclIntsPolPol2D(poly1, poly2);
        return doObj.getInterference(true).toJgclCurveCurveInterference2DArray(false);
    }

    static JgclCurveCurveInterference2D[] interference(JgclPolyline2D dA, JgclVector2D[] dA_uvecs, double[] dA_lengs, JgclEnclosingBox2D dA_enrc, JgclPolyline2D dB, JgclVector2D[] dB_uvecs, double[] dB_lengs, JgclEnclosingBox2D dB_enrc) {
        JgclIntsPolPol2D doObj = new JgclIntsPolPol2D(dA, dA_uvecs, dA_lengs, dA_enrc, dB, dB_uvecs, dB_lengs, dB_enrc);
        return doObj.getInterference(false).toJgclCurveCurveInterference2DArray(false);
    }

    private class SegmentInfo {
        private JgclBoundedLine2D bln;
        private JgclVector2D udir;
        private double leng;
        private double tol;
        private JgclEnclosingBox2D box;

        private SegmentInfo(JgclPoint2D spnt, JgclPoint2D epnt, JgclVector2D udir, double leng) {
            JgclIntsPolPol2D.this = JgclIntsPolPol2D.this;
            double d_tol = spnt.getToleranceForDistance();
            if (udir == null) {
                this.udir = epnt.subtract(spnt);
                this.leng = this.udir.length();
                this.udir = this.leng > d_tol ? this.udir.divide(this.leng) : JgclVector2D.zeroVector;
            } else {
                this.udir = udir;
                this.leng = leng;
            }
            if (this.leng <= d_tol) {
                this.tol = -1.0;
                this.bln = null;
                this.box = null;
            } else {
                this.tol = d_tol / this.leng;
                this.bln = new JgclBoundedLine2D(spnt, epnt, false);
                this.box = this.bln.enclosingBox();
            }
        }

        private SegmentInfo(JgclPoint2D spnt, JgclPoint2D epnt) {
            this(spnt, epnt, null, 0.0);
        }
    }
}

