/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Vector;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclEllipse2D;
import jp.go.ipa.jgcl.JgclHyperbola2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntsCncCnc2D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclParabola2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;

class JgclIntsEllCnc2D
extends JgclIntsCncCnc2D {
    static final double SAFETY_ATOL = 0.001;
    static final double SAFETY_EPS = 0.1;

    JgclIntsEllCnc2D() {
    }

    double[] getCoefficent(JgclEllipse2D ellA, JgclEllipse2D ellB, double dAlrd, double dAsrd, double dBlrd, double dBsrd, JgclPoint2D eiBc, double erc, double ers, double imethod) {
        double[] eprep = new double[7];
        double[] ercoef = new double[5];
        double aA = dAlrd;
        double bA = dAsrd;
        double aB = dBlrd;
        double bB = dBsrd;
        double cx = eiBc.x();
        double cy = eiBc.y();
        eprep[0] = erc * aB;
        eprep[1] = ers * bB;
        eprep[2] = 2.0 * eprep[0] * eprep[1] * (aA * aA - bA * bA);
        eprep[0] = eprep[0] * bA;
        eprep[1] = eprep[1] * bA;
        eprep[5] = ers * aB * aA;
        eprep[6] = erc * bB * aA;
        eprep[3] = 2.0 * (eprep[0] * cx * bA + eprep[5] * cy * aA);
        eprep[4] = 2.0 * (eprep[6] * cy * aA - eprep[1] * cx * bA);
        eprep[0] = eprep[0] * eprep[0] + eprep[5] * eprep[5];
        eprep[1] = eprep[1] * eprep[1] + eprep[6] * eprep[6];
        eprep[5] = bA * bA * cx * cx + aA * aA * cy * cy;
        eprep[6] = aA * aA * bA * bA;
        if (imethod == 1.0) {
            double ework = eprep[0];
            eprep[0] = eprep[1];
            eprep[1] = ework;
            ework = eprep[3];
            eprep[3] = eprep[4];
            eprep[4] = ework;
        }
        ercoef[4] = eprep[0] - eprep[1];
        ercoef[0] = eprep[5] + eprep[1] - eprep[6];
        ercoef[1] = eprep[2] * eprep[4];
        ercoef[3] = 2.0 * (ercoef[4] * eprep[3] + ercoef[1]);
        ercoef[1] = 2.0 * (ercoef[0] * eprep[3] - ercoef[1]);
        ercoef[2] = 2.0 * ercoef[4] * ercoef[0] + eprep[3] * eprep[3] + eprep[4] * eprep[4] - eprep[2] * eprep[2];
        ercoef[4] = ercoef[4] * ercoef[4] + eprep[2] * eprep[2];
        ercoef[0] = ercoef[0] * ercoef[0] - eprep[4] * eprep[4];
        return ercoef;
    }

    private boolean choose_far_solution_1st(double T, double[] Ta, int n_ints) {
        int i = 0;
        while (i < n_ints) {
            double ediff = Math.abs(T - Ta[i]);
            if (ediff < 0.001 || Math.PI * 2 - ediff < 0.001) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean check_solution(double pB, JgclEllipse2D ellA, double dAlrd, double dAsrd, JgclEllipse2D ellB, JgclPoint2D dBic, double dBlrd, double dBsrd, double erc, double ers, double[] eTb, int n_ints, Vector intervec) {
        JgclPointOnCurve2D bPnt;
        JgclIntersectionPoint2D inter;
        JgclPoint2D aPnt;
        double pPntx = dBlrd * Math.cos(pB);
        double pPnty = dBsrd * Math.sin(pB);
        double bPntx = erc * pPntx - ers * pPnty + dBic.x();
        double bPnty = ers * pPntx + erc * pPnty + dBic.y();
        double cosA = bPntx / dAlrd;
        if (cosA > 1.0) {
            cosA = 1.0;
        }
        if (cosA < -1.0) {
            cosA = -1.0;
        }
        double pA = Math.acos(cosA);
        JgclCartesianPoint2D lbPnt = new JgclCartesianPoint2D(bPntx, bPnty);
        int i = 0;
        while (i < 2) {
            double aPnty;
            double aPntx = dAlrd * Math.cos(pA);
            aPnt = new JgclCartesianPoint2D(aPntx, aPnty = dAsrd * Math.sin(pA));
            if (aPnt.identical(lbPnt)) break;
            pA = Math.PI * 2 - pA;
            ++i;
        }
        if (i == 2) {
            return false;
        }
        double Aparam = pA;
        if (ellA.xRadius() < ellA.yRadius()) {
            Aparam += 1.5707963267948966;
        }
        if (Aparam < 0.0 || Aparam > Math.PI * 2) {
            Aparam = JgclMath.normalizeAngle(Aparam);
        }
        double Bparam = pB;
        if (ellB.xRadius() < ellB.yRadius()) {
            Bparam += 1.5707963267948966;
        }
        if (Bparam < 0.0 || Bparam > Math.PI * 2) {
            Bparam = JgclMath.normalizeAngle(Bparam);
        }
        if (this.checkUnique(inter = new JgclIntersectionPoint2D((JgclPointOnCurve2D)(aPnt = new JgclPointOnCurve2D(ellA, Aparam, false)), bPnt = new JgclPointOnCurve2D(ellB, Bparam, false), false), intervec)) {
            intervec.addElement(inter);
            return true;
        }
        return false;
    }

    private JgclIntersectionPoint2D[] getIntersection(JgclEllipse2D ellA, JgclEllipse2D ellB, JgclComplex[] root, JgclPoint2D eiBc, double dAlrd, double dAsrd, double dBlrd, double dBsrd, double ers, double erc, int imethod, double eanthr, boolean doExchange) {
        int n_real_roots = 0;
        double[] eTb = new double[root.length];
        int i = 0;
        while (i < root.length) {
            eTb[i] = root[i].real();
            if (!(Math.abs(eTb[i]) > 1.1)) {
                if (eTb[i] > 1.0) {
                    eTb[i] = 1.0;
                }
                if (eTb[i] < -1.0) {
                    eTb[i] = -1.0;
                }
                eTb[n_real_roots] = imethod == 0 ? Math.acos(eTb[i]) : Math.asin(eTb[i]);
                ++n_real_roots;
            }
            ++i;
        }
        Vector intervec = new Vector();
        int n_ints = 0;
        int i2 = 0;
        while (i2 < n_real_roots) {
            int itryTb = 0;
            while (itryTb < 2) {
                if (this.choose_far_solution_1st(eTb[i2], eTb, n_ints)) break;
                eTb[i2] = eanthr - eTb[i2];
                ++itryTb;
            }
            while (itryTb < 2) {
                if (this.check_solution(eTb[i2], ellA, dAlrd, dAsrd, ellB, eiBc, dBlrd, dBsrd, erc, ers, eTb, n_ints, intervec)) {
                    eTb[n_ints] = eTb[i2];
                    ++n_ints;
                    break;
                }
                eTb[i2] = eanthr - eTb[i2];
                ++itryTb;
            }
            ++i2;
        }
        JgclIntersectionPoint2D[] intersectPoints = this.vectorToArray(intervec, doExchange);
        return intersectPoints;
    }

    JgclIntersectionPoint2D[] intersection(JgclEllipse2D ellA, JgclEllipse2D ellB, boolean doExchange) {
        double eanthr;
        int imethod;
        JgclVector2D ac2bc;
        double length_ac2bc;
        double dTol = ellA.getToleranceForDistance();
        double dAlrd = Math.max(ellA.semiAxis1(), ellA.semiAxis2());
        double dAsrd = Math.min(ellA.semiAxis1(), ellA.semiAxis2());
        double dAslp = Math.atan2(ellA.position().x().y(), ellA.position().x().x());
        if (ellA.xRadius() < ellA.yRadius()) {
            dAslp += 1.5707963267948966;
        }
        double dBlrd = Math.max(ellB.semiAxis1(), ellB.semiAxis2());
        double dBsrd = Math.min(ellB.semiAxis1(), ellB.semiAxis2());
        double dBslp = Math.atan2(ellB.position().x().y(), ellB.position().x().x());
        if (ellB.xRadius() < ellB.yRadius()) {
            dBslp += 1.5707963267948966;
        }
        if (Math.abs(dBsrd - ((length_ac2bc = (ac2bc = ellB.position().location().subtract(ellA.position().location())).length()) + dAlrd)) < dTol || Math.abs(dAsrd - (length_ac2bc - dBlrd)) < dTol || Math.abs(length_ac2bc - (dBsrd - dBlrd)) < dTol) {
            return new JgclIntersectionPoint2D[0];
        }
        double erotcos = Math.cos(dAslp);
        double erotsin = Math.sin(dAslp);
        double rotateX = erotcos * ac2bc.x() + erotsin * ac2bc.y();
        double rotateY = -erotsin * ac2bc.x() + erotcos * ac2bc.y();
        JgclCartesianPoint2D eiBc = new JgclCartesianPoint2D(rotateX, rotateY);
        double eslope = dBslp - dAslp;
        double erc = Math.cos(eslope);
        double ers = Math.sin(eslope);
        if (Math.abs(((JgclPoint2D)eiBc).x()) < Math.abs(((JgclPoint2D)eiBc).y())) {
            imethod = 0;
            eanthr = Math.PI * 2;
        } else {
            imethod = 1;
            eanthr = Math.PI;
        }
        double[] coefficent = this.getCoefficent(ellA, ellB, dAlrd, dAsrd, dBlrd, dBsrd, eiBc, erc, ers, imethod);
        JgclComplex[] root = this.getRoot(coefficent);
        if (root == null) {
            return new JgclIntersectionPoint2D[0];
        }
        return this.getIntersection(ellA, ellB, root, eiBc, dAlrd, dAsrd, dBlrd, dBsrd, ers, erc, imethod, eanthr, doExchange);
    }

    double[] getCoefficent(JgclEllipse2D ell, JgclParabola2D par, JgclPoint2D eiBc, double dAlrd, double dAsrd, double ers, double erc) {
        double[] ercoef = new double[5];
        double a = dAlrd;
        double b = dAsrd;
        double a2 = a * a;
        double b2 = b * b;
        double vx = eiBc.x();
        double vy = eiBc.y();
        double efcos = par.focalDist() * erc;
        double efsin = par.focalDist() * ers;
        ercoef[4] = a * efsin * (a * efsin) + b * efcos * (b * efcos);
        ercoef[3] = 4.0 * (a2 - b2) * efsin * efcos;
        ercoef[2] = 2.0 * (a2 * (vy * efsin + 2.0 * efcos * efcos) + b2 * (vx * efcos + 2.0 * efsin * efsin));
        ercoef[1] = 4.0 * (a2 * vy * efcos - b2 * vx * efsin);
        ercoef[0] = a2 * vy * vy + b2 * vx * vx - a2 * b2;
        return ercoef;
    }

    private JgclIntersectionPoint2D[] getIntersection(JgclEllipse2D ell, JgclParabola2D par, JgclComplex[] root, JgclPoint2D eiBc, double dAlrd, double dAsrd, double ers, double erc, boolean doExchange) {
        double dTol = ell.getToleranceForDistance();
        Vector<JgclIntersectionPoint2D> intervec = new Vector<JgclIntersectionPoint2D>();
        JgclPoint2D[] dDpnts = new JgclPoint2D[root.length];
        int n_ints = 0;
        int i = 0;
        while (i < root.length) {
            block9: {
                JgclIntersectionPoint2D inter;
                double Bparam;
                JgclPointOnCurve2D bPnt;
                JgclPointOnCurve2D aPnt;
                double eTb = root[i].real();
                double dDpnt_x = par.focalDist() * eTb * eTb;
                double dDpnt_y = 2.0 * par.focalDist() * eTb;
                JgclCartesianPoint2D dDpnt = new JgclCartesianPoint2D(dDpnt_x, dDpnt_y);
                int j = 0;
                while (j < n_ints) {
                    if (!dDpnt.identical(dDpnts[j])) {
                        ++j;
                        continue;
                    }
                    break block9;
                }
                dDpnts[n_ints] = dDpnt;
                ++n_ints;
                double pPntx = erc * ((JgclPoint2D)dDpnt).x() - ers * ((JgclPoint2D)dDpnt).y() + eiBc.x();
                double pPnty = ers * ((JgclPoint2D)dDpnt).x() + erc * ((JgclPoint2D)dDpnt).y() + eiBc.y();
                double cosA = pPntx / dAlrd;
                if (cosA > 1.0) {
                    cosA = 1.0;
                }
                if (cosA < -1.0) {
                    cosA = -1.0;
                }
                double eTa = Math.acos(cosA);
                double yA = dAsrd * Math.sqrt(1.0 - cosA * cosA);
                if (Math.abs(yA - pPnty) > dTol) {
                    eTa = Math.PI * 2 - eTa;
                }
                double Aparam = eTa;
                if (ell.xRadius() < ell.yRadius()) {
                    Aparam += 1.5707963267948966;
                }
                if (Aparam < 0.0 || Aparam > Math.PI * 2) {
                    Aparam = JgclMath.normalizeAngle(Aparam);
                }
                if ((aPnt = new JgclPointOnCurve2D(ell, Aparam, false)).identical(bPnt = new JgclPointOnCurve2D(par, Bparam = eTb, false)) && (inter = new JgclIntersectionPoint2D(aPnt, bPnt, false)) != null && this.checkUnique(inter, intervec)) {
                    intervec.addElement(inter);
                }
            }
            ++i;
        }
        JgclIntersectionPoint2D[] intersectPoints = this.vectorToArray(intervec, doExchange);
        return intersectPoints;
    }

    JgclIntersectionPoint2D[] intersection(JgclEllipse2D ell, JgclParabola2D par, boolean doExchange) {
        double dTol = ell.getToleranceForDistance();
        double dAlrd = Math.max(ell.semiAxis1(), ell.semiAxis2());
        double dAsrd = Math.min(ell.semiAxis1(), ell.semiAxis2());
        double dAslp = Math.atan2(ell.position().x().y(), ell.position().x().x());
        if (ell.xRadius() < ell.yRadius()) {
            dAslp += 1.5707963267948966;
        }
        double dBslp = Math.atan2(par.position().x().y(), par.position().x().x());
        JgclVector2D ac2bc = par.position().location().subtract(ell.position().location());
        double erotcos = Math.cos(dAslp);
        double erotsin = Math.sin(dAslp);
        double rotateX = erotcos * ac2bc.x() + erotsin * ac2bc.y();
        double rotateY = -erotsin * ac2bc.x() + erotcos * ac2bc.y();
        JgclCartesianPoint2D eiBc = new JgclCartesianPoint2D(rotateX, rotateY);
        double eslope = dBslp - dAslp;
        double erc = Math.cos(eslope);
        double ers = Math.sin(eslope);
        double[] coefficent = this.getCoefficent(ell, par, (JgclPoint2D)eiBc, dAlrd, dAsrd, ers, erc);
        JgclComplex[] root = this.getRoot(coefficent);
        if (root == null) {
            return new JgclIntersectionPoint2D[0];
        }
        return this.getIntersection(ell, par, root, (JgclPoint2D)eiBc, dAlrd, dAsrd, ers, erc, doExchange);
    }

    double[] getCoefficent(JgclEllipse2D ell, JgclHyperbola2D hyp, JgclPoint2D eiBc, double dAlrd, double dAsrd, double ers, double erc) {
        double[] eprep = new double[6];
        double[] ercoef = new double[5];
        double a = dAlrd;
        double b = dAsrd;
        double a2 = a * a;
        double b2 = b * b;
        double e = hyp.xRadius();
        double f = hyp.yRadius();
        double cx = eiBc.x();
        double cy = eiBc.y();
        double erc2 = erc * erc;
        double ers2 = ers * ers;
        eprep[0] = e * e * (b2 * erc2 + a2 * ers2);
        eprep[1] = f * f * (b2 * ers2 + a2 * erc2);
        eprep[2] = 2.0 * e * f * erc * ers * (a2 - b2);
        eprep[3] = 2.0 * e * (b2 * cx * erc + a2 * cy * ers);
        eprep[4] = 2.0 * f * (a2 * cy * erc - b2 * cx * ers);
        eprep[5] = b2 * cx * cx + a2 * cy * cy - a2 * b2;
        ercoef[4] = eprep[1] + eprep[0];
        ercoef[0] = eprep[5] + eprep[0];
        ercoef[1] = eprep[2] * eprep[3];
        ercoef[3] = 2.0 * (ercoef[4] * eprep[4] - ercoef[1]);
        ercoef[1] = 2.0 * (ercoef[0] * eprep[4] - ercoef[1]);
        ercoef[2] = 2.0 * ercoef[4] * ercoef[0] + eprep[4] * eprep[4] - eprep[2] * eprep[2] - eprep[3] * eprep[3];
        ercoef[4] = ercoef[4] * ercoef[4] - eprep[2] * eprep[2];
        ercoef[0] = ercoef[0] * ercoef[0] - eprep[3] * eprep[3];
        return ercoef;
    }

    private JgclIntersectionPoint2D[] getIntersection(JgclEllipse2D ell, JgclHyperbola2D hyp, JgclComplex[] root, JgclPoint2D eiBc, double dAlrd, double dAsrd, double ers, double erc, boolean doExchange) {
        double dTol = ell.getToleranceForDistance();
        Vector<JgclIntersectionPoint2D> intervec = new Vector<JgclIntersectionPoint2D>();
        int i = 0;
        while (i < root.length) {
            double sinhB = root[i].real();
            double coshB = Math.sqrt(1.0 + sinhB * sinhB);
            double pPntx = hyp.xRadius() * coshB;
            double pPnty = hyp.yRadius() * sinhB;
            double bPntx = erc * pPntx - ers * pPnty + eiBc.x();
            double bPnty = ers * pPntx + erc * pPnty + eiBc.y();
            double cosA = bPntx / dAlrd;
            if (cosA > 1.0) {
                cosA = 1.0;
            }
            if (cosA < -1.0) {
                cosA = -1.0;
            }
            double pA = Math.acos(cosA);
            JgclCartesianPoint2D lbPnt = new JgclCartesianPoint2D(bPntx, bPnty);
            int j = 0;
            while (j < 2) {
                JgclCartesianPoint2D laPnt = new JgclCartesianPoint2D(dAlrd * Math.cos(pA), dAsrd * Math.sin(pA));
                if (laPnt.identical(lbPnt)) break;
                pA = Math.PI * 2 - pA;
                ++j;
            }
            if (j != 2) {
                JgclIntersectionPoint2D inter;
                double Bparam;
                JgclPointOnCurve2D bPnt;
                JgclPointOnCurve2D aPnt;
                double Aparam = pA;
                if (ell.xRadius() < ell.yRadius()) {
                    Aparam += 1.5707963267948966;
                }
                if (Aparam < 0.0 || Aparam > Math.PI * 2) {
                    Aparam = JgclMath.normalizeAngle(Aparam);
                }
                if ((aPnt = new JgclPointOnCurve2D(ell, Aparam, false)).identical(bPnt = new JgclPointOnCurve2D(hyp, Bparam = Math.log(sinhB + coshB), false)) && (inter = new JgclIntersectionPoint2D(aPnt, bPnt, false)) != null && this.checkUnique(inter, intervec)) {
                    intervec.addElement(inter);
                }
            }
            ++i;
        }
        JgclIntersectionPoint2D[] intersectPoints = this.vectorToArray(intervec, doExchange);
        return intersectPoints;
    }

    JgclIntersectionPoint2D[] intersection(JgclEllipse2D ell, JgclHyperbola2D hyp, boolean doExchange) {
        double dTol = ell.getToleranceForDistance();
        double dAlrd = Math.max(ell.semiAxis1(), ell.semiAxis2());
        double dAsrd = Math.min(ell.semiAxis1(), ell.semiAxis2());
        double dAslp = Math.atan2(ell.position().x().y(), ell.position().x().x());
        if (ell.xRadius() < ell.yRadius()) {
            dAslp += 1.5707963267948966;
        }
        double dBslp = Math.atan2(hyp.position().x().y(), hyp.position().x().x());
        JgclVector2D ac2bc = hyp.position().location().subtract(ell.position().location());
        double erotcos = Math.cos(dAslp);
        double erotsin = Math.sin(dAslp);
        double rotateX = erotcos * ac2bc.x() + erotsin * ac2bc.y();
        double rotateY = -erotsin * ac2bc.x() + erotcos * ac2bc.y();
        JgclCartesianPoint2D eiBc = new JgclCartesianPoint2D(rotateX, rotateY);
        double eslope = dBslp - dAslp;
        double erc = Math.cos(eslope);
        double ers = Math.sin(eslope);
        double[] coefficent = this.getCoefficent(ell, hyp, (JgclPoint2D)eiBc, dAlrd, dAsrd, ers, erc);
        JgclComplex[] root = this.getRoot(coefficent);
        if (root == null) {
            return new JgclIntersectionPoint2D[0];
        }
        return this.getIntersection(ell, hyp, root, (JgclPoint2D)eiBc, dAlrd, dAsrd, ers, erc, doExchange);
    }
}

