/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterferenceList;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclIntsCylCyl3D {
    private static final int COINCIDENT = 0;
    private static final int PARALLEL = 1;
    private static final int PARALLEL_NO_TOUCH = 2;
    private static final int PARALLEL_TOUCH = 3;
    private static final int PARALLEL_INTERSECT = 4;
    private static final int INTERSECT_SAME_RADIUS = 5;
    private static final int NO_INTERSECT_OUT_OF_LINE = 6;
    private static final int NO_INTERSECT_BETWEEN_LINE = 7;
    private static final int NO_INTERSECT_TOUCH_OUTSIDE = 8;
    private static final int NO_INTERSECT_TOUCH_INSIDE = 9;
    private static final int NO_INTERSECT_LINE_INTERSECT = 10;
    private JgclCylindricalSurface3D bCyl;
    private JgclCylindricalSurface3D sCyl;
    private JgclPoint3D bOrg;
    private JgclPoint3D sOrg;
    private JgclLine3D bAxis;
    private JgclLine3D sAxis;
    private JgclVector3D bCylU;
    private JgclVector3D bCylV;
    private JgclVector3D bCylW;
    private double w1w2;
    private static final int nst = 41;
    private boolean doExchange;
    private JgclIntersectionPoint3D axisIntsP;
    private JgclIntersectionPoint3D[] bLineSCylIntsP;

    private JgclIntsCylCyl3D(JgclCylindricalSurface3D cyl1, JgclCylindricalSurface3D cyl2, boolean doExchange) {
        if (cyl1.radius() < cyl2.radius()) {
            this.sCyl = cyl1;
            this.bCyl = cyl2;
            this.doExchange = !doExchange;
        } else {
            this.sCyl = cyl2;
            this.bCyl = cyl1;
            this.doExchange = doExchange;
        }
        JgclAxis2Placement3D bPosition = this.bCyl.position();
        JgclAxis2Placement3D sPosition = this.sCyl.position();
        this.bOrg = bPosition.location();
        this.sOrg = sPosition.location();
        this.bAxis = this.bCyl.getAxis();
        this.sAxis = this.sCyl.getAxis();
        this.bCylW = bPosition.z();
        this.bCylV = this.bCylW.crossProduct(this.sOrg.subtract(this.bOrg)).unitized();
        this.bCylU = this.bCylV.crossProduct(this.bCylW).unitized();
        this.w1w2 = this.bAxis.dir().dotProduct(this.sAxis.dir());
    }

    private JgclLine3D[] makeLinesOnCylinder() {
        JgclVector3D zOfSCyl = this.sAxis.dir();
        JgclVector3D zOfBCyl = this.bAxis.dir();
        JgclVector3D evec = zOfSCyl.crossProduct(zOfBCyl);
        JgclVector3D axis = evec.crossProduct(zOfBCyl);
        JgclVector3D refDirection = zOfBCyl;
        JgclPoint3D location = this.bCyl.position().location();
        JgclPlane3D bPlane = new JgclPlane3D(new JgclAxis2Placement3D(location, axis, refDirection));
        try {
            JgclSurfaceSurfaceInterference3D[] intf = this.bCyl.intersect(bPlane);
            int nSol = intf.length;
            JgclLine3D[] lines = new JgclLine3D[nSol];
            int i = 0;
            while (i < nSol) {
                JgclParametricCurve3D curve = intf[i].toIntersectionCurve().curve3d();
                if (curve instanceof JgclLine3D) {
                    lines[i] = (JgclLine3D)curve;
                }
                ++i;
            }
            return lines;
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    private int getRelationInParallel() {
        double sRadius;
        JgclPoint3D source = this.sOrg;
        JgclPointOnCurve3D[] foot = this.bAxis.projectFrom(source);
        if (foot.length != 1) {
            throw new JgclFatal();
        }
        double dist = source.distance(foot[0]);
        double dTol = this.bCyl.getToleranceForDistance();
        double bRadius = this.bCyl.radius();
        if (Math.abs(dist - (bRadius + (sRadius = this.sCyl.radius()))) < dTol || Math.abs(dist - (bRadius - sRadius)) < dTol) {
            return 3;
        }
        if (dist > bRadius + sRadius || dist < bRadius - sRadius) {
            return 2;
        }
        return 4;
    }

    private int getRelationInNotParallel() {
        JgclIntersectionPoint3D[] intsP;
        double dTol = this.bCyl.getToleranceForDistance();
        try {
            intsP = this.bAxis.intersect(this.sAxis);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        if (intsP.length == 1 && Math.abs(this.bCyl.radius() - this.sCyl.radius()) < dTol) {
            this.axisIntsP = intsP[0];
            return 5;
        }
        return this.getRelationInNotParallelNotIntersect();
    }

    private int getRelationInNotParallelNotIntersect() {
        JgclIntersectionPoint3D[] intsPB2;
        JgclIntersectionPoint3D[] intsPB1;
        JgclLine3D[] bLines = this.makeLinesOnCylinder();
        try {
            intsPB1 = bLines[0].intersect(this.sCyl);
            intsPB2 = bLines[1].intersect(this.sCyl);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        int n1 = intsPB1.length;
        int n2 = intsPB2.length;
        this.bLineSCylIntsP = n1 != 0 ? intsPB1 : (n2 != 0 ? intsPB2 : null);
        if (n1 == 0 && n2 == 0) {
            return this.noIntersectionPoint();
        }
        if (n1 == 0 && n2 == 1 || n1 == 1 && n2 == 0) {
            return this.oneIntersectionPoint();
        }
        if (n1 == 0 && n2 == 2 || n1 == 2 && n2 == 0) {
            return 10;
        }
        throw new JgclFatal();
    }

    private int noIntersectionPoint() {
        JgclIntersectionPoint3D[] point;
        try {
            point = this.bCyl.intersect(this.sAxis);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        if (point.length == 0) {
            return 6;
        }
        return 7;
    }

    private int oneIntersectionPoint() {
        JgclIntersectionPoint3D[] point;
        try {
            point = this.bCyl.intersect(this.sAxis);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        if (point.length == 0) {
            return 8;
        }
        return 9;
    }

    private int twoIntersectionPoint() {
        return 10;
    }

    private int getRelation() {
        if (this.bCyl.equals(this.sCyl)) {
            return 0;
        }
        if (this.bCyl.isParallel(this.sCyl)) {
            return this.getRelationInParallel();
        }
        return this.getRelationInNotParallel();
    }

    private JgclSurfaceSurfaceInterference3D[] makeOneLine() {
        JgclVector3D bTos = this.bCylU.multiply(this.bCyl.radius());
        JgclPoint3D point = this.bOrg.add(bTos);
        JgclVector3D direction = this.bCylW;
        JgclLine3D res = new JgclLine3D(point, direction);
        JgclIntersectionCurve3D ints = this.bCyl.curveToIntersectionCurve(res, this.sCyl, this.doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
        return sol;
    }

    private JgclSurfaceSurfaceInterference3D[] makeTwoLine() {
        JgclIntersectionPoint3D[] intsP;
        JgclCircle3D bCylCircle = new JgclCircle3D(this.bCyl.position(), this.bCyl.radius());
        try {
            intsP = bCylCircle.intersect(this.sCyl);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        if (intsP.length != 2) {
            throw new JgclFatal();
        }
        JgclLine3D res = new JgclLine3D((JgclPoint3D)intsP[0], this.bCylW);
        JgclIntersectionCurve3D ints1 = this.bCyl.curveToIntersectionCurve(res, this.sCyl, this.doExchange);
        res = new JgclLine3D((JgclPoint3D)intsP[1], this.bCylW);
        JgclIntersectionCurve3D ints2 = this.bCyl.curveToIntersectionCurve(res, this.sCyl, this.doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints1, ints2};
        return sol;
    }

    private JgclSurfaceSurfaceInterference3D[] makeTwoEllipse() {
        double theta = this.bAxis.angleWith(this.sAxis);
        JgclVector3D zOfBCyl = this.bAxis.dir();
        JgclVector3D zOfSCyl = this.sAxis.dir();
        JgclVector3D w1 = zOfSCyl.add(zOfBCyl).unitized();
        JgclVector3D w2 = zOfSCyl.subtract(zOfBCyl).unitized();
        if (this.axisIntsP == null) {
            throw new JgclFatal();
        }
        double bRadius = this.bCyl.radius();
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(this.axisIntsP, w1, w2);
        double xRadius = bRadius / Math.cos(theta / 2.0);
        double yRadius = bRadius;
        JgclEllipse3D ellipse = new JgclEllipse3D(position, xRadius, yRadius);
        JgclIntersectionCurve3D ints1 = this.bCyl.curveToIntersectionCurve(ellipse, this.sCyl, this.doExchange);
        position = new JgclAxis2Placement3D(this.axisIntsP, w2, w1);
        xRadius = bRadius / Math.sin(theta / 2.0);
        yRadius = bRadius;
        ellipse = new JgclEllipse3D(position, xRadius, yRadius);
        JgclIntersectionCurve3D ints2 = this.bCyl.curveToIntersectionCurve(ellipse, this.sCyl, this.doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints1, ints2};
        return sol;
    }

    private JgclPoint3D uvPointFromT(JgclPoint3D point, JgclVector3D uVec, JgclVector3D vVec, double r, double t) {
        double cost = Math.cos(t);
        double sint = Math.sin(t);
        return new JgclCartesianPoint3D(point.x() + r * (cost * uVec.x() + sint * vVec.x()), point.y() + r * (cost * uVec.y() + sint * vVec.y()), point.z() + r * (cost * uVec.z() + sint * vVec.z()));
    }

    private JgclVector3D[] getUVVector() {
        JgclPointOnCurve3D[] cNorm;
        try {
            cNorm = this.sAxis.commonNormal(this.bAxis);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        JgclVector3D cSw = this.sAxis.dir();
        JgclVector3D cSu = cNorm[1].subtract(cNorm[0]).unitized();
        if (cSu.norm() == 0.0) {
            cSu = this.sCyl.position().effectiveRefDirection();
        }
        JgclVector3D cSv = cSw.crossProduct(cSu).unitized();
        JgclVector3D[] unitVec = new JgclVector3D[]{cSu, cSv, cSw};
        return unitVec;
    }

    private JgclSurfaceSurfaceInterference3D[] makeTwoCurve() {
        double step = 0.15707963267948966;
        double[] dA = new double[3];
        JgclVector3D[] uvVec = this.getUVVector();
        JgclPoint3D[] pArray1 = new JgclPoint3D[41];
        JgclPoint3D[] pArray2 = new JgclPoint3D[41];
        dA[2] = 1.0 - this.w1w2 * this.w1w2;
        int i = 0;
        while (i < 41) {
            double dX0;
            double dX1;
            double t = -Math.PI + (double)i * step;
            JgclPoint3D ePnt = this.uvPointFromT(this.sOrg, uvVec[0], uvVec[1], this.sCyl.radius(), t);
            JgclVector3D evec = this.sAxis.dir().subtract(this.bAxis.dir().multiply(this.w1w2));
            JgclVector3D evec2 = ePnt.subtract(this.bOrg);
            dA[1] = 2.0 * evec.dotProduct(evec2);
            double ework = evec2.dotProduct(this.bAxis.dir());
            dA[0] = evec2.dotProduct(evec2) - ework * ework - this.bCyl.radius() * this.bCyl.radius();
            JgclRealPolynomial poly = new JgclRealPolynomial(dA);
            double[] dX = poly.getAlwaysRootsIfQuadric();
            if (dX == null) {
                throw new JgclFatal();
            }
            if (dX.length == 1) {
                dX0 = dX1 = dX[0];
            } else if (dX[0] < dX[1]) {
                dX0 = dX[1];
                dX1 = dX[0];
            } else {
                dX0 = dX[0];
                dX1 = dX[1];
            }
            pArray1[i] = ePnt.add(this.sAxis.dir().multiply(dX0));
            pArray2[i] = ePnt.add(this.sAxis.dir().multiply(dX1));
            ++i;
        }
        JgclPolyline3D pol = new JgclPolyline3D(pArray1);
        JgclIntersectionCurve3D ints1 = this.bCyl.curveToIntersectionCurve(pol, this.sCyl, this.doExchange);
        pol = new JgclPolyline3D(pArray2);
        JgclIntersectionCurve3D ints2 = this.bCyl.curveToIntersectionCurve(pol, this.sCyl, this.doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints1, ints2};
        return sol;
    }

    private JgclSurfaceSurfaceInterference3D[] makeOnePoint() {
        if (this.bLineSCylIntsP.length != 1) {
            throw new JgclFatal();
        }
        JgclSurfaceSurfaceInterferenceList intf = new JgclSurfaceSurfaceInterferenceList(this.bCyl, this.sCyl);
        JgclPoint3D point = this.bLineSCylIntsP[0].coordinates();
        double[] paramsA = this.bCyl.pointToParameter(point);
        double[] paramsB = this.sCyl.pointToParameter(point);
        intf.addAsIntersectionPoint(point, paramsA[0], paramsA[1], paramsB[0], paramsB[1]);
        return intf.toJgclSurfaceSurfaceInterference3DArray(this.doExchange);
    }

    private JgclSurfaceSurfaceInterference3D[] makeEightFigureCurve() {
        return this.makeTwoCurve();
    }

    private JgclSurfaceSurfaceInterference3D[] makeOneCurve() {
        double dX0;
        double dX1;
        double[] dX;
        JgclRealPolynomial poly;
        double ework;
        JgclVector3D evec2;
        JgclPoint3D ePnt;
        double t;
        int myNst = 81;
        double[] dA = new double[3];
        JgclVector3D[] uvVec = this.getUVVector();
        JgclPoint3D[] pArray = new JgclPoint3D[myNst];
        JgclVector3D evec = this.bLineSCylIntsP[0].subtract(this.sOrg);
        evec = evec.project(uvVec[2]).unitized();
        double t0 = Math.acos(evec.dotProduct(uvVec[0]));
        double step = 2.0 * t0 / 40.0;
        dA[2] = 1.0 - this.w1w2 * this.w1w2;
        int i = 0;
        while (i < 40) {
            t = -t0 + (double)i * step;
            ePnt = this.uvPointFromT(this.sOrg, uvVec[0], uvVec[1], this.sCyl.radius(), t);
            evec = this.sAxis.dir().subtract(this.bAxis.dir().multiply(this.w1w2));
            evec2 = ePnt.subtract(this.bOrg);
            dA[1] = 2.0 * evec.dotProduct(evec2);
            ework = evec2.dotProduct(this.bAxis.dir());
            dA[0] = evec2.dotProduct(evec2) - ework * ework - this.bCyl.radius() * this.bCyl.radius();
            poly = new JgclRealPolynomial(dA);
            dX = poly.getAlwaysRootsIfQuadric();
            if (dX == null) {
                throw new JgclFatal();
            }
            if (dX.length == 1) {
                dX0 = dX1 = dX[0];
            } else if (dX[0] < dX[1]) {
                dX0 = dX[1];
                dX1 = dX[0];
            } else {
                dX0 = dX[0];
                dX1 = dX[1];
            }
            pArray[i] = ePnt.add(this.sAxis.dir().multiply(dX0));
            pArray[myNst - 1 - i] = ePnt.add(this.sAxis.dir().multiply(dX1));
            ++i;
        }
        t = t0;
        ePnt = this.uvPointFromT(this.sOrg, uvVec[0], uvVec[1], this.sCyl.radius(), t);
        evec = this.sAxis.dir().subtract(this.bAxis.dir().multiply(this.w1w2));
        evec2 = ePnt.subtract(this.bOrg);
        dA[1] = 2.0 * evec.dotProduct(evec2);
        ework = evec2.dotProduct(this.bAxis.dir());
        dA[0] = evec2.dotProduct(evec2) - ework * ework - this.bCyl.radius() * this.bCyl.radius();
        poly = new JgclRealPolynomial(dA);
        dX = poly.getAlwaysRootsIfQuadric();
        if (dX == null) {
            throw new JgclFatal();
        }
        if (dX.length == 1) {
            dX0 = dX1 = dX[0];
        } else if (dX[0] < dX[1]) {
            dX0 = dX[1];
            dX1 = dX[0];
        } else {
            dX0 = dX[0];
            dX1 = dX[1];
        }
        pArray[40] = ePnt.add(this.sAxis.dir().multiply(dX0));
        JgclPolyline3D pol = new JgclPolyline3D(pArray);
        JgclIntersectionCurve3D ints = this.bCyl.curveToIntersectionCurve(pol, this.sCyl, this.doExchange);
        JgclSurfaceSurfaceInterference3D[] sol = new JgclSurfaceSurfaceInterference3D[]{ints};
        return sol;
    }

    private JgclSurfaceSurfaceInterference3D[] noIntersectionCurve() {
        return new JgclSurfaceSurfaceInterference3D[0];
    }

    static JgclSurfaceSurfaceInterference3D[] intersection(JgclCylindricalSurface3D cyl1, JgclCylindricalSurface3D cyl2, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntsCylCyl3D doObj = new JgclIntsCylCyl3D(cyl1, cyl2, doExchange);
        switch (doObj.getRelation()) {
            case 0: {
                throw new JgclIndefiniteSolution(cyl1);
            }
            case 2: {
                return doObj.noIntersectionCurve();
            }
            case 3: {
                return doObj.makeOneLine();
            }
            case 4: {
                return doObj.makeTwoLine();
            }
            case 5: {
                return doObj.makeTwoEllipse();
            }
            case 6: {
                return doObj.noIntersectionCurve();
            }
            case 7: {
                return doObj.makeTwoCurve();
            }
            case 8: {
                return doObj.makeOnePoint();
            }
            case 9: {
                return doObj.makeEightFigureCurve();
            }
            case 10: {
                return doObj.makeOneCurve();
            }
        }
        throw new JgclFatal();
    }
}

