/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.NoSuchElementException;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclConicalSurface3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclGeometry;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMachineEpsilon;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclUtil;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclIntsConCon3D {
    private JgclConicalSurface3D geomA;
    private JgclConicalSurface3D geomB;
    private JgclConicalSurface3D coneB;
    private JgclConicalSurface3D coneS;
    private JgclVector3D b2s;
    private JgclVector3D s2b;
    private double dist;
    private double theta;
    private double phiS;
    private double phiB;
    private double aTol;
    private double dTol;
    private static int nst = 20;
    private JgclConicalSurface3D cp;
    private JgclConicalSurface3D co;
    private JgclVector3D wp;
    private JgclVector3D wo;
    private JgclPoint3D vep;
    private JgclPoint3D veo;
    private double phip;
    private double alpp;
    private double cosp;
    private double coso;
    private double tanp;
    private double tano;
    private JgclVector3D p2o;
    private JgclVector3D o2p;
    static final double MY_HUGE = 1.0E7;

    private void setupParams(JgclConicalSurface3D geomA, JgclConicalSurface3D geomB) {
        this.aTol = geomA.getToleranceForAngle();
        this.dTol = geomA.getToleranceForDistance();
        this.geomA = geomA;
        this.geomB = geomB;
        if (geomA.semiAngle() > geomB.semiAngle()) {
            this.coneB = geomA;
            this.coneS = geomB;
        } else {
            this.coneB = geomB;
            this.coneS = geomA;
        }
        this.b2s = this.coneS.apex().subtract(this.coneB.apex());
        this.s2b = this.coneB.apex().subtract(this.coneS.apex());
        this.dist = this.b2s.length();
        this.phiS = Math.acos(this.s2b.dotProduct(this.coneS.position().z()) / this.dist);
        this.phiB = Math.acos(this.b2s.dotProduct(this.coneB.position().z()) / this.dist);
        double ework = this.coneB.position().z().dotProduct(this.coneS.position().z());
        if (ework > 1.0) {
            ework = 1.0;
        }
        if (ework < -1.0) {
            ework = -1.0;
        }
        this.theta = Math.acos(ework);
    }

    JgclIntsConCon3D(JgclConicalSurface3D geomA, JgclConicalSurface3D geomB) {
        this.setupParams(geomA, geomB);
    }

    private JgclLiteralVector3D uvwPointFromT(JgclVector3D u, JgclVector3D v, JgclVector3D w, double ctan, double t) {
        double cosT = Math.cos(t);
        double sinT = Math.sin(t);
        double x = ctan * (cosT * u.x() + sinT * v.x()) + w.x();
        double y = ctan * (cosT * u.y() + sinT * v.y()) + w.y();
        double z = ctan * (cosT * u.z() + sinT * v.z()) + w.z();
        return new JgclLiteralVector3D(x, y, z);
    }

    private double coefA(JgclVector3D evec, JgclVector3D w2, double cosa1, double cosa2) {
        double edot = evec.dotProduct(w2);
        return edot * edot - cosa2 * cosa2 / (cosa1 * cosa1);
    }

    private double coefB(JgclVector3D evec, JgclVector3D v12v2, JgclVector3D w2, double cosa2) {
        double edot = v12v2.dotProduct(w2);
        double cosa22 = cosa2 * cosa2;
        JgclVector3D sw2 = w2.multiply(edot);
        sw2 = sw2.subtract(v12v2.multiply(cosa22));
        return 2.0 * sw2.dotProduct(evec);
    }

    private double coefC(JgclVector3D v12v2, JgclVector3D w2, double cosa2) {
        double edot = v12v2.dotProduct(w2);
        return edot * edot - cosa2 * cosa2 * v12v2.dotProduct(v12v2);
    }

    private double[] aZero(JgclConicalSurface3D cp, JgclConicalSurface3D co, JgclPoint3D cpOrg, JgclVector3D up, JgclVector3D wp, JgclVector3D wo) {
        JgclIntersectionPoint3D[] ints;
        JgclPoint3D loc = cpOrg.add(wo);
        JgclVector3D axis = co.position().z();
        JgclVector3D refDir = co.position().x();
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(loc, axis, refDir);
        double radius = Math.tan(co.semiAngle());
        JgclCircle3D circle = new JgclCircle3D(position, radius);
        try {
            ints = circle.intersect(cp);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        double[] azero = new double[ints.length];
        int i = 0;
        while (i < ints.length) {
            JgclVector3D evec = ints[i].subtract(cpOrg);
            evec = evec.project(wp).unitized();
            azero[i] = up.angleWith(evec, wp);
            ++i;
        }
        return azero;
    }

    private double[] bZero(JgclConicalSurface3D cp, JgclConicalSurface3D co, JgclPoint3D cpOrg, JgclVector3D up, JgclVector3D wp, JgclPoint3D coOrg, JgclVector3D wo) {
        JgclIntersectionPoint3D[] ints;
        JgclVector3D eO2P = cpOrg.subtract(coOrg);
        double edot = eO2P.dotProduct(wo);
        JgclVector3D evec = wo.multiply(edot);
        double ecos = Math.cos(co.semiAngle());
        double ecos2 = ecos * ecos;
        JgclVector3D axis = evec.subtract(eO2P.multiply(ecos2));
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(cpOrg, axis, wo);
        JgclPlane3D plane = new JgclPlane3D(position);
        JgclCircle3D circle = new JgclCircle3D(cp.position(), cp.radius());
        try {
            ints = circle.intersect(plane);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        double[] bzero = new double[ints.length];
        int i = 0;
        while (i < ints.length) {
            evec = ints[i].subtract(cpOrg);
            evec = evec.project(wp).unitized();
            bzero[i] = up.angleWith(evec, wp);
            ++i;
        }
        return bzero;
    }

    private boolean areCoplanar(JgclVector3D w1, JgclVector3D w2, JgclVector3D diff) {
        JgclVector3D b;
        JgclVector3D udiff = diff.unitized();
        JgclVector3D a = w1.crossProduct(udiff).unitized();
        return Math.abs(a.dotProduct(b = w2.crossProduct(udiff).unitized())) > Math.cos(this.aTol);
    }

    private boolean areRealTangent(JgclVector3D sz, JgclVector3D bz, JgclVector3D s2b, JgclVector3D b2s) {
        JgclVector3D b;
        JgclVector3D a;
        if (sz.dotProduct(s2b) > 0.0) {
            a = s2b.crossProduct(sz);
            b = s2b.crossProduct(bz);
        } else {
            a = b2s.crossProduct(sz);
            b = b2s.crossProduct(bz);
        }
        return a.dotProduct(b) <= 0.0;
    }

    private JgclSurfaceSurfaceInterference3D[] axesAreOverlap(boolean doExchange) throws JgclIndefiniteSolution {
        JgclSurfaceSurfaceInterference3D[] intf;
        if (this.dist < this.dTol) {
            JgclSurfaceSurfaceInterference3D[] work;
            JgclPoint3D mid = this.coneB.apex().midPoint(this.coneS.apex());
            JgclIntersectionPoint3D intersectPoint = this.geomA.pointToIntersectionPoint(mid, this.geomB, doExchange);
            if (Math.abs(this.coneB.semiAngle() - this.coneS.semiAngle()) < this.aTol) {
                throw new JgclIndefiniteSolution(intersectPoint);
            }
            intf = work = new JgclSurfaceSurfaceInterference3D[]{intersectPoint};
        } else {
            double tanB = Math.tan(this.coneB.semiAngle());
            double tanS = Math.tan(this.coneS.semiAngle());
            double x1 = this.dist * tanB / (tanB + tanS);
            JgclVector3D axis = this.coneS.position().z();
            JgclVector3D refDir = this.coneS.position().x();
            JgclPoint3D location1 = this.coneS.apex().add(axis.multiply(x1));
            JgclAxis2Placement3D position1 = new JgclAxis2Placement3D(location1, axis, refDir);
            JgclCircle3D circle1 = new JgclCircle3D(position1, x1 * tanS);
            JgclIntersectionCurve3D ints1 = this.geomA.curveToIntersectionCurve(circle1, this.geomB, doExchange);
            if (Math.abs(this.coneB.semiAngle() - this.coneS.semiAngle()) < this.aTol) {
                JgclSurfaceSurfaceInterference3D[] work = new JgclSurfaceSurfaceInterference3D[]{ints1};
                intf = work;
            } else {
                double x2 = this.dist + this.dist * tanS / (tanB - tanS);
                JgclPoint3D location2 = this.coneS.apex().add(axis.multiply(x2));
                JgclAxis2Placement3D position2 = new JgclAxis2Placement3D(location2, axis, refDir);
                JgclCircle3D circle2 = new JgclCircle3D(position2, x2 * tanS);
                JgclIntersectionCurve3D ints2 = this.geomA.curveToIntersectionCurve(circle2, this.geomB, doExchange);
                JgclSurfaceSurfaceInterference3D[] work = new JgclSurfaceSurfaceInterference3D[]{ints1, ints2};
                intf = work;
            }
        }
        return intf;
    }

    /*
     * Exception decompiling
     */
    private JgclSurfaceSurfaceInterference3D[] getConic() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JgclSurfaceSurfaceInterference3D[] rulingTangent(boolean doExchange) {
        JgclLine3D resL;
        JgclIntersectionCurve3D ints = null;
        JgclSurfaceSurfaceInterference3D[] resG = null;
        if (Math.abs(this.theta - (this.coneS.semiAngle() + this.coneB.semiAngle())) < this.aTol && this.areRealTangent(this.coneS.position().z(), this.coneB.position().z(), this.s2b, this.b2s)) {
            resL = this.coneS.position().z().dotProduct(this.s2b) > 0.0 ? new JgclLine3D(this.coneB.apex(), this.s2b) : new JgclLine3D(this.coneS.apex(), this.b2s);
            ints = this.geomA.curveToIntersectionCurve(resL, this.geomB, doExchange);
        } else if (Math.abs(this.theta - (this.coneB.semiAngle() - this.coneS.semiAngle())) < this.aTol) {
            if (this.coneB.position().z().dotProduct(this.b2s) > 0.0) {
                resL = new JgclLine3D(this.coneS.apex(), this.b2s);
                ints = this.geomA.curveToIntersectionCurve(resL, this.geomB, doExchange);
            } else {
                resL = new JgclLine3D(this.coneB.apex(), this.s2b);
                ints = this.geomA.curveToIntersectionCurve(resL, this.geomB, doExchange);
                resG = this.getConic();
            }
        } else if (Math.abs(this.coneS.semiAngle() + this.coneB.semiAngle() + this.theta - Math.PI) < this.aTol) {
            if (this.coneB.position().z().dotProduct(this.b2s) > 0.0) {
                resL = new JgclLine3D(this.coneB.apex(), this.coneS.apex());
                ints = this.geomA.curveToIntersectionCurve(resL, this.geomB, doExchange);
                resG = this.getConic();
            } else if (this.coneS.semiAngle() + this.coneB.semiAngle() > 1.5707963267948966 + this.aTol) {
                resG = this.getConic();
            }
        } else if (Math.abs(this.coneB.semiAngle() + this.theta - this.coneS.semiAngle() - Math.PI) < this.aTol && this.coneB.position().z().dotProduct(this.b2s) > 0.0) {
            resL = new JgclLine3D(this.coneB.apex(), this.coneS.apex());
            ints = this.geomA.curveToIntersectionCurve(resL, this.geomB, doExchange);
        }
        Vector<JgclSurfaceSurfaceInterference3D> vec = new Vector<JgclSurfaceSurfaceInterference3D>();
        if (ints != null) {
            vec.addElement(ints);
        }
        if (resG != null) {
            int i = 0;
            while (i < resG.length) {
                vec.addElement(resG[i]);
                ++i;
            }
        }
        Object[] intf = new JgclSurfaceSurfaceInterference3D[vec.size()];
        vec.copyInto(intf);
        return intf;
    }

    private JgclSurfaceSurfaceInterference3D[] fourLines(boolean doExchange) {
        JgclSurfaceSurfaceInterference3D[] intf;
        JgclIntersectionPoint3D[] rcv;
        JgclCircle3D circle = new JgclCircle3D(this.coneB.position(), this.coneB.radius());
        try {
            rcv = circle.intersect(this.coneS);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        int numberOfSolutions = rcv.length;
        JgclPoint3D pnt = this.coneB.apex().midPoint(this.coneS.apex());
        if (numberOfSolutions == 0) {
            JgclIntersectionPoint3D intersectPoint = this.geomA.pointToIntersectionPoint(pnt, this.geomB, doExchange);
            JgclSurfaceSurfaceInterference3D[] work = new JgclSurfaceSurfaceInterference3D[]{intersectPoint};
            intf = work;
        } else {
            JgclSurfaceSurfaceInterference3D[] work = new JgclSurfaceSurfaceInterference3D[numberOfSolutions];
            int i = 0;
            while (i < numberOfSolutions) {
                JgclLine3D line = new JgclLine3D(pnt, rcv[i]);
                work[i] = this.geomA.curveToIntersectionCurve(line, this.geomB, doExchange);
                ++i;
            }
            intf = work;
        }
        return intf;
    }

    private void setParametarizedCone(boolean condition) {
        if (condition) {
            this.cp = this.coneB;
            this.co = this.coneS;
            this.vep = this.coneB.apex();
            this.veo = this.coneS.apex();
            this.wp = this.coneB.position().z();
            this.wo = this.coneS.position().z();
            this.p2o = this.b2s;
            this.o2p = this.s2b;
            this.phip = this.phiB;
            this.alpp = this.coneB.semiAngle();
            this.cosp = Math.cos(this.coneB.semiAngle());
            this.coso = Math.cos(this.coneS.semiAngle());
            this.tanp = Math.tan(this.coneB.semiAngle());
            this.tano = Math.tan(this.coneS.semiAngle());
        } else {
            this.cp = this.coneS;
            this.co = this.coneB;
            this.vep = this.coneS.apex();
            this.veo = this.coneB.apex();
            this.wp = this.coneS.position().z();
            this.wo = this.coneB.position().z();
            this.p2o = this.s2b;
            this.o2p = this.b2s;
            this.phip = this.phiS;
            this.alpp = this.coneS.semiAngle();
            this.cosp = Math.cos(this.coneS.semiAngle());
            this.coso = Math.cos(this.coneB.semiAngle());
            this.tanp = Math.tan(this.coneS.semiAngle());
            this.tano = Math.tan(this.coneB.semiAngle());
        }
    }

    private InterferenceOfVertexIsOnTheOther vertexIsOnTheOther(boolean doExchange) {
        this.setParametarizedCone(Math.abs(this.phiS - this.coneS.semiAngle()) < this.aTol || Math.abs(Math.PI - this.phiS - this.coneS.semiAngle()) < this.aTol);
        JgclVector3D cw = this.wp;
        JgclVector3D cv = cw.crossProduct(this.p2o);
        if (cv.length() / this.dist < Math.sin(this.aTol)) {
            cv = cw.crossProduct(this.wo);
        }
        JgclVector3D cu = cv.crossProduct(cw).unitized();
        cv = cv.unitized();
        double[] azero = this.aZero(this.cp, this.co, this.vep, cu, cw, this.wo);
        int naz = azero.length;
        double[] bzero = this.bZero(this.cp, this.co, this.vep, cu, cw, this.veo, this.wo);
        int nbz = bzero.length;
        Object[] res = null;
        JgclPoint3D res2 = null;
        if (Math.abs(this.phip - this.alpp) < this.aTol || Math.abs(Math.PI - this.phip - this.alpp) < this.aTol) {
            double[] t = new double[6];
            double t1 = 0.0;
            int count1 = 0;
            int count2 = 2;
            while (count1 < naz) {
                if (Math.abs(bzero[0] - azero[count1]) < this.aTol) {
                    t1 = bzero[0];
                    t[0] = bzero[1];
                } else if (Math.abs(bzero[1] - azero[count1]) < this.aTol) {
                    t1 = bzero[1];
                    t[0] = bzero[0];
                } else {
                    t[count2++] = azero[count1];
                }
                ++count1;
            }
            JgclVector3D evec = this.wp.project(this.p2o).unitized();
            t[1] = Math.acos(evec.dotProduct(cu));
            int j0 = 0;
            int jn = count2 - 1;
            JgclUtil.sortDoubleArray(t, j0, jn);
            if (t1 < t[0]) {
                t1 += Math.PI * 2;
            }
            t[count2] = t[0] + Math.PI * 2;
            Vector<JgclPolyline3D> polvec = new Vector<JgclPolyline3D>();
            int i = 0;
            while (i < count2) {
                JgclPoint3D epnt;
                double ework;
                double s;
                double t2 = (t[i] + t[i + 1]) / 2.0;
                if (Math.abs(t2 - t1) < this.aTol) {
                    t2 = (t[i] + t2) / 2.0;
                }
                if (!((s = -this.coefB(evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t2), this.o2p, this.wo, this.coso) / this.coefA(evec, this.wo, this.cosp, this.coso)) < 0.0) && !((ework = (evec = (epnt = this.vep.add(evec.multiply(s))).subtract(this.veo)).dotProduct(this.wo)) < 0.0)) {
                    double step = (t[i + 1] - t[i]) / (double)(nst - 1);
                    Vector<JgclPoint3D> pntvec = new Vector<JgclPoint3D>();
                    int k = 0;
                    while (k < nst) {
                        JgclPoint3D pnt;
                        double a;
                        t2 = t[i] + (double)k * step;
                        if (Math.abs(t2 - t1) < this.aTol) {
                            t2 += this.aTol;
                        }
                        if (Math.abs(a = this.coefA(evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t2), this.wo, this.cosp, this.coso)) < JgclMachineEpsilon.DOUBLE) {
                            t2 = k == 0 ? t[i] + (double)k * step / 2.0 : (t2 -= (double)k * step / 2.0);
                            if (Math.abs(t2 - t1) < this.aTol) {
                                t2 += this.aTol;
                            }
                            evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t2);
                            a = this.coefA(evec, this.wo, this.cosp, this.coso);
                        }
                        if ((pnt = this.vep.add(evec.multiply(s = -this.coefB(evec, this.o2p, this.wo, this.coso) / a))) != null) {
                            pntvec.addElement(pnt);
                        }
                        ++k;
                    }
                    Object[] points = new JgclPoint3D[pntvec.size()];
                    pntvec.copyInto(points);
                    JgclPolyline3D pol = new JgclPolyline3D((JgclPoint3D[])points);
                    if (pol != null) {
                        polvec.addElement(pol);
                    }
                }
                ++i;
            }
            res = new JgclPolyline3D[polvec.size()];
            polvec.copyInto(res);
        } else if (naz == 0) {
            if (nbz == 0) {
                JgclVector3D evec = this.uvwPointFromT(cu, cv, cw, this.tanp, 0.0);
                double s = -this.coefB(evec, this.o2p, this.wo, this.coso) / this.coefA(evec, this.wo, this.cosp, this.coso);
                JgclPoint3D epnt = this.vep.add(evec.multiply(s));
                evec = epnt.subtract(this.veo);
                if (s < 0.0 || evec.dotProduct(this.wo) < 0.0) {
                    res2 = this.vep;
                } else {
                    double step = Math.PI * 2 / (double)(nst - 1);
                    Vector<JgclPoint3D> pntvec = new Vector<JgclPoint3D>();
                    int i = 0;
                    while (i < nst) {
                        double t = -Math.PI + (double)i * step;
                        evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t);
                        s = -this.coefB(evec, this.o2p, this.wo, this.coso) / this.coefA(evec, this.wo, this.cosp, this.coso);
                        JgclPoint3D pnt = this.vep.add(evec.multiply(s));
                        pntvec.addElement(pnt);
                        ++i;
                    }
                    Object[] points = new JgclPoint3D[pntvec.size()];
                    pntvec.copyInto(points);
                    res = new JgclPolyline3D[]{new JgclPolyline3D((JgclPoint3D[])points)};
                    res2 = this.vep;
                }
            } else if (nbz == 1) {
                JgclLiteralVector3D evec = this.uvwPointFromT(cu, cv, cw, this.tanp, 0.0);
                double s = -this.coefB(evec, this.o2p, this.wo, this.coso) / this.coefA(evec, this.wo, this.cosp, this.coso);
                if (s < 0.0) {
                    res2 = this.vep;
                } else {
                    double step = Math.PI * 2 / (double)(nst - 1);
                    Vector<JgclPoint3D> pntvec = new Vector<JgclPoint3D>();
                    int i = 0;
                    while (i < nst) {
                        double t = -Math.PI + (double)i * step;
                        evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t);
                        s = -this.coefB(evec, this.o2p, this.wo, this.coso) / this.coefA(evec, this.wo, this.cosp, this.coso);
                        pntvec.addElement(this.vep.add(evec.multiply(s)));
                        ++i;
                    }
                    Object[] points = new JgclPoint3D[pntvec.size()];
                    pntvec.copyInto(points);
                    res = new JgclPolyline3D[]{new JgclPolyline3D((JgclPoint3D[])points)};
                }
            } else {
                double step;
                double t1;
                double[] t0 = new double[2];
                if (bzero[0] < bzero[1]) {
                    t0[0] = bzero[0];
                    t0[1] = bzero[1];
                } else {
                    t0[0] = bzero[1];
                    t0[1] = bzero[0];
                }
                double t = (t0[0] + t0[1]) / 2.0;
                JgclLiteralVector3D evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t);
                double s = -this.coefB(evec, this.o2p, this.wo, this.coso) / this.coefA(evec, this.wo, this.cosp, this.coso);
                if (s > 0.0) {
                    t1 = t0[0];
                    step = (t0[1] - t0[0]) / (double)(nst - 1);
                } else {
                    t1 = t0[1];
                    step = (Math.PI * 2 + t0[0] - t0[1]) / (double)(nst - 1);
                }
                Vector<JgclPoint3D> pntvec = new Vector<JgclPoint3D>();
                int i = 0;
                while (i < nst) {
                    t = t1 + (double)i * step;
                    evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t);
                    s = -this.coefB(evec, this.o2p, this.wo, this.coso) / this.coefA(evec, this.wo, this.cosp, this.coso);
                    pntvec.addElement(this.vep.add(evec.multiply(s)));
                    ++i;
                }
                Object[] points = new JgclPoint3D[pntvec.size()];
                pntvec.copyInto(points);
                res = new JgclPolyline3D[]{new JgclPolyline3D((JgclPoint3D[])points)};
            }
        } else {
            double[] t1 = new double[7];
            int count1 = 0;
            while (count1 < naz) {
                t1[count1] = azero[count1];
                ++count1;
            }
            int count2 = 0;
            while (count2 < nbz) {
                t1[count1 + count2] = bzero[count2];
                ++count2;
            }
            int j0 = 0;
            int jn = naz + nbz - 1;
            JgclUtil.sortDoubleArray(t1, j0, jn);
            t1[naz + nbz] = t1[0] + Math.PI * 2;
            Vector<JgclPolyline3D> polyvec = new Vector<JgclPolyline3D>();
            int i = 0;
            while (i < naz + nbz) {
                JgclPoint3D epnt;
                double ework;
                double t2 = (t1[i] + t1[i + 1]) / 2.0;
                JgclVector3D evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t2);
                double s1 = -this.coefB(evec, this.o2p, this.wo, this.coso) / this.coefA(evec, this.wo, this.cosp, this.coso);
                if (!(s1 < 0.0) && !((ework = (evec = (epnt = this.vep.add(evec.multiply(s1))).subtract(this.veo)).dotProduct(this.wo)) < 0.0)) {
                    double step1 = (t1[i + 1] - t1[i]) / (double)(nst - 1);
                    Vector<JgclPoint3D> pntvec = new Vector<JgclPoint3D>();
                    int k = 0;
                    while (k < nst) {
                        t2 = t1[i] + (double)k * step1;
                        evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t2);
                        double a = this.coefA(evec, this.wo, this.cosp, this.coso);
                        if (Math.abs(a) < JgclMachineEpsilon.DOUBLE) {
                            t2 = k == 0 ? t1[i] + step1 / 2.0 : (t2 -= step1 / 2.0);
                            evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t2);
                            a = this.coefA(evec, this.wo, this.cosp, this.coso);
                        }
                        s1 = -this.coefB(evec, this.o2p, this.wo, this.coso) / a;
                        pntvec.addElement(this.vep.add(evec.multiply(s1)));
                        ++k;
                    }
                    Object[] points = new JgclPoint3D[pntvec.size()];
                    pntvec.copyInto(points);
                    JgclPolyline3D poly = new JgclPolyline3D((JgclPoint3D[])points);
                    polyvec.addElement(poly);
                }
                ++i;
            }
            res = new JgclPolyline3D[polyvec.size()];
            polyvec.copyInto(res);
            if (nbz == 0) {
                res2 = this.vep;
            }
        }
        return new InterferenceOfVertexIsOnTheOther((JgclPolyline3D[])res, res2);
    }

    double[] getRootsByCoefficents(double[] dA) {
        double dX0;
        double dX1;
        JgclRealPolynomial poly = new JgclRealPolynomial(dA);
        double[] roots = poly.getAlwaysRootsIfQuadric();
        if (roots == null) {
            throw new JgclFatal();
        }
        if (roots.length == 1) {
            dX0 = dX1 = roots[0];
        } else if (roots[0] < roots[1]) {
            dX0 = roots[1];
            dX1 = roots[0];
        } else {
            dX0 = roots[0];
            dX1 = roots[1];
        }
        if (dX0 > 1.0E7) {
            dX0 = dX1;
        } else if (dX1 < -1.0E7) {
            dX1 = dX0;
        }
        double[] dX = new double[]{dX0, dX1};
        return dX;
    }

    private JgclPolyline3D[] vertexOfParametarizedConeIsInTheOther() {
        Object[] pols;
        this.setParametarizedCone(this.phiS < this.coneS.semiAngle() || Math.PI - this.phiS < this.coneS.semiAngle());
        JgclVector3D cw = this.wp;
        JgclVector3D cv = cw.crossProduct(this.p2o);
        JgclVector3D cu = cv.crossProduct(cw).unitized();
        cv = cv.unitized();
        double[] azero = this.aZero(this.cp, this.co, this.vep, cu, cw, this.wo);
        int naz = azero.length;
        double[] bzero = this.bZero(this.cp, this.co, this.vep, cu, cw, this.veo, this.wo);
        int nbz = bzero.length;
        if (naz == 0) {
            double[] dA = new double[3];
            dA[0] = this.coefC(this.o2p, this.wo, this.coso);
            double step = Math.PI * 2 / (double)(nst - 1);
            Vector<JgclPoint3D> pntvec = new Vector<JgclPoint3D>();
            int k = 0;
            while (k < nst) {
                JgclVector3D evec2;
                double t = -Math.PI + (double)k * step;
                JgclLiteralVector3D evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t);
                dA[2] = this.coefA(evec, this.wo, this.cosp, this.coso);
                dA[1] = this.coefB(evec, this.o2p, this.wo, this.coso);
                double[] dX = this.getRootsByCoefficents(dA);
                JgclPoint3D pnt = this.vep.add(evec.multiply(dX[0]));
                if (dX[1] > -JgclMachineEpsilon.DOUBLE && (evec2 = pnt.subtract(this.veo)).dotProduct(this.wo) < 0.0) {
                    pnt = this.vep.add(evec.multiply(dX[1]));
                }
                pntvec.addElement(pnt);
                ++k;
            }
            Object[] points = new JgclPoint3D[pntvec.size()];
            pntvec.copyInto(points);
            JgclPolyline3D[] work = new JgclPolyline3D[]{new JgclPolyline3D((JgclPoint3D[])points)};
            pols = work;
        } else {
            double[] dA = new double[3];
            double[] t = new double[5];
            int i = 0;
            while (i < naz && i < t.length) {
                t[i] = azero[i];
                ++i;
            }
            int j0 = 0;
            int jn = naz - 1;
            JgclUtil.sortDoubleArray(t, j0, jn);
            t[naz] = t[0] + Math.PI * 2;
            dA[0] = this.coefC(this.o2p, this.wo, this.coso);
            Vector<JgclPolyline3D> polvec = new Vector<JgclPolyline3D>();
            int i2 = 0;
            while (i2 < naz) {
                JgclPoint3D pnt;
                double[] dX2;
                int k;
                double ework;
                JgclVector3D evec2;
                JgclPoint3D epnt;
                double t1 = (t[i2] + t[i2 + 1]) / 2.0;
                JgclLiteralVector3D evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t1);
                dA[2] = this.coefA(evec, this.wo, this.cosp, this.coso);
                dA[1] = this.coefB(evec, this.o2p, this.wo, this.coso);
                double[] dX = this.getRootsByCoefficents(dA);
                if (dX[0] > 0.0) {
                    Object[] points;
                    epnt = this.vep.add(evec.multiply(dX[0]));
                    evec2 = epnt.subtract(this.veo);
                    ework = evec2.dotProduct(this.wo);
                    Vector<JgclPoint3D> pntvec1 = new Vector<JgclPoint3D>();
                    if (ework > 0.0) {
                        double step = (t[i2 + 1] - t[i2]) / (double)(nst - 1);
                        k = 0;
                        while (k < nst) {
                            t1 = k == 0 ? t[i2] + 0.5 * step : (k == nst - 1 ? t[i2 + 1] - 0.5 * step : t[i2] + (double)k * step);
                            evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t1);
                            dA[2] = this.coefA(evec, this.wo, this.cosp, this.coso);
                            dA[1] = this.coefB(evec, this.o2p, this.wo, this.coso);
                            dX2 = this.getRootsByCoefficents(dA);
                            pnt = this.vep.add(evec.multiply(dX2[0]));
                            if (dX2[1] > -JgclMachineEpsilon.DOUBLE && (evec2 = pnt.subtract(this.veo)).dotProduct(this.wo) < 0.0) {
                                pnt = this.vep.add(evec.multiply(dX2[1]));
                            }
                            if (pnt != null) {
                                pntvec1.addElement(pnt);
                            }
                            ++k;
                        }
                    }
                    if ((points = new JgclPoint3D[pntvec1.size()]).length > 0) {
                        pntvec1.copyInto(points);
                        JgclPolyline3D pol = new JgclPolyline3D((JgclPoint3D[])points);
                        polvec.addElement(pol);
                    }
                }
                if (dX[1] > 0.0) {
                    epnt = this.vep.add(evec.multiply(dX[1]));
                    evec2 = epnt.subtract(this.veo);
                    ework = evec2.dotProduct(this.wo);
                    Vector<JgclPoint3D> pntvec2 = new Vector<JgclPoint3D>();
                    if (ework > 0.0) {
                        double step = (t[i2 + 1] - t[i2]) / (double)(nst - 1);
                        k = 0;
                        while (k < nst) {
                            t1 = k == 0 ? t[i2] + 0.5 * step : (k == nst - 1 ? t[i2 + 1] - 0.5 * step : t[i2] + (double)k * step);
                            evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t1);
                            dA[2] = this.coefA(evec, this.wo, this.cosp, this.coso);
                            dA[1] = this.coefB(evec, this.o2p, this.wo, this.coso);
                            dX2 = this.getRootsByCoefficents(dA);
                            pnt = this.vep.add(evec.multiply(dX2[1]));
                            if (dX2[0] > -JgclMachineEpsilon.DOUBLE && (evec2 = pnt.subtract(this.veo)).dotProduct(this.wo) < 0.0) {
                                pnt = this.vep.add(evec.multiply(dX2[0]));
                            }
                            pntvec2.addElement(pnt);
                            ++k;
                        }
                        Object[] points = new JgclPoint3D[pntvec2.size()];
                        pntvec2.copyInto(points);
                        JgclPolyline3D pol = new JgclPolyline3D((JgclPoint3D[])points);
                        polvec.addElement(pol);
                    }
                }
                ++i2;
            }
            Object[] work = new JgclPolyline3D[polvec.size()];
            polvec.copyInto(work);
            pols = work;
        }
        return pols;
    }

    private JgclPoint3D[] connect2Polyline(JgclPoint3D[] resp, JgclPoint3D[] resc) {
        int i = 0;
        JgclPoint3D[] resn = new JgclPoint3D[resp.length + resc.length - 1];
        if (resp[0].identical(resc[0])) {
            i = resp.length - 1;
            while (i > 0) {
                resn[resp.length - (i + 1)] = resp[i];
                --i;
            }
            resn[resp.length - 1] = resp[0].midPoint(resc[0]);
            i = 1;
            while (i < resc.length) {
                resn[resp.length - 1 + i] = resc[i];
                ++i;
            }
            return resn;
        }
        if (resp[0].identical(resc[resc.length - 1])) {
            i = resp.length - 1;
            while (i > 0) {
                resn[resp.length - (i + 1)] = resp[i];
                --i;
            }
            resn[resp.length - 1] = resp[0].midPoint(resc[resc.length - 1]);
            i = resc.length - 2;
            while (i >= 0) {
                resn[resp.length + resc.length - 2 - i] = resc[i];
                --i;
            }
            return resn;
        }
        if (resp[resp.length - 1].identical(resc[0])) {
            i = 0;
            while (i < resp.length - 1) {
                resn[i] = resp[i];
                ++i;
            }
            resn[resp.length - 1] = resp[resp.length - 1].midPoint(resc[0]);
            i = 1;
            while (i < resc.length) {
                resn[resp.length - 1 + i] = resc[i];
                ++i;
            }
            return resn;
        }
        if (resp[resp.length - 1].identical(resc[resc.length - 1])) {
            i = 0;
            while (i < resp.length - 1) {
                resn[resp.length - (i + 2)] = resp[i];
                ++i;
            }
            resn[resp.length - 1] = resp[resp.length - 1].midPoint(resc[resc.length - 1]);
            i = resc.length - 2;
            while (i >= 0) {
                resn[resp.length + resc.length - 2 - i] = resc[i];
                --i;
            }
            return resn;
        }
        return null;
    }

    private int checkIntervalType(double t1, double t2, double[] azero) {
        int naz = azero.length;
        int type = 0;
        int i = 0;
        while (i < naz) {
            if (Math.abs(t1 - azero[i]) < JgclMachineEpsilon.DOUBLE) {
                ++type;
                break;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < naz) {
            if (Math.abs(t2 - azero[i2]) < JgclMachineEpsilon.DOUBLE) {
                ++type;
                break;
            }
            ++i2;
        }
        return type;
    }

    private JgclPolyline3D[] bothVerticesAreOutOfTheOther() {
        this.setParametarizedCone(true);
        double[] t = new double[10];
        double[] dA = new double[3];
        JgclPoint3D[][] res = new JgclPoint3D[10][];
        int myNst = 2 * nst - 1;
        int intvlType = 0;
        int prevIntvlType = 0;
        JgclVector3D cw = this.wp;
        JgclVector3D cv = cw.crossProduct(this.p2o);
        JgclVector3D cu = cv.crossProduct(cw).unitized();
        cv = cv.unitized();
        JgclVector3D vo = this.wo.crossProduct(this.p2o).reverse();
        JgclVector3D uo = vo.crossProduct(this.wo).unitized();
        uo = uo.unitized();
        vo = vo.unitized();
        int num = 0;
        JgclVector3D tmp1 = this.wo.multiply(this.tano);
        double r = tmp1.dotProduct(this.o2p) / uo.dotProduct(this.o2p);
        JgclVector3D tmp2 = tmp1.subtract(uo.multiply(r));
        if (Math.abs(r) < 1.0 + JgclMachineEpsilon.DOUBLE) {
            if (r > 1.0) {
                r = 1.0;
            }
            if (r < -1.0) {
                r = -1.0;
            }
            double r2 = Math.sqrt(1.0 - r * r);
            JgclVector3D[] nor = new JgclVector3D[]{tmp2.add(vo.multiply(r2)), tmp2.subtract(vo.multiply(r2))};
            int i = 0;
            while (i < 2) {
                JgclSurfaceSurfaceInterference3D[] ints;
                JgclPlane3D plane = new JgclPlane3D(new JgclAxis2Placement3D(this.vep, nor[i], this.o2p));
                try {
                    ints = plane.intersect(this.cp);
                }
                catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                    throw new JgclFatal();
                }
                if (!(ints[0] instanceof JgclIntersectionPoint3D)) {
                    int j = 0;
                    while (j < ints.length) {
                        JgclLine3D line = (JgclLine3D)((JgclIntersectionCurve3D)ints[j]).curve3d();
                        JgclVector3D evec = line.dir().project(cw);
                        evec = evec.unitized();
                        t[num] = cu.angleWith(evec, cw);
                        ++num;
                        ++j;
                    }
                }
                ++i;
            }
        }
        double[] azero = this.aZero(this.cp, this.co, this.vep, cu, cw, this.wo);
        int naz = azero.length;
        int i = 0;
        while (i < naz) {
            t[num++] = azero[i];
            ++i;
        }
        if (num > 0) {
            int j0 = 0;
            int jn = num - 1;
            JgclUtil.sortDoubleArray(t, j0, jn);
            t[num] = t[0] + Math.PI * 2;
            int j = 0;
            while (j < naz) {
                if (Math.abs(t[0] - azero[j]) < JgclMachineEpsilon.DOUBLE) {
                    double[] temp = new double[naz + 1];
                    int jj = 0;
                    while (jj < naz) {
                        temp[jj] = azero[jj];
                        ++jj;
                    }
                    temp[naz] = azero[j] + Math.PI * 2;
                    azero = temp;
                    naz = azero.length;
                    break;
                }
                ++j;
            }
            prevIntvlType = this.checkIntervalType(t[num - 1], t[num], azero);
            dA[0] = this.coefC(this.o2p, this.wo, this.coso);
        }
        int n = 0;
        int i2 = 0;
        while (i2 < num) {
            double t0 = (t[i2] + t[i2 + 1]) / 2.0;
            JgclLiteralVector3D evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t0);
            dA[2] = this.coefA(evec, this.wo, this.cosp, this.coso);
            dA[1] = this.coefB(evec, this.o2p, this.wo, this.coso);
            JgclRealPolynomial poly = new JgclRealPolynomial(dA);
            double[] dX = poly.getRootsIfQuadric();
            if (dX == null) {
                throw new JgclFatal();
            }
            if (dX.length == 0) {
                prevIntvlType = 0;
            } else {
                double dX0;
                double dX1;
                if (dX.length == 1) {
                    dX0 = dX1 = dX[0];
                } else if (dX[0] > dX[1]) {
                    dX0 = dX[0];
                    dX1 = dX[1];
                } else {
                    dX0 = dX[1];
                    dX1 = dX[0];
                }
                if (dX0 < 0.0) {
                    prevIntvlType = 0;
                } else {
                    JgclPoint3D epnt = this.vep.add(evec.multiply(dX0));
                    JgclVector3D evec2 = epnt.subtract(this.veo);
                    if (evec2.dotProduct(this.wo) < 0.0) {
                        prevIntvlType = 0;
                    } else {
                        JgclPoint3D[] newRes;
                        intvlType = this.checkIntervalType(t[i2], t[i2 + 1], azero);
                        JgclPoint3D[] points = intvlType == 0 ? new JgclPoint3D[myNst] : (intvlType == 1 ? new JgclPoint3D[myNst - 1] : new JgclPoint3D[nst]);
                        double step = (t[i2 + 1] - t[i2]) / (double)(nst - 1);
                        int nsetted = 0;
                        int j = 0;
                        while (j < nst - 1) {
                            t0 = t[i2] + (double)j * step;
                            evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t0);
                            dA[2] = this.coefA(evec, this.wo, this.cosp, this.coso);
                            dA[1] = this.coefB(evec, this.o2p, this.wo, this.coso);
                            dX = this.getRootsByCoefficents(dA);
                            switch (intvlType) {
                                case 0: {
                                    points[j] = this.vep.add(evec.multiply(dX[0]));
                                    points[myNst - 1 - j] = this.vep.add(evec.multiply(dX[1]));
                                    break;
                                }
                                case 1: {
                                    if (prevIntvlType == 0) {
                                        points[JgclIntsConCon3D.nst - 1 - j - 1] = this.vep.add(evec.multiply(dX[0]));
                                        points[JgclIntsConCon3D.nst - 1 + j - 1] = this.vep.add(evec.multiply(dX[1]));
                                        break;
                                    }
                                    points[j] = this.vep.add(evec.multiply(dX[1]));
                                    if (j <= 0) break;
                                    points[myNst - 1 - j] = this.vep.add(evec.multiply(dX[0]));
                                    break;
                                }
                                case 2: {
                                    if (!(dX[0] > 0.0)) break;
                                    points[nsetted] = this.vep.add(evec.multiply(dX[0]));
                                    ++nsetted;
                                    break;
                                }
                            }
                            ++j;
                        }
                        t0 = t[i2 + 1];
                        evec = this.uvwPointFromT(cu, cv, cw, this.tanp, t0);
                        dA[2] = this.coefA(evec, this.wo, this.cosp, this.coso);
                        dA[1] = this.coefB(evec, this.o2p, this.wo, this.coso);
                        dX = this.getRootsByCoefficents(dA);
                        switch (intvlType) {
                            case 0: {
                                points[JgclIntsConCon3D.nst - 1] = this.vep.add(evec.multiply(dX[0]));
                                break;
                            }
                            case 1: {
                                if (prevIntvlType == 0) {
                                    points[myNst - 2] = this.vep.add(evec.multiply(dX[0]));
                                    break;
                                }
                                points[JgclIntsConCon3D.nst - 1] = this.vep.add(evec.multiply(dX[0]));
                                break;
                            }
                            case 2: {
                                if (dX[0] > 0.0) {
                                    points[nsetted] = this.vep.add(evec.multiply(dX[0]));
                                }
                                if (nsetted == nst - 1) break;
                                JgclPoint3D[] points2 = new JgclPoint3D[nsetted];
                                int jj = 0;
                                while (jj < nsetted) {
                                    points2[jj] = points[jj];
                                    ++jj;
                                }
                                points = points2;
                                break;
                            }
                        }
                        res[n] = points;
                        if (i2 > 0 && intvlType != 0 && prevIntvlType != 0) {
                            newRes = this.connect2Polyline(res[n - 1], res[n]);
                            if (newRes != null) {
                                res[n - 1] = newRes;
                            } else {
                                ++n;
                            }
                        } else if (i2 == num - 1 && intvlType != 0 && n > 0) {
                            newRes = this.connect2Polyline(res[0], res[n]);
                            if (newRes != null) {
                                res[0] = newRes;
                            } else {
                                ++n;
                            }
                        } else {
                            ++n;
                        }
                        prevIntvlType = intvlType;
                    }
                }
            }
            ++i2;
        }
        JgclPolyline3D[] pols = new JgclPolyline3D[n];
        int i3 = 0;
        while (i3 < n) {
            pols[i3] = new JgclPolyline3D(res[i3]);
            ++i3;
        }
        return pols;
    }

    JgclSurfaceSurfaceInterference3D[] getInterferenceVertexIsOnTheOther(boolean doExchange) throws JgclIndefiniteSolution {
        InterferenceOfVertexIsOnTheOther[] res = new InterferenceOfVertexIsOnTheOther[4];
        res[0] = this.vertexIsOnTheOther(doExchange);
        JgclIntsConCon3D doObj = new JgclIntsConCon3D(this.geomA, this.geomB.getReverse());
        res[1] = doObj.vertexIsOnTheOther(doExchange);
        doObj = new JgclIntsConCon3D(this.geomA.getReverse(), this.geomB);
        res[2] = doObj.vertexIsOnTheOther(doExchange);
        doObj = new JgclIntsConCon3D(this.geomA.getReverse(), this.geomB.getReverse());
        res[3] = doObj.vertexIsOnTheOther(doExchange);
        Vector<JgclGeometry> intfvec = new Vector<JgclGeometry>();
        Vector<JgclIntersectionPoint3D> intspnt = new Vector<JgclIntersectionPoint3D>();
        int i = 0;
        while (i < res.length) {
            if (res[i] != null) {
                if (res[i].ints() != null) {
                    double[] geomAParams = this.geomA.pointToParameter(res[i].ints());
                    double[] geomBParams = this.geomB.pointToParameter(res[i].ints());
                    JgclIntersectionPoint3D intsPoint = new JgclIntersectionPoint3D(this.geomA, geomAParams[0], geomAParams[1], (JgclParametricSurface3D)this.geomB, geomBParams[0], geomBParams[1], false);
                    intspnt.addElement(intsPoint);
                }
                if (res[i].pols() != null) {
                    JgclPolyline3D[] pols = res[i].pols();
                    int j = 0;
                    while (j < pols.length) {
                        if (pols[j] != null) {
                            JgclIntersectionCurve3D intsPoly = this.geomA.curveToIntersectionCurve(pols[j], this.geomB, doExchange);
                            intfvec.addElement(intsPoly);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        try {
            JgclIntersectionPoint3D pnt = (JgclIntersectionPoint3D)intspnt.firstElement();
            intfvec.addElement(pnt);
        }
        catch (NoSuchElementException noSuchElementException) {}
        Object[] intf = new JgclSurfaceSurfaceInterference3D[intfvec.size()];
        intfvec.copyInto(intf);
        return intf;
    }

    JgclPolyline3D[] getInterferenceVertexIsNotOnTheOtherHalfSide(boolean doExchange) throws JgclIndefiniteSolution {
        JgclPolyline3D[] pols = this.phiS < this.coneS.semiAngle() || Math.PI - this.phiS < this.coneS.semiAngle() || this.phiB < this.coneB.semiAngle() || Math.PI - this.phiB < this.coneB.semiAngle() ? (this.phiS > this.coneS.semiAngle() && this.phiB > this.coneB.semiAngle() && this.theta > this.coneS.semiAngle() + this.coneB.semiAngle() ? new JgclPolyline3D[]{} : this.vertexOfParametarizedConeIsInTheOther()) : this.bothVerticesAreOutOfTheOther();
        return pols;
    }

    JgclSurfaceSurfaceInterference3D[] getInterferenceVertexIsNotOnTheOther(boolean doExchange) throws JgclIndefiniteSolution {
        JgclPolyline3D[][] pols = new JgclPolyline3D[4][];
        pols[0] = this.getInterferenceVertexIsNotOnTheOtherHalfSide(doExchange);
        JgclIntsConCon3D doObj = new JgclIntsConCon3D(this.geomA, this.geomB.getReverse());
        pols[1] = doObj.getInterferenceVertexIsNotOnTheOtherHalfSide(doExchange);
        doObj = new JgclIntsConCon3D(this.geomA.getReverse(), this.geomB);
        pols[2] = doObj.getInterferenceVertexIsNotOnTheOtherHalfSide(doExchange);
        doObj = new JgclIntsConCon3D(this.geomA.getReverse(), this.geomB.getReverse());
        pols[3] = doObj.getInterferenceVertexIsNotOnTheOtherHalfSide(doExchange);
        Vector<JgclIntersectionCurve3D> intfvec = new Vector<JgclIntersectionCurve3D>();
        int i = 0;
        while (i < pols.length) {
            int j = 0;
            while (j < pols[i].length) {
                if (pols[i][j] != null) {
                    JgclIntersectionCurve3D intsPoly = this.geomA.curveToIntersectionCurve(pols[i][j], this.geomB, doExchange);
                    intfvec.addElement(intsPoly);
                }
                ++j;
            }
            ++i;
        }
        Object[] intf = new JgclSurfaceSurfaceInterference3D[intfvec.size()];
        intfvec.copyInto(intf);
        return intf;
    }

    JgclSurfaceSurfaceInterference3D[] getInterference(boolean doExchange) throws JgclIndefiniteSolution {
        JgclLine3D axisBZ = new JgclLine3D(this.coneB.position().location(), this.coneB.position().z());
        JgclLine3D axisSZ = new JgclLine3D(this.coneS.position().location(), this.coneS.position().z());
        if (this.coneB.position().z().parallelDirection(this.coneS.position().z()) && this.coneS.position().location().isOn(axisBZ) && this.coneB.position().location().isOn(axisSZ)) {
            JgclSurfaceSurfaceInterference3D[] intf = this.axesAreOverlap(doExchange);
            return intf;
        }
        JgclSurfaceSurfaceInterference3D[] intf = this.dist > this.dTol && (Math.abs(this.phiS - this.coneS.semiAngle()) < this.aTol || Math.abs(Math.PI - this.phiS - this.coneS.semiAngle()) < this.aTol) && (Math.abs(this.phiB - this.coneB.semiAngle()) < this.aTol || Math.abs(Math.PI - this.phiB - this.coneB.semiAngle()) < this.aTol) && this.areCoplanar(this.coneS.position().z(), this.coneB.position().z(), this.s2b) ? this.rulingTangent(doExchange) : (this.dist < this.dTol ? this.fourLines(doExchange) : (Math.abs(this.phiS - this.coneS.semiAngle()) < this.aTol || Math.abs(Math.PI - this.phiS - this.coneS.semiAngle()) < this.aTol || Math.abs(this.phiB - this.coneB.semiAngle()) < this.aTol || Math.abs(Math.PI - this.phiB - this.coneB.semiAngle()) < this.aTol ? this.getInterferenceVertexIsOnTheOther(doExchange) : this.getInterferenceVertexIsNotOnTheOther(doExchange)));
        return intf;
    }

    public static void main(String[] argv) throws JgclIndefiniteSolution {
        System.out.println("\n>>> [both vertices are out of the other case]\n");
        JgclConicalSurface3D coneA = new JgclConicalSurface3D(JgclPoint3D.origin, JgclVector3D.xUnitVector, 0.8, 0.4);
        JgclConicalSurface3D coneB = new JgclConicalSurface3D(JgclPoint3D.origin, JgclVector3D.of(1.0, 0.8, 0.0), 1.0, 0.5);
        JgclSurfaceSurfaceInterference3D[] intf = coneA.intersect(coneB);
        System.out.print("both vertices are out of the other case: ");
        System.out.print("interference number is " + intf.length + "\n");
        System.out.println("\n>>> [verteces is in the other case]\n");
        coneA = new JgclConicalSurface3D(JgclPoint3D.of(0.0, -0.8, 0.0), JgclVector3D.xUnitVector, 1.0, 0.5);
        coneB = new JgclConicalSurface3D(JgclPoint3D.of(-1.8, 0.0, 0.0), JgclVector3D.yUnitVector, 1.0, 0.5);
        intf = coneA.intersect(coneB);
        System.out.print("verteces is in the other case: ");
        System.out.print("interference number is " + intf.length + "\n");
    }

    private class InterferenceOfVertexIsOnTheOther {
        private JgclPolyline3D[] pols;
        private JgclPoint3D ints;

        InterferenceOfVertexIsOnTheOther(JgclPolyline3D[] pols, JgclPoint3D ints) {
            JgclIntsConCon3D.this = JgclIntsConCon3D.this;
            this.pols = pols;
            this.ints = ints;
        }

        JgclPolyline3D[] pols() {
            return this.pols;
        }

        JgclPoint3D ints() {
            return this.ints;
        }
    }
}

