/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBooleanFunctionWithRealVariables;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclCurveSurfaceInterferenceList;
import jp.go.ipa.jgcl.JgclEnclosingBox3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclRealFunction;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclVector3D;

final class JgclIntsCncBzs3D {
    JgclParametricCurve3D dA;
    JgclPureBezierSurface3D dB;
    JgclCurveSurfaceInterferenceList solutions;
    double dTol;
    double dTol2;
    double pTol;
    JgclPoint3D sApnt;
    JgclPoint3D sBpnt;
    JgclPureBezierSurface3D bzsL;
    JgclCartesianTransformationOperator3D transform;
    private static final int UNKNOWN = 0;
    private static final int BEZIER = 1;
    private static final int LINE = 2;
    private static final int POINT = 3;
    private static final int PLANER = 4;

    JgclIntsCncBzs3D(JgclParametricCurve3D curve, JgclPureBezierSurface3D bzs) {
        JgclAxis2Placement3D position;
        this.dA = curve;
        this.dB = bzs;
        JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
        this.dTol2 = cond.getToleranceForDistance2();
        this.dTol = cond.getToleranceForDistance();
        this.pTol = cond.getToleranceForParameter();
        if (curve instanceof JgclLine3D) {
            JgclLine3D line = (JgclLine3D)curve;
            position = new JgclAxis2Placement3D(line.pnt(), line.dir().verticalVector().unitized(), line.dir().unitized());
        } else if (curve instanceof JgclConic3D) {
            position = ((JgclConic3D)curve).position();
        } else {
            throw new JgclFatal();
        }
        this.transform = new JgclCartesianTransformationOperator3D(position);
        this.solutions = new JgclCurveSurfaceInterferenceList(curve, bzs);
    }

    private void intersect_dA_plane(BezierSurfaceInfo bsi) {
        if (this.dA instanceof JgclLine3D) {
            bsi.intersectLinePlane((JgclLine3D)this.dA);
        } else if (this.dA instanceof JgclConic3D) {
            bsi.intersectConicPlane((JgclConic3D)this.dA);
        } else {
            throw new JgclFatal();
        }
    }

    private void setbackParams(PointInfo pi, double[] param) {
        JgclPoint3D aPnt = null;
        JgclPoint3D bPnt = null;
        pi.aParam = this.dA.parameterDomain().force(param[0]);
        pi.bUParam = this.dB.uParameterDomain().force(param[1]);
        pi.bVParam = this.dB.vParameterDomain().force(param[2]);
        if (this.dA instanceof JgclLine3D) {
            aPnt = ((JgclLine3D)this.dA).nlFunc(pi.aParam);
        } else if (this.dA instanceof JgclConic3D) {
            aPnt = ((JgclConic3D)this.dA).nlFunc(pi.aParam);
        }
        bPnt = this.bzsL.coordinates(pi.bUParam, pi.bVParam);
        pi.pnt = aPnt.linearInterpolate(bPnt, 0.5);
    }

    boolean refinePointInfo(PointInfo pi) {
        double[] param = new double[]{pi.aParam, pi.bUParam, pi.bVParam};
        nlFunc nl_func = new nlFunc();
        JgclRealFunction[] dnl_func = new JgclRealFunction[]{new dnlFunc(0), new dnlFunc(1), new dnlFunc(2)};
        cnvFunc cnv_func = new cnvFunc();
        if ((param = JgclMath.solveSimultaneousEquations(nl_func, dnl_func, cnv_func, param)) == null) {
            return false;
        }
        this.setbackParams(pi, param);
        return true;
    }

    void getIntersections(BezierSurfaceInfo crnt_bi) {
        boolean ci11;
        boolean ci10;
        boolean ci01;
        boolean ci00;
        BezierSurfaceInfo bi11;
        BezierSurfaceInfo bi10;
        BezierSurfaceInfo bi01;
        BezierSurfaceInfo bi00;
        if (crnt_bi.whatTypeIsBezierSurface() != 1) {
            this.intersect_dA_plane(crnt_bi);
            return;
        }
        double half_point = 0.5;
        double ug_half = (crnt_bi.usp + crnt_bi.uep) / 2.0;
        double vg_half = (crnt_bi.vsp + crnt_bi.vep) / 2.0;
        while (true) {
            JgclPureBezierSurface3D[] geomB = crnt_bi.bzs.vDivide(half_point);
            JgclPureBezierSurface3D[] bzs0 = geomB[0].uDivide(half_point);
            JgclPureBezierSurface3D[] bzs1 = geomB[1].uDivide(half_point);
            bi00 = new BezierSurfaceInfo(bzs0[0], crnt_bi.usp, ug_half, crnt_bi.vsp, vg_half);
            bi01 = new BezierSurfaceInfo(bzs0[1], ug_half, crnt_bi.uep, crnt_bi.vsp, vg_half);
            bi10 = new BezierSurfaceInfo(bzs1[0], crnt_bi.usp, ug_half, vg_half, crnt_bi.vep);
            bi11 = new BezierSurfaceInfo(bzs1[1], ug_half, crnt_bi.uep, vg_half, crnt_bi.vep);
            ci00 = bi00.checkInterfere(this.dA);
            ci01 = bi01.checkInterfere(this.dA);
            ci10 = bi10.checkInterfere(this.dA);
            ci11 = bi11.checkInterfere(this.dA);
            if (!(half_point > 0.45) || ci00 || ci01 || ci10 || ci11) break;
            half_point = 0.4;
            ug_half = 0.6 * crnt_bi.usp + 0.4 * crnt_bi.uep;
            vg_half = 0.6 * crnt_bi.vsp + 0.4 * crnt_bi.vep;
        }
        if (ci00) {
            this.getIntersections(bi00);
        }
        if (ci01) {
            this.getIntersections(bi01);
        }
        if (ci10) {
            this.getIntersections(bi10);
        }
        if (ci11) {
            this.getIntersections(bi11);
        }
    }

    JgclPureBezierSurface3D transformBezier(JgclParametricCurve3D curve, JgclPureBezierSurface3D bzs) {
        int uncp = bzs.uNControlPoints();
        int vncp = bzs.vNControlPoints();
        JgclPoint3D[][] cp = new JgclPoint3D[uncp][vncp];
        int i = 0;
        while (i < uncp) {
            int j = 0;
            while (j < vncp) {
                cp[i][j] = this.transform.toLocal(bzs.controlPointAt(i, j));
                ++j;
            }
            ++i;
        }
        if (!bzs.isRational()) {
            return new JgclPureBezierSurface3D(cp);
        }
        return new JgclPureBezierSurface3D(cp, bzs.weights());
    }

    JgclCurveSurfaceInterferenceList intsCncBzs() {
        boolean hasInterfere;
        this.bzsL = this.transformBezier(this.dA, this.dB);
        BezierSurfaceInfo dBRoot = new BezierSurfaceInfo(this.bzsL, 0.0, 1.0, 0.0, 1.0);
        if (this.dA instanceof JgclLine3D) {
            hasInterfere = ((JgclLine3D)this.dA).checkInterfere(dBRoot);
        } else if (this.dA instanceof JgclConic3D) {
            hasInterfere = ((JgclConic3D)this.dA).checkInterfere(dBRoot);
        } else {
            throw new JgclFatal();
        }
        if (hasInterfere) {
            this.getIntersections(dBRoot);
        }
        return this.solutions;
    }

    static JgclIntersectionPoint3D[] intersection(JgclConic3D cnc, JgclPureBezierSurface3D bzs, boolean doExchange) {
        JgclIntsCncBzs3D doObj = new JgclIntsCncBzs3D(cnc, bzs);
        return doObj.intsCncBzs().toJgclIntersectionPoint3DArray(doExchange);
    }

    static JgclIntersectionPoint3D[] intersection(JgclLine3D line, JgclPureBezierSurface3D bzs, boolean doExchange) {
        JgclIntsCncBzs3D doObj = new JgclIntsCncBzs3D(line, bzs);
        return doObj.intsCncBzs().toJgclIntersectionPoint3DArray(doExchange);
    }

    static /* synthetic */ int access$0() {
        return 0;
    }

    static /* synthetic */ int access$1() {
        return 1;
    }

    static /* synthetic */ int access$2() {
        return 3;
    }

    static /* synthetic */ int access$3() {
        return 2;
    }

    static /* synthetic */ int access$4() {
        return 4;
    }

    class BezierSurfaceInfo {
        private JgclPureBezierSurface3D bzs;
        private double usp;
        private double uep;
        private double vsp;
        private double vep;
        JgclEnclosingBox3D box;
        private PlaneBezier pb;
        private int currentType;

        BezierSurfaceInfo(JgclPureBezierSurface3D bzs, double usp, double uep, double vsp, double vep) {
            JgclIntsCncBzs3D.this = JgclIntsCncBzs3D.this;
            this.bzs = bzs;
            this.usp = usp;
            this.uep = uep;
            this.vsp = vsp;
            this.vep = vep;
            this.box = bzs.approximateEnclosingBox();
            this.currentType = JgclIntsCncBzs3D.access$0();
            JgclIntsCncBzs3D jgclIntsCncBzs3D = JgclIntsCncBzs3D.this;
            jgclIntsCncBzs3D.getClass();
            this.pb = jgclIntsCncBzs3D.new PlaneBezier(bzs);
        }

        int whatTypeIsBezierSurface() {
            JgclVector3D evec;
            int i;
            PlaneBezier pb;
            if (this.currentType != JgclIntsCncBzs3D.access$0()) {
                return this.currentType;
            }
            int u_uicp = this.bzs.uNControlPoints();
            int v_uicp = this.bzs.vNControlPoints();
            this.currentType = JgclIntsCncBzs3D.access$1();
            this.pb = pb = new PlaneBezier(this.bzs);
            JgclPoint3D org = pb.origin();
            JgclVector3D zaxis = pb.zaxis();
            JgclVector3D[] xyz = pb.axis.axes();
            int j = 0;
            while (j < v_uicp) {
                i = 0;
                while (i < u_uicp) {
                    evec = this.bzs.controlPointAt(i, j).subtract(org);
                    if (Math.abs(evec.dotProduct(zaxis)) > JgclIntsCncBzs3D.this.dTol) {
                        return this.currentType;
                    }
                    ++i;
                }
                ++j;
            }
            this.currentType = JgclIntsCncBzs3D.access$2();
            i = 0;
            while (i < 4) {
                int uicp = i % 2 == 0 ? u_uicp : v_uicp;
                JgclPoint3D pnt = null;
                if (pb.shape_info[i] == 0) {
                    pb.bcrv[i] = null;
                } else {
                    JgclPoint2D[] pnt2d = new JgclPoint2D[uicp];
                    double[] ws = new double[uicp];
                    int j2 = 0;
                    while (j2 < uicp) {
                        switch (i) {
                            case 0: {
                                pnt = this.bzs.controlPointAt(j2, 0);
                                if (!this.bzs.isRational()) break;
                                ws[j2] = this.bzs.weightAt(j2, 0);
                                break;
                            }
                            case 1: {
                                pnt = this.bzs.controlPointAt(u_uicp - 1, j2);
                                if (!this.bzs.isRational()) break;
                                ws[j2] = this.bzs.weightAt(u_uicp - 1, j2);
                                break;
                            }
                            case 2: {
                                pnt = this.bzs.controlPointAt(u_uicp - 1 - j2, v_uicp - 1);
                                if (!this.bzs.isRational()) break;
                                ws[j2] = this.bzs.weightAt(u_uicp - 1 - j2, v_uicp - 1);
                                break;
                            }
                            case 3: {
                                pnt = this.bzs.controlPointAt(0, v_uicp - 1 - j2);
                                if (!this.bzs.isRational()) break;
                                ws[j2] = this.bzs.weightAt(0, v_uicp - 1 - j2);
                                break;
                            }
                        }
                        evec = pnt.subtract(org);
                        pnt2d[j2] = new JgclCartesianPoint2D(evec.dotProduct(xyz[0]), evec.dotProduct(xyz[1]));
                        ++j2;
                    }
                    pb.bcrv[i] = this.bzs.isRational() ? new JgclPureBezierCurve2D(pnt2d, ws) : new JgclPureBezierCurve2D(pnt2d);
                    JgclVector2D s2e = pnt2d[uicp - 1].subtract(pnt2d[0]).unitized();
                    int j3 = 1;
                    while (j3 < uicp - 1) {
                        JgclVector2D evec2 = pnt2d[j3].subtract(pnt2d[0]);
                        double edot = evec2.dotProduct(s2e);
                        if (Math.abs(evec2.norm() - edot * edot) > JgclIntsCncBzs3D.this.dTol2) break;
                        ++j3;
                    }
                    pb.bcrv_is_line[i] = j3 == uicp - 1;
                    this.currentType = pb.bcrv_is_line[i] ? JgclIntsCncBzs3D.access$3() : JgclIntsCncBzs3D.access$4();
                }
                ++i;
            }
            return this.currentType;
        }

        private boolean isPointInPlane(JgclPoint3D point) {
            if (point.x() > this.box.max().x() + JgclIntsCncBzs3D.this.dTol || point.y() > this.box.max().y() + JgclIntsCncBzs3D.this.dTol || point.z() > this.box.max().z() + JgclIntsCncBzs3D.this.dTol || point.x() < this.box.min().x() - JgclIntsCncBzs3D.this.dTol || point.y() < this.box.min().y() - JgclIntsCncBzs3D.this.dTol || point.z() < this.box.min().z() - JgclIntsCncBzs3D.this.dTol) {
                return false;
            }
            JgclVector3D evec = point.subtract(this.pb.origin());
            JgclCartesianPoint2D point2d = new JgclCartesianPoint2D(evec.dotProduct(this.pb.axis.x()), evec.dotProduct(this.pb.axis.y()));
            JgclLiteralVector2D dir = new JgclLiteralVector2D(0.70710678, 0.70710678);
            JgclLine2D line2d = new JgclLine2D((JgclPoint2D)point2d, dir);
            Vector<Double> saved_ipl_list = new Vector<Double>();
            double saved_ipl = 0.0;
            int icnt = 0;
            int i = 0;
            while (i < 4) {
                if (this.pb.bcrv[i] != null) {
                    JgclIntersectionPoint2D[] intp;
                    try {
                        intp = line2d.intersect(this.pb.bcrv[i]);
                    }
                    catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
                        throw new JgclFatal();
                    }
                    if (intp.length > 0) {
                        int j = 0;
                        while (j < intp.length) {
                            double ipl = intp[j].pointOnCurve1().parameter();
                            if (ipl > -JgclIntsCncBzs3D.this.dTol) {
                                if (ipl < JgclIntsCncBzs3D.this.dTol) {
                                    return true;
                                }
                                int k = 0;
                                while (k < saved_ipl_list.size()) {
                                    saved_ipl = (Double)saved_ipl_list.elementAt(k);
                                    if (Math.abs(ipl - saved_ipl) < JgclIntsCncBzs3D.this.dTol) break;
                                    ++k;
                                }
                                if (k == saved_ipl_list.size()) {
                                    saved_ipl_list.addElement(new Double(ipl));
                                    ++icnt;
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            return icnt % 2 != 0;
        }

        private boolean checkInterfere(JgclParametricCurve3D curve) {
            if (curve instanceof JgclLine3D) {
                return ((JgclLine3D)curve).checkInterfere(this);
            }
            if (curve instanceof JgclConic3D) {
                return ((JgclConic3D)curve).checkInterfere(this);
            }
            throw new JgclFatal();
        }

        private void intersectLinePlane(JgclLine3D line) {
            double bVParam;
            double bUParam;
            JgclPoint3D origin = this.pb.origin();
            JgclVector3D[] xyz = this.pb.axis.axes();
            double eT = (origin.y() * xyz[0].z() - origin.z() * xyz[0].y()) / (xyz[1].z() * xyz[0].y() - xyz[1].y() * xyz[0].z());
            double eS = Math.abs(xyz[0].y()) > JgclIntsCncBzs3D.this.dTol ? -(origin.y() + eT * xyz[1].y()) / xyz[0].y() : -(origin.z() + eT * xyz[1].z()) / xyz[0].z();
            double x = origin.x() + eS * xyz[0].x() + eT * xyz[1].x();
            JgclCartesianPoint3D point = new JgclCartesianPoint3D(x, 0.0, 0.0);
            if (!this.isPointInPlane(point)) {
                return;
            }
            double ework = Math.sqrt(line.dir().norm());
            JgclLine3D aLineL = new JgclLine3D(JgclPoint3D.origin, new JgclLiteralVector3D(ework, 0.0, 0.0));
            double aParam = x / aLineL.dir().x();
            PointInfo pi = new PointInfo(point, aParam, bUParam = (this.usp + this.uep) / 2.0, bVParam = (this.vsp + this.vep) / 2.0);
            if (JgclIntsCncBzs3D.this.refinePointInfo(pi)) {
                pi.pnt = JgclIntsCncBzs3D.this.transform.toEnclosed(pi.pnt);
                JgclIntsCncBzs3D.this.solutions.addAsIntersection(pi.pnt, pi.aParam, pi.bUParam, pi.bVParam);
            }
        }

        private void intersectConicPlane(JgclConic3D cnc) {
            JgclIntersectionPoint3D[] intp = cnc.intersectConicPlane(new JgclPlane3D(this.pb.axis));
            int i = 0;
            while (i < intp.length) {
                double bVParam;
                double bUParam;
                double aParam;
                JgclPoint3D point;
                PointInfo pi;
                if (this.isPointInPlane(intp[i]) && JgclIntsCncBzs3D.this.refinePointInfo(pi = new PointInfo(point = intp[i].coordinates(), aParam = intp[i].pointOnCurve1().parameter(), bUParam = (this.usp + this.uep) / 2.0, bVParam = (this.vsp + this.vep) / 2.0))) {
                    pi.pnt = JgclIntsCncBzs3D.this.transform.toEnclosed(pi.pnt);
                    JgclIntsCncBzs3D.this.solutions.addAsIntersection(pi.pnt, pi.aParam, pi.bUParam, pi.bVParam);
                }
                ++i;
            }
        }
    }

    final class PlaneBezier {
        JgclAxis2Placement3D axis;
        JgclPureBezierCurve2D[] bcrv;
        boolean[] bcrv_is_line;
        int edge_cnt;
        int[] shape_info;

        PlaneBezier(JgclPureBezierSurface3D bzs) {
            JgclIntsCncBzs3D.this = JgclIntsCncBzs3D.this;
            int u_uicp = bzs.uNControlPoints();
            int v_uicp = bzs.vNControlPoints();
            boolean retrying = false;
            JgclVector3D udir = null;
            JgclVector3D vdir = null;
            this.shape_info = new int[4];
            this.bcrv_is_line = new boolean[4];
            this.bcrv = new JgclPureBezierCurve2D[4];
            JgclPoint3D c00 = bzs.controlPointAt(0, 0);
            JgclPoint3D c10 = bzs.controlPointAt(u_uicp - 1, 0);
            JgclPoint3D c01 = bzs.controlPointAt(0, v_uicp - 1);
            JgclPoint3D c11 = bzs.controlPointAt(u_uicp - 1, v_uicp - 1);
            JgclVector3D u0dir = c10.subtract(c00);
            JgclVector3D v1dir = c11.subtract(c10);
            JgclVector3D u1dir = c01.subtract(c11);
            JgclVector3D v0dir = c00.subtract(c01);
            block5: while (true) {
                double u0norm;
                int iu0dir = (u0norm = u0dir.norm()) > JgclIntsCncBzs3D.this.dTol2 ? 1 : 0;
                double v0norm = v0dir.norm();
                int iv0dir = v0norm > JgclIntsCncBzs3D.this.dTol2 ? 1 : 0;
                double u1norm = u1dir.norm();
                int iu1dir = u1norm > JgclIntsCncBzs3D.this.dTol2 ? 1 : 0;
                double v1norm = v1dir.norm();
                int iv1dir = v1norm > JgclIntsCncBzs3D.this.dTol2 ? 1 : 0;
                this.edge_cnt = iu0dir + iv0dir + iu1dir + iv1dir;
                this.shape_info[0] = iu0dir;
                this.shape_info[3] = iv0dir;
                this.shape_info[2] = iu1dir;
                this.shape_info[1] = iv1dir;
                switch (this.edge_cnt) {
                    case 4: {
                        udir = u0dir;
                        vdir = v0dir;
                        break block5;
                    }
                    case 3: {
                        if (iu0dir == 0) {
                            udir = v1dir.multiply(-1.0);
                            vdir = v0dir;
                            break block5;
                        }
                        if (iv0dir == 0) {
                            udir = u0dir;
                            vdir = u1dir.multiply(-1.0);
                            break block5;
                        }
                        udir = u0dir;
                        vdir = v0dir;
                        break block5;
                    }
                    case 2: {
                        vdir = null;
                        udir = null;
                        if (iu0dir == 1) {
                            udir = bzs.controlPointAt(1, 0).subtract(bzs.controlPointAt(0, 0));
                        }
                        if (iv0dir == 1) {
                            if (udir == null) {
                                udir = bzs.controlPointAt(0, 1).subtract(bzs.controlPointAt(0, 0));
                            } else {
                                vdir = bzs.controlPointAt(0, 1).subtract(bzs.controlPointAt(0, 0));
                                break block5;
                            }
                        }
                        if (iu1dir == 1) {
                            if (udir == null) {
                                udir = bzs.controlPointAt(u_uicp - 2, v_uicp - 1).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                                break block5;
                            }
                            if (iu0dir == 1) {
                                vdir = bzs.controlPointAt(1, v_uicp - 1).subtract(bzs.controlPointAt(0, v_uicp - 1));
                                break block5;
                            }
                            vdir = bzs.controlPointAt(u_uicp - 2, v_uicp - 1).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                            break block5;
                        }
                        if (iv0dir == 1) {
                            vdir = bzs.controlPointAt(u_uicp - 1, 1).subtract(bzs.controlPointAt(u_uicp - 1, 0));
                            break block5;
                        }
                        vdir = bzs.controlPointAt(u_uicp - 1, v_uicp - 2).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                        break block5;
                    }
                    default: {
                        if (retrying) {
                            return;
                        }
                        retrying = true;
                        u0dir = bzs.controlPointAt(1, 0).subtract(bzs.controlPointAt(0, 0));
                        v0dir = bzs.controlPointAt(0, 1).subtract(bzs.controlPointAt(0, 0));
                        u1dir = bzs.controlPointAt(u_uicp - 2, v_uicp - 1).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                        v1dir = bzs.controlPointAt(u_uicp - 1, v_uicp - 2).subtract(bzs.controlPointAt(u_uicp - 1, v_uicp - 1));
                        continue block5;
                    }
                }
                break;
            }
            udir = udir.unitized();
            vdir = vdir.unitized();
            this.axis = new JgclAxis2Placement3D(c00, udir.crossProduct(vdir), udir);
        }

        JgclPoint3D origin() {
            return this.axis.location();
        }

        JgclVector3D zaxis() {
            return this.axis.z();
        }
    }

    final class PointInfo {
        JgclPoint3D pnt;
        double aParam;
        double bUParam;
        double bVParam;

        PointInfo(JgclPoint3D pnt, double aParam, double bUParam, double bVParam) {
            JgclIntsCncBzs3D.this = JgclIntsCncBzs3D.this;
            this.pnt = pnt;
            this.aParam = aParam;
            this.bUParam = bUParam;
            this.bVParam = bVParam;
        }
    }

    private class nlFunc
    implements JgclRealFunction {
        private nlFunc() {
            JgclIntsCncBzs3D.this = JgclIntsCncBzs3D.this;
        }

        public double[] evaluate(double[] parameter) {
            JgclVector3D evec = JgclIntsCncBzs3D.this.sApnt.subtract(JgclIntsCncBzs3D.this.sBpnt);
            double[] vec = new double[]{evec.x(), evec.y(), evec.z()};
            return vec;
        }
    }

    private class dnlFunc
    implements JgclRealFunction {
        int idx;

        private dnlFunc(int idx) {
            JgclIntsCncBzs3D.this = JgclIntsCncBzs3D.this;
            this.idx = idx;
        }

        public double[] evaluate(double[] parameter) {
            JgclVector3D aTang;
            JgclVector3D[] bTang = new JgclVector3D[3];
            if (JgclIntsCncBzs3D.this.dA instanceof JgclLine3D) {
                aTang = ((JgclLine3D)JgclIntsCncBzs3D.this.dA).dnlFunc(JgclIntsCncBzs3D.this.dA.parameterDomain().force(parameter[0]));
            } else if (JgclIntsCncBzs3D.this.dA instanceof JgclConic3D) {
                aTang = ((JgclConic3D)JgclIntsCncBzs3D.this.dA).dnlFunc(JgclIntsCncBzs3D.this.dA.parameterDomain().force(parameter[0]));
            } else {
                throw new JgclFatal();
            }
            bTang = JgclIntsCncBzs3D.this.bzsL.tangentVector(JgclIntsCncBzs3D.this.dB.uParameterDomain().force(parameter[1]), JgclIntsCncBzs3D.this.dB.vParameterDomain().force(parameter[2]));
            switch (this.idx) {
                case 0: {
                    return new double[]{aTang.x(), -bTang[0].x(), -bTang[1].x()};
                }
                case 1: {
                    return new double[]{aTang.y(), -bTang[0].y(), -bTang[1].y()};
                }
                case 2: {
                    return new double[]{aTang.z(), -bTang[0].z(), -bTang[1].z()};
                }
            }
            throw new JgclFatal();
        }
    }

    private class cnvFunc
    implements JgclBooleanFunctionWithRealVariables {
        private cnvFunc() {
            JgclIntsCncBzs3D.this = JgclIntsCncBzs3D.this;
        }

        public boolean evaluate(double[] parameter) {
            if (JgclIntsCncBzs3D.this.dA instanceof JgclLine3D) {
                JgclIntsCncBzs3D.this.sApnt = ((JgclLine3D)JgclIntsCncBzs3D.this.dA).nlFunc(JgclIntsCncBzs3D.this.dA.parameterDomain().force(parameter[0]));
            } else if (JgclIntsCncBzs3D.this.dA instanceof JgclConic3D) {
                JgclIntsCncBzs3D.this.sApnt = ((JgclConic3D)JgclIntsCncBzs3D.this.dA).nlFunc(JgclIntsCncBzs3D.this.dA.parameterDomain().force(parameter[0]));
            } else {
                throw new JgclFatal();
            }
            JgclIntsCncBzs3D.this.sBpnt = JgclIntsCncBzs3D.this.bzsL.coordinates(JgclIntsCncBzs3D.this.dB.uParameterDomain().force(parameter[1]), JgclIntsCncBzs3D.this.dB.vParameterDomain().force(parameter[2]));
            return JgclIntsCncBzs3D.this.sApnt.identical(JgclIntsCncBzs3D.this.sBpnt);
        }
    }
}

