/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Enumeration;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclCurveCurveInterference2D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntsBzcBzc2D;
import jp.go.ipa.jgcl.JgclOverlapCurve2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;

final class JgclIntsBzcBsc2D {
    private static JgclCurveCurveInterferenceList getInterference(JgclPureBezierCurve2D bzcA, JgclBsplineCurve2D bscB) {
        JgclBsplineKnot.ValidSegmentInfo vldsB = bscB.validSegments();
        JgclPureBezierCurve2D[] bzcsB = bscB.toPureBezierCurveArray();
        JgclCurveCurveInterferenceList interferenceList = new JgclCurveCurveInterferenceList(bzcA, bscB);
        int iB = 0;
        while (iB < bzcsB.length) {
            JgclCurveCurveInterference2D[] localInterferences = JgclIntsBzcBzc2D.interference(bzcA, bzcsB[iB], false);
            Vector intsList = JgclCurveCurveInterferenceList.extractIntersections(localInterferences);
            Enumeration e = intsList.elements();
            while (e.hasMoreElements()) {
                JgclIntersectionPoint2D ints = (JgclIntersectionPoint2D)e.nextElement();
                interferenceList.addAsIntersection(ints.coordinates(), ints.pointOnCurve1().parameter(), vldsB.l2Gp(iB, ints.pointOnCurve2().parameter()));
            }
            Vector ovlpList = JgclCurveCurveInterferenceList.extractOverlaps(localInterferences);
            Enumeration e2 = ovlpList.elements();
            while (e2.hasMoreElements()) {
                JgclOverlapCurve2D ovlp = (JgclOverlapCurve2D)e2.nextElement();
                interferenceList.addAsOverlap(ovlp.start1(), vldsB.l2Gp(iB, ovlp.start2()), ovlp.increase1(), vldsB.l2Gw(iB, ovlp.increase2()));
            }
            ++iB;
        }
        interferenceList.removeOverlapsContainedInOtherOverlap();
        interferenceList.removeIntersectionsContainedInOverlap();
        return interferenceList;
    }

    static JgclCurveCurveInterference2D[] interference(JgclPureBezierCurve2D bzcA, JgclBsplineCurve2D bscB, boolean doExchange) {
        return JgclIntsBzcBsc2D.getInterference(bzcA, bscB).toJgclCurveCurveInterference2DArray(doExchange);
    }

    static JgclIntersectionPoint2D[] intersection(JgclPureBezierCurve2D bzcA, JgclBsplineCurve2D bscB, boolean doExchange) {
        return JgclIntsBzcBsc2D.getInterference(bzcA, bscB).toJgclIntersectionPoint2DArray(doExchange);
    }

    JgclIntsBzcBsc2D() {
    }
}

