/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Enumeration;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclCurveCurveInterference3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsBzcBzc3D;
import jp.go.ipa.jgcl.JgclOverlapCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;

final class JgclIntsBscBsc3D {
    private static JgclCurveCurveInterferenceList getInterference(JgclBsplineCurve3D bscA, JgclBsplineCurve3D bscB) {
        JgclBsplineKnot.ValidSegmentInfo vldsA = bscA.validSegments();
        JgclPureBezierCurve3D[] bzcsA = bscA.toPureBezierCurveArray();
        JgclBsplineKnot.ValidSegmentInfo vldsB = bscB.validSegments();
        JgclPureBezierCurve3D[] bzcsB = bscB.toPureBezierCurveArray();
        JgclCurveCurveInterferenceList interferenceList = new JgclCurveCurveInterferenceList(bscA, bscB);
        int iA = 0;
        while (iA < bzcsA.length) {
            int iB = 0;
            while (iB < bzcsB.length) {
                JgclCurveCurveInterference3D[] localInterferences = JgclIntsBzcBzc3D.interference(bzcsA[iA], bzcsB[iB], false);
                Vector intsList = JgclCurveCurveInterferenceList.extractIntersections(localInterferences);
                Enumeration e = intsList.elements();
                while (e.hasMoreElements()) {
                    JgclIntersectionPoint3D ints = (JgclIntersectionPoint3D)e.nextElement();
                    interferenceList.addAsIntersection(ints.coordinates(), vldsA.l2Gp(iA, ints.pointOnCurve1().parameter()), vldsB.l2Gp(iB, ints.pointOnCurve2().parameter()));
                }
                Vector ovlpList = JgclCurveCurveInterferenceList.extractOverlaps(localInterferences);
                Enumeration e2 = ovlpList.elements();
                while (e2.hasMoreElements()) {
                    JgclOverlapCurve3D ovlp = (JgclOverlapCurve3D)e2.nextElement();
                    interferenceList.addAsOverlap(vldsA.l2Gp(iA, ovlp.start1()), vldsB.l2Gp(iB, ovlp.start2()), vldsA.l2Gw(iA, ovlp.increase1()), vldsB.l2Gw(iB, ovlp.increase2()));
                }
                ++iB;
            }
            ++iA;
        }
        interferenceList.removeOverlapsContainedInOtherOverlap();
        interferenceList.removeIntersectionsContainedInOverlap();
        return interferenceList;
    }

    static JgclCurveCurveInterference3D[] interference(JgclBsplineCurve3D bscA, JgclBsplineCurve3D bscB, boolean doExchange) {
        return JgclIntsBscBsc3D.getInterference(bscA, bscB).toJgclCurveCurveInterference3DArray(doExchange);
    }

    static JgclIntersectionPoint3D[] intersection(JgclBsplineCurve3D bscA, JgclBsplineCurve3D bscB, boolean doExchange) {
        return JgclIntsBscBsc3D.getInterference(bscA, bscB).toJgclIntersectionPoint3DArray(doExchange);
    }

    JgclIntsBscBsc3D() {
    }
}

