/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveCurveInterference3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclOverlapCurve3D;
import jp.go.ipa.jgcl.JgclParameterConversion3D;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnGeometry3D;
import jp.go.ipa.jgcl.JgclPointOnPoint3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;

public class JgclIntersectionPoint3D
extends JgclPoint3D
implements JgclCurveCurveInterference3D,
JgclSurfaceSurfaceInterference3D {
    private final JgclPoint3D coordinates;
    private final JgclPointOnGeometry3D pointOnGeometry1;
    private final JgclPointOnGeometry3D pointOnGeometry2;

    private void checkPoints() {
        if (!(this.coordinates.identical(this.pointOnGeometry1) && this.coordinates.identical(this.pointOnGeometry2) && this.pointOnGeometry1.identical(this.pointOnGeometry2))) {
            throw new JgclInvalidArgumentValue();
        }
    }

    JgclIntersectionPoint3D(JgclPoint3D coordinates, JgclPointOnGeometry3D pointOnGeometry1, JgclPointOnGeometry3D pointOnGeometry2, boolean doCheck) {
        this.coordinates = coordinates;
        this.pointOnGeometry1 = pointOnGeometry1;
        this.pointOnGeometry2 = pointOnGeometry2;
        if (doCheck) {
            this.checkPoints();
        }
    }

    JgclIntersectionPoint3D(JgclPointOnGeometry3D pointOnGeometry1, JgclPointOnGeometry3D pointOnGeometry2, boolean doCheck) {
        this.pointOnGeometry1 = pointOnGeometry1;
        this.pointOnGeometry2 = pointOnGeometry2;
        this.coordinates = this.pointOnGeometry1.linearInterpolate(this.pointOnGeometry2, 0.5);
        if (doCheck) {
            this.checkPoints();
        }
    }

    JgclIntersectionPoint3D(JgclPoint3D coordinates, JgclParametricCurve3D curve1, double param1, JgclParametricCurve3D curve2, double param2, boolean doCheck) {
        this.coordinates = coordinates;
        this.pointOnGeometry1 = new JgclPointOnCurve3D(curve1, param1, false);
        this.pointOnGeometry2 = new JgclPointOnCurve3D(curve2, param2, false);
        if (doCheck) {
            this.checkPoints();
        }
    }

    JgclIntersectionPoint3D(JgclParametricCurve3D curve1, double param1, JgclParametricCurve3D curve2, double param2, boolean doCheck) {
        this.pointOnGeometry1 = new JgclPointOnCurve3D(curve1, param1, false);
        this.pointOnGeometry2 = new JgclPointOnCurve3D(curve2, param2, false);
        this.coordinates = this.pointOnGeometry1.linearInterpolate(this.pointOnGeometry2, 0.5);
        if (doCheck) {
            this.checkPoints();
        }
    }

    JgclIntersectionPoint3D(JgclPoint3D coordinates, JgclParametricCurve3D curve1, double param1, JgclParametricSurface3D surface2, double uParam2, double vParam2, boolean doCheck) {
        this.coordinates = coordinates;
        this.pointOnGeometry1 = new JgclPointOnCurve3D(curve1, param1, false);
        this.pointOnGeometry2 = new JgclPointOnSurface3D(surface2, uParam2, vParam2, false);
        if (doCheck) {
            this.checkPoints();
        }
    }

    JgclIntersectionPoint3D(JgclParametricCurve3D curve1, double param1, JgclParametricSurface3D surface2, double uParam2, double vParam2, boolean doCheck) {
        this.pointOnGeometry1 = new JgclPointOnCurve3D(curve1, param1, false);
        this.pointOnGeometry2 = new JgclPointOnSurface3D(surface2, uParam2, vParam2, false);
        this.coordinates = this.pointOnGeometry1.linearInterpolate(this.pointOnGeometry2, 0.5);
        if (doCheck) {
            this.checkPoints();
        }
    }

    JgclIntersectionPoint3D(JgclPoint3D coordinates, JgclParametricSurface3D surface1, double uParam1, double vParam1, JgclParametricCurve3D curve2, double param2, boolean doCheck) {
        this.coordinates = coordinates;
        this.pointOnGeometry1 = new JgclPointOnSurface3D(surface1, uParam1, vParam1, false);
        this.pointOnGeometry2 = new JgclPointOnCurve3D(curve2, param2, false);
        if (doCheck) {
            this.checkPoints();
        }
    }

    JgclIntersectionPoint3D(JgclParametricSurface3D surface1, double uParam1, double vParam1, JgclParametricCurve3D curve2, double param2, boolean doCheck) {
        this.pointOnGeometry1 = new JgclPointOnSurface3D(surface1, uParam1, vParam1, false);
        this.pointOnGeometry2 = new JgclPointOnCurve3D(curve2, param2, false);
        this.coordinates = this.pointOnGeometry1.linearInterpolate(this.pointOnGeometry2, 0.5);
        if (doCheck) {
            this.checkPoints();
        }
    }

    JgclIntersectionPoint3D(JgclPoint3D coordinates, JgclParametricSurface3D surface1, double uParam1, double vParam1, JgclParametricSurface3D surface2, double uParam2, double vParam2, boolean doCheck) {
        this.coordinates = coordinates;
        this.pointOnGeometry1 = new JgclPointOnSurface3D(surface1, uParam1, vParam1, false);
        this.pointOnGeometry2 = new JgclPointOnSurface3D(surface2, uParam2, vParam2, false);
        if (doCheck) {
            this.checkPoints();
        }
    }

    JgclIntersectionPoint3D(JgclParametricSurface3D surface1, double uParam1, double vParam1, JgclParametricSurface3D surface2, double uParam2, double vParam2, boolean doCheck) {
        this.pointOnGeometry1 = new JgclPointOnSurface3D(surface1, uParam1, vParam1, false);
        this.pointOnGeometry2 = new JgclPointOnSurface3D(surface2, uParam2, vParam2, false);
        this.coordinates = this.pointOnGeometry1.linearInterpolate(this.pointOnGeometry2, 0.5);
        if (doCheck) {
            this.checkPoints();
        }
    }

    public double x() {
        return this.coordinates.x();
    }

    public double y() {
        return this.coordinates.y();
    }

    public double z() {
        return this.coordinates.z();
    }

    public JgclPoint3D coordinates() {
        return this.coordinates;
    }

    public JgclPointOnGeometry3D pointOnGeometry1() {
        return this.pointOnGeometry1;
    }

    public JgclPointOnGeometry3D pointOnGeometry2() {
        return this.pointOnGeometry2;
    }

    public JgclPointOnCurve3D pointOnCurve1() {
        if (!this.pointOnGeometry1().geometry().isCurve()) {
            return null;
        }
        return (JgclPointOnCurve3D)this.pointOnGeometry1();
    }

    public JgclPointOnCurve3D pointOnCurve2() {
        if (!this.pointOnGeometry2().geometry().isCurve()) {
            return null;
        }
        return (JgclPointOnCurve3D)this.pointOnGeometry2();
    }

    public JgclPointOnSurface3D pointOnSurface1() {
        if (!this.pointOnGeometry1().geometry().isSurface()) {
            return null;
        }
        return (JgclPointOnSurface3D)this.pointOnGeometry1();
    }

    public JgclPointOnSurface3D pointOnSurface2() {
        if (!this.pointOnGeometry2().geometry().isSurface()) {
            return null;
        }
        return (JgclPointOnSurface3D)this.pointOnGeometry2();
    }

    public boolean isIntersectionPoint() {
        return true;
    }

    public boolean isOverlapCurve() {
        return false;
    }

    public boolean isIntersectionCurve() {
        return false;
    }

    public JgclIntersectionPoint3D toIntersectionPoint() {
        return this;
    }

    public JgclOverlapCurve3D toOverlapCurve() {
        return null;
    }

    public JgclIntersectionCurve3D toIntersectionCurve() {
        return null;
    }

    public JgclIntersectionPoint3D exchange() {
        JgclIntersectionPoint3D ex = new JgclIntersectionPoint3D(this.coordinates, this.pointOnGeometry2, this.pointOnGeometry1, false);
        return ex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JgclCurveCurveInterference3D trim1(JgclParameterSection sec, JgclParameterConversion3D conv) {
        double param;
        block2: {
            JgclCurveCurveInterference3D jgclCurveCurveInterference3D;
            JgclPointOnCurve3D pnt = (JgclPointOnCurve3D)this.pointOnGeometry1;
            param = pnt.parameter();
            JgclParametricCurve3D curve = (JgclParametricCurve3D)pnt.geometry();
            JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
            cond.makeCopy(cond.getToleranceForDistanceAsObject().toToleranceForParameter(curve, param)).push();
            try {
                if (sec.isValid(param)) break block2;
                jgclCurveCurveInterference3D = null;
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                JgclConditionOfOperation.pop();
                throw throwable;
            }
            JgclConditionOfOperation.pop();
            return jgclCurveCurveInterference3D;
        }
        Object var10_10 = null;
        JgclConditionOfOperation.pop();
        JgclPointOnCurve3D poc1 = conv.convToPoint(param);
        JgclPointOnCurve3D poc2 = (JgclPointOnCurve3D)this.pointOnGeometry2;
        return new JgclIntersectionPoint3D(poc1, poc2, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JgclCurveCurveInterference3D trim2(JgclParameterSection sec, JgclParameterConversion3D conv) {
        double param;
        block2: {
            JgclCurveCurveInterference3D jgclCurveCurveInterference3D;
            JgclPointOnCurve3D pnt = (JgclPointOnCurve3D)this.pointOnGeometry2;
            param = pnt.parameter();
            JgclParametricCurve3D curve = (JgclParametricCurve3D)pnt.geometry();
            JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
            cond.makeCopy(cond.getToleranceForDistanceAsObject().toToleranceForParameter(curve, param)).push();
            try {
                if (sec.isValid(param)) break block2;
                jgclCurveCurveInterference3D = null;
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                JgclConditionOfOperation.pop();
                throw throwable;
            }
            JgclConditionOfOperation.pop();
            return jgclCurveCurveInterference3D;
        }
        Object var10_10 = null;
        JgclConditionOfOperation.pop();
        JgclPointOnCurve3D poc1 = (JgclPointOnCurve3D)this.pointOnGeometry1;
        JgclPointOnCurve3D poc2 = conv.convToPoint(param);
        return new JgclIntersectionPoint3D(poc1, poc2, false);
    }

    public JgclCurveCurveInterference3D changeCurve1(JgclParametricCurve3D newCurve) {
        if (!this.pointOnGeometry1().geometry().isCurve()) {
            throw new JgclFatal();
        }
        JgclPointOnCurve3D pointOnCurve1 = (JgclPointOnCurve3D)this.pointOnGeometry1();
        JgclPointOnCurve3D newPointOnCurve1 = new JgclPointOnCurve3D(newCurve, pointOnCurve1.parameter(), false);
        return new JgclIntersectionPoint3D(newPointOnCurve1, this.pointOnGeometry2, false);
    }

    public JgclCurveCurveInterference3D changeCurve2(JgclParametricCurve3D newCurve) {
        if (!this.pointOnGeometry2().geometry().isCurve()) {
            throw new JgclFatal();
        }
        JgclPointOnCurve3D pointOnCurve2 = (JgclPointOnCurve3D)this.pointOnGeometry2();
        JgclPointOnCurve3D newPointOnCurve2 = new JgclPointOnCurve3D(newCurve, pointOnCurve2.parameter(), false);
        return new JgclIntersectionPoint3D(this.pointOnGeometry1, newPointOnCurve2, false);
    }

    protected synchronized JgclPoint3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPointOnGeometry3D tPointOnGeometry2;
        JgclPointOnGeometry3D tPointOnGeometry1;
        JgclPoint3D tCoordinates = this.coordinates.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        if (this.pointOnGeometry1.geometry().isPoint()) {
            JgclPointOnPoint3D pointOnPoint1 = (JgclPointOnPoint3D)this.pointOnGeometry1;
            tPointOnGeometry1 = (JgclPointOnPoint3D)pointOnPoint1.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        } else if (this.pointOnGeometry1.geometry().isCurve()) {
            JgclPointOnCurve3D pointOnCurve1 = (JgclPointOnCurve3D)this.pointOnGeometry1;
            tPointOnGeometry1 = (JgclPointOnCurve3D)pointOnCurve1.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        } else {
            JgclPointOnSurface3D pointOnSurface1 = (JgclPointOnSurface3D)this.pointOnGeometry1;
            tPointOnGeometry1 = (JgclPointOnSurface3D)pointOnSurface1.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        if (this.pointOnGeometry2.geometry().isPoint()) {
            JgclPointOnPoint3D pointOnPoint2 = (JgclPointOnPoint3D)this.pointOnGeometry2;
            tPointOnGeometry2 = (JgclPointOnPoint3D)pointOnPoint2.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        } else if (this.pointOnGeometry2.geometry().isCurve()) {
            JgclPointOnCurve3D pointOnCurve2 = (JgclPointOnCurve3D)this.pointOnGeometry2;
            tPointOnGeometry2 = (JgclPointOnCurve3D)pointOnCurve2.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        } else {
            JgclPointOnSurface3D pointOnSurface2 = (JgclPointOnSurface3D)this.pointOnGeometry2;
            tPointOnGeometry2 = (JgclPointOnSurface3D)pointOnSurface2.transformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        return new JgclIntersectionPoint3D(tCoordinates, tPointOnGeometry1, tPointOnGeometry2, false);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tcoordinates");
        this.coordinates.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tpointOnGeometry1");
        this.pointOnGeometry1.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tpointOnGeometry2");
        this.pointOnGeometry2.output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

