/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclInterpolation;
import jp.go.ipa.jgcl.JgclInterpolation3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclVector3D;

class JgclInterpolationSurface3D {
    private JgclInterpolation uInfo;
    private JgclInterpolation vInfo;
    private JgclPoint3D[][] points;
    private JgclVector3D[][] uEndvecs;
    private JgclVector3D[][] vEndvecs;

    JgclInterpolationSurface3D(JgclPoint3D[][] points, double[] uParams, double[] vParams, boolean uIsClosed, boolean vIsClosed) {
        JgclVector3D[] tmpVecs;
        this.uInfo = new JgclInterpolation(uParams, uIsClosed);
        this.vInfo = new JgclInterpolation(vParams, vIsClosed);
        this.points = points;
        if (!uIsClosed) {
            this.uEndvecs = new JgclVector3D[2][this.vInfo.uip];
            JgclPoint3D[] auxPoints = new JgclPoint3D[this.uInfo.uip];
            int i = 0;
            while (i < this.vInfo.uip) {
                int j = 0;
                while (j < this.uInfo.uip) {
                    auxPoints[j] = points[j][i];
                    ++j;
                }
                tmpVecs = JgclInterpolation3D.besselPoints(auxPoints, uParams);
                int j2 = 0;
                while (j2 < 2) {
                    this.uEndvecs[j2][i] = tmpVecs[j2];
                    ++j2;
                }
                ++i;
            }
        }
        if (!vIsClosed) {
            this.vEndvecs = new JgclVector3D[2][this.uInfo.uip];
            int i = 0;
            while (i < this.uInfo.uip) {
                tmpVecs = JgclInterpolation3D.besselPoints(points[i], vParams);
                int j = 0;
                while (j < 2) {
                    this.vEndvecs[j][i] = tmpVecs[j];
                    ++j;
                }
                ++i;
            }
        }
    }

    JgclInterpolationSurface3D(JgclPoint3D[][] points, double[] uParams, double[] vParams, JgclVector3D[][] uEndvecs, JgclVector3D[][] vEndvecs, boolean uIsClosed, boolean vIsClosed) {
        this.uInfo = new JgclInterpolation(uParams, uIsClosed);
        this.vInfo = new JgclInterpolation(vParams, vIsClosed);
        this.points = points;
        if (!uIsClosed) {
            this.uEndvecs = uEndvecs;
        }
        if (!vIsClosed) {
            this.vEndvecs = vEndvecs;
        }
    }

    JgclBsplineKnot uKnotData() {
        return this.uInfo.knotData();
    }

    JgclBsplineKnot vKnotData() {
        return this.vInfo.knotData();
    }

    JgclPoint3D[][] controlPoints() {
        JgclPoint3D[] work;
        int i;
        int u_uicp = this.uInfo.nControlPoints();
        int v_uicp = this.vInfo.nControlPoints();
        JgclPoint3D[][] controlPoints = new JgclPoint3D[u_uicp][v_uicp];
        JgclPoint3D[][] auxPoints = new JgclPoint3D[v_uicp][this.uInfo.uip];
        JgclVector3D[][] auxUEndVecs = null;
        JgclVector3D[] tmpVecs = new JgclVector3D[2];
        int j = 0;
        while (j < this.uInfo.uip) {
            if (!this.vInfo.isClosed) {
                i = 0;
                while (i < 2) {
                    tmpVecs[i] = this.vEndvecs[i][j];
                    ++i;
                }
            }
            work = JgclInterpolation3D.controlPoints(this.vInfo, this.points[j], tmpVecs);
            i = 0;
            while (i < v_uicp) {
                auxPoints[i][j] = work[i];
                ++i;
            }
            ++j;
        }
        if (!this.uInfo.isClosed) {
            auxUEndVecs = new JgclVector3D[2][];
            j = 0;
            while (j < 2) {
                work = JgclInterpolation3D.controlPoints(this.vInfo, JgclVector3D.toPoint3D(this.uEndvecs[j]), null);
                auxUEndVecs[j] = JgclPoint3D.toVector3D(work);
                ++j;
            }
        }
        j = 0;
        while (j < v_uicp) {
            if (!this.uInfo.isClosed) {
                i = 0;
                while (i < 2) {
                    tmpVecs[i] = auxUEndVecs[i][j];
                    ++i;
                }
            }
            work = JgclInterpolation3D.controlPoints(this.uInfo, auxPoints[j], tmpVecs);
            i = 0;
            while (i < u_uicp) {
                controlPoints[i][j] = work[i];
                ++i;
            }
            ++j;
        }
        return controlPoints;
    }

    double[][] weights() {
        return null;
    }
}

