/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclEnclosingBox3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclMesh3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclUtil;
import jp.go.ipa.jgcl.JgclVector3D;

public abstract class JgclFreeformSurfaceWithControlPoints3D
extends JgclBoundedSurface3D {
    protected JgclPoint3D[][] controlPoints;
    protected double[][] weights;
    private double[][][] controlPointsArray;

    protected JgclFreeformSurfaceWithControlPoints3D() {
    }

    protected JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][] controlPoints) {
        int[] npnts = this.setControlPoints(controlPoints);
        this.weights = null;
    }

    protected JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][] controlPoints, double[][] weights) {
        int[] npnts = this.setControlPoints(controlPoints);
        this.setWeights(npnts, weights);
    }

    protected JgclFreeformSurfaceWithControlPoints3D(double[][][] cpArray) {
        this(cpArray, true);
    }

    protected JgclFreeformSurfaceWithControlPoints3D(double[][][] cpArray, boolean doCheck) {
        boolean isPoly;
        int uNpnts = cpArray.length;
        int vNpnts = cpArray[0].length;
        int[] npnts = null;
        int dimension = cpArray[0][0].length;
        JgclPoint3D[][] cp = new JgclPoint3D[uNpnts][vNpnts];
        double[][] wt = null;
        boolean bl = isPoly = dimension == 3;
        if (!isPoly) {
            double[] tmp = new double[4];
            wt = new double[uNpnts][vNpnts];
            int i = 0;
            while (i < uNpnts) {
                int j = 0;
                while (j < vNpnts) {
                    int k = 0;
                    while (k < 4) {
                        tmp[k] = cpArray[i][j][k];
                        ++k;
                    }
                    this.convRational0Deriv(tmp);
                    cp[i][j] = new JgclCartesianPoint3D(tmp[0], tmp[1], tmp[2]);
                    wt[i][j] = tmp[3];
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < uNpnts) {
                int j = 0;
                while (j < vNpnts) {
                    cp[i][j] = new JgclCartesianPoint3D(cpArray[i][j][0], cpArray[i][j][1], cpArray[i][j][2]);
                    ++j;
                }
                ++i;
            }
        }
        if (doCheck) {
            npnts = this.setControlPoints(cp);
        } else {
            this.controlPoints = cp;
        }
        if (isPoly) {
            this.weights = null;
        } else if (doCheck) {
            this.setWeights(npnts, wt);
        } else {
            this.weights = wt;
        }
    }

    protected JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][] controlPoints, double[][] weights, boolean doCheck) {
        if (doCheck) {
            int[] npnts = this.setControlPoints(controlPoints);
            if (weights == null) {
                weights = null;
            } else {
                this.setWeights(npnts, weights);
            }
        } else {
            this.controlPoints = controlPoints;
            this.weights = weights;
        }
    }

    public JgclPoint3D[][] controlPoints() {
        JgclPoint3D[][] copied = new JgclPoint3D[this.controlPoints.length][this.controlPoints[0].length];
        int i = 0;
        while (i < this.controlPoints.length) {
            int j = 0;
            while (j < this.controlPoints[0].length) {
                copied[i][j] = this.controlPoints[i][j];
                ++j;
            }
            ++i;
        }
        return copied;
    }

    public JgclPoint3D controlPointAt(int i, int j) {
        return this.controlPoints[i][j];
    }

    public double[][] weights() {
        if (this.weights == null) {
            return null;
        }
        return (double[][])this.weights.clone();
    }

    public double weightAt(int i, int j) {
        if (this.weights == null) {
            throw new JgclInvalidArgumentValue();
        }
        return this.weights[i][j];
    }

    public int uNControlPoints() {
        return this.controlPoints.length;
    }

    public int vNControlPoints() {
        return this.controlPoints[0].length;
    }

    public int nControlPoints() {
        return this.uNControlPoints() * this.vNControlPoints();
    }

    public boolean isRational() {
        return this.weights != null;
    }

    public boolean isPolynomial() {
        return this.weights == null;
    }

    abstract boolean isPlaner(JgclToleranceForDistance var1);

    abstract JgclFreeformSurfaceWithControlPoints3D[] divideForMesh(JgclToleranceForDistance var1);

    void getSrfMesh(SegInfo si, JgclToleranceForDistance tol, GpList u_gp_list, GpList v_gp_list) {
        if (this.isPlaner(tol)) {
            u_gp_list.addGp(si.u_sp);
            u_gp_list.addGp(si.u_ep);
            v_gp_list.addGp(si.v_sp);
            v_gp_list.addGp(si.v_ep);
            return;
        }
        JgclFreeformSurfaceWithControlPoints3D[] divsrf = this.divideForMesh(tol);
        JgclFreeformSurfaceWithControlPoints3D lb_srf = divsrf[0];
        JgclFreeformSurfaceWithControlPoints3D rb_srf = divsrf[1];
        JgclFreeformSurfaceWithControlPoints3D lu_srf = divsrf[2];
        JgclFreeformSurfaceWithControlPoints3D ru_srf = divsrf[3];
        if (lb_srf == null && rb_srf == null && lu_srf == null && ru_srf == null) {
            u_gp_list.addGp(si.u_sp);
            u_gp_list.addGp(si.u_ep);
            v_gp_list.addGp(si.v_sp);
            v_gp_list.addGp(si.v_ep);
            return;
        }
        MeshParam u_mp = this.makeMidGp(si.u_sp, si.u_ep);
        MeshParam v_mp = this.makeMidGp(si.v_sp, si.v_ep);
        if (lb_srf != null && rb_srf != null && lu_srf != null && ru_srf != null) {
            SegInfo si_lb = new SegInfo(si.u_sp, u_mp, si.v_sp, v_mp);
            SegInfo si_rb = new SegInfo(u_mp, si.u_ep, si.v_sp, v_mp);
            SegInfo si_lu = new SegInfo(si.u_sp, u_mp, v_mp, si.v_ep);
            SegInfo si_ru = new SegInfo(u_mp, si.u_ep, v_mp, si.v_ep);
            lb_srf.getSrfMesh(si_lb, tol, u_gp_list, v_gp_list);
            rb_srf.getSrfMesh(si_rb, tol, u_gp_list, v_gp_list);
            lu_srf.getSrfMesh(si_lu, tol, u_gp_list, v_gp_list);
            ru_srf.getSrfMesh(si_ru, tol, u_gp_list, v_gp_list);
        } else if (lb_srf != null && rb_srf == null && lu_srf != null && ru_srf == null) {
            SegInfo si_lb = new SegInfo(si.u_sp, si.u_ep, si.v_sp, v_mp);
            SegInfo si_lu = new SegInfo(si.u_sp, si.u_ep, v_mp, si.v_ep);
            lb_srf.getSrfMesh(si_lb, tol, u_gp_list, v_gp_list);
            lu_srf.getSrfMesh(si_lu, tol, u_gp_list, v_gp_list);
        } else if (lb_srf != null && rb_srf != null && lu_srf == null && ru_srf == null) {
            SegInfo si_lb = new SegInfo(si.u_sp, u_mp, si.v_sp, si.v_ep);
            SegInfo si_rb = new SegInfo(u_mp, si.u_ep, si.v_sp, si.v_ep);
            lb_srf.getSrfMesh(si_lb, tol, u_gp_list, v_gp_list);
            rb_srf.getSrfMesh(si_rb, tol, u_gp_list, v_gp_list);
        }
    }

    private MeshParam makeMidGp(MeshParam sp, MeshParam ep) {
        int sgidx = sp.sgidx;
        int denom = JgclMath.LCM(sp.denom, ep.denom);
        if (denom == sp.denom || denom == ep.denom) {
            denom *= 2;
        }
        int numer = (sp.numer * (denom / sp.denom) + ep.numer * (denom / ep.denom)) / 2;
        return new MeshParam(sgidx, numer, denom);
    }

    private static boolean pointsAreColinear(double tol2, JgclPoint3D[] pnts, double[] info) {
        double d;
        int npnts = pnts.length;
        int npnts_1 = npnts - 1;
        if (npnts <= 1) {
            int i = 0;
            while (i < 4) {
                info[i] = 0.0;
                ++i;
            }
            return true;
        }
        JgclPoint3D l_pnt = pnts[0].longestPoint(pnts);
        JgclVector3D uax = l_pnt.subtract(pnts[0]);
        double length = uax.norm();
        if (d < tol2) {
            int i = 0;
            while (i < 3) {
                info[i] = 0.0;
                ++i;
            }
            info[3] = Math.sqrt(length);
            return true;
        }
        length = Math.sqrt(length);
        uax = uax.divide(length);
        int i = 1;
        while (i < npnts) {
            JgclVector3D evec = pnts[i].subtract(pnts[0]);
            JgclVector3D ecrs = evec.crossProduct(uax);
            if (ecrs.norm() > tol2) {
                return false;
            }
            ++i;
        }
        info[0] = uax.x();
        info[1] = uax.y();
        info[2] = uax.z();
        info[3] = length;
        return true;
    }

    static boolean vIsColinear(JgclPoint3D[][] pnts, double tolerance) {
        double tol2 = tolerance * tolerance;
        int u_uicp = pnts.length;
        int v_uicp = pnts[0].length;
        double[] info = new double[4];
        JgclVector3D[] dir = new JgclVector3D[2];
        double[] leng = new double[2];
        JgclVector3D[] tgt_vec = new JgclVector3D[2];
        boolean result = true;
        int u = 0;
        while (u < u_uicp) {
            if (!JgclFreeformSurfaceWithControlPoints3D.pointsAreColinear(tol2, pnts[u], info)) {
                result = false;
                break;
            }
            dir[1] = new JgclLiteralVector3D(info[0], info[1], info[2]);
            leng[1] = info[3];
            if (u == 0) {
                dir[0] = dir[1];
                leng[0] = leng[1];
                tgt_vec[0] = dir[0].multiply(leng[0]);
            } else {
                tgt_vec[1] = dir[1].multiply(leng[1]);
                JgclVector3D crs_prod = dir[0].crossProduct(tgt_vec[1]);
                if (crs_prod.norm() > tol2) {
                    result = false;
                    break;
                }
                crs_prod = dir[1].crossProduct(tgt_vec[0]);
                if (crs_prod.norm() > tol2) {
                    result = false;
                    break;
                }
            }
            ++u;
        }
        return result;
    }

    static boolean uIsColinear(JgclPoint3D[][] pnts, double tolerance) {
        double tol2 = tolerance * tolerance;
        int u_uicp = pnts.length;
        int v_uicp = pnts[0].length;
        JgclPoint3D[] my_pnts = new JgclPoint3D[u_uicp];
        double[] info = new double[4];
        JgclVector3D[] dir = new JgclVector3D[2];
        double[] leng = new double[2];
        JgclVector3D[] tgt_vec = new JgclVector3D[2];
        boolean result = true;
        int v = 0;
        while (v < v_uicp) {
            int u = 0;
            while (u < u_uicp) {
                my_pnts[u] = pnts[u][v];
                ++u;
            }
            if (!JgclFreeformSurfaceWithControlPoints3D.pointsAreColinear(tol2, my_pnts, info)) {
                result = false;
                break;
            }
            dir[1] = new JgclLiteralVector3D(info[0], info[1], info[2]);
            leng[1] = info[3];
            if (v == 0) {
                dir[0] = dir[1];
                leng[0] = leng[1];
                tgt_vec[0] = dir[0].multiply(leng[0]);
            } else {
                tgt_vec[1] = dir[1].multiply(leng[1]);
                JgclVector3D crs_prod = dir[0].crossProduct(tgt_vec[1]);
                if (crs_prod.norm() > tol2) {
                    result = false;
                    break;
                }
                crs_prod = dir[1].crossProduct(tgt_vec[0]);
                if (crs_prod.norm() > tol2) {
                    result = false;
                    break;
                }
            }
            ++v;
        }
        return result;
    }

    JgclMesh3D makeParamAndMesh(GpList u_gp_list, GpList v_gp_list, double[] u_kp, double[] v_kp) {
        double[] u_params = JgclFreeformSurfaceWithControlPoints3D.convGpList2Params(u_gp_list, u_kp);
        double[] v_params = JgclFreeformSurfaceWithControlPoints3D.convGpList2Params(v_gp_list, v_kp);
        int u_npnts = u_params.length;
        int v_npnts = v_params.length;
        JgclPoint3D[][] mesh = new JgclPointOnSurface3D[u_npnts][v_npnts];
        int i = 0;
        while (i < u_npnts) {
            int j = 0;
            while (j < v_npnts) {
                try {
                    mesh[i][j] = new JgclPointOnSurface3D(this, u_params[i], v_params[j], false);
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    throw new JgclFatal();
                }
                ++j;
            }
            ++i;
        }
        return new JgclMesh3D(mesh, false);
    }

    private static double[] convGpList2Params(GpList gp_list, double[] kp) {
        int n_params = gp_list.size();
        double[] params = new double[n_params];
        int i = 0;
        while (i < n_params) {
            MeshParam gp = gp_list.elementAt(i);
            double lp = (double)gp.numer / (double)gp.denom;
            params[i] = kp[gp.sgidx] * (1.0 - lp) + kp[gp.sgidx + 1] * lp;
            ++i;
        }
        JgclUtil.sortDoubleArray(params, 0, n_params - 1);
        return params;
    }

    private int[] setControlPoints(JgclPoint3D[][] controlPoints) {
        int[] npnts = new int[2];
        if (controlPoints == null) {
            throw new JgclInvalidArgumentValue();
        }
        npnts[0] = controlPoints.length;
        if (npnts[0] < 2) {
            throw new JgclInvalidArgumentValue();
        }
        int i = 0;
        while (i < npnts[0]) {
            if (i == 0) {
                npnts[1] = controlPoints[0].length;
                if (npnts[1] < 2) {
                    throw new JgclInvalidArgumentValue();
                }
                this.controlPoints = new JgclPoint3D[npnts[0]][npnts[1]];
            } else if (controlPoints[i].length != npnts[1]) {
                throw new JgclInvalidArgumentValue();
            }
            int j = 0;
            while (j < npnts[1]) {
                if (controlPoints[i][j] == null) {
                    throw new JgclInvalidArgumentValue();
                }
                this.controlPoints[i][j] = controlPoints[i][j];
                ++j;
            }
            ++i;
        }
        return npnts;
    }

    private void setWeights(int[] npnts, double[][] weights) {
        if (weights == null) {
            throw new JgclInvalidArgumentValue();
        }
        if (weights.length != npnts[0]) {
            throw new JgclInvalidArgumentValue();
        }
        double max_weight = 0.0;
        int i = 0;
        while (i < npnts[0]) {
            int j = 0;
            while (j < npnts[1]) {
                if (weights[i][j] > max_weight) {
                    max_weight = weights[i][j];
                }
                ++j;
            }
            ++i;
        }
        if (max_weight <= 0.0) {
            throw new JgclInvalidArgumentValue();
        }
        this.weights = new double[npnts[0]][npnts[1]];
        int i2 = 0;
        while (i2 < npnts[0]) {
            if (weights[i2].length != npnts[1]) {
                throw new JgclInvalidArgumentValue();
            }
            int j = 0;
            while (j < npnts[1]) {
                if (weights[i2][j] <= 0.0 || !JgclUtil.isDividable(max_weight, weights[i2][j])) {
                    throw new JgclInvalidArgumentValue();
                }
                this.weights[i2][j] = weights[i2][j];
                ++j;
            }
            ++i2;
        }
    }

    protected static double[][][] allocateDoubleArray(boolean isPoly, int uSize, int vSize) {
        return new double[uSize][vSize][isPoly ? 3 : 4];
    }

    protected void setCoordinatesToDoubleArray(boolean isPoly, int uUicp, int vUicp, double[][][] doubleArray) {
        if (isPoly) {
            int i = 0;
            while (i < uUicp) {
                int j = 0;
                while (j < vUicp) {
                    doubleArray[i][j][0] = this.controlPoints[i][j].x();
                    doubleArray[i][j][1] = this.controlPoints[i][j].y();
                    doubleArray[i][j][2] = this.controlPoints[i][j].z();
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < uUicp) {
                int j = 0;
                while (j < vUicp) {
                    doubleArray[i][j][0] = this.controlPoints[i][j].x() * this.weights[i][j];
                    doubleArray[i][j][1] = this.controlPoints[i][j].y() * this.weights[i][j];
                    doubleArray[i][j][2] = this.controlPoints[i][j].z() * this.weights[i][j];
                    doubleArray[i][j][3] = this.weights[i][j];
                    ++j;
                }
                ++i;
            }
        }
    }

    protected double[][][] toDoubleArray(boolean isPoly) {
        if (this.controlPointsArray != null) {
            return this.controlPointsArray;
        }
        int uUicp = this.uNControlPoints();
        int vUicp = this.vNControlPoints();
        this.controlPointsArray = JgclFreeformSurfaceWithControlPoints3D.allocateDoubleArray(isPoly, uUicp, vUicp);
        this.setCoordinatesToDoubleArray(isPoly, uUicp, vUicp, this.controlPointsArray);
        return this.controlPointsArray;
    }

    protected void convRational0Deriv(double[] d0) {
        int i = 0;
        while (i < 3) {
            int n = i++;
            d0[n] = d0[n] / d0[3];
        }
    }

    protected void convRational1Deriv(double[] d0, double[] du, double[] dv) {
        this.convRational0Deriv(d0);
        int i = 0;
        while (i < 3) {
            du[i] = (du[i] - du[3] * d0[i]) / d0[3];
            dv[i] = (dv[i] - dv[3] * d0[i]) / d0[3];
            ++i;
        }
    }

    protected void convRational2Deriv(double[] d0, double[] du, double[] dv, double[] duu, double[] duv, double[] dvv) {
        this.convRational1Deriv(d0, du, dv);
        int i = 0;
        while (i < 3) {
            duu[i] = (duu[i] - duu[3] * d0[i] - 2.0 * du[3] * du[i]) / d0[3];
            duv[i] = (duv[i] - duv[3] * d0[i] - du[3] * dv[i] - dv[3] * du[i]) / d0[3];
            dvv[i] = (dvv[i] - dvv[3] * d0[i] - 2.0 * dv[3] * dv[i]) / d0[3];
            ++i;
        }
    }

    JgclEnclosingBox3D approximateEnclosingBox() {
        double z;
        double y;
        double x;
        double min_crd_z;
        double min_crd_y;
        double min_crd_x;
        int uN = this.uNControlPoints();
        int vN = this.vNControlPoints();
        JgclPoint3D point = this.controlPointAt(0, 0);
        double max_crd_x = min_crd_x = point.x();
        double max_crd_y = min_crd_y = point.y();
        double max_crd_z = min_crd_z = point.z();
        int i = 1;
        while (i < uN) {
            point = this.controlPointAt(i, 0);
            x = point.x();
            y = point.y();
            z = point.z();
            if (x < min_crd_x) {
                min_crd_x = x;
            } else if (x > max_crd_x) {
                max_crd_x = x;
            }
            if (y < min_crd_y) {
                min_crd_y = y;
            } else if (y > max_crd_y) {
                max_crd_y = y;
            }
            if (z < min_crd_z) {
                min_crd_z = z;
            } else if (z > max_crd_z) {
                max_crd_z = z;
            }
            ++i;
        }
        int j = 1;
        while (j < vN) {
            i = 0;
            while (i < uN) {
                point = this.controlPointAt(i, j);
                x = point.x();
                y = point.y();
                z = point.z();
                if (x < min_crd_x) {
                    min_crd_x = x;
                } else if (x > max_crd_x) {
                    max_crd_x = x;
                }
                if (y < min_crd_y) {
                    min_crd_y = y;
                } else if (y > max_crd_y) {
                    max_crd_y = y;
                }
                if (z < min_crd_z) {
                    min_crd_z = z;
                } else if (z > max_crd_z) {
                    max_crd_z = z;
                }
                ++i;
            }
            ++j;
        }
        return new JgclEnclosingBox3D(min_crd_x, min_crd_y, min_crd_z, max_crd_x, max_crd_y, max_crd_z);
    }

    double getMaxLengthOfUControlPolygons(boolean closed) {
        double result = 0.0;
        int j = 0;
        while (j < this.vNControlPoints()) {
            double scale = 0.0;
            int k = 0;
            int i = 1;
            while (i < this.uNControlPoints()) {
                scale += this.controlPointAt(k, j).distance(this.controlPointAt(i, j));
                ++k;
                ++i;
            }
            if (closed) {
                scale += this.controlPointAt(k, j).distance(this.controlPointAt(0, j));
            }
            if (result < scale) {
                result = scale;
            }
            ++j;
        }
        return result;
    }

    double getMaxLengthOfVControlPolygons(boolean closed) {
        double result = 0.0;
        int i = 0;
        while (i < this.uNControlPoints()) {
            double scale = 0.0;
            int k = 0;
            int j = 1;
            while (j < this.vNControlPoints()) {
                scale += this.controlPointAt(i, k).distance(this.controlPointAt(i, j));
                ++k;
                ++j;
            }
            if (closed) {
                scale += this.controlPointAt(i, k).distance(this.controlPointAt(i, 0));
            }
            if (result < scale) {
                result = scale;
            }
            ++i;
        }
        return result;
    }

    public boolean isFreeform() {
        return true;
    }

    public double[][] makeUniformWeights() {
        double[][] uniformWeights = new double[this.uNControlPoints()][this.vNControlPoints()];
        int ui = 0;
        while (ui < this.uNControlPoints()) {
            int vi = 0;
            while (vi < this.vNControlPoints()) {
                uniformWeights[ui][vi] = 1.0;
                ++vi;
            }
            ++ui;
        }
        return uniformWeights;
    }

    class MeshParam {
        int sgidx;
        int numer;
        int denom;

        MeshParam(int sgidx, int numer, int denom) {
            JgclFreeformSurfaceWithControlPoints3D.this = JgclFreeformSurfaceWithControlPoints3D.this;
            this.sgidx = sgidx;
            this.numer = numer;
            this.denom = denom;
        }

        private boolean isSame(MeshParam mate) {
            int b_numer;
            int cmn_denom;
            int a_numer;
            if (this.sgidx != mate.sgidx) {
                if (this.sgidx == mate.sgidx - 1 && this.numer == this.denom && mate.numer == 0) {
                    return true;
                }
                if (mate.sgidx == this.sgidx - 1 && mate.numer == mate.denom && this.numer == 0) {
                    return true;
                }
            } else if (this.denom == mate.denom ? this.numer == mate.numer : (a_numer = this.numer * ((cmn_denom = JgclMath.LCM(this.denom, mate.denom)) / this.denom)) == (b_numer = mate.numer * (cmn_denom / mate.denom))) {
                return true;
            }
            return false;
        }
    }

    class SegInfo {
        MeshParam u_sp;
        MeshParam u_ep;
        MeshParam v_sp;
        MeshParam v_ep;

        SegInfo(MeshParam u_sp, MeshParam u_ep, MeshParam v_sp, MeshParam v_ep) {
            JgclFreeformSurfaceWithControlPoints3D.this = JgclFreeformSurfaceWithControlPoints3D.this;
            this.u_sp = u_sp;
            this.u_ep = u_ep;
            this.v_sp = v_sp;
            this.v_ep = v_ep;
        }
    }

    class GpList {
        Vector list = new Vector();

        GpList() {
            JgclFreeformSurfaceWithControlPoints3D.this = JgclFreeformSurfaceWithControlPoints3D.this;
        }

        int size() {
            return this.list.size();
        }

        MeshParam elementAt(int index) {
            return (MeshParam)this.list.elementAt(index);
        }

        void addGp(MeshParam gp) {
            int n_list = this.size();
            int i = 0;
            while (i < n_list) {
                if (gp.isSame(this.elementAt(i))) {
                    return;
                }
                ++i;
            }
            this.list.addElement(gp);
        }
    }
}

