/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import jp.go.ipa.jgcl.JgclBooleanFunctionWithRealVariables;
import jp.go.ipa.jgcl.JgclBoundedLine2D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclCurveDerivative2D;
import jp.go.ipa.jgcl.JgclFilletObject2D;
import jp.go.ipa.jgcl.JgclFilletObjectList;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLiteralVector2D;
import jp.go.ipa.jgcl.JgclMath;
import jp.go.ipa.jgcl.JgclNotSupported;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclRealFunction;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve2D;
import jp.go.ipa.jgcl.JgclVector2D;

final class JgclFiltCrvCrv2D {
    static boolean debug;
    private JgclFilletObjectList fillets;
    private CurveInfo[] infoA;
    private CurveInfo[] infoB;
    private double radius;

    private JgclFiltCrvCrv2D(JgclParametricCurve2D curveA, JgclParameterSection sectA, int sideA, JgclParametricCurve2D curveB, JgclParameterSection sectB, int sideB, double radius) {
        curveA.checkValidity(sectA);
        curveB.checkValidity(sectB);
        double tol = curveA.getToleranceForDistance();
        if (radius < tol) {
            throw new JgclInvalidArgumentValue();
        }
        this.fillets = new JgclFilletObjectList();
        this.radius = radius;
        this.infoA = this.getInfo(curveA, sectA, sideA);
        this.infoB = this.getInfo(curveB, sectB, sideB);
    }

    private JgclParametricCurve2D offsetCurve(JgclParametricCurve2D curve, JgclParameterSection section, int side, double radius) {
        switch (curve.type()) {
            case 1: {
                JgclLine2D lin = (JgclLine2D)curve;
                JgclVector2D enrm = side == 1 ? new JgclLiteralVector2D(lin.dir().y(), -lin.dir().x()) : new JgclLiteralVector2D(-lin.dir().y(), lin.dir().x());
                enrm = enrm.unitized();
                JgclPoint2D pnt = lin.pnt().add(enrm.multiply(radius));
                lin = new JgclLine2D(pnt, lin.dir());
                return new JgclTrimmedCurve2D(lin, section);
            }
            case 10: {
                double cRadius;
                JgclCircle2D cir = (JgclCircle2D)curve;
                boolean rev = false;
                if (side == 1) {
                    cRadius = cir.radius() + radius;
                } else {
                    cRadius = cir.radius() - radius;
                    if (cRadius < 0.0) {
                        cRadius = -cRadius;
                        rev = true;
                    }
                }
                if (cRadius < curve.getToleranceForDistance()) break;
                cir = new JgclCircle2D(cir.position(), cRadius);
                if (rev) {
                    double newStart = section.start() + Math.PI;
                    if (newStart > Math.PI * 2) {
                        newStart -= Math.PI * 2;
                    }
                    section = new JgclParameterSection(newStart, section.increase());
                }
                return new JgclTrimmedCurve2D(cir, section);
            }
        }
        JgclToleranceForDistance ofst_tol = new JgclToleranceForDistance(radius / 100.0);
        return curve.offsetByBsplineCurve(section, radius, side, ofst_tol);
    }

    private CurveInfo[] getInfo(JgclParametricCurve2D curve, JgclParameterSection section, int side) {
        int[] sides;
        int nInfo;
        switch (side) {
            case -1: {
                nInfo = 2;
                sides = new int[]{2, 1};
                break;
            }
            case 1: 
            case 2: {
                nInfo = 1;
                sides = new int[]{side};
                break;
            }
            default: {
                throw new JgclInvalidArgumentValue();
            }
        }
        CurveInfo[] infoArray = new CurveInfo[nInfo];
        int i = 0;
        while (i < nInfo) {
            infoArray[i] = new CurveInfo(curve, section, sides[i], this.radius);
            ++i;
        }
        return infoArray;
    }

    private JgclFilletObject2D[] getFillets() {
        int i = 0;
        while (i < this.infoA.length) {
            int j = 0;
            while (j < this.infoB.length) {
                FilletInfo doObj = new FilletInfo(this.infoA[i], this.infoB[j]);
                doObj.getFillets();
                ++j;
            }
            ++i;
        }
        return this.fillets.toJgclFilletObject2DArray(false);
    }

    static JgclFilletObject2D[] fillet(JgclParametricCurve2D curveA, JgclParameterSection sectA, int sideA, JgclParametricCurve2D curveB, JgclParameterSection sectB, int sideB, double radius) throws JgclIndefiniteSolution {
        int typeA = curveA.type();
        int typeB = curveB.type();
        switch (typeA) {
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 22: {
                switch (typeB) {
                    case 1: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 21: 
                    case 22: {
                        JgclFiltCrvCrv2D doObj = new JgclFiltCrvCrv2D(curveA, sectA, sideA, curveB, sectB, sideB, radius);
                        return doObj.getFillets();
                    }
                    case 23: {
                        return ((JgclTrimmedCurve2D)curveB).doFillet(sectB, sideB, curveA, sectA, sideA, radius, true);
                    }
                    case 24: {
                        return ((JgclCompositeCurve2D)curveB).doFillet(sectB, sideB, curveA, sectA, sideA, radius, true);
                    }
                    case 25: {
                        return ((JgclCompositeCurveSegment2D)curveB).doFillet(sectB, sideB, curveA, sectA, sideA, radius, true);
                    }
                    case 20: {
                        return ((JgclPolyline2D)curveB).doFillet(sectB, sideB, curveA, sectA, sideA, radius, true);
                    }
                    case 2: {
                        return ((JgclBoundedLine2D)curveB).doFillet(sectB, sideB, curveA, sectA, sideA, radius, true);
                    }
                }
                throw new JgclNotSupported();
            }
            case 23: {
                return ((JgclTrimmedCurve2D)curveA).doFillet(sectA, sideA, curveB, sectB, sideB, radius, false);
            }
            case 24: {
                return ((JgclCompositeCurve2D)curveA).doFillet(sectA, sideA, curveB, sectB, sideB, radius, false);
            }
            case 25: {
                return ((JgclCompositeCurveSegment2D)curveA).doFillet(sectA, sideA, curveB, sectB, sideB, radius, false);
            }
            case 20: {
                return ((JgclPolyline2D)curveA).doFillet(sectA, sideA, curveB, sectB, sideB, radius, false);
            }
            case 2: {
                return ((JgclBoundedLine2D)curveA).doFillet(sectA, sideA, curveB, sectB, sideB, radius, false);
            }
        }
        throw new JgclNotSupported();
    }

    private class CurveInfo {
        JgclParametricCurve2D curve;
        JgclParameterSection section;
        int side;
        JgclParametricCurve2D ofstCrv;

        private CurveInfo(JgclParametricCurve2D curve, JgclParameterSection section, int side, double radius) {
            JgclFiltCrvCrv2D.this = JgclFiltCrvCrv2D.this;
            this.curve = curve;
            this.section = section;
            this.side = side;
            this.ofstCrv = JgclFiltCrvCrv2D.this.offsetCurve(curve, section, side, radius);
            if (debug) {
                this.ofstCrv.output(System.out);
            }
        }

        private JgclPoint2D evaluate(double parameter) {
            JgclCurveDerivative2D deriv = this.curve.evaluation(this.curve.parameterDomain().force(parameter));
            JgclVector2D enrm = this.side == 1 ? new JgclLiteralVector2D(deriv.d1D().y(), -deriv.d1D().x()) : new JgclLiteralVector2D(-deriv.d1D().y(), deriv.d1D().x());
            enrm = enrm.unitized();
            return deriv.d0D().add(enrm.multiply(JgclFiltCrvCrv2D.this.radius));
        }
    }

    private class FilletInfo {
        CurveInfo cInfoA;
        CurveInfo cInfoB;
        private nlFunc nl_func;
        private JgclRealFunction[] dnl_func;
        private cnvFunc cnv_func;
        private JgclPoint2D sPntA;
        private JgclPoint2D sPntB;
        private JgclVector2D sTngA;
        private JgclVector2D sTngB;
        private JgclVector2D sNrmA;
        private JgclVector2D sNrmB;

        private FilletInfo(CurveInfo cInfoA, CurveInfo cInfoB) {
            JgclFiltCrvCrv2D.this = JgclFiltCrvCrv2D.this;
            this.cInfoA = cInfoA;
            this.cInfoB = cInfoB;
            this.nl_func = new nlFunc();
            this.dnl_func = new JgclRealFunction[2];
            this.dnl_func[0] = new dnlFunc(0);
            this.dnl_func[1] = new dnlFunc(1);
            this.cnv_func = new cnvFunc();
        }

        private JgclFilletObject2D refineFillet(JgclIntersectionPoint2D intp, JgclPointOnCurve2D pocA, JgclPointOnCurve2D pocB) {
            double[] param = new double[]{pocA.parameter(), pocB.parameter()};
            double[] refined = JgclMath.solveSimultaneousEquations(this.nl_func, this.dnl_func, this.cnv_func, param);
            if (refined == null) {
                return null;
            }
            JgclPoint2D cntr = this.sPntA.midPoint(this.sPntB);
            pocA = new JgclPointOnCurve2D(this.cInfoA.curve, refined[0], false);
            pocB = new JgclPointOnCurve2D(this.cInfoB.curve, refined[1], false);
            return new JgclFilletObject2D(JgclFiltCrvCrv2D.this.radius, cntr, pocA, pocB);
        }

        private JgclFilletObject2D toFillet(JgclIntersectionPoint2D intp) {
            JgclPointOnCurve2D pocA = this.cInfoA.curve.nearestProjectWithDistanceFrom(intp, JgclFiltCrvCrv2D.this.radius);
            JgclPointOnCurve2D pocB = this.cInfoB.curve.nearestProjectWithDistanceFrom(intp, JgclFiltCrvCrv2D.this.radius);
            return this.refineFillet(intp, pocA, pocB);
        }

        private void getFillets() {
            JgclIntersectionPoint2D[] ints;
            try {
                ints = this.cInfoA.ofstCrv.intersect(this.cInfoB.ofstCrv);
            }
            catch (JgclIndefiniteSolution e) {
                JgclIntersectionPoint2D intp = (JgclIntersectionPoint2D)e.suitable();
                ints = new JgclIntersectionPoint2D[]{intp};
            }
            int i = 0;
            while (i < ints.length) {
                JgclFilletObject2D oneSol = this.toFillet(ints[i]);
                if (oneSol != null) {
                    JgclFiltCrvCrv2D.this.fillets.addFillet(oneSol);
                }
                ++i;
            }
        }

        private class nlFunc
        implements JgclRealFunction {
            private nlFunc() {
                FilletInfo.this = FilletInfo.this;
            }

            public double[] evaluate(double[] parameter) {
                double[] vctr = new double[2];
                JgclVector2D evec = FilletInfo.this.sPntA.subtract(FilletInfo.this.sPntB);
                vctr[0] = evec.x();
                vctr[1] = evec.y();
                return vctr;
            }
        }

        private class dnlFunc
        implements JgclRealFunction {
            int idx;

            private dnlFunc(int idx) {
                FilletInfo.this = FilletInfo.this;
                this.idx = idx;
            }

            public double[] evaluate(double[] parameter) {
                double[] mtrx = new double[2];
                if (this.idx == 0) {
                    double nrmX;
                    double nrmY;
                    JgclCurveDerivative2D deriv = FilletInfo.this.cInfoA.curve.evaluation(FilletInfo.this.cInfoA.curve.parameterDomain().force(parameter[0]));
                    FilletInfo.this.sTngA = deriv.d1D();
                    JgclVector2D enrm = FilletInfo.this.cInfoA.side == 1 ? new JgclLiteralVector2D(FilletInfo.this.sTngA.y(), -FilletInfo.this.sTngA.x()) : new JgclLiteralVector2D(-FilletInfo.this.sTngA.y(), FilletInfo.this.sTngA.x());
                    enrm = enrm.unitized();
                    if (Math.abs(enrm.x()) > Math.abs(enrm.y())) {
                        nrmY = -(deriv.d2D().x() * enrm.x() + deriv.d2D().y() * enrm.y()) / (FilletInfo.this.sTngA.y() - FilletInfo.this.sTngA.x() * enrm.y() / enrm.x());
                        nrmX = -(enrm.y() * nrmY) / enrm.x();
                    } else {
                        nrmX = -(deriv.d2D().x() * enrm.x() + deriv.d2D().y() * enrm.y()) / (FilletInfo.this.sTngA.x() - FilletInfo.this.sTngA.y() * enrm.x() / enrm.y());
                        nrmY = -(enrm.x() * nrmX) / enrm.y();
                    }
                    FilletInfo.this.sNrmA = new JgclLiteralVector2D(nrmX, nrmY);
                    deriv = FilletInfo.this.cInfoB.curve.evaluation(FilletInfo.this.cInfoB.curve.parameterDomain().force(parameter[1]));
                    FilletInfo.this.sTngB = deriv.d1D();
                    enrm = FilletInfo.this.cInfoB.side == 1 ? new JgclLiteralVector2D(FilletInfo.this.sTngB.y(), -FilletInfo.this.sTngB.x()) : new JgclLiteralVector2D(-FilletInfo.this.sTngB.y(), FilletInfo.this.sTngB.x());
                    nrmY = -(deriv.d2D().x() * enrm.x() + deriv.d2D().y() * enrm.y()) / (FilletInfo.this.sTngB.y() - FilletInfo.this.sTngB.x() * enrm.y() / enrm.x());
                    nrmX = -(enrm.y() * nrmY) / enrm.x();
                    FilletInfo.this.sNrmB = new JgclLiteralVector2D(nrmX, nrmY);
                    mtrx[0] = FilletInfo.this.sTngA.x() + JgclFiltCrvCrv2D.this.radius * FilletInfo.this.sNrmA.x();
                    mtrx[1] = -FilletInfo.this.sTngB.x() - JgclFiltCrvCrv2D.this.radius * FilletInfo.this.sNrmB.x();
                } else {
                    mtrx[0] = FilletInfo.this.sTngA.y() + JgclFiltCrvCrv2D.this.radius * FilletInfo.this.sNrmA.y();
                    mtrx[1] = -FilletInfo.this.sTngB.y() - JgclFiltCrvCrv2D.this.radius * FilletInfo.this.sNrmB.y();
                }
                return mtrx;
            }
        }

        private class cnvFunc
        implements JgclBooleanFunctionWithRealVariables {
            private cnvFunc() {
                FilletInfo.this = FilletInfo.this;
            }

            public boolean evaluate(double[] parameter) {
                FilletInfo.this.sPntA = FilletInfo.this.cInfoA.evaluate(parameter[0]);
                FilletInfo.this.sPntB = FilletInfo.this.cInfoB.evaluate(parameter[1]);
                return FilletInfo.this.sPntA.identical(FilletInfo.this.sPntB);
            }
        }
    }
}

