/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Vector;
import jp.go.ipa.jgcl.JgclCompositeCurve2D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclListSorter;
import jp.go.ipa.jgcl.JgclOpenCurve;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclPoint1D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPolyline1D;
import jp.go.ipa.jgcl.JgclPolyline2D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector2D;

class JgclDivideCmcIntoSimpleLoops2D {
    private JgclCompositeCurve2D closedCmc;
    private int cmcWise;
    private int validSide;
    private int parameterOnSegmentCounter;
    private double aTol;
    private static final int VI_A = 0;
    private static final int VI_B = 0;

    JgclDivideCmcIntoSimpleLoops2D(JgclCompositeCurve2D closedCmc, int cmcWise, int validSide) throws JgclOpenCurve {
        if (!closedCmc.isClosed()) {
            throw new JgclOpenCurve();
        }
        if (!closedCmc.isPeriodic()) {
            closedCmc = new JgclCompositeCurve2D(closedCmc.segments(), true);
        }
        this.closedCmc = closedCmc;
        this.cmcWise = cmcWise;
        this.validSide = validSide;
        this.parameterOnSegmentCounter = 0;
        this.aTol = JgclConditionOfOperation.getCondition().getToleranceForAngle();
    }

    JgclCompositeCurve2D[] doIt() {
        JgclCompositeCurveSegment2D[] segments = this.closedCmc.decomposeAsSegmentsRecursively();
        int nSegments = segments.length;
        JgclToleranceForDistance dTol = this.closedCmc.getToleranceForDistanceAsObject();
        Vector<IntersectionInfo> selfIntsList = new Vector<IntersectionInfo>();
        int i = 0;
        while (i < nSegments) {
            JgclIntersectionPoint2D[] ints;
            if (segments[i].isFreeform()) {
                JgclPolyline2D polyline = segments[i].toPolyline(dTol);
                JgclPoint1D[] parameters = new JgclPoint1D[polyline.nPoints()];
                int j = 0;
                while (j < polyline.nPoints()) {
                    JgclPointOnCurve2D poc = (JgclPointOnCurve2D)polyline.pointAt(j);
                    parameters[j] = JgclPoint1D.of(poc.parameter());
                    ++j;
                }
                JgclPolyline1D polyline1D = new JgclPolyline1D(parameters, polyline.isPeriodic());
                ints = polyline.selfIntersect();
                int j2 = 0;
                while (j2 < ints.length) {
                    JgclPoint1D pnt1D = polyline1D.coordinates(ints[j2].pointOnCurve1().parameter());
                    ParameterOnSegment posA = new ParameterOnSegment(segments[i], i, pnt1D.x());
                    pnt1D = polyline1D.coordinates(ints[j2].pointOnCurve2().parameter());
                    ParameterOnSegment posB = new ParameterOnSegment(segments[i], i, pnt1D.x());
                    IntersectionInfo intsInfo = new IntersectionInfo(ints[j2], posA, posB);
                    selfIntsList.addElement(intsInfo);
                    ++j2;
                }
            }
            int k = i + 1;
            while (k < nSegments) {
                ints = segments[i].intersect(segments[k]);
                int j = 0;
                while (j < ints.length) {
                    ParameterOnSegment posA = new ParameterOnSegment(segments[i], i, ints[j].pointOnCurve1().parameter());
                    ParameterOnSegment posB = new ParameterOnSegment(segments[k], k, ints[j].pointOnCurve2().parameter());
                    IntersectionInfo intsInfo = new IntersectionInfo(ints[j], posA, posB);
                    selfIntsList.addElement(intsInfo);
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        if (selfIntsList.size() == 0) {
            JgclCompositeCurve2D[] result = new JgclCompositeCurve2D[]{this.closedCmc};
            return result;
        }
        1 comparator = new 1();
        JgclListSorter.doSorting(selfIntsList, comparator);
        return this.divideIntoSimpleLoops(segments, selfIntsList);
    }

    private VertexInfo[] makeInOutInfo(Vector intersectionList) {
        int nVInfo = intersectionList.size();
        VertexInfo[] vInfo = new VertexInfo[nVInfo];
        int i = 0;
        while (i < nVInfo) {
            IntersectionInfo ints = (IntersectionInfo)intersectionList.elementAt(i);
            vInfo[i] = new VertexInfo(ints.posA, ints.posB);
            ++i;
        }
        int i2 = 0;
        while (i2 < nVInfo) {
            int k = 0;
            while (k < 2) {
                int j = 0;
                while (j < nVInfo) {
                    int l = 0;
                    while (l < 2) {
                        if (vInfo[i2].pair[k] == null) {
                            if (vInfo[i2].me[k].isMateBig(vInfo[j].me[l])) {
                                vInfo[i2].pair[k] = vInfo[j].me[l];
                            }
                        } else if (vInfo[i2].me[k].isMateBig(vInfo[j].me[l]) && !vInfo[i2].pair[k].isMateBig(vInfo[j].me[l])) {
                            vInfo[i2].pair[k] = vInfo[j].me[l];
                        }
                        ++l;
                    }
                    ++j;
                }
                if (vInfo[i2].pair[k] == null) {
                    vInfo[i2].pair[k] = vInfo[i2].me[k];
                    int j2 = 0;
                    while (j2 < nVInfo) {
                        int l = 0;
                        while (l < 2) {
                            if (!vInfo[i2].pair[k].isMateBig(vInfo[j2].me[l])) {
                                vInfo[i2].pair[k] = vInfo[j2].me[l];
                            }
                            ++l;
                        }
                        ++j2;
                    }
                }
                ++k;
            }
            ++i2;
        }
        return vInfo;
    }

    private ParameterOnSegment getUnusedOut(VertexInfo[] vInfo) {
        int i = 0;
        while (i < vInfo.length) {
            if (!vInfo[i].used[0]) {
                return vInfo[i].me[0];
            }
            if (!vInfo[i].used[0]) {
                return vInfo[i].me[0];
            }
            ++i;
        }
        return null;
    }

    private ParameterOnSegment getMate(VertexInfo[] vInfo, ParameterOnSegment popc) {
        int i = 0;
        while (i < vInfo.length) {
            if (vInfo[i].me[0] == popc) {
                return vInfo[i].me[0];
            }
            if (vInfo[i].me[0] == popc) {
                return vInfo[i].me[0];
            }
            ++i;
        }
        return null;
    }

    private ParameterOnSegment getNextIn(VertexInfo[] vInfo, ParameterOnSegment out) {
        int i = 0;
        while (i < vInfo.length) {
            if (vInfo[i].me[0] == out) {
                vInfo[i].used[0] = true;
                return vInfo[i].pair[0];
            }
            if (vInfo[i].me[0] == out) {
                vInfo[i].used[0] = true;
                return vInfo[i].pair[0];
            }
            ++i;
        }
        return null;
    }

    private boolean forward2Right(double cp) {
        return cp < -this.aTol;
    }

    private boolean forward2Left(double cp) {
        return cp > this.aTol;
    }

    private int isValidCmc(JgclVector2D in_tang, JgclVector2D out_tang) {
        JgclVector2D iu_tang = in_tang.unitized();
        JgclVector2D ou_tang = out_tang.unitized();
        double crs_prod = in_tang.zOfCrossProduct(ou_tang);
        int is_valid = this.cmcWise == 1 ? (this.forward2Right(crs_prod) ? 1 : (this.forward2Left(crs_prod) ? 0 : -1)) : (this.forward2Right(crs_prod) ? 0 : (this.forward2Left(crs_prod) ? 1 : -1));
        if (this.validSide == 6) {
            if (is_valid == 1) {
                is_valid = 0;
            } else if (is_valid == 0) {
                is_valid = 1;
            }
        }
        return is_valid;
    }

    private JgclCompositeCurveSegment2D addTruncatedSegment(Vector segmentList, JgclCompositeCurveSegment2D segment, double sP, double eP, int transition) {
        JgclParameterSection trimmingSection = new JgclParameterSection(sP, eP - sP);
        JgclCompositeCurveSegment2D trimmedSegment = segment.truncate(trimmingSection, transition);
        segmentList.addElement(trimmedSegment);
        return trimmedSegment;
    }

    private int getNextSegmentIndex(JgclCompositeCurveSegment2D[] segments, int i) {
        return ++i < segments.length ? i : 0;
    }

    private JgclCompositeCurve2D[] divideIntoSimpleLoops(JgclCompositeCurveSegment2D[] segments, Vector intersectionList) {
        ParameterOnSegment first_out;
        Vector<JgclCompositeCurve2D> resultVector = new Vector<JgclCompositeCurve2D>();
        VertexInfo[] vInfo = this.makeInOutInfo(intersectionList);
        JgclVector2D in_tang = null;
        JgclVector2D first_out_tang = null;
        while ((first_out = this.getUnusedOut(vInfo)) != null) {
            int is_v;
            ParameterOnSegment c_in;
            Vector<JgclCompositeCurveSegment2D> segmentList = new Vector<JgclCompositeCurveSegment2D>();
            ParameterOnSegment c_out = first_out;
            JgclCompositeCurveSegment2D lastSegment = null;
            int loop_is_valid = -1;
            do {
                c_in = this.getNextIn(vInfo, c_out);
                JgclVector2D out_tang = c_out.segment.tangentVector(c_out.parameter);
                if (lastSegment == null) {
                    first_out_tang = out_tang;
                } else {
                    is_v = this.isValidCmc(in_tang, out_tang);
                    if (is_v != -1 && loop_is_valid != 0) {
                        loop_is_valid = is_v;
                    }
                }
                if (c_out.segmentIndex == c_in.segmentIndex && c_out.isMateBig(c_in)) {
                    lastSegment = this.addTruncatedSegment(segmentList, c_out.segment, c_out.parameter, c_in.parameter, 1);
                } else {
                    lastSegment = this.addTruncatedSegment(segmentList, c_out.segment, c_out.parameter, c_out.segment.eParameter(), c_out.segment.transition());
                    int segmentIndex = c_out.segmentIndex;
                    while ((segmentIndex = this.getNextSegmentIndex(segments, segmentIndex)) != c_in.segmentIndex) {
                        segmentList.addElement(segments[segmentIndex]);
                        lastSegment = segments[segmentIndex];
                    }
                    lastSegment = this.addTruncatedSegment(segmentList, c_in.segment, c_in.segment.sParameter(), c_in.parameter, 1);
                }
                if (lastSegment == null) continue;
                in_tang = lastSegment.tangentVector(lastSegment.eParameter());
            } while ((c_out = this.getMate(vInfo, c_in)) != first_out);
            is_v = this.isValidCmc(in_tang, first_out_tang);
            if (is_v != -1 && loop_is_valid != 0) {
                loop_is_valid = is_v;
            }
            Object[] newSegments = new JgclCompositeCurveSegment2D[segmentList.size()];
            segmentList.copyInto(newSegments);
            JgclCompositeCurve2D newCurve = new JgclCompositeCurve2D((JgclCompositeCurveSegment2D[])newSegments, true);
            resultVector.addElement(newCurve);
        }
        Object[] result = new JgclCompositeCurve2D[resultVector.size()];
        resultVector.copyInto(result);
        return result;
    }

    static /* synthetic */ int access$0() {
        return 0;
    }

    static /* synthetic */ int access$1() {
        return 0;
    }

    private final class 1
    implements JgclListSorter.ObjectComparator {
        public boolean latterIsGreaterThanFormer(Object former, Object latter) {
            IntersectionInfo f = (IntersectionInfo)former;
            IntersectionInfo l = (IntersectionInfo)latter;
            if (f == l) {
                return false;
            }
            if (f.posA.segmentIndex < l.posA.segmentIndex) {
                return true;
            }
            if (f.posA.segmentIndex > l.posA.segmentIndex) {
                return false;
            }
            return f.posA.parameter < l.posA.parameter;
        }

        /* synthetic */ 1() {
        }
    }

    private class ParameterOnSegment {
        JgclCompositeCurveSegment2D segment;
        int segmentIndex;
        double parameter;
        int id;

        ParameterOnSegment(JgclCompositeCurveSegment2D s, int i, double p) {
            JgclDivideCmcIntoSimpleLoops2D.this = JgclDivideCmcIntoSimpleLoops2D.this;
            this.segment = s;
            this.segmentIndex = i;
            this.parameter = p;
            JgclDivideCmcIntoSimpleLoops2D jgclDivideCmcIntoSimpleLoops2D = JgclDivideCmcIntoSimpleLoops2D.this;
            int n = jgclDivideCmcIntoSimpleLoops2D.parameterOnSegmentCounter;
            jgclDivideCmcIntoSimpleLoops2D.parameterOnSegmentCounter = n + 1;
            this.id = n;
        }

        boolean isMateBig(ParameterOnSegment mate) {
            boolean result;
            if (this.segmentIndex < mate.segmentIndex) {
                result = true;
            } else if (this.segmentIndex > mate.segmentIndex) {
                result = false;
            } else {
                result = false;
                if (this.parameter < mate.parameter) {
                    result = true;
                }
                if (!(result || this.id == mate.id || this.parameter < mate.parameter || this.parameter > mate.parameter || this.id >= mate.id)) {
                    result = true;
                }
            }
            return result;
        }
    }

    private class IntersectionInfo {
        JgclPoint2D coordinates;
        ParameterOnSegment posA;
        ParameterOnSegment posB;

        IntersectionInfo(JgclPoint2D c, ParameterOnSegment pA, ParameterOnSegment pB) {
            JgclDivideCmcIntoSimpleLoops2D.this = JgclDivideCmcIntoSimpleLoops2D.this;
            this.coordinates = c;
            this.posA = pA;
            this.posB = pB;
        }
    }

    private class VertexInfo {
        boolean[] used = new boolean[2];
        ParameterOnSegment[] me = new ParameterOnSegment[2];
        ParameterOnSegment[] pair = new ParameterOnSegment[2];

        VertexInfo(ParameterOnSegment posA, ParameterOnSegment posB) {
            JgclDivideCmcIntoSimpleLoops2D.this = JgclDivideCmcIntoSimpleLoops2D.this;
            this.used[JgclDivideCmcIntoSimpleLoops2D.access$0()] = false;
            this.used[JgclDivideCmcIntoSimpleLoops2D.access$1()] = false;
            this.me[JgclDivideCmcIntoSimpleLoops2D.access$0()] = posA;
            this.me[JgclDivideCmcIntoSimpleLoops2D.access$1()] = posB;
            this.pair[JgclDivideCmcIntoSimpleLoops2D.access$0()] = null;
            this.pair[JgclDivideCmcIntoSimpleLoops2D.access$1()] = null;
        }
    }
}

