/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBsplineCurve2D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCylindricalSurface3D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsConCon3D;
import jp.go.ipa.jgcl.JgclIntsCylCon3D;
import jp.go.ipa.jgcl.JgclIntsPlnCon3D;
import jp.go.ipa.jgcl.JgclIntsQrdBzs3D;
import jp.go.ipa.jgcl.JgclIntsSphCon3D;
import jp.go.ipa.jgcl.JgclIntsSrfBss3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclMachineEpsilon;
import jp.go.ipa.jgcl.JgclMesh3D;
import jp.go.ipa.jgcl.JgclOfst3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclReducedToPoint;
import jp.go.ipa.jgcl.JgclSphericalSurface3D;
import jp.go.ipa.jgcl.JgclSurfaceCurvature3D;
import jp.go.ipa.jgcl.JgclSurfaceDerivative3D;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclConicalSurface3D
extends JgclElementarySurface3D {
    private double radius;
    private double semiAngle;

    private void setRadius(double radius, double semiAngle) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        double aTol = condition.getToleranceForAngle();
        if (radius < 0.0) {
            throw new JgclInvalidArgumentValue();
        }
        this.radius = radius;
        if (semiAngle < aTol || 1.5707963267948966 - aTol < semiAngle) {
            throw new JgclInvalidArgumentValue();
        }
        this.semiAngle = semiAngle;
    }

    public JgclConicalSurface3D(JgclAxis2Placement3D position, double radius, double semiAngle) {
        super(position);
        this.setRadius(radius, semiAngle);
    }

    public JgclConicalSurface3D(JgclPoint3D pnt, JgclVector3D axis, double radius, double semiAngle) {
        super(new JgclAxis2Placement3D(pnt, axis, axis.verticalVector().unitized()));
        this.setRadius(radius, semiAngle);
    }

    public double radius() {
        return this.radius;
    }

    public double semiAngle() {
        return this.semiAngle;
    }

    public JgclPoint3D coordinates(double uParam, double vParam) {
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        double rad = this.radius + vParam * Math.tan(this.semiAngle);
        double x = rad * Math.cos(uParam);
        double y = rad * Math.sin(uParam);
        JgclCartesianPoint3D pnt = new JgclCartesianPoint3D(x, y, vParam);
        return gtrans.transform(pnt);
    }

    public JgclVector3D[] tangentVector(double uParam, double vParam) {
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        double tan_sa = Math.tan(this.semiAngle);
        double sin_u = Math.sin(uParam);
        double cos_u = Math.cos(uParam);
        double rad = this.radius + vParam * tan_sa;
        JgclLiteralVector3D dup = new JgclLiteralVector3D(-rad * sin_u, rad * cos_u, 0.0);
        JgclLiteralVector3D dvp = new JgclLiteralVector3D(tan_sa * cos_u, tan_sa * sin_u, 1.0);
        JgclVector3D[] tang = new JgclVector3D[]{gtrans.transform(dup), gtrans.transform(dvp)};
        return tang;
    }

    public JgclVector3D normalVector(double uParam, double vParam) {
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        JgclLiteralVector3D nrm = new JgclLiteralVector3D(Math.cos(uParam), Math.sin(uParam), -Math.tan(this.semiAngle));
        return gtrans.transform(nrm).unitized();
    }

    public JgclSurfaceCurvature3D curvature(double uParam, double vParam) {
        JgclVector3D[] tangent = this.tangentVector(uParam, vParam);
        double tan_sa = Math.tan(this.semiAngle);
        double rad = this.radius + vParam * tan_sa;
        return new JgclSurfaceCurvature3D(-1.0 / (rad * (tan_sa * tan_sa + 1.0)), tangent[0].unitized(), 0.0, tangent[1].unitized());
    }

    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam) {
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        double tan_sa = Math.tan(this.semiAngle);
        double sin_u = Math.sin(uParam);
        double cos_u = Math.cos(uParam);
        double rad = this.radius + vParam * tan_sa;
        JgclCartesianPoint3D pnt = new JgclCartesianPoint3D(rad * cos_u, rad * sin_u, vParam);
        JgclLiteralVector3D dup = new JgclLiteralVector3D(-rad * sin_u, rad * cos_u, 0.0);
        JgclLiteralVector3D dvp = new JgclLiteralVector3D(tan_sa * cos_u, tan_sa * sin_u, 1.0);
        JgclLiteralVector3D duup = new JgclLiteralVector3D(-rad * cos_u, -rad * sin_u, 0.0);
        JgclLiteralVector3D duvp = new JgclLiteralVector3D(-tan_sa * sin_u, tan_sa * cos_u, 0.0);
        JgclVector3D zerov = JgclVector3D.zeroVector;
        return new JgclSurfaceDerivative3D(gtrans.transform(pnt), gtrans.transform(dup), gtrans.transform(dvp), gtrans.transform(duup), gtrans.transform(duvp), gtrans.transform(zerov));
    }

    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point) throws JgclIndefiniteSolution {
        JgclCartesianTransformationOperator3D gtrans = this.toGlobal();
        JgclPoint3D lpoint = gtrans.reverseTransform(point);
        double z = lpoint.z();
        JgclCartesianPoint3D apoint = new JgclCartesianPoint3D(0.0, 0.0, z);
        JgclVector3D eduvec = lpoint.subtract(apoint);
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = Math.abs(condition.getToleranceForDistance());
        double lx = eduvec.length();
        if (lx < dTol) {
            JgclPointOnSurface3D p;
            try {
                p = new JgclPointOnSurface3D(this, 0.0, z, false);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            throw new JgclIndefiniteSolution(p);
        }
        double u = Math.atan2(eduvec.y(), eduvec.x());
        double Btan = Math.tan(this.semiAngle);
        double Bcos = Math.cos(this.semiAngle);
        double Bsin = Math.sin(this.semiAngle);
        double zoff = this.radius / Btan;
        double ly = z + zoff;
        double edist = ly * Bcos + lx * Bsin;
        if (u < 0.0) {
            u += Math.PI * 2;
        }
        JgclPointOnSurface3D foot1 = new JgclPointOnSurface3D(this, u, Bcos * edist - zoff, false);
        edist = ly * Bcos - lx * Bsin;
        if ((u += Math.PI) >= Math.PI * 2) {
            u -= Math.PI * 2;
        }
        JgclPointOnSurface3D foot2 = new JgclPointOnSurface3D(this, u, Bcos * edist - zoff, false);
        JgclPointOnSurface3D[] proj = new JgclPointOnSurface3D[]{foot1, foot2};
        return proj;
    }

    public JgclMesh3D toMesh(JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        return this.makeMesh(1, uPint, vPint, tol);
    }

    private JgclMesh3D makeMesh(int meshType, JgclParameterSection uPint, JgclParameterSection vPint, JgclToleranceForDistance tol) {
        int v_npnts;
        double vStart = vPint.start();
        double vEnd = vPint.end();
        double vMiddle = 0.0;
        double rad = this.getMaxRadius(vPint);
        int u_npnts = rad <= JgclConditionOfOperation.getCondition().getToleranceForDistance() ? 2 : JgclCircle2D.toPolylineNDivision(rad, uPint.increase(), tol) + 1;
        if (meshType == 1) {
            double ep;
            double apexV = this.apexVParameter();
            double sp = vStart - apexV;
            if (sp * (ep = vEnd - apexV) >= 0.0) {
                v_npnts = 2;
            } else {
                JgclPoint3D apex = this.apex();
                if (this.coordinates(0.0, vStart).identical(apex) || this.coordinates(0.0, vEnd).identical(apex)) {
                    v_npnts = 2;
                } else {
                    v_npnts = 3;
                    vMiddle = apexV;
                }
            }
        } else {
            v_npnts = 3;
            vMiddle = (vStart + vEnd) / 2.0;
        }
        JgclPoint3D[][] mesh = new JgclPointOnSurface3D[u_npnts][v_npnts];
        double uDelta = uPint.increase() / (double)(u_npnts - 1);
        double uParam = uPint.start();
        int i = 0;
        while (i < u_npnts) {
            int j = 0;
            while (j < v_npnts) {
                double vParam = j == 0 ? vStart : (j == 2 || v_npnts == 2 ? vEnd : vMiddle);
                mesh[i][j] = new JgclPointOnSurface3D(this, uParam, vParam, false);
                ++j;
            }
            uParam = i == u_npnts - 2 ? uPint.end() : (uParam += uDelta);
            ++i;
        }
        return new JgclMesh3D(mesh, false);
    }

    private double getMaxRadius(JgclParameterSection vPint) {
        double rads = Math.abs(this.radius + vPint.start() * Math.tan(this.semiAngle));
        double rade = Math.abs(this.radius + vPint.end() * Math.tan(this.semiAngle));
        return Math.max(rads, rade);
    }

    public JgclBsplineSurface3D toBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint) {
        JgclCircle2D circle2D = new JgclCircle2D(JgclAxis2Placement2D.origin, this.radius());
        JgclBsplineCurve2D uBsplineCurve2D = circle2D.toBsplineCurve(uPint);
        int uNPoints = uBsplineCurve2D.nControlPoints();
        int vNPoints = 2;
        JgclPoint3D[][] controlPoints = new JgclPoint3D[uNPoints][vNPoints];
        double[][] weights = new double[uNPoints][vNPoints];
        JgclCartesianTransformationOperator3D localTransformationOperator = this.position().toCartesianTransformationOperator(1.0);
        JgclCartesianPoint3D localVertex = JgclPoint3D.of(0.0, 0.0, -(this.radius() / Math.tan(this.semiAngle())));
        double vLowerCoord = vPint.start() / ((JgclPoint3D)localVertex).z();
        double vUpperCoord = vPint.end() / ((JgclPoint3D)localVertex).z();
        int ui = 0;
        while (ui < uNPoints) {
            JgclPoint3D uPoint = uBsplineCurve2D.controlPointAt(ui).to3D();
            controlPoints[ui][0] = localTransformationOperator.toEnclosed(localVertex.linearInterpolate(uPoint, vLowerCoord));
            controlPoints[ui][1] = localTransformationOperator.toEnclosed(localVertex.linearInterpolate(uPoint, vUpperCoord));
            double d = uBsplineCurve2D.weightAt(ui);
            weights[ui][1] = d;
            weights[ui][0] = d;
            ++ui;
        }
        return new JgclBsplineSurface3D(uBsplineCurve2D.knotData(), JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment, controlPoints, weights);
    }

    boolean checkSolution(JgclPoint3D point) {
        double ework;
        double dTol = this.getToleranceForDistance();
        double tanBsa = Math.tan(this.semiAngle());
        double dist = Math.sqrt(point.x() * point.x() + point.y() * point.y());
        return Math.abs(dist - (ework = tanBsa * point.z() + this.radius())) < dTol;
    }

    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
        int j;
        double tanBsa = Math.tan(this.semiAngle());
        boolean isPoly = poly.length < 4;
        int degree = poly[0].degree();
        double[] zCoef = new double[degree + 1];
        if (isPoly) {
            j = 0;
            while (j <= degree) {
                zCoef[j] = tanBsa * poly[2].coefficientAt(j);
                ++j;
            }
            zCoef[0] = zCoef[0] + this.radius();
        } else {
            j = 0;
            while (j <= degree) {
                zCoef[j] = tanBsa * poly[2].coefficientAt(j) + this.radius() * poly[3].coefficientAt(j);
                ++j;
            }
        }
        JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
        JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
        JgclRealPolynomial workPoly = new JgclRealPolynomial(zCoef);
        JgclRealPolynomial wPoly = workPoly.multiply(workPoly);
        degree = xPoly.degree();
        double[] coef = new double[degree + 1];
        int j2 = 0;
        while (j2 <= degree) {
            coef[j2] = xPoly.coefficientAt(j2) + yPoly.coefficientAt(j2) - wPoly.coefficientAt(j2);
            ++j2;
        }
        return new JgclRealPolynomial(coef);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntersectionPoint3D[] one_side = this.intersectLine(mate, doExchange);
        JgclConicalSurface3D another_cone = this.getReverse();
        JgclIntersectionPoint3D[] another_side = another_cone.intersectLine(mate, doExchange);
        if (another_side.length == 2) {
            double[] param = new double[2];
            JgclPoint3D pnt = another_side[0].coordinates();
            param = this.pointToParameter(pnt);
            JgclPointOnSurface3D trans_another_side1 = new JgclPointOnSurface3D(pnt, this, param[0], param[1]);
            pnt = another_side[1].coordinates();
            param = this.pointToParameter(pnt);
            JgclPointOnSurface3D trans_another_side2 = new JgclPointOnSurface3D(pnt, this, param[0], param[1]);
            JgclIntersectionPoint3D[] returnValue = new JgclIntersectionPoint3D[2];
            if (doExchange) {
                returnValue[0] = new JgclIntersectionPoint3D(another_side[0].pointOnGeometry1(), trans_another_side1, false);
                returnValue[1] = new JgclIntersectionPoint3D(another_side[1].pointOnGeometry1(), trans_another_side2, false);
            } else {
                returnValue[0] = new JgclIntersectionPoint3D(trans_another_side1, another_side[0].pointOnGeometry1(), false);
                returnValue[1] = new JgclIntersectionPoint3D(trans_another_side2, another_side[1].pointOnGeometry1(), false);
            }
            return returnValue;
        }
        if (another_side.length == 1) {
            JgclIntersectionPoint3D[] returnValue;
            double[] param = new double[2];
            JgclPoint3D pnt = another_side[0].coordinates();
            param = this.pointToParameter(pnt);
            JgclPointOnSurface3D trans_another_side = new JgclPointOnSurface3D(pnt, this, param[0], param[1]);
            JgclIntersectionPoint3D another_intersection = doExchange ? new JgclIntersectionPoint3D(another_side[0].pointOnGeometry1(), trans_another_side, false) : new JgclIntersectionPoint3D(trans_another_side, another_side[0].pointOnGeometry2(), false);
            if (one_side.length == 1) {
                JgclPoint3D another_point;
                JgclPoint3D this_point = one_side[0].pointOnGeometry2().coordinates();
                if (this_point.distance(another_point = another_intersection.pointOnGeometry2().coordinates()) < this.getToleranceForDistance()) {
                    returnValue = new JgclIntersectionPoint3D[]{one_side[0]};
                } else {
                    double another_param;
                    returnValue = new JgclIntersectionPoint3D[2];
                    double this_param = doExchange ? ((JgclPointOnCurve3D)one_side[0].pointOnGeometry1()).parameter() : ((JgclPointOnCurve3D)one_side[0].pointOnGeometry2()).parameter();
                    if (this_param > (another_param = doExchange ? ((JgclPointOnCurve3D)another_intersection.pointOnGeometry1()).parameter() : ((JgclPointOnCurve3D)another_intersection.pointOnGeometry2()).parameter())) {
                        returnValue[0] = one_side[0];
                        returnValue[1] = another_intersection;
                    } else {
                        returnValue[0] = another_intersection;
                        returnValue[1] = one_side[0];
                    }
                }
            } else {
                returnValue = new JgclIntersectionPoint3D[]{another_intersection};
            }
            return returnValue;
        }
        return one_side;
    }

    /*
     * WARNING - void declaration
     */
    JgclIntersectionPoint3D[] intersectLine(JgclLine3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        void var24_17;
        int number_of_intpnt;
        JgclPoint3D[] int_pnt;
        double[] paraA = new double[2];
        double[][] paraB = new double[2][2];
        double aTol = this.getToleranceForAngle();
        double dTol = this.getToleranceForDistance();
        double epsilon = JgclMachineEpsilon.DOUBLE;
        double etan = Math.tan(this.semiAngle());
        double ework1 = this.radius() / etan;
        JgclPoint3D dBorg = this.position().location();
        JgclVector3D dBxyz = this.position().z();
        JgclCartesianPoint3D Vp = new JgclCartesianPoint3D(dBorg.x() - ework1 * dBxyz.x(), dBorg.y() - ework1 * dBxyz.y(), dBorg.z() - ework1 * dBxyz.z());
        JgclPointOnCurve3D project = mate.project1From(Vp);
        if (project.distance(Vp) < dTol) {
            JgclVector3D uAdir = mate.dir().unitized();
            ework1 = Math.abs(uAdir.dotProduct(dBxyz));
            if (ework1 > 1.0) {
                ework1 = 1.0;
            }
            if (Math.abs(Math.acos(ework1) - this.semiAngle()) < aTol) {
                throw new JgclIndefiniteSolution(mate.pnt());
            }
            int_pnt = new JgclPoint3D[]{new JgclCartesianPoint3D(Vp.x(), Vp.y(), Vp.z())};
            JgclVector3D pnt_to_vertex = Vp.subtract(mate.pnt());
            paraA[0] = pnt_to_vertex.length() / mate.dir().length();
            if (pnt_to_vertex.dotProduct(mate.dir()) < 0.0) {
                paraA[0] = -1.0 * paraA[0];
            }
            paraB[0][0] = 0.0;
            paraB[0][1] = -1.0 * this.radius() / etan;
            number_of_intpnt = 1;
        } else {
            double dist;
            JgclCartesianTransformationOperator3D trans = new JgclCartesianTransformationOperator3D(this.position(), 1.0);
            JgclPoint3D dAtpnt = trans.reverseTransform(mate.pnt());
            JgclVector3D dAtdir = trans.reverseTransform(mate.dir());
            JgclLine3D dAt = new JgclLine3D(dAtpnt, dAtdir);
            ework1 = etan * dAtdir.z();
            double ework2 = etan * dAtpnt.z() + this.radius();
            double[] ecoef = new double[3];
            ecoef[2] = dAtdir.x() * dAtdir.x() + dAtdir.y() * dAtdir.y() - ework1 * ework1;
            ecoef[1] = 2.0 * (dAtpnt.x() * dAtdir.x() + dAtpnt.y() * dAtdir.y() - ework1 * ework2);
            ecoef[0] = dAtpnt.x() * dAtpnt.x() + dAtpnt.y() * dAtpnt.y() - ework2 * ework2;
            JgclRealPolynomial poly = new JgclRealPolynomial(ecoef);
            double[] eroot = poly.getRootsIfQuadric();
            int_pnt = new JgclPoint3D[eroot.length];
            int j = 0;
            int i = 0;
            while (i < eroot.length) {
                JgclPoint3D epnt = dAt.coordinates(eroot[i]);
                if (!(epnt.z() < -(this.radius() / etan + dTol))) {
                    int_pnt[j] = mate.coordinates(eroot[i]);
                    paraA[j] = eroot[i];
                    if (Math.abs(epnt.x()) < epsilon) {
                        paraB[j][0] = epnt.y() > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
                    } else {
                        paraB[j][0] = Math.atan(epnt.y() / epnt.x());
                        if (epnt.x() < 0.0) {
                            double[] dArray = paraB[j];
                            dArray[0] = dArray[0] + Math.PI;
                        }
                        if (paraB[j][0] < 0.0) {
                            double[] dArray = paraB[j];
                            dArray[0] = dArray[0] + Math.PI * 2;
                        }
                    }
                    paraB[j][1] = epnt.z();
                    ++j;
                }
                ++i;
            }
            if (j == 2 && (dist = int_pnt[0].distance(int_pnt[1])) < dTol) {
                j = 1;
                int_pnt[0] = int_pnt[0].midPoint(int_pnt[1]);
                paraA[0] = (paraA[0] + paraA[1]) / 2.0;
                if (Math.abs(paraB[0][0] - paraB[0][1]) < Math.PI) {
                    paraB[0][0] = (paraB[0][0] + paraB[1][0]) / 2.0;
                }
                paraB[0][1] = (paraB[0][1] + paraB[1][1]) / 2.0;
            }
            number_of_intpnt = j;
        }
        JgclIntersectionPoint3D[] return_pnt = new JgclIntersectionPoint3D[number_of_intpnt];
        boolean i = false;
        while (var24_17 < number_of_intpnt) {
            JgclPointOnCurve3D PonC = new JgclPointOnCurve3D(int_pnt[var24_17], mate, paraA[var24_17], false);
            JgclPointOnSurface3D PonS = new JgclPointOnSurface3D(int_pnt[var24_17], this, paraB[var24_17][0], paraB[var24_17][1], false);
            return_pnt[var24_17] = doExchange ? new JgclIntersectionPoint3D(int_pnt[var24_17], PonC, PonS, false) : new JgclIntersectionPoint3D(int_pnt[var24_17], PonS, PonC, false);
            ++var24_17;
        }
        return return_pnt;
    }

    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate, boolean doExchange) {
        JgclIntsPlnCon3D doObj = new JgclIntsPlnCon3D(mate, this);
        return doObj.getInterference(!doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate, boolean doExchange) {
        JgclIntsSphCon3D doObj = new JgclIntsSphCon3D(mate, this);
        return doObj.getInterference(!doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate, boolean doExchange) {
        return JgclIntsCylCon3D.intersection(mate, this, !doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclIntsConCon3D doObj = new JgclIntsConCon3D(this, mate);
        return doObj.getInterference(doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        return JgclIntsQrdBzs3D.intersection(this, mate, doExchange);
    }

    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        return JgclIntsSrfBss3D.intersection(this, mate, doExchange);
    }

    public JgclBsplineSurface3D offsetByBsplineSurface(JgclParameterSection uPint, JgclParameterSection vPint, double magni, int side, JgclToleranceForDistance tol) {
        JgclOfst3D doObj = new JgclOfst3D(this, uPint, vPint, magni, side, tol);
        return doObj.offset();
    }

    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
        JgclCartesianTransformationOperator3D trns = this.position().toCartesianTransformationOperator();
        double tan_sa = Math.tan(this.semiAngle());
        double cos_u = Math.cos(uParam);
        double sin_u = Math.sin(uParam);
        JgclPoint3D pnt = new JgclCartesianPoint3D(cos_u * this.radius(), sin_u * this.radius(), 0.0);
        pnt = trns.toEnclosed(pnt);
        JgclVector3D dir = new JgclLiteralVector3D(tan_sa * cos_u, tan_sa * sin_u, 1.0);
        dir = trns.toEnclosed(dir);
        return new JgclLine3D(pnt, dir);
    }

    public JgclParametricCurve3D vIsoParametricCurve(double vParam) throws JgclReducedToPoint {
        JgclCartesianTransformationOperator3D trns = this.position().toCartesianTransformationOperator();
        double tan_sa = Math.tan(this.semiAngle());
        JgclPoint3D cntr = new JgclCartesianPoint3D(0.0, 0.0, vParam);
        cntr = trns.toEnclosed(cntr);
        double cRadius = this.radius() + vParam * tan_sa;
        if (cRadius <= this.getToleranceForDistance()) {
            throw new JgclReducedToPoint(cntr);
        }
        JgclVector3D xVec = this.position().x();
        if (this.radius < 0.0) {
            xVec = xVec.reverse();
            this.radius = -this.radius;
        }
        JgclAxis2Placement3D a2p = new JgclAxis2Placement3D(cntr, this.position().z(), xVec);
        return new JgclCircle3D(a2p, cRadius);
    }

    JgclParameterDomain getUParameterDomain() {
        try {
            return new JgclParameterDomain(true, 0.0, Math.PI * 2);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    JgclParameterDomain getVParameterDomain() {
        return new JgclParameterDomain();
    }

    int type() {
        return 11;
    }

    private double apexVParameter() {
        return -this.radius() / Math.tan(this.semiAngle());
    }

    JgclPoint3D apex() {
        return this.coordinates(0.0, this.apexVParameter());
    }

    JgclLine3D getAxis() {
        return new JgclLine3D(this.position().location(), this.position().z());
    }

    JgclConicalSurface3D getReverse() {
        JgclVector3D originToVertex = this.apex().subtract(this.position().location());
        JgclPointOnCurve3D reverseLocation = this.getAxis().project1From(this.apex().add(originToVertex));
        JgclAxis2Placement3D reverse_position = new JgclAxis2Placement3D(reverseLocation, this.position().z().reverse(), this.position().x().reverse());
        JgclConicalSurface3D result = new JgclConicalSurface3D(reverse_position, this.radius, this.semiAngle);
        return result;
    }

    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection, JgclParameterSection vParameterSection, double tolerance, double[] scalingFactor) {
        Vector<JgclPoint3D> result = new Vector<JgclPoint3D>();
        JgclMesh3D mesh = this.makeMesh(2, uParameterSection, vParameterSection, new JgclToleranceForDistance(tolerance));
        int u = 0;
        while (u < mesh.uNPoints()) {
            int v = 0;
            while (v < mesh.vNPoints()) {
                result.addElement(mesh.pointAt(u, v));
                ++v;
            }
            ++u;
        }
        scalingFactor[0] = this.getMaxRadius(vParameterSection);
        scalingFactor[1] = Math.sqrt(1.0 + this.semiAngle * this.semiAngle);
        return result;
    }

    protected synchronized JgclParametricSurface3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclAxis2Placement3D tPosition = this.position().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        double tRadius = !reverseTransform ? transformationOperator.transform(this.radius()) : transformationOperator.reverseTransform(this.radius());
        return new JgclConicalSurface3D(tPosition, tRadius, this.semiAngle);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tposition");
        this.position().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tradius\t" + this.radius);
        writer.println(String.valueOf(indent_tab) + "\tsemiAngle\t" + this.semiAngle);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

