/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Vector;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBinaryTree;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineKnot;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclComplex;
import jp.go.ipa.jgcl.JgclComplexPolynomial;
import jp.go.ipa.jgcl.JgclConic2D;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionCurve3D;
import jp.go.ipa.jgcl.JgclIntersectionPoint2D;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsCncBzs3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine2D;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve2D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclSurfaceSurfaceInterference3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclVector2D;
import jp.go.ipa.jgcl.JgclVector3D;
import jp.go.ipa.jgcl.JgclZeroLength;

public abstract class JgclConic3D
extends JgclParametricCurve3D {
    private JgclAxis2Placement3D position;

    private JgclConic3D() {
        this.position = null;
    }

    protected JgclConic3D(JgclAxis2Placement3D position) {
        if (position == null) {
            throw new JgclInvalidArgumentValue("position is null.");
        }
        this.position = position;
    }

    protected JgclCartesianTransformationOperator3D toGlobal() {
        return new JgclCartesianTransformationOperator3D(this.position(), 1.0);
    }

    abstract JgclConic2D toLocal2D(JgclAxis2Placement2D var1);

    JgclConic2D toLocal2D() {
        return this.toLocal2D(JgclAxis2Placement2D.origin);
    }

    JgclConic2D toLocal2D(JgclCartesianTransformationOperator3D transform) {
        JgclPoint2D location = transform.toLocal(this.position().location()).to2D();
        JgclVector2D x_axis = transform.toLocal(this.position().x()).to2D();
        JgclAxis2Placement2D position = new JgclAxis2Placement2D(location, x_axis);
        return this.toLocal2D(position);
    }

    public double length(JgclParameterSection pint) {
        JgclConic2D conic2D = this.toLocal2D();
        return conic2D.length(pint);
    }

    public JgclPolyline3D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        double ep;
        double sp;
        if (pint.increase() < 0.0) {
            return this.toPolyline(pint.reverse(), tol).reverse();
        }
        JgclParameterDomain domain = this.parameterDomain();
        if (domain.isPeriodic()) {
            sp = domain.wrap(pint.start());
            if (sp > (ep = domain.wrap(pint.end()))) {
                ep += domain.section().increase();
            }
        } else {
            sp = pint.lower();
            this.checkValidity(sp);
            ep = pint.upper();
            this.checkValidity(ep);
        }
        double tolerance = Math.abs(tol.value());
        IntervalInfo root_info = new IntervalInfo();
        try {
            root_info.left = new JgclPointOnCurve3D(this, sp, false);
            root_info.right = new JgclPointOnCurve3D(this, ep, false);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        JgclBinaryTree pnt_tree = new JgclBinaryTree(root_info);
        int no_pnts = 2;
        JgclPoint3D[] pnts = new JgclPoint3D[no_pnts += this.divideInterval(pnt_tree.rootNode(), tolerance * tolerance)];
        FillInfo fill_info = new FillInfo(pnts, 0);
        pnt_tree.rootNode().preOrderTraverse(new FillArray(), fill_info);
        if (no_pnts == 2 && pnts[0].identical(pnts[1])) {
            throw new JgclZeroLength();
        }
        return new JgclPolyline3D(pnts);
    }

    private int divideInterval(JgclBinaryTree.Node crnt_node, double tol_2) {
        int no_pnts = 1;
        IntervalInfo crnt_info = (IntervalInfo)crnt_node.data();
        double mid_param = (crnt_info.left.parameter() + crnt_info.right.parameter()) / 2.0;
        IntervalInfo left_info = new IntervalInfo();
        left_info.left = crnt_info.left;
        try {
            left_info.right = new JgclPointOnCurve3D(this, mid_param, false);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        JgclBinaryTree.Node left_node = crnt_node.makeLeft(left_info);
        IntervalInfo right_info = new IntervalInfo();
        right_info.left = left_info.right;
        right_info.right = crnt_info.right;
        JgclBinaryTree.Node right_node = crnt_node.makeRight(right_info);
        if (!this.checkInterval(left_info, tol_2)) {
            no_pnts += this.divideInterval(left_node, tol_2);
        }
        if (!this.checkInterval(right_info, tol_2)) {
            no_pnts += this.divideInterval(right_node, tol_2);
        }
        return no_pnts;
    }

    abstract double getPeak(double var1, double var3);

    private boolean checkInterval(IntervalInfo info, double tol_2) {
        double peak_param = this.getPeak(info.left.parameter(), info.right.parameter());
        JgclPoint3D peak = this.coordinates(peak_param);
        JgclVector3D unitChord = info.right.subtract(info.left).unitized();
        JgclVector3D left2peak = peak.subtract(info.left);
        double norm = left2peak.crossProduct(unitChord).norm();
        return norm < tol_2;
    }

    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point) throws JgclIndefiniteSolution {
        JgclCartesianTransformationOperator3D trans = this.toGlobal();
        JgclPoint3D localp = trans.reverseTransform(point);
        JgclPoint2D p2 = localp.to2D();
        JgclConic2D conic2d = this.toLocal2D();
        JgclPointOnCurve2D[] proj2 = conic2d.projectFrom(p2);
        JgclPointOnCurve3D[] proj3 = new JgclPointOnCurve3D[proj2.length];
        int i = 0;
        while (i < proj2.length) {
            proj3[i] = new JgclPointOnCurve3D(this, proj2[i].parameter(), false);
            ++i;
        }
        return proj3;
    }

    public JgclAxis2Placement3D position() {
        return this.position;
    }

    public double torsion(double param) {
        return 0.0;
    }

    public JgclPointOnCurve3D[] singular() {
        return new JgclPointOnCurve3D[0];
    }

    public JgclPointOnCurve3D[] inflexion() {
        return new JgclPointOnCurve3D[0];
    }

    abstract JgclRealPolynomial makePoly(JgclRealPolynomial[] var1);

    abstract boolean checkSolution(JgclPoint3D var1);

    abstract double getParameter(JgclPoint3D var1);

    private JgclIntersectionPoint3D[] toIntersectionPoint3D(JgclIntersectionPoint2D[] ints2, JgclParametricCurve3D curve1, JgclParametricCurve3D curve2, boolean doExchange) {
        JgclIntersectionPoint3D[] ints3 = new JgclIntersectionPoint3D[ints2.length];
        int i = 0;
        while (i < ints2.length) {
            ints3[i] = !doExchange ? new JgclIntersectionPoint3D(curve1, ints2[i].pointOnCurve1().parameter(), curve2, ints2[i].pointOnCurve2().parameter(), false) : new JgclIntersectionPoint3D(curve2, ints2[i].pointOnCurve2().parameter(), curve1, ints2[i].pointOnCurve1().parameter(), false);
            ++i;
        }
        return ints3;
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
        JgclIntersectionPoint3D ints;
        JgclPlane3D plane = new JgclPlane3D(this.position());
        try {
            ints = plane.intersect1(mate);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            JgclIntersectionPoint2D[] ints2d;
            JgclCartesianTransformationOperator3D trans = new JgclCartesianTransformationOperator3D(this.position(), 1.0);
            JgclLine2D lline = mate.toLocal2D(trans);
            try {
                ints2d = this.toLocal2D().intersect(lline);
            }
            catch (JgclIndefiniteSolution jgclIndefiniteSolution2) {
                throw new JgclFatal();
            }
            return this.toIntersectionPoint3D(ints2d, this, mate, doExchange);
        }
        if (ints != null) {
            double cparam;
            try {
                cparam = this.pointToParameter(ints);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                return new JgclIntersectionPoint3D[0];
            }
            JgclPointOnCurve3D pnt2 = (JgclPointOnCurve3D)ints.pointOnGeometry2();
            JgclIntersectionPoint3D[] intvec = new JgclIntersectionPoint3D[]{new JgclIntersectionPoint3D(this, cparam, mate, pnt2.parameter(), false)};
            if (!doExchange) {
                intvec[0] = intvec[0].exchange();
            }
            return intvec;
        }
        return new JgclIntersectionPoint3D[0];
    }

    JgclIntersectionPoint3D[] intersectCnc(JgclConic3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclLine3D line;
        JgclPlane3D plane1 = new JgclPlane3D(this.position());
        JgclPlane3D plane2 = new JgclPlane3D(mate.position());
        JgclCartesianTransformationOperator3D trans1 = new JgclCartesianTransformationOperator3D(this.position(), 1.0);
        JgclConic2D con1 = this.toLocal2D();
        JgclConic2D con2 = mate.toLocal2D(trans1);
        try {
            line = plane1.intersect1Plane(plane2);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            JgclIntersectionPoint2D[] lpnts = con1.intersect(con2);
            return this.toIntersectionPoint3D(lpnts, this, mate, doExchange);
        }
        if (line == null) {
            return new JgclIntersectionPoint3D[0];
        }
        JgclLine2D lline = line.toLocal2D(trans1);
        JgclIntersectionPoint2D[] lpnts = con1.intersect(lline);
        Vector<JgclIntersectionPoint3D> intsvec = new Vector<JgclIntersectionPoint3D>();
        int i = 0;
        while (i < lpnts.length) {
            block6: {
                double c2param;
                JgclIntersectionPoint2D int2d = lpnts[i];
                try {
                    c2param = con2.pointToParameter(int2d);
                }
                catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                    break block6;
                }
                double c1param = int2d.pointOnCurve1().parameter();
                JgclIntersectionPoint3D int3d = new JgclIntersectionPoint3D(this, c1param, mate, c2param, false);
                intsvec.addElement(int3d);
            }
            ++i;
        }
        Object[] ints = new JgclIntersectionPoint3D[intsvec.size()];
        intsvec.copyInto(ints);
        return ints;
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
        JgclComplex[] roots;
        JgclAxis2Placement3D placement = this.position();
        JgclCartesianTransformationOperator3D transform = new JgclCartesianTransformationOperator3D(placement, 1.0);
        int uicp = mate.nControlPoints();
        JgclPoint3D[] newCp = new JgclPoint3D[uicp];
        int i = 0;
        while (i < uicp) {
            newCp[i] = transform.toLocal(mate.controlPointAt(i));
            ++i;
        }
        JgclPureBezierCurve3D bzc = new JgclPureBezierCurve3D(newCp, mate.weights(), false);
        Vector<JgclPoint3D> pointVec = new Vector<JgclPoint3D>();
        Vector<Double> paramVec = new Vector<Double>();
        boolean isPoly = bzc.isPolynomial();
        JgclRealPolynomial[] poly = bzc.polynomial(isPoly);
        JgclRealPolynomial realPoly = this.makePoly(poly);
        JgclComplexPolynomial compPoly = realPoly.toComplexPolynomial();
        try {
            roots = compPoly.getRootsByDKA();
        }
        catch (JgclComplexPolynomial.DKANotConverge e) {
            roots = e.getValues();
        }
        catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
            throw new JgclFatal();
        }
        catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
            throw new JgclFatal();
        }
        int nRoots = roots.length;
        int j = 0;
        while (j < nRoots) {
            double realRoot = roots[j].real();
            if (bzc.parameterValidity(realRoot) != 3) {
                JgclPoint3D workPoint;
                if (realRoot < 0.0) {
                    realRoot = 0.0;
                }
                if (realRoot > 1.0) {
                    realRoot = 1.0;
                }
                if (this.checkSolution(workPoint = bzc.coordinates(realRoot))) {
                    int jj = 0;
                    while (jj < pointVec.size()) {
                        JgclPoint3D pt = (JgclPoint3D)pointVec.elementAt(jj);
                        double param = (Double)paramVec.elementAt(jj);
                        if (pt.identical(workPoint) && bzc.identicalParameter(param, realRoot)) break;
                        ++jj;
                    }
                    pointVec.addElement(workPoint);
                    paramVec.addElement(new Double(realRoot));
                }
            }
            ++j;
        }
        int num = paramVec.size();
        JgclIntersectionPoint3D[] intersectPoint = new JgclIntersectionPoint3D[num];
        int i2 = 0;
        while (i2 < num) {
            JgclPoint3D point = (JgclPoint3D)pointVec.elementAt(i2);
            double param = this.getParameter(point);
            JgclPointOnCurve3D pointOnConic = new JgclPointOnCurve3D(this, param, false);
            double work = (Double)paramVec.elementAt(i2);
            JgclPointOnCurve3D pointOnBzc = new JgclPointOnCurve3D(mate, work, false);
            intersectPoint[i2] = !doExchange ? new JgclIntersectionPoint3D(pointOnConic, pointOnBzc, false) : new JgclIntersectionPoint3D(pointOnBzc, pointOnConic, false);
            ++i2;
        }
        return intersectPoint;
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
        JgclAxis2Placement3D placement = this.position();
        JgclCartesianTransformationOperator3D transform = new JgclCartesianTransformationOperator3D(placement, 1.0);
        JgclBsplineKnot.ValidSegmentInfo vsegInfo = mate.validSegments();
        JgclPoint3D[] cp = mate.controlPoints();
        int uicp = mate.nControlPoints();
        JgclPoint3D[] newCp = new JgclPoint3D[uicp];
        int i = 0;
        while (i < uicp) {
            newCp[i] = transform.toLocal(cp[i]);
            ++i;
        }
        JgclBsplineCurve3D bsc = new JgclBsplineCurve3D(mate.knotData(), newCp, mate.weights());
        Vector<JgclPoint3D> pointVec = new Vector<JgclPoint3D>();
        Vector<Double> paramVec = new Vector<Double>();
        int nSeg = vsegInfo.nSegments();
        int k = 0;
        int i2 = 0;
        while (i2 < nSeg) {
            JgclComplex[] roots;
            JgclRealPolynomial[] poly = bsc.polynomial(vsegInfo.segmentNumber(i2), bsc.isPolynomial());
            JgclRealPolynomial realPoly = this.makePoly(poly);
            JgclComplexPolynomial compPoly = realPoly.toComplexPolynomial();
            try {
                roots = compPoly.getRootsByDKA();
            }
            catch (JgclComplexPolynomial.DKANotConverge e) {
                roots = e.getValues();
            }
            catch (JgclComplexPolynomial.ImpossibleEquation impossibleEquation) {
                throw new JgclFatal();
            }
            catch (JgclComplexPolynomial.IndefiniteEquation indefiniteEquation) {
                throw new JgclFatal();
            }
            int nRoots = roots.length;
            int j = 0;
            while (j < nRoots) {
                double realRoot = roots[j].real();
                if (bsc.parameterValidity(realRoot) != 3) {
                    JgclPoint3D workPoint;
                    double[] knotParams = vsegInfo.knotPoint(i2);
                    if (realRoot < knotParams[0]) {
                        realRoot = knotParams[0];
                    }
                    if (realRoot > knotParams[1]) {
                        realRoot = knotParams[1];
                    }
                    if (this.checkSolution(workPoint = bsc.coordinates(realRoot))) {
                        int jj = 0;
                        while (jj < k) {
                            double dTol = bsc.getToleranceForDistance();
                            JgclPoint3D pt = (JgclPoint3D)pointVec.elementAt(jj);
                            double param = (Double)paramVec.elementAt(jj);
                            if (pt.identical(workPoint) && bsc.identicalParameter(param, realRoot)) break;
                            ++jj;
                        }
                        if (jj >= k) {
                            pointVec.addElement(workPoint);
                            paramVec.addElement(new Double(realRoot));
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i2;
        }
        int num = paramVec.size();
        JgclIntersectionPoint3D[] intersectPoint = new JgclIntersectionPoint3D[num];
        int i3 = 0;
        while (i3 < k) {
            JgclPoint3D point = (JgclPoint3D)pointVec.elementAt(i3);
            double param = this.getParameter(point);
            JgclPointOnCurve3D pointOnConic = new JgclPointOnCurve3D(this, param, false);
            double work = (Double)paramVec.elementAt(i3);
            JgclPointOnCurve3D pointOnBsc = new JgclPointOnCurve3D(mate, work, false);
            intersectPoint[i3] = !doExchange ? new JgclIntersectionPoint3D(pointOnConic, pointOnBsc, false) : new JgclIntersectionPoint3D(pointOnBsc, pointOnConic, false);
            ++i3;
        }
        return intersectPoint;
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclIntersectionPoint3D[] intersect(JgclPlane3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersectQrd(JgclElementarySurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        JgclPlane3D pln = new JgclPlane3D(this.position());
        JgclSurfaceSurfaceInterference3D[] dCint = pln.intersect(mate);
        if (dCint.length < 1) {
            return new JgclIntersectionPoint3D[0];
        }
        Vector<JgclIntersectionPoint3D> ints_list = new Vector<JgclIntersectionPoint3D>();
        boolean indefinite = false;
        int i = 0;
        while (i < dCint.length) {
            block10: {
                JgclIntersectionPoint3D one_int;
                if (dCint[i].isIntersectionCurve()) {
                    JgclIntersectionPoint3D[] dEpnt;
                    JgclIntersectionCurve3D dCintCurve = dCint[i].toIntersectionCurve();
                    try {
                        dEpnt = this.intersect(dCintCurve.curve3d());
                    }
                    catch (JgclIndefiniteSolution e) {
                        dEpnt = new JgclIntersectionPoint3D[]{(JgclIntersectionPoint3D)e.suitable()};
                        indefinite = true;
                    }
                    int j = 0;
                    while (j < dEpnt.length) {
                        double[] params = mate.pointToParameter(dEpnt[j]);
                        one_int = !doExchange ? new JgclIntersectionPoint3D(dEpnt[j].coordinates(), this, dEpnt[j].pointOnCurve1().parameter(), (JgclParametricSurface3D)mate, params[0], params[1], false) : new JgclIntersectionPoint3D(dEpnt[j].coordinates(), mate, params[0], params[1], this, dEpnt[j].pointOnCurve1().parameter(), false);
                        ints_list.addElement(one_int);
                        ++j;
                    }
                } else {
                    double param;
                    JgclIntersectionPoint3D dCintPnt = dCint[i].toIntersectionPoint();
                    try {
                        param = this.pointToParameter(dCintPnt);
                    }
                    catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                        break block10;
                    }
                    one_int = !doExchange ? new JgclIntersectionPoint3D(this, param, mate, dCintPnt.pointOnSurface2().uParameter(), dCintPnt.pointOnSurface2().vParameter(), false) : new JgclIntersectionPoint3D(mate, dCintPnt.pointOnSurface2().uParameter(), dCintPnt.pointOnSurface2().vParameter(), (JgclParametricCurve3D)this, param, false);
                    ints_list.addElement(one_int);
                }
            }
            ++i;
        }
        if (indefinite && ints_list.size() == 1) {
            throw new JgclIndefiniteSolution((JgclIntersectionPoint3D)ints_list.elementAt(0));
        }
        Object[] ints = new JgclIntersectionPoint3D[ints_list.size()];
        ints_list.copyInto(ints);
        return ints;
    }

    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.intersectQrd(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return mate.intersect(this, !doExchange);
    }

    JgclPureBezierCurve3D[] transformPolyBezierCurvesInLocal2DToGrobal3D(JgclPureBezierCurve2D[] bezierCurves2D) {
        int nCurves = bezierCurves2D.length;
        JgclCartesianTransformationOperator3D localTransformationOperator = this.position().toCartesianTransformationOperator(1.0);
        JgclPureBezierCurve3D[] bzcs = new JgclPureBezierCurve3D[nCurves];
        int i = 0;
        while (i < nCurves) {
            JgclPoint3D[] controlPoints = new JgclPoint3D[3];
            double[] weights = new double[3];
            int j = 0;
            while (j < 3) {
                JgclPoint3D pnt = bezierCurves2D[i].controlPointAt(j).to3D();
                controlPoints[j] = localTransformationOperator.toEnclosed(pnt);
                weights[j] = bezierCurves2D[i].weightAt(j);
                ++j;
            }
            bzcs[i] = new JgclPureBezierCurve3D(controlPoints, weights);
            ++i;
        }
        return bzcs;
    }

    protected static JgclBsplineCurve3D convertPolyBezierCurvesToOneBsplineCurve(JgclPureBezierCurve3D[] bezierCurves, boolean closed) {
        int uik;
        int uicp;
        int nBeziers = bezierCurves.length;
        if (!closed) {
            uicp = nBeziers != 3 ? nBeziers + 2 : nBeziers + 3;
            uik = nBeziers + 1;
        } else {
            uicp = 5;
            uik = 6;
        }
        int degree = 2;
        boolean periodic = closed;
        int[] knotMultiplicities = new int[uik];
        double[] knots = new double[uik];
        JgclPoint3D[] controlPoints = new JgclPoint3D[uicp];
        double[] weights = new double[uicp];
        switch (nBeziers) {
            case 1: {
                int i = 0;
                while (i < 3) {
                    controlPoints[i] = bezierCurves[0].controlPointAt(i);
                    weights[i] = bezierCurves[0].weightAt(i);
                    ++i;
                }
                knots[0] = 0.0;
                knotMultiplicities[0] = 3;
                knots[1] = 1.0;
                knotMultiplicities[1] = 3;
                break;
            }
            case 2: {
                controlPoints[0] = bezierCurves[0].controlPointAt(0);
                controlPoints[1] = bezierCurves[0].controlPointAt(1);
                controlPoints[2] = bezierCurves[1].controlPointAt(1);
                controlPoints[3] = bezierCurves[1].controlPointAt(2);
                weights[0] = 1.0;
                weights[1] = weights[2] = bezierCurves[0].weightAt(1) * bezierCurves[0].weightAt(1);
                weights[3] = 1.0;
                knots[0] = 0.0;
                knotMultiplicities[0] = 3;
                knots[1] = 1.0;
                knotMultiplicities[1] = 1;
                knots[2] = 2.0;
                knotMultiplicities[2] = 3;
                break;
            }
            case 3: {
                if (!closed) {
                    controlPoints[0] = bezierCurves[0].controlPointAt(0);
                    controlPoints[1] = bezierCurves[0].controlPointAt(1);
                    controlPoints[2] = bezierCurves[1].controlPointAt(1);
                    controlPoints[3] = bezierCurves[1].controlPointAt(2);
                    controlPoints[4] = bezierCurves[2].controlPointAt(1);
                    controlPoints[5] = bezierCurves[2].controlPointAt(2);
                    weights[0] = 1.0;
                    weights[1] = weights[2] = bezierCurves[0].weightAt(1) * bezierCurves[0].weightAt(1);
                    weights[3] = 1.0;
                    weights[4] = bezierCurves[2].weightAt(1);
                    weights[5] = 1.0;
                    knots[0] = 0.0;
                    knotMultiplicities[0] = 3;
                    knots[1] = 1.0;
                    knotMultiplicities[1] = 1;
                    knots[2] = 2.0;
                    knotMultiplicities[2] = 2;
                    knots[3] = 4.0;
                    knotMultiplicities[3] = 3;
                    break;
                }
                controlPoints[0] = bezierCurves[2].controlPointAt(1);
                controlPoints[1] = bezierCurves[0].controlPointAt(0);
                controlPoints[2] = bezierCurves[0].controlPointAt(1);
                controlPoints[3] = bezierCurves[1].controlPointAt(1);
                controlPoints[4] = bezierCurves[1].controlPointAt(2);
                weights[0] = bezierCurves[2].weightAt(1);
                weights[1] = 1.0;
                weights[2] = weights[3] = bezierCurves[0].weightAt(1) * bezierCurves[0].weightAt(1);
                weights[4] = 1.0;
                knots[0] = -2.0;
                knotMultiplicities[0] = 2;
                knots[1] = 0.0;
                knotMultiplicities[1] = 2;
                knots[2] = 1.0;
                knotMultiplicities[2] = 1;
                knots[3] = 2.0;
                knotMultiplicities[3] = 2;
                knots[4] = 4.0;
                knotMultiplicities[4] = 2;
                knots[5] = 5.0;
                knotMultiplicities[5] = 1;
                break;
            }
        }
        return new JgclBsplineCurve3D(degree, periodic, knotMultiplicities, knots, controlPoints, weights);
    }

    abstract boolean checkInterfere(JgclIntsCncBzs3D.BezierSurfaceInfo var1);

    abstract JgclIntersectionPoint3D[] intersectConicPlane(JgclPlane3D var1);

    abstract JgclPoint3D nlFunc(double var1);

    abstract JgclVector3D dnlFunc(double var1);

    private class IntervalInfo {
        JgclPointOnCurve3D left;
        JgclPointOnCurve3D right;

        IntervalInfo() {
            JgclConic3D.this = JgclConic3D.this;
        }
    }

    private class FillArray
    implements JgclBinaryTree.TraverseProc {
        public boolean doit(JgclBinaryTree.Node node, int ctl, Object pdata) {
            if (node.left() == null && node.right() == null) {
                FillInfo fill_info = (FillInfo)pdata;
                int idx = fill_info.index;
                IntervalInfo info = (IntervalInfo)node.data();
                if (idx == 0) {
                    ((FillInfo)fill_info).pnts[idx++] = info.left;
                }
                ((FillInfo)fill_info).pnts[idx++] = info.right;
                fill_info.index = idx;
            }
            return false;
        }

        FillArray() {
            JgclConic3D.this = JgclConic3D.this;
        }
    }

    private class FillInfo {
        private JgclPoint3D[] pnts;
        private int index;

        private FillInfo(JgclPoint3D[] pnts, int index) {
            JgclConic3D.this = JgclConic3D.this;
            this.pnts = pnts;
            this.index = index;
        }
    }
}

