/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclBoundedCurve3D;
import jp.go.ipa.jgcl.JgclBoundedLine3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclBsplineSurface3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterference3D;
import jp.go.ipa.jgcl.JgclCurveCurveInterferenceList;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclCurveSurfaceInterferenceList;
import jp.go.ipa.jgcl.JgclElementarySurface3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclOverlapCurve3D;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterOutOfRange;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclParametricSurface3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPointOnGeometryList;
import jp.go.ipa.jgcl.JgclPointOnSurface3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclPureBezierSurface3D;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclTwoGeomertiesAreNotContinuous;
import jp.go.ipa.jgcl.JgclUtil;
import jp.go.ipa.jgcl.JgclVector3D;
import jp.go.ipa.jgcl.JgclZeroLength;

public class JgclCompositeCurve3D
extends JgclBoundedCurve3D {
    private JgclCompositeCurveSegment3D[] segments;
    private boolean periodic;
    private double[] localStartParams;
    private double[] globalStartParams;

    public JgclCompositeCurve3D(JgclCompositeCurveSegment3D[] segments, boolean periodic) {
        this.segments = new JgclCompositeCurveSegment3D[segments.length];
        this.periodic = periodic;
        this.localStartParams = new double[segments.length];
        this.globalStartParams = new double[segments.length + 1];
        this.globalStartParams[0] = 0.0;
        int i = 0;
        while (i < segments.length) {
            JgclCompositeCurveSegment3D seg = segments[i];
            JgclParameterSection sec = seg.parameterDomain().section();
            this.segments[i] = seg;
            this.localStartParams[i] = sec.start();
            this.globalStartParams[i + 1] = this.globalStartParams[i] + sec.increase();
            ++i;
        }
    }

    public JgclCompositeCurve3D(JgclBoundedCurve3D[] segments, boolean[] sense) {
        if (segments.length != sense.length) {
            throw new JgclInvalidArgumentValue();
        }
        double dTol = JgclConditionOfOperation.getCondition().getToleranceForDistance();
        this.segments = new JgclCompositeCurveSegment3D[segments.length];
        this.localStartParams = new double[segments.length];
        this.globalStartParams = new double[segments.length + 1];
        this.globalStartParams[0] = 0.0;
        int transition = 4;
        int i = 0;
        while (i < segments.length) {
            int j = i + 1 == segments.length ? 0 : i + 1;
            JgclBoundedCurve3D pseg = segments[i];
            JgclBoundedCurve3D nseg = segments[j];
            JgclParameterSection psec = pseg.parameterDomain().section();
            JgclParameterSection nsec = nseg.parameterDomain().section();
            double pp = sense[i] ? psec.end() : psec.start();
            double np = sense[j] ? nsec.start() : nsec.end();
            JgclCurveDerivative3D pder = pseg.evaluation(pp);
            JgclCurveDerivative3D nder = nseg.evaluation(np);
            double pcur = pseg.curvature(pp).curvature();
            double ncur = nseg.curvature(np).curvature();
            transition = !pder.d0D().identical(nder.d0D()) ? 0 : (!pder.d1D().identicalDirection(nder.d1D()) ? 1 : (Math.abs(pcur - ncur) >= dTol ? 1 : 1));
            if (j != 0 && transition == 0) {
                throw new JgclInvalidArgumentValue();
            }
            this.segments[i] = new JgclCompositeCurveSegment3D(transition, sense[i], pseg);
            this.localStartParams[i] = psec.start();
            this.globalStartParams[i + 1] = this.globalStartParams[i] + psec.increase();
            ++i;
        }
        this.periodic = transition != 0;
    }

    JgclCompositeCurveSegment3D[] segments() {
        return (JgclCompositeCurveSegment3D[])this.segments.clone();
    }

    JgclCompositeCurveSegment3D[] decomposeAsSegmentsRecursively() {
        Vector<JgclCompositeCurveSegment3D> resultList = new Vector<JgclCompositeCurveSegment3D>();
        int i = 0;
        while (i < this.nSegments()) {
            JgclCompositeCurveSegment3D segment = this.segmentAt(i);
            JgclBoundedCurve3D parent = segment.parentCurve();
            if (parent.type() == 24) {
                JgclCompositeCurveSegment3D revised;
                int j;
                JgclCompositeCurve3D parentCmc = (JgclCompositeCurve3D)parent;
                JgclCompositeCurveSegment3D[] parentSegments = parentCmc.decomposeAsSegmentsRecursively();
                if (segment.sameSense()) {
                    j = 0;
                    while (j < parentSegments.length - 1) {
                        resultList.addElement(parentSegments[j]);
                        ++j;
                    }
                    revised = parentSegments[j].makeCopyWithTransition(segment.transition());
                    resultList.addElement(revised);
                } else {
                    j = parentSegments.length - 1;
                    while (j > 0) {
                        revised = parentSegments[j].makeReverseWithTransition(parentSegments[j - 1].transition());
                        resultList.addElement(revised);
                        --j;
                    }
                    revised = parentSegments[j].makeReverseWithTransition(segment.transition());
                    resultList.addElement(revised);
                }
            } else {
                resultList.addElement(segment);
            }
            ++i;
        }
        Object[] result = new JgclCompositeCurveSegment3D[resultList.size()];
        resultList.copyInto(result);
        return result;
    }

    public boolean periodic() {
        return this.periodic;
    }

    public int nSegments() {
        return this.segments.length;
    }

    public JgclCompositeCurveSegment3D segmentAt(int ith) {
        return this.segments[ith];
    }

    private CompositeIndexParam getIndexParam(double param) {
        JgclParameterDomain domain = this.parameterDomain();
        CompositeIndexParam ip = new CompositeIndexParam();
        this.checkValidity(param);
        param = domain.wrap(param);
        ip.index = JgclUtil.bsearchDoubleArray(this.globalStartParams, 1, this.nSegments() - 1, param);
        ip.param = this.localStartParams[ip.index] + (param - this.globalStartParams[ip.index]);
        return ip;
    }

    private double getCompositeParam(int index, double param) {
        return this.globalStartParams[index] + (param - this.localStartParams[index]);
    }

    public JgclPoint3D startPoint() {
        if (this.isPeriodic()) {
            return null;
        }
        return this.segments[0].startPoint();
    }

    public JgclPoint3D endPoint() {
        if (this.isPeriodic()) {
            return null;
        }
        int n = this.nSegments();
        return this.segments[n - 1].endPoint();
    }

    public double length(JgclParameterSection pint) {
        LengthAccumulator acc = new LengthAccumulator();
        acc.accumulate(pint);
        return acc.extract();
    }

    public JgclPoint3D coordinates(double param) {
        CompositeIndexParam ip = this.getIndexParam(param);
        return this.segments[ip.index].coordinates(ip.param);
    }

    public JgclVector3D tangentVector(double param) {
        CompositeIndexParam ip = this.getIndexParam(param);
        return this.segments[ip.index].tangentVector(ip.param);
    }

    public JgclCurveCurvature3D curvature(double param) {
        CompositeIndexParam ip = this.getIndexParam(param);
        return this.segments[ip.index].curvature(ip.param);
    }

    public double torsion(double param) {
        CompositeIndexParam ip = this.getIndexParam(param);
        return this.segments[ip.index].torsion(ip.param);
    }

    public JgclCurveDerivative3D evaluation(double param) {
        CompositeIndexParam ip = this.getIndexParam(param);
        return this.segments[ip.index].evaluation(ip.param);
    }

    public JgclPointOnCurve3D[] singular() throws JgclIndefiniteSolution {
        SingularAccumulator acc = new SingularAccumulator(this);
        try {
            acc.accumulate(this.parameterDomain().section());
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        return acc.extract();
    }

    public JgclPointOnCurve3D[] inflexion() throws JgclIndefiniteSolution {
        InflexionAccumulator acc = new InflexionAccumulator(this);
        try {
            acc.accumulate(this.parameterDomain().section());
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        return acc.extract();
    }

    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point) throws JgclIndefiniteSolution {
        ProjectionAccumulator acc = new ProjectionAccumulator(point, this);
        try {
            acc.accumulate(this.parameterDomain().section());
        }
        catch (JgclParameterOutOfRange jgclParameterOutOfRange) {
            throw new JgclFatal();
        }
        return acc.extract();
    }

    public JgclPolyline3D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        if (pint.increase() < 0.0) {
            return this.toPolyline(new JgclParameterSection(pint.end(), -pint.increase()), tol).reverse();
        }
        ToPolylineAccumulator accm = new ToPolylineAccumulator(tol, this);
        accm.accumulate(pint);
        return accm.extract();
    }

    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
        ToBsplineCurveAccumulator accm = new ToBsplineCurveAccumulator();
        accm.accumulate(pint.positiveIncrease());
        JgclBsplineCurve3D result = accm.extract();
        if (pint.increase() < 0.0) {
            result = result.reverse();
        }
        return result;
    }

    private JgclIntersectionPoint3D[] doIntersect(JgclParametricCurve3D mate, boolean doExchange) {
        IntersectionAccumulator acc = new IntersectionAccumulator(mate, this);
        acc.accumulate(this.parameterDomain().section());
        return acc.extract(doExchange);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) {
        return this.doIntersect(mate, false);
    }

    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] doIntersect(JgclParametricSurface3D mate, boolean doExchange) {
        IntersectionWithSurfaceAccumulator acc = new IntersectionWithSurfaceAccumulator(mate, this);
        acc.accumulate(this.parameterDomain().section());
        return acc.extract(doExchange);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate) {
        return this.doIntersect(mate, false);
    }

    JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate, boolean doExchange) {
        return this.doIntersect(mate, doExchange);
    }

    public JgclCurveCurveInterference3D[] interfere(JgclBoundedCurve3D mate) {
        return this.getInterference(mate, false);
    }

    private JgclCurveCurveInterference3D[] getInterference(JgclBoundedCurve3D mate, boolean doExchange) {
        JgclCurveCurveInterferenceList interferenceList = new JgclCurveCurveInterferenceList(this, mate);
        int i = 0;
        while (i < this.nSegments()) {
            JgclCurveCurveInterference3D[] localInterferences = this.segmentAt(i).interfere(mate, false);
            Vector intsList = JgclCurveCurveInterferenceList.extractIntersections(localInterferences);
            Enumeration e = intsList.elements();
            while (e.hasMoreElements()) {
                JgclIntersectionPoint3D ints = (JgclIntersectionPoint3D)e.nextElement();
                interferenceList.addAsIntersection(ints.coordinates(), ints.pointOnCurve1().parameter(), this.getCompositeParam(i, ints.pointOnCurve2().parameter()));
            }
            Vector ovlpList = JgclCurveCurveInterferenceList.extractOverlaps(localInterferences);
            Enumeration e2 = ovlpList.elements();
            while (e2.hasMoreElements()) {
                JgclOverlapCurve3D ovlp = (JgclOverlapCurve3D)e2.nextElement();
                interferenceList.addAsOverlap(ovlp.start1(), this.getCompositeParam(i, ovlp.start2()), ovlp.increase1(), ovlp.increase2());
            }
            ++i;
        }
        interferenceList.removeOverlapsContainedInOtherOverlap();
        interferenceList.removeIntersectionsContainedInOverlap();
        return interferenceList.toJgclCurveCurveInterference3DArray(doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclBoundedLine3D mate, boolean doExchange) {
        return this.getInterference(mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclPolyline3D mate, boolean doExchange) {
        return this.getInterference(mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclPureBezierCurve3D mate, boolean doExchange) {
        return this.getInterference(mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclBsplineCurve3D mate, boolean doExchange) {
        return this.getInterference(mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclTrimmedCurve3D mate, boolean doExchange) {
        return this.getInterference(mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return this.getInterference(mate, doExchange);
    }

    JgclCurveCurveInterference3D[] interfere(JgclCompositeCurve3D mate, boolean doExchange) {
        return this.getInterference(mate, doExchange);
    }

    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
        int nSeg = this.nSegments();
        JgclCompositeCurveSegment3D[] newSegs = new JgclCompositeCurveSegment3D[nSeg];
        int i = 0;
        while (i < nSeg) {
            newSegs[i] = (JgclCompositeCurveSegment3D)this.segmentAt(i).parallelTranslate(moveVec);
            ++i;
        }
        return new JgclCompositeCurve3D(newSegs, this.periodic);
    }

    JgclParameterDomain getParameterDomain() {
        try {
            return new JgclParameterDomain(this.periodic, 0.0, this.globalStartParams[this.nSegments()]);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    int type() {
        return 24;
    }

    public boolean isFreeform() {
        return true;
    }

    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        int n_segs = this.nSegments();
        JgclCompositeCurveSegment3D[] segs = new JgclCompositeCurveSegment3D[n_segs];
        int i = 0;
        while (i < n_segs) {
            segs[i] = (JgclCompositeCurveSegment3D)this.segmentAt(i).rotateZ(trns, rCos, rSin);
            ++i;
        }
        return new JgclCompositeCurve3D(segs, this.periodic());
    }

    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
        JgclParameterSection pint = this.parameterDomain().section();
        JgclBsplineCurve3D b_spline = this.toBsplineCurve(pint);
        return b_spline.getPointNotOnLine(line);
    }

    protected synchronized JgclParametricCurve3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclCompositeCurveSegment3D[] tSegments = new JgclCompositeCurveSegment3D[this.nSegments()];
        int i = 0;
        while (i < this.nSegments()) {
            tSegments[i] = (JgclCompositeCurveSegment3D)this.segmentAt(i).transformBy(reverseTransform, transformationOperator, transformedGeometries);
            ++i;
        }
        return new JgclCompositeCurve3D(tSegments, this.periodic());
    }

    protected boolean hasPolyline() {
        int i = 0;
        while (i < this.nSegments()) {
            if (this.segmentAt(i).hasPolyline()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isComposedOfOnlyPolylines() {
        int i = 0;
        while (i < this.nSegments()) {
            if (!this.segmentAt(i).isComposedOfOnlyPolylines()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tsegments");
        int i = 0;
        while (i < this.nSegments()) {
            this.segments[i].output(writer, indent + 2);
            ++i;
        }
        writer.println(String.valueOf(indent_tab) + "\tperiodic\t" + this.periodic);
        writer.println(String.valueOf(indent_tab) + "End");
    }

    class CompositeIndexParam {
        int index;
        double param;

        CompositeIndexParam() {
            JgclCompositeCurve3D.this = JgclCompositeCurve3D.this;
        }
    }

    private class LengthAccumulator
    extends SegmentAccumulator {
        double length;

        void allocate(int nsegs) {
            this.length = 0.0;
        }

        void doit(JgclCompositeCurveSegment3D seg, JgclParameterSection sec, int compIndex) {
            this.length += seg.length(sec);
        }

        double extract() {
            return this.length;
        }

        LengthAccumulator() {
            JgclCompositeCurve3D.this = JgclCompositeCurve3D.this;
        }
    }

    private class SingularAccumulator
    extends SegmentAccumulator {
        JgclCompositeCurve3D curve;
        Vector singularVec;
        JgclIndefiniteSolution inf;

        SingularAccumulator(JgclCompositeCurve3D curve) {
            JgclCompositeCurve3D.this = JgclCompositeCurve3D.this;
            this.curve = curve;
            this.inf = null;
        }

        void allocate(int nsegs) {
            this.singularVec = new Vector();
        }

        void doit(JgclCompositeCurveSegment3D seg, JgclParameterSection sec, int compIndex) {
            double param;
            JgclPointOnCurve3D[] singular;
            try {
                singular = seg.singular();
            }
            catch (JgclIndefiniteSolution e) {
                this.inf = e;
                return;
            }
            int i = 0;
            while (i < singular.length) {
                param = JgclCompositeCurve3D.this.getCompositeParam(compIndex, singular[i].parameter());
                this.singularVec.addElement(new JgclPointOnCurve3D(this.curve, param, false));
                ++i;
            }
            if (seg.transition() == 1) {
                param = JgclCompositeCurve3D.this.getCompositeParam(compIndex, sec.end());
                this.singularVec.addElement(new JgclPointOnCurve3D(this.curve, param, false));
            }
        }

        JgclPointOnCurve3D[] extract() throws JgclIndefiniteSolution {
            if (this.inf != null) {
                throw this.inf;
            }
            Object[] thisSingular = new JgclPointOnCurve3D[this.singularVec.size()];
            this.singularVec.copyInto(thisSingular);
            return thisSingular;
        }
    }

    private class InflexionAccumulator
    extends SegmentAccumulator {
        JgclCompositeCurve3D curve;
        Vector inflexionVec;
        JgclIndefiniteSolution inf;

        InflexionAccumulator(JgclCompositeCurve3D curve) {
            JgclCompositeCurve3D.this = JgclCompositeCurve3D.this;
            this.curve = curve;
            this.inf = null;
        }

        void allocate(int nsegs) {
            this.inflexionVec = new Vector();
        }

        void doit(JgclCompositeCurveSegment3D seg, JgclParameterSection sec, int compIndex) {
            double param;
            JgclPointOnCurve3D[] inflexion;
            try {
                inflexion = seg.inflexion();
            }
            catch (JgclIndefiniteSolution e) {
                this.inf = e;
                return;
            }
            int i = 0;
            while (i < inflexion.length) {
                param = JgclCompositeCurve3D.this.getCompositeParam(compIndex, inflexion[i].parameter());
                this.inflexionVec.addElement(new JgclPointOnCurve3D(this.curve, param, false));
                ++i;
            }
            if (seg.transition() == 2) {
                param = JgclCompositeCurve3D.this.getCompositeParam(compIndex, sec.end());
                this.inflexionVec.addElement(new JgclPointOnCurve3D(this.curve, param, false));
            }
        }

        JgclPointOnCurve3D[] extract() throws JgclIndefiniteSolution {
            if (this.inf != null) {
                throw this.inf;
            }
            Object[] thisInflexion = new JgclPointOnCurve3D[this.inflexionVec.size()];
            this.inflexionVec.copyInto(thisInflexion);
            return thisInflexion;
        }
    }

    private abstract class SegmentAccumulator {
        abstract void doit(JgclCompositeCurveSegment3D var1, JgclParameterSection var2, int var3);

        void doit(JgclCompositeCurveSegment3D seg, double sp, double ep, int compIndex) {
            this.doit(seg, new JgclParameterSection(sp, ep), compIndex);
        }

        abstract void allocate(int var1);

        void accumulate(JgclParameterSection pint) {
            boolean wraparound;
            CompositeIndexParam ex;
            CompositeIndexParam sx;
            JgclParameterDomain domain = JgclCompositeCurve3D.this.parameterDomain();
            if (domain.isPeriodic()) {
                double sp = domain.wrap(pint.start());
                double ep = sp + pint.increase();
                sx = JgclCompositeCurve3D.this.getIndexParam(sp);
                ex = JgclCompositeCurve3D.this.getIndexParam(ep);
                wraparound = domain.section().increase() < ep;
            } else {
                sx = JgclCompositeCurve3D.this.getIndexParam(pint.lower());
                ex = JgclCompositeCurve3D.this.getIndexParam(pint.upper());
                wraparound = false;
            }
            int nsegs = wraparound ? JgclCompositeCurve3D.this.segments.length + ex.index - sx.index + 1 : ex.index - sx.index + 1;
            this.allocate(nsegs);
            if (nsegs == 1) {
                this.doit(JgclCompositeCurve3D.this.segments[sx.index], sx.param, ex.param, sx.index);
            } else if (wraparound) {
                JgclCompositeCurveSegment3D seg = JgclCompositeCurve3D.this.segments[sx.index];
                this.doit(seg, sx.param, seg.eParameter(), sx.index);
                int i = sx.index + 1;
                while (i < JgclCompositeCurve3D.this.segments.length) {
                    seg = JgclCompositeCurve3D.this.segments[i];
                    this.doit(seg, seg.sParameter(), seg.eParameter(), i);
                    ++i;
                }
                i = 0;
                while (i < ex.index) {
                    seg = JgclCompositeCurve3D.this.segments[i];
                    this.doit(seg, seg.sParameter(), seg.eParameter(), i);
                    ++i;
                }
                seg = JgclCompositeCurve3D.this.segments[ex.index];
                this.doit(seg, seg.sParameter(), ex.param, ex.index);
            } else {
                JgclCompositeCurveSegment3D seg = JgclCompositeCurve3D.this.segments[sx.index];
                this.doit(seg, sx.param, seg.eParameter(), sx.index);
                int i = sx.index + 1;
                while (i < ex.index) {
                    seg = JgclCompositeCurve3D.this.segments[i];
                    this.doit(seg, seg.sParameter(), seg.eParameter(), i);
                    ++i;
                }
                seg = JgclCompositeCurve3D.this.segments[ex.index];
                this.doit(seg, seg.sParameter(), ex.param, ex.index);
            }
        }

        SegmentAccumulator() {
            JgclCompositeCurve3D.this = JgclCompositeCurve3D.this;
        }
    }

    private class ProjectionAccumulator
    extends SegmentAccumulator {
        JgclPoint3D point;
        JgclCompositeCurve3D curve;
        JgclPointOnGeometryList projList;
        JgclIndefiniteSolution inf;

        ProjectionAccumulator(JgclPoint3D point, JgclCompositeCurve3D curve) {
            JgclCompositeCurve3D.this = JgclCompositeCurve3D.this;
            this.curve = curve;
            this.point = point;
            this.inf = null;
        }

        void allocate(int nsegs) {
            this.projList = new JgclPointOnGeometryList();
        }

        void doit(JgclCompositeCurveSegment3D seg, JgclParameterSection sec, int compIndex) {
            JgclPointOnCurve3D[] proj;
            try {
                proj = seg.projectFrom(this.point);
            }
            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                throw new JgclFatal();
            }
            catch (JgclIndefiniteSolution e) {
                this.inf = e;
                return;
            }
            int i = 0;
            while (i < proj.length) {
                double param = JgclCompositeCurve3D.this.getCompositeParam(compIndex, proj[i].parameter());
                this.projList.addPoint(this.curve, param);
                ++i;
            }
        }

        JgclPointOnCurve3D[] extract() throws JgclIndefiniteSolution {
            if (this.inf != null) {
                throw this.inf;
            }
            return this.projList.toJgclPointOnCurve3DArray();
        }
    }

    private class ToPolylineAccumulator
    extends SegmentAccumulator {
        JgclToleranceForDistance tol;
        JgclPolyline3D[] pls;
        JgclCompositeCurveSegment3D[] segs;
        int[] compIndex;
        JgclCompositeCurve3D curve;
        int segIndex;

        ToPolylineAccumulator(JgclToleranceForDistance tol, JgclCompositeCurve3D curve) {
            JgclCompositeCurve3D.this = JgclCompositeCurve3D.this;
            this.tol = tol;
            this.curve = curve;
            this.segIndex = 0;
        }

        void allocate(int nsegs) {
            this.pls = new JgclPolyline3D[nsegs];
            this.segs = new JgclCompositeCurveSegment3D[nsegs];
            this.compIndex = new int[nsegs];
        }

        void doit(JgclCompositeCurveSegment3D seg, JgclParameterSection sec, int compIndex) {
            this.segs[this.segIndex] = seg;
            this.compIndex[this.segIndex] = compIndex;
            try {
                this.pls[this.segIndex] = seg.toPolyline(sec, this.tol);
            }
            catch (JgclZeroLength jgclZeroLength) {
                this.pls[this.segIndex] = null;
            }
            ++this.segIndex;
        }

        JgclPolyline3D extract() {
            int npnts = 1;
            int i = 0;
            while (i < this.pls.length) {
                if (this.pls[i] != null) {
                    npnts += this.pls[i].nPoints() - 1;
                }
                ++i;
            }
            if (npnts < 2) {
                throw new JgclZeroLength();
            }
            JgclPoint3D[] points = new JgclPointOnCurve3D[npnts];
            int k = 0;
            i = 0;
            while (i < this.pls.length) {
                if (this.pls[i] != null) {
                    int j = 0;
                    while (j < this.pls[i].nPoints()) {
                        JgclPointOnCurve3D pnts = (JgclPointOnCurve3D)this.pls[i].pointAt(j);
                        double param = JgclCompositeCurve3D.this.getCompositeParam(this.compIndex[i], pnts.parameter());
                        if (i == 0 || j != 0) {
                            try {
                                points[k++] = new JgclPointOnCurve3D(this.curve, param, false);
                            }
                            catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
                                throw new JgclFatal();
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return new JgclPolyline3D(points);
        }
    }

    private class ToBsplineCurveAccumulator
    extends SegmentAccumulator {
        JgclBsplineCurve3D result;

        ToBsplineCurveAccumulator() {
            JgclCompositeCurve3D.this = JgclCompositeCurve3D.this;
        }

        void allocate(int nsegs) {
            this.result = null;
        }

        void doit(JgclCompositeCurveSegment3D seg, JgclParameterSection sec, int compIndex) {
            try {
                JgclBsplineCurve3D bsc = seg.toBsplineCurve(sec);
                this.result = this.result == null ? bsc : this.result.mergeIfContinuous(bsc);
            }
            catch (JgclTwoGeomertiesAreNotContinuous jgclTwoGeomertiesAreNotContinuous) {
                throw new JgclFatal();
            }
        }

        JgclBsplineCurve3D extract() {
            return this.result;
        }
    }

    private class IntersectionAccumulator
    extends SegmentAccumulator {
        JgclParametricCurve3D mate;
        JgclCompositeCurve3D curve;
        Vector intsvec;

        IntersectionAccumulator(JgclParametricCurve3D mate, JgclCompositeCurve3D curve) {
            JgclCompositeCurve3D.this = JgclCompositeCurve3D.this;
            this.curve = curve;
            this.mate = mate;
        }

        void allocate(int nsegs) {
            this.intsvec = new Vector();
        }

        void doit(JgclCompositeCurveSegment3D seg, JgclParameterSection sec, int compIndex) {
            JgclIntersectionPoint3D[] ints = seg.intersect(this.mate);
            int i = 0;
            while (i < ints.length) {
                JgclPointOnCurve3D pnt1 = (JgclPointOnCurve3D)ints[i].pointOnGeometry1();
                double cparam = pnt1.parameter();
                double sparam = JgclCompositeCurve3D.this.getCompositeParam(compIndex, cparam);
                JgclPointOnCurve3D thisPnts = new JgclPointOnCurve3D(this.curve, sparam, false);
                JgclIntersectionPoint3D thisInts = new JgclIntersectionPoint3D(thisPnts, ints[i].pointOnGeometry2(), false);
                this.intsvec.addElement(thisInts);
                ++i;
            }
        }

        JgclIntersectionPoint3D[] extract(boolean doExchange) {
            Object[] ints = new JgclIntersectionPoint3D[this.intsvec.size()];
            this.intsvec.copyInto(ints);
            if (doExchange) {
                int i = 0;
                while (i < ints.length) {
                    ints[i] = ((JgclIntersectionPoint3D)ints[i]).exchange();
                    ++i;
                }
            }
            return ints;
        }
    }

    private class IntersectionWithSurfaceAccumulator
    extends SegmentAccumulator {
        JgclParametricSurface3D mate;
        JgclCompositeCurve3D curve;
        JgclCurveSurfaceInterferenceList intfList;

        IntersectionWithSurfaceAccumulator(JgclParametricSurface3D mate, JgclCompositeCurve3D curve) {
            JgclCompositeCurve3D.this = JgclCompositeCurve3D.this;
            this.curve = curve;
            this.mate = mate;
        }

        void allocate(int nsegs) {
            this.intfList = new JgclCurveSurfaceInterferenceList(this.curve, this.mate);
        }

        void doit(JgclCompositeCurveSegment3D seg, JgclParameterSection sec, int compIndex) {
            JgclIntersectionPoint3D[] intp = seg.intersect(this.mate);
            int i = 0;
            while (i < intp.length) {
                JgclPointOnCurve3D crvPnt = (JgclPointOnCurve3D)intp[i].pointOnGeometry1();
                double param = crvPnt.parameter();
                double compositeParam = JgclCompositeCurve3D.this.getCompositeParam(compIndex, param);
                JgclPointOnSurface3D srfPnt = (JgclPointOnSurface3D)intp[i].pointOnGeometry2();
                this.intfList.addAsIntersection(intp[i].coordinates(), compositeParam, srfPnt.uParameter(), srfPnt.vParameter());
                ++i;
            }
        }

        JgclIntersectionPoint3D[] extract(boolean doExchange) {
            return this.intfList.toJgclIntersectionPoint3DArray(doExchange);
        }
    }
}

