/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclAxis2Placement2D;
import jp.go.ipa.jgcl.JgclAxis2Placement3D;
import jp.go.ipa.jgcl.JgclBsplineCurve3D;
import jp.go.ipa.jgcl.JgclCartesianPoint2D;
import jp.go.ipa.jgcl.JgclCartesianPoint3D;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclCircle2D;
import jp.go.ipa.jgcl.JgclCompositeCurve3D;
import jp.go.ipa.jgcl.JgclCompositeCurveSegment3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclConic2D;
import jp.go.ipa.jgcl.JgclConic3D;
import jp.go.ipa.jgcl.JgclCurveCurvature3D;
import jp.go.ipa.jgcl.JgclCurveDerivative3D;
import jp.go.ipa.jgcl.JgclEllipse3D;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclHyperbola3D;
import jp.go.ipa.jgcl.JgclIndefiniteSolution;
import jp.go.ipa.jgcl.JgclIntersectionPoint3D;
import jp.go.ipa.jgcl.JgclIntsCncBzs3D;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclLine3D;
import jp.go.ipa.jgcl.JgclLiteralVector3D;
import jp.go.ipa.jgcl.JgclParabola3D;
import jp.go.ipa.jgcl.JgclParameterDomain;
import jp.go.ipa.jgcl.JgclParameterSection;
import jp.go.ipa.jgcl.JgclParametricCurve3D;
import jp.go.ipa.jgcl.JgclPlane3D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclPointOnCurve3D;
import jp.go.ipa.jgcl.JgclPolyline3D;
import jp.go.ipa.jgcl.JgclPureBezierCurve2D;
import jp.go.ipa.jgcl.JgclPureBezierCurve3D;
import jp.go.ipa.jgcl.JgclRealPolynomial;
import jp.go.ipa.jgcl.JgclToleranceForDistance;
import jp.go.ipa.jgcl.JgclTrimmedCurve3D;
import jp.go.ipa.jgcl.JgclVector3D;
import jp.go.ipa.jgcl.JgclZeroLength;

public class JgclCircle3D
extends JgclConic3D {
    private double radius;

    private void setRadius(double radius) {
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        if (radius < dTol) {
            throw new JgclInvalidArgumentValue();
        }
        this.radius = radius;
    }

    public JgclCircle3D(JgclAxis2Placement3D position, double radius) {
        super(position);
        this.setRadius(radius);
    }

    public JgclCircle3D(JgclPoint3D center, JgclVector3D normal, double radius) {
        super(new JgclAxis2Placement3D(center, normal, normal.verticalVector().unitized()));
        this.setRadius(radius);
    }

    private static JgclAxis2Placement3D placement(JgclPoint3D pnt1, JgclPoint3D pnt2, JgclPoint3D pnt3) {
        JgclIntersectionPoint3D isec;
        JgclVector3D vec3;
        if (pnt1.identical(pnt2) || pnt1.identical(pnt3) || pnt2.identical(pnt3)) {
            throw new JgclInvalidArgumentValue();
        }
        JgclVector3D vec2 = pnt2.subtract(pnt1);
        if (vec2.identicalDirection(vec3 = pnt3.subtract(pnt1))) {
            throw new JgclInvalidArgumentValue();
        }
        JgclVector3D normal = vec2.crossProduct(vec3);
        JgclLine3D line2 = new JgclLine3D(pnt1.linearInterpolate(pnt2, 0.5), vec2.crossProduct(normal));
        JgclLine3D line3 = new JgclLine3D(pnt1.linearInterpolate(pnt3, 0.5), vec3.crossProduct(normal));
        try {
            isec = line2.intersect1Line(line3);
            if (isec == null) {
                throw new JgclFatal();
            }
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
        return new JgclAxis2Placement3D(isec.coordinates(), normal, vec2);
    }

    public JgclCircle3D(JgclPoint3D pnt1, JgclPoint3D pnt2, JgclPoint3D pnt3) {
        super(JgclCircle3D.placement(pnt1, pnt2, pnt3));
        this.setRadius(this.position().location().subtract(pnt1).length());
    }

    JgclConic2D toLocal2D(JgclAxis2Placement2D position) {
        return new JgclCircle2D(position, this.radius);
    }

    public double radius() {
        return this.radius;
    }

    public double length(JgclParameterSection pint) {
        return this.radius() * Math.abs(pint.increase());
    }

    public JgclPoint3D coordinates(double param) {
        param = this.parameterDomain().wrap(param);
        JgclPoint3D center = this.position().location();
        double ecos = Math.cos(param) * this.radius;
        double esin = Math.sin(param) * this.radius;
        JgclVector3D x = this.position().x().multiply(ecos);
        JgclVector3D y = this.position().y().multiply(esin);
        return center.add(x.add(y));
    }

    public JgclVector3D tangentVector(double param) {
        param = this.parameterDomain().wrap(param);
        double ecos = Math.cos(param) * this.radius;
        double esin = Math.sin(param) * this.radius;
        JgclVector3D x = this.position().x().multiply(-esin);
        JgclVector3D y = this.position().y().multiply(ecos);
        return x.add(y);
    }

    public JgclCurveCurvature3D curvature(double param) {
        param = this.parameterDomain().wrap(param);
        double ucos = Math.cos(param);
        double usin = Math.sin(param);
        JgclVector3D x = this.position().x().multiply(-ucos);
        JgclVector3D y = this.position().y().multiply(-usin);
        return new JgclCurveCurvature3D(1.0 / this.radius, x.add(y));
    }

    public JgclCurveDerivative3D evaluation(double param) {
        param = this.parameterDomain().wrap(param);
        double ecos = Math.cos(param) * this.radius;
        double esin = Math.sin(param) * this.radius;
        JgclPoint3D center = this.position().location();
        JgclVector3D xcos = this.position().x().multiply(ecos);
        JgclVector3D ysin = this.position().y().multiply(esin);
        JgclVector3D xsin = this.position().x().multiply(esin);
        JgclVector3D ycos = this.position().y().multiply(ecos);
        JgclPoint3D d0 = center.add(xcos.add(ysin));
        JgclVector3D d1 = ycos.add(xsin.multiply(-1.0));
        JgclVector3D d2 = xcos.add(ysin).multiply(-1.0);
        JgclVector3D d3 = ycos.multiply(-1.0).add(xsin);
        return new JgclCurveDerivative3D(d0, d1, d2, d3);
    }

    private void indefiniteFoot() throws JgclIndefiniteSolution {
        JgclPointOnCurve3D p;
        try {
            p = new JgclPointOnCurve3D(this, 0.0, false);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
        throw new JgclIndefiniteSolution(p);
    }

    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D point) throws JgclIndefiniteSolution {
        double edot;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol = condition.getToleranceForDistance();
        double aTol = condition.getToleranceForAngle();
        JgclVector3D eV = point.subtract(this.position().location());
        if (eV.length() < dTol) {
            this.indefiniteFoot();
        }
        if (Math.abs(edot = (eV = eV.unitized()).dotProduct(this.position().z())) > Math.cos(aTol)) {
            this.indefiniteFoot();
        }
        JgclVector3D eU = eV.crossProduct(this.position().z());
        eV = this.position().z().crossProduct(eU).unitized();
        double eangle = this.position().x().angleWith(eV, this.position().z());
        double eangle2 = eangle + Math.PI;
        if (eangle2 >= Math.PI * 2) {
            eangle2 -= Math.PI * 2;
        }
        JgclPointOnCurve3D[] prj = new JgclPointOnCurve3D[]{new JgclPointOnCurve3D(this, eangle, false), new JgclPointOnCurve3D(this, eangle2, false)};
        return prj;
    }

    double getPeak(double left, double right) {
        throw new JgclFatal();
    }

    public JgclPolyline3D toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol) {
        double sa = this.parameterDomain().wrap(pint.start());
        double inc = pint.increase();
        int no_intvls = JgclCircle2D.toPolylineNDivision(this.radius(), inc, tol);
        double atheta = inc / (double)no_intvls;
        JgclPoint3D[] pnts = new JgclPoint3D[no_intvls + 1];
        int i = 0;
        while (i < no_intvls + 1) {
            pnts[i] = new JgclPointOnCurve3D(this, sa + atheta * (double)i, false);
            ++i;
        }
        if (no_intvls == 1 && pnts[0].identical(pnts[1])) {
            throw new JgclZeroLength();
        }
        return new JgclPolyline3D(pnts);
    }

    public JgclPureBezierCurve3D[] toPolyBezierCurves(JgclParameterSection pint) {
        JgclCircle2D this2D = (JgclCircle2D)this.toLocal2D(JgclAxis2Placement2D.origin);
        JgclPureBezierCurve2D[] bzcs2D = this2D.toPolyBezierCurves(pint);
        return this.transformPolyBezierCurvesInLocal2DToGrobal3D(bzcs2D);
    }

    JgclPureBezierCurve3D[] toPolyBezierCurvesOfN(int nCurves, JgclParameterSection pint) {
        JgclCircle2D this2D = (JgclCircle2D)this.toLocal2D(JgclAxis2Placement2D.origin);
        JgclPureBezierCurve2D[] bzcs2D = this2D.toPolyBezierCurvesOfN(nCurves, pint);
        return this.transformPolyBezierCurvesInLocal2DToGrobal3D(bzcs2D);
    }

    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection pint) {
        JgclPureBezierCurve3D[] bzcs = this.toPolyBezierCurves(pint);
        boolean closed = Math.abs(pint.increase()) >= Math.PI * 2;
        return JgclConic3D.convertPolyBezierCurvesToOneBsplineCurve(bzcs, closed);
    }

    JgclBsplineCurve3D toBsplineCurveOfNSegments(int nSegments, JgclParameterSection pint) {
        JgclPureBezierCurve3D[] bzcs = this.toPolyBezierCurvesOfN(nSegments, pint);
        boolean closed = Math.abs(pint.increase()) >= Math.PI * 2;
        return JgclConic3D.convertPolyBezierCurvesToOneBsplineCurve(bzcs, closed);
    }

    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) throws JgclIndefiniteSolution {
        return mate.intersect(this, true);
    }

    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
        JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
        JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
        double rad2 = this.radius() * this.radius();
        boolean isPoly = poly.length < 4;
        int degree = xPoly.degree();
        double[] coef = new double[degree + 1];
        if (isPoly) {
            int j = 0;
            while (j <= degree) {
                coef[j] = xPoly.coefficientAt(j) + yPoly.coefficientAt(j);
                ++j;
            }
            coef[0] = coef[0] - rad2;
        } else {
            JgclRealPolynomial wPoly = poly[3].multiply(poly[3]);
            int j = 0;
            while (j <= degree) {
                coef[j] = xPoly.coefficientAt(j) + yPoly.coefficientAt(j) - rad2 * wPoly.coefficientAt(j);
                ++j;
            }
        }
        return new JgclRealPolynomial(coef);
    }

    boolean checkSolution(JgclPoint3D point) {
        double dTol = this.getToleranceForDistance();
        return Math.abs(point.toVector3D().length() - this.radius()) < dTol && Math.abs(point.z()) < dTol;
    }

    double getParameter(JgclPoint3D point) {
        double cos = point.x() / this.radius();
        if (cos > 1.0) {
            cos = 1.0;
        }
        if (cos < -1.0) {
            cos = -1.0;
        }
        double acos = Math.acos(cos);
        if (point.y() < 0.0) {
            acos = Math.PI * 2 - acos;
        }
        return acos;
    }

    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) throws JgclIndefiniteSolution {
        return this.intersectCnc(mate, doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
        try {
            return this.intersectCnc(mate, doExchange);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
        try {
            return this.intersectCnc(mate, doExchange);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
        try {
            return this.intersectCnc(mate, doExchange);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
        return mate.intersect(this, !doExchange);
    }

    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
        return new JgclCircle3D(this.position().parallelTranslate(moveVec), this.radius);
    }

    JgclParameterDomain getParameterDomain() {
        try {
            return new JgclParameterDomain(true, 0.0, Math.PI * 2);
        }
        catch (JgclInvalidArgumentValue jgclInvalidArgumentValue) {
            throw new JgclFatal();
        }
    }

    boolean getClosedFlag() {
        return true;
    }

    int type() {
        return 10;
    }

    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        JgclAxis2Placement3D rpos = this.position().rotateZ(trns, rCos, rSin);
        return new JgclCircle3D(rpos, this.radius());
    }

    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
        JgclVector3D vector;
        JgclPoint3D point;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double dTol2 = condition.getToleranceForDistance2();
        double start = 0.0;
        double increase = 1.5707963267948966;
        int itry = 0;
        int limit = 3;
        do {
            if (itry > limit) {
                throw new JgclFatal();
            }
            point = this.coordinates(start + increase * (double)itry);
            vector = point.subtract(line.project1From(point));
            ++itry;
        } while (point.isOn(line) || vector.norm() < dTol2);
        return point;
    }

    boolean checkInterfere(JgclIntsCncBzs3D.BezierSurfaceInfo bi) {
        double dTol = this.getToleranceForDistance();
        if (!(bi.box.min().z() < -dTol) || !(bi.box.max().z() > dTol)) {
            return false;
        }
        boolean all_in = true;
        boolean all_out = true;
        JgclPoint2D[] point = new JgclPoint2D[]{new JgclCartesianPoint2D(bi.box.min().x(), bi.box.min().y()), new JgclCartesianPoint2D(bi.box.max().x(), bi.box.min().y()), new JgclCartesianPoint2D(bi.box.max().x(), bi.box.max().y()), new JgclCartesianPoint2D(bi.box.min().x(), bi.box.max().y())};
        int i = 0;
        while (i < 4) {
            double dist = point[i].toVector2D().length();
            if (dist < this.radius() - dTol) {
                all_out = false;
            } else if (dist > this.radius() + dTol) {
                all_in = false;
            } else {
                all_out = false;
                all_in = false;
            }
            ++i;
        }
        if (all_in) {
            return false;
        }
        if (all_out) {
            if (bi.box.min().x() > this.radius() + dTol || bi.box.min().y() > this.radius() + dTol || bi.box.max().x() < -(this.radius() + dTol) || bi.box.max().y() < -(this.radius() + dTol)) {
                return false;
            }
            return !(point[0].x() > 0.0 && point[0].y() > 0.0 || point[1].x() < 0.0 && point[1].y() > 0.0 || point[2].x() < 0.0 && point[2].y() < 0.0) && (!(point[3].x() > 0.0) || !(point[3].y() < 0.0));
        }
        return true;
    }

    JgclIntersectionPoint3D[] intersectConicPlane(JgclPlane3D plane) {
        JgclAxis2Placement3D position = new JgclAxis2Placement3D(JgclPoint3D.origin, null, null);
        JgclCircle3D circle = new JgclCircle3D(position, this.radius());
        try {
            return circle.intersect(plane);
        }
        catch (JgclIndefiniteSolution jgclIndefiniteSolution) {
            throw new JgclFatal();
        }
    }

    JgclPoint3D nlFunc(double parameter) {
        double x = this.radius() * Math.cos(parameter);
        double y = this.radius() * Math.sin(parameter);
        double z = 0.0;
        return new JgclCartesianPoint3D(x, y, z);
    }

    JgclVector3D dnlFunc(double parameter) {
        double x = -this.radius() * Math.sin(parameter);
        double y = this.radius() * Math.cos(parameter);
        double z = 0.0;
        return new JgclLiteralVector3D(x, y, z);
    }

    protected synchronized JgclParametricCurve3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclAxis2Placement3D tPosition = this.position().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        double tRadius = !reverseTransform ? transformationOperator.transform(this.radius()) : transformationOperator.reverseTransform(this.radius());
        return new JgclCircle3D(tPosition, tRadius);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tposition");
        this.position().output(writer, indent + 2);
        writer.println(String.valueOf(indent_tab) + "\tradius " + this.radius);
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

