/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.util.Enumeration;
import java.util.Vector;
import jp.go.ipa.jgcl.JgclFatal;

class JgclBinaryTree {
    private Node root;

    JgclBinaryTree(Object data) {
        this.root = new Node(null, data);
    }

    Node rootNode() {
        return this.root;
    }

    class Node {
        private final Object data;
        private final Node parent;
        private Node left;
        private Node right;

        Node(Node parent, Object data) {
            JgclBinaryTree.this = JgclBinaryTree.this;
            this.data = data;
            this.parent = parent;
        }

        Object data() {
            return this.data;
        }

        Node parent() {
            return this.parent;
        }

        synchronized Node left() {
            return this.left;
        }

        synchronized Node right() {
            return this.right;
        }

        synchronized void left(Node left) {
            this.left = left;
        }

        synchronized void right(Node right) {
            this.right = right;
        }

        synchronized Node makeLeft(Object data) {
            if (this.left() != null) {
                throw new JgclFatal();
            }
            this.left(new Node(this, data));
            return this.left();
        }

        synchronized Node makeRight(Object data) {
            if (this.right() != null) {
                throw new JgclFatal();
            }
            this.right(new Node(this, data));
            return this.right();
        }

        synchronized Node preOrderTraverse(TraverseProc tproc, Object pdata) {
            return this.myPreOrderTraverse(0, this, tproc, pdata);
        }

        synchronized Node inOrderTraverse(TraverseProc tproc, Object pdata) {
            return this.myInOrderTraverse(0, this, tproc, pdata);
        }

        synchronized Node postOrderTraverse(TraverseProc tproc, Object pdata) {
            return this.myPostOrderTraverse(0, this, tproc, pdata);
        }

        private Node myPreOrderTraverse(int ctl, Node node, TraverseProc tproc, Object pdata) {
            Node leftVal = null;
            Node rightVal = null;
            if (node == null) {
                return null;
            }
            boolean rvalh = tproc.doit(node, ctl, pdata);
            if (rvalh || (leftVal = this.myPreOrderTraverse(ctl + 1, node.left(), tproc, pdata)) != null || (rightVal = this.myPreOrderTraverse(ctl + 1, node.right(), tproc, pdata)) != null) {
                if (rvalh) {
                    return node;
                }
                if (leftVal != null) {
                    return leftVal;
                }
                return rightVal;
            }
            return null;
        }

        private Node myInOrderTraverse(int ctl, Node node, TraverseProc tproc, Object pdata) {
            boolean rvalh = false;
            Node rightVal = null;
            if (node == null) {
                return null;
            }
            Node leftVal = this.myInOrderTraverse(ctl + 1, node.left(), tproc, pdata);
            if (leftVal != null || (rvalh = tproc.doit(node, ctl, pdata)) || (rightVal = this.myInOrderTraverse(ctl + 1, node.right(), tproc, pdata)) != null) {
                if (leftVal != null) {
                    return leftVal;
                }
                if (rvalh) {
                    return node;
                }
                return rightVal;
            }
            return null;
        }

        private Node myPostOrderTraverse(int ctl, Node node, TraverseProc tproc, Object pdata) {
            boolean rvalh;
            Node rightVal = null;
            if (node == null) {
                return null;
            }
            Node leftVal = this.myPostOrderTraverse(ctl + 1, node.left(), tproc, pdata);
            if (leftVal != null || (rightVal = this.myPostOrderTraverse(ctl + 1, node.right(), tproc, pdata)) != null || (rvalh = tproc.doit(node, ctl, pdata))) {
                if (leftVal != null) {
                    return leftVal;
                }
                if (rightVal != null) {
                    return rightVal;
                }
                return node;
            }
            return null;
        }

        synchronized Enumeration preOrderEnumeration() {
            Vector nodes = new Vector();
            this.preOrderTraverse(new addNodeProc(), nodes);
            return nodes.elements();
        }

        synchronized Enumeration inOrderEnumeration() {
            Vector nodes = new Vector();
            this.inOrderTraverse(new addNodeProc(), nodes);
            return nodes.elements();
        }

        synchronized Enumeration postOrderEnumeration() {
            Vector nodes = new Vector();
            this.postOrderTraverse(new addNodeProc(), nodes);
            return nodes.elements();
        }
    }

    interface TraverseProc {
        public boolean doit(Node var1, int var2, Object var3);
    }

    private class addNodeProc
    implements TraverseProc {
        public boolean doit(Node node, int ctl, Object pdata) {
            Vector nodes = (Vector)pdata;
            nodes.addElement(node);
            return false;
        }

        addNodeProc() {
            JgclBinaryTree.this = JgclBinaryTree.this;
        }
    }

    private class checkNode
    implements TraverseProc {
        public boolean doit(Node node, int ctl, Object pdata) {
            Node givenNode = (Node)pdata;
            return node == givenNode;
        }

        checkNode() {
            JgclBinaryTree.this = JgclBinaryTree.this;
        }
    }
}

