/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator3D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclGeometrySchemaFunction;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclPlacement3D;
import jp.go.ipa.jgcl.JgclPoint3D;
import jp.go.ipa.jgcl.JgclVector3D;

public class JgclAxis2Placement3D
extends JgclPlacement3D {
    public static final JgclAxis2Placement3D origin = new JgclAxis2Placement3D(JgclPoint3D.origin, JgclVector3D.zUnitVector, JgclVector3D.xUnitVector);
    private final JgclVector3D axis;
    private final JgclVector3D refDirection;
    private JgclVector3D[] axes;

    public JgclAxis2Placement3D(JgclPoint3D location, JgclVector3D axis, JgclVector3D refDirection) {
        super(location);
        this.axis = axis;
        this.refDirection = refDirection;
        this.checkFields();
    }

    private void checkFields() {
        JgclVector3D b;
        JgclVector3D a;
        JgclVector3D c;
        JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
        double tol_2d = condition.getToleranceForDistance();
        tol_2d *= tol_2d;
        if (this.axis != null && this.axis.norm() <= tol_2d) {
            throw new JgclInvalidArgumentValue();
        }
        if (this.refDirection != null && this.refDirection.norm() <= tol_2d) {
            throw new JgclInvalidArgumentValue();
        }
        if ((this.axis != null || this.refDirection != null) && (c = (a = this.axis == null ? JgclVector3D.zUnitVector : this.axis).crossProduct(b = this.refDirection == null ? JgclVector3D.xUnitVector : this.refDirection)).norm() <= tol_2d) {
            throw new JgclInvalidArgumentValue();
        }
    }

    public JgclVector3D axis() {
        return this.axis;
    }

    public JgclVector3D effectiveAxis() {
        return this.axis != null ? this.axis : JgclGeometrySchemaFunction.defaultAxis3D;
    }

    public JgclVector3D refDirection() {
        return this.refDirection;
    }

    public JgclVector3D effectiveRefDirection() {
        return this.refDirection != null ? this.refDirection : JgclGeometrySchemaFunction.defaultRefDirection3D;
    }

    public JgclVector3D x() {
        if (this.axes == null) {
            this.axes();
        }
        return this.axes[0];
    }

    public JgclVector3D y() {
        if (this.axes == null) {
            this.axes();
        }
        return this.axes[1];
    }

    public JgclVector3D z() {
        if (this.axes == null) {
            this.axes();
        }
        return this.axes[2];
    }

    public JgclVector3D[] axes() {
        if (this.axes == null) {
            this.axes = JgclGeometrySchemaFunction.buildAxes(this.axis, this.refDirection);
        }
        return (JgclVector3D[])this.axes.clone();
    }

    public JgclAxis2Placement3D parallelTranslate(JgclVector3D moveVec) {
        return new JgclAxis2Placement3D(this.location().add(moveVec), this.axis, this.refDirection);
    }

    JgclAxis2Placement3D rotateZ(JgclCartesianTransformationOperator3D trns, double rCos, double rSin) {
        JgclPoint3D rloc = this.location().rotateZ(trns, rCos, rSin);
        JgclVector3D raxis = this.z().rotateZ(trns, rCos, rSin);
        JgclVector3D rref = this.x().rotateZ(trns, rCos, rSin);
        return new JgclAxis2Placement3D(rloc, raxis, rref);
    }

    public JgclCartesianTransformationOperator3D toCartesianTransformationOperator(double scale) {
        return new JgclCartesianTransformationOperator3D(this, scale);
    }

    public JgclCartesianTransformationOperator3D toCartesianTransformationOperator() {
        return new JgclCartesianTransformationOperator3D(this);
    }

    protected synchronized JgclAxis2Placement3D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint3D tLocation = this.location().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclVector3D tAxis = this.effectiveAxis().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclVector3D tRefDirection = this.effectiveRefDirection().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclAxis2Placement3D(tLocation, tAxis, tRefDirection);
    }

    public synchronized JgclAxis2Placement3D transformBy(boolean reverseTransform, JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        if (transformedGeometries == null) {
            return this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclAxis2Placement3D transformed = (JgclAxis2Placement3D)transformedGeometries.get(this);
        if (transformed == null) {
            transformed = this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
            transformedGeometries.put(this, transformed);
        }
        return transformed;
    }

    public synchronized JgclAxis2Placement3D transformBy(JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(false, transformationOperator, transformedGeometries);
    }

    public synchronized JgclAxis2Placement3D reverseTransformBy(JgclCartesianTransformationOperator3D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(true, transformationOperator, transformedGeometries);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tlocation");
        this.location().output(writer, indent + 2);
        if (this.axis != null) {
            writer.println(String.valueOf(indent_tab) + "\taxis");
            this.axis.output(writer, indent + 2);
        }
        if (this.refDirection != null) {
            writer.println(String.valueOf(indent_tab) + "\trefDirection");
            this.refDirection.output(writer, indent + 2);
        }
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

