/*
 * Decompiled with CFR 0.152.
 */
package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.Hashtable;
import jp.go.ipa.jgcl.JgclCartesianTransformationOperator2D;
import jp.go.ipa.jgcl.JgclConditionOfOperation;
import jp.go.ipa.jgcl.JgclGeometrySchemaFunction;
import jp.go.ipa.jgcl.JgclInvalidArgumentValue;
import jp.go.ipa.jgcl.JgclPlacement2D;
import jp.go.ipa.jgcl.JgclPoint2D;
import jp.go.ipa.jgcl.JgclVector2D;

public class JgclAxis2Placement2D
extends JgclPlacement2D {
    public static final JgclAxis2Placement2D origin = new JgclAxis2Placement2D(JgclPoint2D.origin, JgclVector2D.xUnitVector);
    private final JgclVector2D refDirection;
    private JgclVector2D[] axes;

    public JgclAxis2Placement2D(JgclPoint2D location, JgclVector2D refDirection) {
        super(location);
        this.refDirection = refDirection;
        this.checkRefDirection();
    }

    private void checkRefDirection() {
        if (this.refDirection != null) {
            JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
            double tol_d = condition.getToleranceForDistance();
            if (this.refDirection.norm() <= tol_d * tol_d) {
                throw new JgclInvalidArgumentValue();
            }
        }
    }

    public JgclVector2D refDirection() {
        return this.refDirection;
    }

    public JgclVector2D effectiveRefDirection() {
        return this.refDirection != null ? this.refDirection : JgclGeometrySchemaFunction.defaultRefDirection2D;
    }

    public JgclVector2D x() {
        if (this.axes == null) {
            this.axes();
        }
        return this.axes[0];
    }

    public JgclVector2D y() {
        if (this.axes == null) {
            this.axes();
        }
        return this.axes[1];
    }

    public JgclVector2D[] axes() {
        if (this.axes == null) {
            this.axes = JgclGeometrySchemaFunction.build2Axes(this.refDirection);
        }
        return (JgclVector2D[])this.axes.clone();
    }

    public JgclCartesianTransformationOperator2D toCartesianTransformationOperator(double scale) {
        return new JgclCartesianTransformationOperator2D(this, scale);
    }

    protected synchronized JgclAxis2Placement2D doTransformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        JgclPoint2D tLocation = this.location().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        JgclVector2D tRefDirection = this.effectiveRefDirection().transformBy(reverseTransform, transformationOperator, transformedGeometries);
        return new JgclAxis2Placement2D(tLocation, tRefDirection);
    }

    public synchronized JgclAxis2Placement2D transformBy(boolean reverseTransform, JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        if (transformedGeometries == null) {
            return this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
        }
        JgclAxis2Placement2D transformed = (JgclAxis2Placement2D)transformedGeometries.get(this);
        if (transformed == null) {
            transformed = this.doTransformBy(reverseTransform, transformationOperator, transformedGeometries);
            transformedGeometries.put(this, transformed);
        }
        return transformed;
    }

    public synchronized JgclAxis2Placement2D transformBy(JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(false, transformationOperator, transformedGeometries);
    }

    public synchronized JgclAxis2Placement2D reverseTransformBy(JgclCartesianTransformationOperator2D transformationOperator, Hashtable transformedGeometries) {
        return this.transformBy(true, transformationOperator, transformedGeometries);
    }

    protected void output(PrintWriter writer, int indent) {
        String indent_tab = this.makeIndent(indent);
        writer.println(String.valueOf(indent_tab) + this.getClassName());
        writer.println(String.valueOf(indent_tab) + "\tlocation");
        this.location().output(writer, indent + 2);
        if (this.refDirection != null) {
            writer.println(String.valueOf(indent_tab) + "\trefDirection");
            this.refDirection.output(writer, indent + 2);
        }
        writer.println(String.valueOf(indent_tab) + "End");
    }
}

