/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.judan;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.co.sra.judan.JudanTransformer;
import jp.co.sra.judan.JudanView;
import jp.co.sra.judan.JudanViewWithJun;
import jp.go.ipa.jgcl.JgclFatal;
import jp.go.ipa.jgcl.JgclGeometry;

public abstract class JudanMethod {
    protected Method method;
    protected Object result;
    protected JgclGeometry geometry;
    protected Class[] argClasses;
    protected Object[] argEntities;
    protected JudanView view = new JudanView(new JudanViewWithJun());
    protected JudanTransformer resultView;

    protected void setFields(JgclGeometry geometry, String methodName, Class[] argClasses, Object[] argEntities) {
        this.setFields(geometry.getClass(), geometry, methodName, argClasses, argEntities);
    }

    protected void setFields(Class geomClass, JgclGeometry geometry, String methodName, Class[] argClasses, Object[] argEntities) {
        this.geometry = geometry;
        this.argEntities = argEntities;
        try {
            this.method = geomClass.getMethod(methodName, argClasses);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JgclFatal();
        }
        this.argClasses = argClasses;
    }

    JudanMethod() {
    }

    public JudanMethod(JgclGeometry geometry, String methodName, Class[] argClasses, Object[] argEntities) {
        this.setFields(geometry, methodName, argClasses, argEntities);
    }

    public void invoke() {
        try {
            this.result = this.method.invoke((Object)this.geometry, this.argEntities);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JgclFatal();
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
            throw new JgclFatal();
        }
    }

    public abstract void output();

    public void view() {
        if (this.resultView == null) {
            this.resultView = this.makeView();
        }
        if (this.resultView != null) {
            this.resultView.show();
        }
    }

    public void toLispSExpression() {
        if (this.resultView == null) {
            this.resultView = this.makeView();
        }
        if (this.resultView != null) {
            this.resultView.toLispSExpression();
        }
    }

    public abstract JudanTransformer makeView();
}

