/*
 * Decompiled with CFR 0.152.
 */
package helloplugin;

import helloplugin.ConfigurationSettingsOutsurcing;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.codan.core.cxx.Activator;
import org.eclipse.cdt.codan.core.cxx.externaltool.AbstractExternalToolBasedChecker;
import org.eclipse.cdt.codan.core.cxx.externaltool.ConfigurationSettings;
import org.eclipse.cdt.codan.core.cxx.externaltool.SingleConfigurationSetting;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.MapProblemPreference;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class OutsourcingErrorParser
extends AbstractExternalToolBasedChecker
implements IErrorParser {
    static IResource cResource;
    static ITextFileBufferManager manager;
    static IDocument document;
    private ConfigurationSettingsOutsurcing settingsOutsurcing;
    private static Map<String, Integer> SEVERITY_MAPPING;
    private static final String ERROR_PROBLEM_ID = "co.jp.five.helloplugin.outsourcing.error";
    private static final Map<Integer, String> PROBLEM_IDS;

    static {
        SEVERITY_MAPPING = new HashMap<String, Integer>();
        SEVERITY_MAPPING.put("error", 2);
        SEVERITY_MAPPING.put("warning", 1);
        SEVERITY_MAPPING.put("style", 0);
        PROBLEM_IDS = new HashMap<Integer, String>();
        PROBLEM_IDS.put(2, ERROR_PROBLEM_ID);
        PROBLEM_IDS.put(1, "co.jp.five.helloplugin.outsourcing.warning");
        PROBLEM_IDS.put(0, "co.jp.five.helloplugin.outsourcing.style");
    }

    public OutsourcingErrorParser() {
        super(new ConfigurationSettings("Outsourcing", new File("check.bat"), "--enable=all"));
        this.settingsOutsurcing = new ConfigurationSettingsOutsurcing("Outsourcing", ".* +\\s*(.*) +\"(\\d+) +\\s*## (.*) ## +\\s*(.*)");
    }

    public OutsourcingErrorParser(ConfigurationSettings s) {
        super(s);
        this.settingsOutsurcing = new ConfigurationSettingsOutsurcing("Cppcheck", "");
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, this.settingsOutsurcing.getPattern());
    }

    private void addPreference(IProblemWorkingCopy problem, SingleConfigurationSetting<?> setting) {
        IProblemPreference descriptor = (IProblemPreference)setting.getDescriptor();
        this.addPreference(problem, descriptor, setting.getDefaultValue());
    }

    private void updateConfigurationSettingsFromPreferences(IResource fileToProcess) {
        IProblem problem = this.getProblemById(this.getReferenceProblemId(), fileToProcess);
        MapProblemPreference preferences = (MapProblemPreference)problem.getPreference();
        this.settingsOutsurcing.updateValuesFrom(preferences);
    }

    public void before(IResource resource) {
        cResource = resource;
        super.before(resource);
        IPath path = resource.getFullPath();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            manager.connect(path, LocationKind.IFILE, null);
            ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
            document = buffer.getDocument();
        }
        catch (CoreException e) {
            try {
                manager.disconnect(path, LocationKind.IFILE, null);
            }
            catch (CoreException e2) {
                e2.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    public boolean processLine(String line, ErrorParserManager parserManager) {
        block10: {
            String description;
            int severity;
            int lineNumber;
            IFile fileName;
            block11: {
                int length;
                Matcher matcher;
                block9: {
                    String[] comandline;
                    int getLineCounter = parserManager.getLineCounter();
                    if (getLineCounter == 1 && (comandline = line.split("\"")).length >= 4) {
                        String com = comandline[1].replace("\\\\", "\\");
                        File fd = new File(com);
                        if (!fd.exists()) {
                            ProblemMarkerInfo info = new ProblemMarkerInfo(cResource, 1, "Not found file. " + com, this.findSeverityCode("error"), null);
                            parserManager.addProblemMarker(info);
                            return true;
                        }
                        if (!fd.canExecute()) {
                            ProblemMarkerInfo info = new ProblemMarkerInfo(cResource, 1, "Not Execute file. " + com, this.findSeverityCode("error"), null);
                            parserManager.addProblemMarker(info);
                            return true;
                        }
                    }
                    this.updateConfigurationSettingsFromPreferences(cResource);
                    String regex = (String)this.settingsOutsurcing.getPattern().getValue();
                    try {
                        Pattern pattern = Pattern.compile(regex);
                        matcher = pattern.matcher(line);
                        if (matcher.matches()) break block9;
                        return false;
                    }
                    catch (Exception e) {
                        Activator.log((String)"[processLine]", (Throwable)e);
                        OutputStream os = parserManager.getOutputStream();
                        try {
                            os.write(e.toString().getBytes());
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        return false;
                    }
                }
                String[] token = matcher.group(1).split("\\\\");
                fileName = parserManager.findFileName(token[token.length - 1]);
                if (fileName == null) break block10;
                lineNumber = Integer.parseInt(matcher.group(2));
                String group3 = matcher.group(3).toLowerCase().trim();
                severity = this.findSeverityCode(group3);
                description = matcher.group(4);
                int startChar = description.indexOf(39);
                if (startChar < 0 || (length = description.substring(startChar + 1).indexOf(39)) <= 0) break block11;
                String key = description.substring(startChar + 1, startChar + length + 1);
                IRegion region = document.getLineInformation(lineNumber - 1);
                String src = document.get(region.getOffset(), region.getLength());
                startChar = src.indexOf(key) + region.getOffset();
                if (startChar < 0) break block11;
                int endChar = startChar + length;
                ProblemMarkerInfo info = new ProblemMarkerInfo((IResource)fileName, lineNumber, startChar, endChar, description, severity, null);
                parserManager.addProblemMarker(info);
                return true;
            }
            ProblemMarkerInfo info = new ProblemMarkerInfo((IResource)fileName, lineNumber, description, severity, null);
            parserManager.addProblemMarker(info);
            return true;
        }
        return false;
    }

    private int findSeverityCode(String text) {
        Integer code = SEVERITY_MAPPING.get(text);
        if (code != null) {
            return code;
        }
        return 0;
    }

    protected String[] getParserIDs() {
        return new String[]{"co.jp.five.helloplugin.outsourcing.ErrorParser"};
    }

    public void addMarker(ProblemMarkerInfo info) {
        String problemId = PROBLEM_IDS.get(info.severity);
        String description = String.format("[Outsourcing] %s", info.description);
        this.reportProblem(problemId, this.createProblemLocation(info), new Object[]{description});
    }

    protected String getReferenceProblemId() {
        return ERROR_PROBLEM_ID;
    }
}

