# uname emulation written in TCL scripting language
# Copyright (c) 2018 Earnie Boyd <earnie@users.sourceforge.net>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above
#    copyright notice, this list of conditions and the following
#    disclaimer in the documentation and/or other materials
#    provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE WORKWARE SYSTEMS ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
# PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL WORKWARE
# SYSTEMS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# Requires tclsh and cmdline
package require Tcl 8.6
package require cmdline 1.5

# Interpret the architecture
proc machine {} {
	switch $::tcl_platform(machine) {
		amd64 {return "x86_64"}
		intel {return "i386"}
		default {return $::tcl_platform(machine)}
	}
}

# Process the os string to replace spaces with underscores
proc system {} {
	return [string map {" " _} $::tcl_platform(os)]
}

# Emulate the echo of POSIX script engines.
proc echo {str} {
	puts -nonewline $str
}

# Set the options for getoptions
set options {
	{s	"kernel name"}
	{n	"network node hostname"}
	{r	"kernel release"}
	{v	"kernel version"}
	{m	"machine hardware name"}
	{p	"processor type"}
	{i	"hardware platform"}
	{o	"operating system"}
	{a	"all"}
}

# Set the usage for getoptions
set usage ": $argv0 \[options] \noptions:"

# Process the arguments entered
try {
	array set params [::cmdline::getoptions argv $options $usage]
} trap {CMDLINE USAGE} {msg o} {
	puts $msg
	exit 1
}

# Loop through the array of parameters and output the requested info.
foreach p [array names params] {
	switch $params($p) {
		1 {
			switch $p {
				a {echo [exec tclsh $argv0 -s -n -r -v -m -o]}
				s {echo "[system] "}
				m {echo "[machine] "}
				n {echo "[info hostname] "}
				r {echo "$::tcl_platform(osVersion) "}
				o {echo "$::tcl_platform(platform) "}
				i {echo "unknown "}
				p {echo "unknown "}
				v {echo "$::tcl_platform(osVersion) "}
			}
		}
	}
}
echo "\n"
